/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.wizard.model.listener;

import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.entity.DstorageSceneCheckItems;
import com.huawei.ism.tool.inspect.logic.config.TagCondition;
import com.huawei.ism.tool.inspect.ui.wizard.model.CheckItemDataModel;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckBoxTree;
import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckTreeCellEditor;
import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckTreeNode;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.TernaryCheckBox;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemTreeCellEditorListener
implements CellEditorListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ItemTreeCellEditorListener.class);
    private static final String PRE_UPGRADE_CHECK_SCENE = "pre_upgrade_check";
    private final CheckItemDataModel checkItemDataModel;

    public ItemTreeCellEditorListener(CheckItemDataModel checkItemDataModel) {
        this.checkItemDataModel = checkItemDataModel;
    }

    @Override
    public void editingStopped(ChangeEvent event) {
        this.synDialog(event);
        this.processEdit();
    }

    @Override
    public void editingCanceled(ChangeEvent e) {
        this.processEdit();
    }

    private void synDialog(ChangeEvent event) {
        if (this.checkItemDataModel.isHappened()) {
            return;
        }
        if (Objects.nonNull(this.checkItemDataModel.getCheckNodes().get(0).getDevNode()) && !this.checkItemDataModel.getCheckNodes().get(0).getDevNode().isDsStorage()) {
            return;
        }
        List<CheckDevNode> distributeCheckNodes = this.checkItemDataModel.getCheckNodes().stream().filter(checkDevNode -> checkDevNode.getDevNodeSafe().isDsStorage() && !checkDevNode.getDevNodeSafe().isMetaVision()).collect(Collectors.toList());
        if (distributeCheckNodes.size() <= 1) {
            return;
        }
        if (!this.isCheckTreeCellEditor(event)) {
            return;
        }
        this.updateItemSelectStatus(event, distributeCheckNodes);
    }

    private void updateItemSelectStatus(ChangeEvent event, List<CheckDevNode> distributeCheckNodes) {
        CheckTreeCellEditor scene = (CheckTreeCellEditor)event.getSource();
        if (!this.isFirstNode(distributeCheckNodes, scene) || this.notPreUpgradeCheck(distributeCheckNodes, scene)) {
            return;
        }
        distributeCheckNodes.remove(0);
        if (this.isTernaryCheckBox(scene) && !this.boxSelected(scene)) {
            return;
        }
        WarningDialog warningDialog = this.showChooseDialog();
        this.handleUserChoose(distributeCheckNodes, warningDialog);
    }

    private void handleUserChoose(List<CheckDevNode> distributeCheckNodes, WarningDialog warningDialog) {
        log.info("user choose button {}", (Object)warningDialog.getValue());
        this.checkItemDataModel.setHappened(this.cancel(warningDialog) || this.confirm(warningDialog));
        if (this.confirm(warningDialog)) {
            this.checkItemDataModel.setHappened(true);
            distributeCheckNodes.forEach(this::updateItemSelectStatus);
        }
    }

    private void updateItemSelectStatus(CheckDevNode node) {
        if (!this.hasUpgradeCheckScene(node)) {
            return;
        }
        node.getDstorageSceneCheckItemsList().forEach(sceneCheckItems -> this.changeItemSelectStatus((DstorageSceneCheckItems)sceneCheckItems, this.isPreUpgradeScene(sceneCheckItems.getSceneId())));
    }

    private boolean isCheckTreeCellEditor(ChangeEvent event) {
        return event.getSource() instanceof CheckTreeCellEditor;
    }

    private void changeItemSelectStatus(DstorageSceneCheckItems sceneCheckItems, boolean select) {
        sceneCheckItems.getCheckItems().values().stream().flatMap(Collection::stream).filter(item -> !TagCondition.hasTag(item.getTag(), "HIDDEN")).forEach(item -> item.setEnable(select));
    }

    private boolean hasUpgradeCheckScene(CheckDevNode node) {
        return node.getDstorageSceneCheckItemsList().stream().anyMatch(distributedStorageSceneCheckItems -> this.isPreUpgradeScene(distributedStorageSceneCheckItems.getSceneId()));
    }

    private void processEdit() {
        CheckBoxTree itemTree = this.checkItemDataModel.getItemTree();
        Set selectedNodes = this.checkItemDataModel.getItemTree().getAllSelectedNodes((CheckTreeNode)itemTree.getModel().getRoot());
        Set allNodes = itemTree.getAllNodes((CheckTreeNode)itemTree.getModel().getRoot());
        allNodes.stream().filter(node -> node.getUserObject() instanceof CheckItem).forEach(node -> ((CheckItem)node.getUserObject()).setEnable(selectedNodes.contains(node)));
        this.checkItemDataModel.getSelectItemCard().updateNavigationBar();
    }

    private boolean confirm(WarningDialog warningDialog) {
        return warningDialog.getValue() == 0;
    }

    private boolean cancel(WarningDialog warningDialog) {
        return warningDialog.getValue() == 1;
    }

    private WarningDialog showChooseDialog() {
        return DialogUtils.createYesAndNoDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"inspector.items.tipDialog"));
    }

    private boolean boxSelected(CheckTreeCellEditor scene) {
        return ((TernaryCheckBox)scene.getComponent()).isSelected();
    }

    private boolean isTernaryCheckBox(CheckTreeCellEditor scene) {
        return scene.getComponent() instanceof TernaryCheckBox;
    }

    private boolean notPreUpgradeCheck(List<CheckDevNode> distributeCheckNodes, CheckTreeCellEditor scene) {
        return !scene.getCellEditorValue().toString().equals(distributeCheckNodes.get(0).getResourceBundle().getString(PRE_UPGRADE_CHECK_SCENE));
    }

    private boolean isFirstNode(List<CheckDevNode> distributeCheckNodes, CheckTreeCellEditor scene) {
        return scene.getNode().getParent().toString().contains(distributeCheckNodes.get(0).getDevNode().getIp());
    }

    private boolean isPreUpgradeScene(String sceneId) {
        return PRE_UPGRADE_CHECK_SCENE.equals(sceneId);
    }
}

