/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.wizard.model.listener;

import com.huawei.ism.tool.inspect.ui.wizard.AuthClusterNodeCardLayout;
import com.huawei.ism.tool.inspect.ui.wizard.model.SelectClusterNodeModel;
import com.huawei.ism.ui.swing.table.TableRow;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ListSelectionListenerImpl
implements ListSelectionListener {
    private static final String ISM_SORTER_CLS_NAME = "IsmTableRowSorter";
    private final SelectClusterNodeModel selectClusterNodeModel;

    public ListSelectionListenerImpl(SelectClusterNodeModel selectClusterNodeModel) {
        this.selectClusterNodeModel = selectClusterNodeModel;
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        this.processEdit();
    }

    private void processEdit() {
        if (Objects.isNull(this.selectClusterNodeModel.getChooseChkDevNode())) {
            return;
        }
        ActionType actionType = this.getActionType();
        if (ActionType.FILTER_CHANGE.equals((Object)actionType) || ActionType.SORTER_CHANGE.equals((Object)actionType)) {
            return;
        }
        this.clearViewClusterNodeSelection();
        this.syncSelectRowToClusterNode();
    }

    private void syncSelectRowToClusterNode() {
        if (this.isNewAuthCard()) {
            return;
        }
        List identifierList = this.selectClusterNodeModel.getClusterNodesTbl().getMarkedRows().stream().map(TableRow::getIdentifier).collect(Collectors.toList());
        this.selectClusterNodeModel.getChooseChkDevNode().getDevNode().getClusterNodes().stream().filter(identifierList::contains).forEach(clusterNode -> clusterNode.setSelected(true));
    }

    private void clearViewClusterNodeSelection() {
        if (this.isNewAuthCard()) {
            return;
        }
        List viewRows = IntStream.range(0, this.selectClusterNodeModel.getClusterNodesTbl().getRowCount()).mapToObj(this::getRowData).collect(Collectors.toList());
        List identifierList = viewRows.stream().map(TableRow::getIdentifier).collect(Collectors.toList());
        this.selectClusterNodeModel.getChooseChkDevNode().getDevNode().getClusterNodes().stream().filter(identifierList::contains).forEach(clusterNode -> clusterNode.setSelected(false));
    }

    private boolean isNewAuthCard() {
        return this.selectClusterNodeModel.isAuthCard() && this.selectClusterNodeModel.getCardLayout() instanceof AuthClusterNodeCardLayout;
    }

    private TableRow getRowData(int index) {
        return this.selectClusterNodeModel.getClusterNodesTblModel().getRow(this.selectClusterNodeModel.getClusterNodesTbl().convertRowIndexToModel(index));
    }

    ActionType getActionType() {
        StackTraceElement[] stackTraces = Thread.currentThread().getStackTrace();
        return Arrays.stream(stackTraces).anyMatch(stackTrace -> stackTrace.getClassName().contains(ISM_SORTER_CLS_NAME)) ? ActionType.SORTER_CHANGE : ActionType.SINGLE_SELECT;
    }

    static enum ActionType {
        FILTER_CHANGE,
        SORTER_CHANGE,
        SINGLE_SELECT;

    }
}

