/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.wizard.model.listener;

import com.huawei.ism.tool.devicemanager.utils.DeviceContext;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubui.PublicUiManage;
import com.huawei.ism.tool.framework.pubui.common.IDeviceManageUI;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.logic.config.Product;
import com.huawei.ism.tool.inspect.ui.wizard.SelectDeviceCard;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.entity.PriKeyInfo;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.utils.ListOrderedMap;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifyButtonActionListener
extends ToolHyperLinkLabel.ClickAdapter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModifyButtonActionListener.class);
    private static final long serialVersionUID = 1L;
    private final CheckDevNode checkDevNode;
    private final Window parent = InspectContext.getInstance().getMainDialog();
    private final JTree deviceTree;
    private CheckDevNode headCheckDevNode;

    public ModifyButtonActionListener(CheckDevNode checkDevNode, JTree deviceTree) {
        this.deviceTree = deviceTree;
        this.checkDevNode = checkDevNode;
    }

    public void actionPerformed(ActionEvent e) {
        this.initHeadCheckDevNode();
        this.handleAction();
    }

    private void handleAction() {
        if (Objects.isNull(this.headCheckDevNode)) {
            this.handleNoIntegrate();
        } else {
            this.handleIntegrate();
        }
    }

    private void initHeadCheckDevNode() {
        TreePath selectTree = this.deviceTree.getSelectionPath();
        if (Objects.isNull(selectTree)) {
            return;
        }
        String key = selectTree.getParentPath().getParentPath().getLastPathComponent().toString();
        if (StringUtils.isNULLStr((String)key)) {
            return;
        }
        ListOrderedMap<String, List<CheckDevNode>> checkTypeNodes = this.getCheckTypeNodes();
        List devNodes = (List)checkTypeNodes.get((Object)key);
        this.headCheckDevNode = devNodes.stream().findFirst().orElse(null);
    }

    @NotNull
    private ListOrderedMap<String, List<CheckDevNode>> getCheckTypeNodes() {
        List checkDevNodes = (List)InspectContext.getInstance().getInspectWorktaker().get("check_dev_nodes");
        return InspectUtils.classifyDevs(checkDevNodes);
    }

    private void handleIntegrate() {
        Product product = this.headCheckDevNode.getProduct();
        if (product != null && "accessory".equals(product.getApplyRange())) {
            this.handleIntegrateApplyAccessory();
        } else {
            this.handleIntegrateApplyAll();
        }
    }

    private void handleIntegrateApplyAccessory() {
        this.updateDevsInfo();
        this.showModifyIntegrateDeviceDialog();
        this.updateDevsInfo();
    }

    private void showModifyIntegrateDeviceDialog() {
        IDeviceManageUI idm = (IDeviceManageUI)PublicUiManage.getInstance().getUi(IDeviceManageUI.class);
        idm.showModifyIntegrateDeviceDialog(this.parent, true, this.checkDevNode.getDevNode().getIp(), this.createNewDevNode());
    }

    private List<DevNode> createNewDevNode() {
        return EntityUtils.toNewDevList(this.headCheckDevNode.getAllCheckNode().stream().map(CheckDevNode::getDevNode).collect(Collectors.toList()));
    }

    private void updateDevsInfo() {
        this.headCheckDevNode.getAllCheckNode().stream().map(CheckDevNode::getFirstNode).forEach(this::checkDevNodeIp);
    }

    private void handleIntegrateApplyAll() {
        IDeviceManageUI idm = (IDeviceManageUI)PublicUiManage.getInstance().getUi(IDeviceManageUI.class);
        List<com.huawei.ism.tool.obase.entity.DevNode> devManagerdevs = SelectDeviceCard.getDevManagerList();
        List devNodes = EntityUtils.toNewDevList(devManagerdevs);
        idm.showModifyDeviceDialog(this.parent, true, this.headCheckDevNode.getFirstNode().getIp(), devNodes);
    }

    private void handleNoIntegrate() {
        List checkDevNodes = (List)InspectContext.getInstance().getInspectWorktaker().get("check_dev_nodes");
        List<com.huawei.ism.tool.obase.entity.DevNode> headDevs = this.getHeadDevs(checkDevNodes);
        this.showIdmDialog(headDevs);
    }

    private void showIdmDialog(List<com.huawei.ism.tool.obase.entity.DevNode> headDevs) {
        IDeviceManageUI idm = (IDeviceManageUI)PublicUiManage.getInstance().getUi(IDeviceManageUI.class);
        List devNodes = EntityUtils.toNewDevList(headDevs);
        idm.showModifyDeviceDialog(this.parent, true, this.checkDevNode.getDevNode().getIp(), devNodes);
    }

    private List<com.huawei.ism.tool.obase.entity.DevNode> getHeadDevs(List<CheckDevNode> checkDevNodes) {
        return checkDevNodes.stream().filter(checkNode -> CollectionUtils.isNotEmpty(checkNode.getAllCheckNode())).map(CheckDevNode::getFirstNode).peek(this::checkDevNodeIp).collect(Collectors.toList());
    }

    private void checkDevNodeIp(com.huawei.ism.tool.obase.entity.DevNode headDev) {
        DeviceContext.getInstance().getModifyDevicesInfo().stream().filter(devNodeTmp -> headDev.getIp().equals(devNodeTmp.getIp())).forEach(devNodeTmp -> this.updateDevNode(headDev, (com.huawei.ism.tool.obase.entity.DevNode)devNodeTmp));
    }

    private void updateDevNode(com.huawei.ism.tool.obase.entity.DevNode changeDev, com.huawei.ism.tool.obase.entity.DevNode sourceDev) {
        if (changeDev == sourceDev) {
            return;
        }
        this.updateChangeDevProperties(changeDev, sourceDev);
        this.updateUserProperties(changeDev, sourceDev);
    }

    private PriKeyInfo createPriKeyInfo(com.huawei.ism.tool.obase.entity.DevNode sourceDev) {
        return Optional.ofNullable(sourceDev.getPriKey()).map(this::buildNewPriKeyInfo).orElse(null);
    }

    private PriKeyInfo buildNewPriKeyInfo(PriKeyInfo info) {
        PriKeyInfo newInfo = new PriKeyInfo();
        newInfo.setKeyName(info.getKeyName());
        newInfo.setKeyPath(info.getKeyPath());
        newInfo.setKeyPwd(info.getKeyPwd());
        return newInfo;
    }

    private void updateChangeDevProperties(com.huawei.ism.tool.obase.entity.DevNode changeDev, com.huawei.ism.tool.obase.entity.DevNode sourceDev) {
        changeDev.setProductVersion(sourceDev.getProductVersion());
        changeDev.setDeviceName(sourceDev.getDeviceName());
        changeDev.setIp(sourceDev.getIp());
        changeDev.setPeerIp(sourceDev.getPeerIp());
        changeDev.setPort(sourceDev.getPort());
        changeDev.setDeveloperPwd(sourceDev.getDeveloperPwd());
        changeDev.setPriKey(this.createPriKeyInfo(sourceDev));
        sourceDev.getIpList().forEach(arg_0 -> ((com.huawei.ism.tool.obase.entity.DevNode)changeDev).setActiveIp(arg_0));
    }

    private void updateUserProperties(com.huawei.ism.tool.obase.entity.DevNode changeDev, com.huawei.ism.tool.obase.entity.DevNode sourceDev) {
        User user = changeDev.getLoginUser();
        user.setUserName(sourceDev.getLoginUser().getUserName());
        user.setPassword(sourceDev.getLoginUser().getPassword());
        user.setPort(sourceDev.getLoginUser().getPort());
    }
}

