/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.utils;

import com.huawei.ism.tool.obase.utils.ApplicationContext;
import java.io.Closeable;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelWriteFile
implements Closeable {
    public static final int MAX_BUFF = 0x100000;
    private static final Logger LOG = LoggerFactory.getLogger(ChannelWriteFile.class);
    private RandomAccessFile file;
    private FileChannel channel;
    private ByteBuffer buffer;

    public ChannelWriteFile(String filePath, boolean append) {
        try {
            this.file = new RandomAccessFile(filePath, "rw");
            if (append) {
                this.file.seek(this.file.length());
            }
            this.channel = this.file.getChannel();
            this.buffer = ByteBuffer.allocate(0x100000);
        }
        catch (IOException e) {
            LOG.error("create error", (Throwable)e);
            throw new IllegalStateException("create file failed.");
        }
    }

    public boolean write(String content) {
        return this.write(content, ApplicationContext.APP_CHARSET);
    }

    public boolean write(String content, Charset charset) {
        if (null == content || content.isEmpty()) {
            LOG.error("content is null or empty.");
            return false;
        }
        return this.write(content.getBytes(charset == null ? ApplicationContext.APP_CHARSET : charset));
    }

    public boolean write(byte[] content) {
        if (content == null) {
            LOG.error("content is null.");
            return false;
        }
        return this.write(content, 0, content.length);
    }

    public boolean write(byte[] content, int offset, int count) {
        if (content == null) {
            LOG.error("write error, content is null.");
            return false;
        }
        if (content.length == 0) {
            LOG.info("content length zore");
            return false;
        }
        if (offset < 0 || offset >= content.length || count <= 0 || count > content.length) {
            LOG.info(String.format(Locale.ENGLISH, "offset or count illegal, offset: %d, count: %d", offset, count));
            return false;
        }
        this.ensureOpen();
        LOG.info(String.format(Locale.ENGLISH, "ready to write, content length: %d, offset: %d, count: %d", content.length, offset, count));
        int iterOffset = offset;
        int iterCount = count;
        try {
            while (iterCount > 0) {
                int putCount = Math.min(iterCount, 0x100000);
                this.buffer.put(content, iterOffset, putCount);
                iterCount -= putCount;
                iterOffset += putCount;
                this.buffer.flip();
                while (this.buffer.hasRemaining()) {
                    this.channel.write(this.buffer);
                }
                this.buffer.clear();
            }
        }
        catch (IOException e) {
            LOG.error("write content error.", (Throwable)e);
            return false;
        }
        return true;
    }

    public void ensureOpen() {
        if (null == this.file) {
            throw new IllegalStateException("file is null.");
        }
        if (null == this.channel) {
            this.channel = this.file.getChannel();
        }
        if (this.buffer == null) {
            this.buffer = ByteBuffer.allocate(0x100000);
        } else {
            this.buffer.clear();
        }
    }

    @Override
    public void close() {
        ChannelWriteFile.close(this.channel);
        this.channel = null;
        ChannelWriteFile.close(this.file);
        this.file = null;
        if (null != this.buffer) {
            this.buffer.clear();
        }
        this.buffer = null;
    }

    private static void close(Closeable closeable) {
        if (null == closeable) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException e) {
            LOG.error("close resource error " + closeable, (Throwable)e);
        }
    }
}

