/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.utils;

import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.entity.DstoragePreCheckConfig;
import com.huawei.ism.tool.inspect.entity.Item;
import com.huawei.ism.tool.inspect.logic.config.TagCondition;
import com.huawei.ism.tool.inspect.logic.fusionstor.inspector.ExpansionTaskUtils;
import com.huawei.ism.tool.inspect.utils.InspectCommonResBundle;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.worktaker.InspectWorktaker;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckTreeNode;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.service.patch.dstorage.Context;
import com.huawei.ism.tool.service.patch.dstorage.entity.DstoragePatchInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.tree.MutableTreeNode;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckItemUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CheckItemUtils.class);

    @NotNull
    public static String getModuleName(@NotNull CheckDevNode checkDevNode, @NotNull List<CheckItem> items, @NotNull String typeKey) {
        String type = CheckItemUtils.allIsPatchItem(checkDevNode, items) ? ResourceUtil.getString((String)typeKey, (ResourceBundle[])new ResourceBundle[]{InspectCommonResBundle.INS.getDistributedResBundle(), checkDevNode.getResourceBundle(), InspectCommonResBundle.INS.getUnifiedResBundle(), checkDevNode.getExpansionResource()}) : ResourceUtil.getString((String)typeKey, (ResourceBundle[])new ResourceBundle[]{checkDevNode.getResourceBundle(), InspectCommonResBundle.INS.getUnifiedResBundle(), checkDevNode.getExpansionResource(), checkDevNode.getSwitchResource()});
        return type;
    }

    private static boolean allIsPatchItem(@NotNull CheckDevNode checkDevNode, @NotNull List<CheckItem> items) {
        DevNode devNode = checkDevNode.getDevNode();
        if (devNode == null || !devNode.isDsStorage()) {
            return false;
        }
        DstoragePatchInfo patchInfo = Context.INS.getAutoImportPatch(checkDevNode.getDevNode(), DstoragePatchInfo.Type.INSPECT);
        if (patchInfo == null) {
            return false;
        }
        List patchItemIdList = patchInfo.getItemIdList();
        return items.stream().allMatch(item -> patchItemIdList.contains(item.getItemId()));
    }

    public static List<CheckDevNode> getSortedCheckNodes(InspectWorktaker workTaker) {
        return CheckItemUtils.sort((List)workTaker.get("check_dev_nodes"));
    }

    private static List<CheckDevNode> sort(List<CheckDevNode> checkDevNodes) {
        return checkDevNodes.stream().sorted(Comparator.comparing(checkDevNode -> Objects.isNull(checkDevNode.getDevNode()) || !checkDevNode.getDevNode().isDsStorage())).collect(Collectors.toList());
    }

    public static void addSubItems(Map<String, List<CheckItem>> checkItems, List<String> keys, CheckTreeNode rootNode) {
        CheckItemUtils.addSubItems(checkItems, keys, rootNode, null, null);
    }

    public static void addSubItems(Map<String, List<CheckItem>> checkItems, List<String> keys, CheckTreeNode rootNode, CheckTreeNode group, Predicate<CheckItem> filterFunc) {
        keys.stream().filter(key -> !CheckItemUtils.isAllSubItemHidden((List)checkItems.get(key))).forEach(key -> {
            List items = (List)checkItems.get(key);
            CheckTreeNode checkTreeNode = new CheckTreeNode(key, true, true);
            rootNode.add((MutableTreeNode)checkTreeNode);
            checkTreeNode.setGroup(group);
            CheckItemUtils.initItems(checkTreeNode, items, group, filterFunc);
            if (checkTreeNode.getChildCount() == 0) {
                rootNode.remove((MutableTreeNode)checkTreeNode);
            }
        });
    }

    private static boolean needSkip(CheckItem item, Predicate<CheckItem> filterFunc) {
        if (CheckItemUtils.needFilter(item, filterFunc)) {
            item.setSelected(false);
            return true;
        }
        return TagCondition.hasTag(item.getTag(), "HIDDEN");
    }

    private static boolean needFilter(CheckItem item, Predicate<CheckItem> filterFunc) {
        return Objects.nonNull(filterFunc) && filterFunc.test(item);
    }

    public static boolean isAllSubItemHidden(List<CheckItem> checkItems) {
        return checkItems.stream().allMatch(checkItem -> TagCondition.hasTag(checkItem.getTag(), "HIDDEN"));
    }

    private static void initItems(CheckTreeNode checkTreeNode, List<CheckItem> items, CheckTreeNode group, Predicate<CheckItem> filterFunc) {
        items.stream().filter(item -> !CheckItemUtils.needSkip(item, filterFunc)).forEach(item -> {
            item.setSelected(true);
            List<Item> allChildItems = item.getItems();
            CheckTreeNode cmdItemNode = new CheckTreeNode(item, allChildItems.size() > 1, true);
            CheckItemUtils.initChildren(allChildItems, cmdItemNode);
            checkTreeNode.add((MutableTreeNode)cmdItemNode);
            cmdItemNode.setGroup(group);
            cmdItemNode.setSelected(item.isEnable());
        });
    }

    private static void initChildren(List<Item> allChildItems, CheckTreeNode cmdItemNode) {
        if (allChildItems.size() <= 1) {
            return;
        }
        allChildItems.forEach(item -> {
            CheckTreeNode itemNode = new CheckTreeNode(item, false, true);
            itemNode.setHasCheckBox(false);
            itemNode.setCheckEnable(false);
            cmdItemNode.add((MutableTreeNode)itemNode);
        });
    }

    public static Map<String, List<String>> getNeedBmcAuthDev(List<CheckDevNode> checkDevNodes) {
        HashMap<String, List<String>> needBmcAuthDev = new HashMap<String, List<String>>();
        if (!InspectContext.getInstance().isBureauCheckSelected()) {
            return needBmcAuthDev;
        }
        checkDevNodes.forEach(checkDevNode -> CheckItemUtils.initNotBmcAuthNode(checkDevNode, needBmcAuthDev));
        return needBmcAuthDev;
    }

    private static void initNotBmcAuthNode(CheckDevNode checkDevNode, Map<String, List<String>> needBmcAuthDev) {
        DevNode devNode = checkDevNode.getDevNode();
        if (devNode == null || !devNode.isDsStorage()) {
            return;
        }
        if (devNode.getClusterNodes() == null) {
            return;
        }
        Map<String, List<CheckItem>> items = checkDevNode.getDstorageCheckItems();
        if (items == null) {
            return;
        }
        List<String> needBmcAuthItem = ExpansionTaskUtils.getNeedBmcAuthTypeRs();
        if (items.keySet().stream().noneMatch(needBmcAuthItem::contains)) {
            return;
        }
        List clusterNodes = devNode.getClusterNodes();
        List selectAndNotBmcAuthNodeIpList = clusterNodes.stream().filter(CheckItemUtils::needBmcAuth).map(ClusterNode::getManagementIp).collect(Collectors.toList());
        if (selectAndNotBmcAuthNodeIpList.isEmpty()) {
            return;
        }
        needBmcAuthDev.put(devNode.getIp(), selectAndNotBmcAuthNodeIpList);
    }

    public static boolean needBmcAuth(ClusterNode clusterNode) {
        return !(!clusterNode.isSelected() || clusterNode.isHGNode() || !clusterNode.includedStorageService() && !clusterNode.isDirectPlanesNode() || clusterNode.getBmcNode() != null && clusterNode.getBmcNode().getLoginUser() != null);
    }

    public static boolean needAuth(ClusterNode clusterNode) {
        return !clusterNode.isHGNode() && (clusterNode.includedStorageService() || clusterNode.isDirectPlanesNode());
    }

    public static boolean needOsAuth(ClusterNode clusterNode) {
        return clusterNode.isSelected() && !clusterNode.isHGNode() && clusterNode.includedStorageService() && (clusterNode.getOsNode() == null || clusterNode.getOsNode().getLoginUser() == null);
    }

    public static List<String> getSoftNoCheckNodes(List<CheckDevNode> checkDevNodes) {
        return CheckItemUtils.addNoCheckNodeIp(checkDevNodes, CheckItem.ItemCheckType.SOFT);
    }

    public static List<String> getHardwareNoCheckNodes(List<CheckDevNode> checkDevNodes) {
        return CheckItemUtils.addNoCheckNodeIp(checkDevNodes, CheckItem.ItemCheckType.HARDWARE);
    }

    private static List<String> addNoCheckNodeIp(List<CheckDevNode> checkDevNodes, CheckItem.ItemCheckType itemCheckType) {
        ArrayList<String> noSelectNodeIp = new ArrayList<String>();
        checkDevNodes.forEach(devNode -> noSelectNodeIp.addAll(devNode.getAllCheckNode().stream().filter(node -> !CheckItemUtils.hasSelect(node.getCheckItems().values(), itemCheckType)).map(checkDevNode -> checkDevNode.getDevNode().getIp()).collect(Collectors.toList())));
        return noSelectNodeIp;
    }

    private static boolean hasSelect(Collection<List<CheckItem>> checkItems, CheckItem.ItemCheckType itemCheckType) {
        return checkItems.stream().anyMatch(checkItem -> checkItem.stream().anyMatch(item -> CheckItemUtils.isSelect(itemCheckType, item)));
    }

    private static boolean isSelect(CheckItem.ItemCheckType itemCheckType, CheckItem item) {
        if (!itemCheckType.equals((Object)item.getItemCheckType())) {
            return false;
        }
        boolean hasResult = false;
        if (!CheckItem.ItemCheckType.HARDWARE.equals((Object)itemCheckType)) {
            hasResult = Objects.nonNull(item.getCheckResult());
        }
        return !TagCondition.hasTag(item.getTag(), "HIDDEN") && item.isEnable() || hasResult;
    }

    public static void changeAllItemSelectStatus(boolean select, List<CheckDevNode> checkNodes, CheckItem.ItemCheckType itemCheckType) {
        CheckItemUtils.getAllItemsByType(checkNodes, itemCheckType).forEach(checkItem -> checkItem.setSelected(select));
    }

    private static List<CheckItem> getAllItemsByType(List<CheckDevNode> checkNodes, CheckItem.ItemCheckType itemCheckType) {
        ArrayList<CheckItem> allCheckItems = new ArrayList<CheckItem>();
        checkNodes.forEach(checkDevNode -> checkDevNode.getDstorageCheckItems().values().forEach(checkItems -> allCheckItems.addAll(checkItems.stream().filter(checkItem -> itemCheckType.equals((Object)checkItem.getItemCheckType())).collect(Collectors.toList()))));
        return allCheckItems;
    }

    public static Optional<CheckItem> getPreCheckItem(CheckDevNode checkDevNode) {
        if (!DstoragePreCheckConfig.INS.needPreCheck(checkDevNode)) {
            log.info("Node {} do not need pre check.", (Object)checkDevNode.getDevNode().getIp());
            return Optional.empty();
        }
        return DstoragePreCheckConfig.INS.findPreCheckItem(checkDevNode);
    }

    public static List<CheckItem> getPreCheckItems(CheckDevNode checkDevNode) {
        if (!DstoragePreCheckConfig.INS.needPreCheck(checkDevNode)) {
            log.info("Node {} do not need pre check.", (Object)checkDevNode.getDevNode().getIp());
            return Collections.emptyList();
        }
        return DstoragePreCheckConfig.INS.findPreCheckItems(checkDevNode);
    }

    @Generated
    private CheckItemUtils() {
    }
}

