/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.utils;

import com.google.common.collect.ImmutableMap;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.entity.Item;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.protocol.rest.FceRestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputerStorageUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComputerStorageUtils.class);
    public static final Map<String, String> INSPECTION_ERROR_STATUS = ImmutableMap.of((Object)"3", (Object)"start failed", (Object)"5", (Object)"running failed", (Object)"8", (Object)"cancel failed", (Object)"10", (Object)"time out");
    public static final Map<String, String> INSPECTION_SUCCESS_STATUS = ImmutableMap.of((Object)"6", (Object)"Success", (Object)"7", (Object)"Partially successful");
    public static final long META_VISION_INSPECTION_TIME_OUT = TimeUnit.MINUTES.toMillis(30L);
    public static final int META_VISION_START_STEP = 50;
    public static final int META_VISION_QUERY_END_STEP = 90;
    private static final String DEVICES_PARAM = "{\"pageNum\":1,\"appendFeature\":1,\"deviceTypes\":[\"server\",\"FusionCubeVision\",\"hypervisor-manager\",\"Storage\",\"FusionCube\"],\"filterChildDevice\":1,\"pageSize\":10}";
    private static final Map<String, List<String>> CHECK_ITEM_TRUST_LIST = ImmutableMap.of((Object)"Storage", Arrays.asList("5101", "5102", "5103", "5104", "5105", "5106", "5107", "5108", "5110", "5111", "5112", "5113", "5114", "5115", "5201", "5202", "5203", "5204", "5205", "5206", "5207", "5301", "5302", "5303", "5304", "5305", "5306"), (Object)"2288H V5", Arrays.asList("1105", "1108", "1600", "1601", "1602", "1720", "1721", "1722", "1727", "1728", "3041", "3042", "3043", "3046", "3505", "3507", "3508", "3509", "3511", "3513"), (Object)"HCIManagementNode", Arrays.asList("1001", "1004", "1018", "1104", "1201", "1202", "1501", "4211", "4212"), (Object)"FusionComputeNode", Arrays.asList("3025", "3035", "3039", "3040", "3045", "3615", "3621"));
    private static final List<String> UNSUPPORTED_VERSION = Collections.singletonList("6.1.5");

    public static boolean isUnsupportedDevice(String version) {
        return UNSUPPORTED_VERSION.stream().anyMatch(version::contains);
    }

    public static Map<String, List<CheckItem>> getFcvCheckItems(CheckDevNode checkDevNode) throws ToolException {
        try {
            FceRestConnection fcvRest = RestConnectionManager.getFceRestConnection((DevNode)checkDevNode.getDevNode());
            return ComputerStorageUtils.getFcvDevCheckItems(fcvRest);
        }
        catch (ToolException e) {
            log.error("get MetaVision checkItems error", (Throwable)e);
            throw new ToolException("get MetaVision checkItems error");
        }
        catch (Exception e) {
            log.error("The MetaVision interface returns an error", (Throwable)e);
            throw new ToolException("The MetaVision interface returns an error");
        }
    }

    public static String getMetaVisionInternalizationId(String name) {
        return ApplicationContext.getInstance().isEnglishEnv() ? name + "En" : name + "Zh";
    }

    public static void sleepMilliseconds(int milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            log.error("sleep error", (Throwable)e);
        }
    }

    @NotNull
    public static Map<String, List<CheckItem>> getFcvDevCheckItems(FceRestConnection fcvRest) throws ToolException {
        JSONArray checkItemJsonArray = ComputerStorageUtils.getAllMetaVisionCheckItems(fcvRest);
        JSONArray deviseJsonArray = ComputerStorageUtils.getAllComputerDeviceInfo(fcvRest);
        TreeMap<String, List<CheckItem>> fcvDevCheckItems = new TreeMap<String, List<CheckItem>>(String::compareToIgnoreCase);
        ComputerStorageUtils.getFcvDevCheckItems(fcvDevCheckItems, checkItemJsonArray, deviseJsonArray);
        return fcvDevCheckItems;
    }

    public static JSONArray getAllComputerDeviceInfo(FceRestConnection fcvRest) throws ToolException {
        String url = String.format("%s/fce/fcc-business/v1/inspection/devices?filter=true", fcvRest.getBaseUrl());
        JSONObject deviseInfos = new JSONObject(fcvRest.execPost(url, DEVICES_PARAM).getContent());
        return deviseInfos.getJSONObject("data").getJSONArray("dataList");
    }

    public static JSONArray getAllMetaVisionCheckItems(FceRestConnection fcvRest) throws ToolException {
        String url = String.format("%s/fce/operation/v1/inspection/items", fcvRest.getBaseUrl());
        ResponseInfo responseInfoChecks = fcvRest.execGet(url);
        JSONObject checkItems = new JSONObject(responseInfoChecks.getContent());
        return checkItems.getJSONArray("data");
    }

    public static JSONObject startMetaVisionInspect(FceRestConnection fcvRest, String param) throws ToolException {
        String url = String.format("%s/fce/operation/v1/inspection/start/oceanstor", fcvRest.getBaseUrl());
        return new JSONObject(fcvRest.execPost(url, param).getContent());
    }

    public static JSONObject queryMetaVisionInspectProgress(FceRestConnection fcvRest, String taskId) throws ToolException {
        String progressUrl = String.format("%s/fce/framework/v1/asyntask/task/%s", fcvRest.getBaseUrl(), taskId);
        return new JSONObject(fcvRest.execGet(progressUrl).getContent());
    }

    public static JSONArray queryAllInspectTaskInfos(FceRestConnection fcvRest, int pageNum) throws ToolException {
        String url = String.format(Locale.ROOT, "%s/fce/operation/v1/inspection/record/oceanstor/history?pageSize=10&pageNum=%d", fcvRest.getBaseUrl(), pageNum);
        JSONObject taskListObject = new JSONObject(fcvRest.execGet(url).getContent());
        return taskListObject.getJSONObject("data").getJSONArray("data");
    }

    public static JSONArray queryInspectResults(FceRestConnection fcvRest, String resultId, int pageSize) throws ToolException {
        String url = String.format(Locale.ROOT, "%s/fce/operation/v1/inspection/record/history/%s?pageSize=%d&pageNum=1", fcvRest.getBaseUrl(), resultId, pageSize);
        return new JSONObject(fcvRest.execGet(url).getContent()).getJSONObject("data").getJSONArray("data");
    }

    public static JSONArray getEnableCheckItemsJsonArray(CheckDevNode node) {
        JSONArray paramArray = new JSONArray();
        for (List<CheckItem> checkItems : node.getCheckItems().values()) {
            if (checkItems.isEmpty() || checkItems.stream().noneMatch(CheckItem::isEnable)) continue;
            JSONObject paramObject = new JSONObject();
            paramObject.put("deviceId", (Object)checkItems.get(0).getTag());
            paramObject.put("itemIds", (Object)new JSONArray((Collection)checkItems.stream().filter(CheckItem::isEnable).map(ComputerStorageUtils::getItemIdWithoutDeviceInfo).collect(Collectors.toList())));
            paramArray.put((Object)paramObject);
        }
        return paramArray;
    }

    private static String getItemIdWithoutDeviceInfo(CheckItem checkItem) {
        String deviceInfo = String.format(Locale.ROOT, "%s-", checkItem.getTag());
        if (checkItem.getItemId().contains(deviceInfo)) {
            return checkItem.getItemId().replaceAll(deviceInfo, "");
        }
        return checkItem.getItemId();
    }

    private static void getFcvDevCheckItems(Map<String, List<CheckItem>> fcvDevCheckItems, JSONArray checkItemJsonArray, JSONArray deviseJsonArray) {
        for (int i = 0; i < deviseJsonArray.length(); ++i) {
            JSONObject deviseJsonObject = deviseJsonArray.getJSONObject(i);
            if (deviseJsonObject.get("childDevices") instanceof JSONArray) {
                ComputerStorageUtils.getFcvDevCheckItems(fcvDevCheckItems, checkItemJsonArray, deviseJsonObject.getJSONArray("childDevices"));
                continue;
            }
            List<CheckItem> fcvCheckItems = ComputerStorageUtils.getCheckItemsForDevice(checkItemJsonArray, deviseJsonObject);
            fcvDevCheckItems.put(deviseJsonObject.getStringOrDefault("deviceName", "MetaVision"), fcvCheckItems);
        }
    }

    public static Map<String, JSONObject> queryMetaVisionInspectResults(FceRestConnection fcvRest, String taskId, int checkItemTypeNum) throws ToolException {
        JSONArray resultJSONArray = ComputerStorageUtils.queryInspectResults(fcvRest, ComputerStorageUtils.getInspectResultId(taskId, fcvRest), ComputerStorageUtils.getMinPageSize(checkItemTypeNum));
        HashMap<String, JSONObject> inspectResults = new HashMap<String, JSONObject>();
        for (int i = 0; i < resultJSONArray.length(); ++i) {
            inspectResults.put(resultJSONArray.getJSONObject(i).getStringOrDefault("deviceId", ""), resultJSONArray.getJSONObject(i));
        }
        return inspectResults;
    }

    private static int getMinPageSize(int checkItemTypeNum) {
        return (int)(Math.ceil((float)checkItemTypeNum / 10.0f) * 10.0);
    }

    private static String getInspectResultId(String taskId, FceRestConnection fcvRest) throws ToolException {
        int pageNum = 1;
        while (true) {
            JSONArray tasksJsonArray;
            if ((tasksJsonArray = ComputerStorageUtils.queryAllInspectTaskInfos(fcvRest, pageNum)).length() == 0) {
                throw new ToolException("Failed to match the result information.");
            }
            for (int i = 0; i < tasksJsonArray.length(); ++i) {
                JSONObject taskObject = tasksJsonArray.getJSONObject(i);
                if (!taskObject.getStringOrDefault("taskId", "-").equals(taskId)) continue;
                return taskObject.getStringOrDefault("id", "");
            }
            ++pageNum;
        }
    }

    @NotNull
    private static List<CheckItem> getCheckItemsForDevice(JSONArray checkItemJsonArray, JSONObject deviseJsonObject) {
        ArrayList<CheckItem> fcvCheckItems = new ArrayList<CheckItem>();
        for (int j = 0; j < checkItemJsonArray.length(); ++j) {
            JSONObject checkItemJsonObject = checkItemJsonArray.getJSONObject(j);
            if (ComputerStorageUtils.filterNonCurrentDeviceCheckItem(deviseJsonObject, fcvCheckItems, checkItemJsonObject)) continue;
            CheckItem checkItem = ComputerStorageUtils.packageCheckItem(deviseJsonObject, checkItemJsonObject);
            fcvCheckItems.add(checkItem);
        }
        return fcvCheckItems;
    }

    private static boolean filterNonCurrentDeviceCheckItem(JSONObject deviseJsonObject, List<CheckItem> fcvCheckItems, JSONObject checkItemJsonObject) {
        return Objects.isNull(checkItemJsonObject) || !ComputerStorageUtils.isCurrentDeviceCheckItem(deviseJsonObject, checkItemJsonObject) || ComputerStorageUtils.hasCheckItems(fcvCheckItems, checkItemJsonObject);
    }

    @NotNull
    private static CheckItem packageCheckItem(JSONObject deviseJsonObject, JSONObject checkItemJsonObject) {
        CheckItem checkItem = new CheckItem();
        checkItem.setEnable(true);
        checkItem.setName(String.format("%s--%s", deviseJsonObject.getStringOrDefault("deviceName", "MetaVision"), checkItemJsonObject.getStringOrDefault(ComputerStorageUtils.getMetaVisionInternalizationId("name"), "")));
        String deviceId = deviseJsonObject.getStringOrDefault("deviceId", "-");
        checkItem.setTag(deviceId);
        checkItem.setItemId(ComputerStorageUtils.concatenateItemId(deviceId, checkItemJsonObject.getStringOrDefault("itemId", "")));
        checkItem.setItemType("fcvcheck");
        Item item = new Item();
        item.setId(checkItem.getItemId());
        item.setName(checkItem.getName());
        checkItem.setItems(Collections.singletonList(item));
        return checkItem;
    }

    private static boolean hasCheckItems(List<CheckItem> checkItems, JSONObject checkItemJsonObject) {
        return checkItems.stream().anyMatch(checkItem -> ComputerStorageUtils.isCurrentCheckItem(checkItem, checkItemJsonObject.getStringOrDefault("itemId", "")));
    }

    private static String concatenateItemId(String deviceId, String fcvItemId) {
        return String.format(Locale.ROOT, "%s-%s", deviceId, fcvItemId);
    }

    public static boolean isCurrentCheckItem(CheckItem checkItem, String fcvItemId) {
        return ComputerStorageUtils.concatenateItemId(checkItem.getTag(), fcvItemId).equals(checkItem.getItemId());
    }

    private static boolean isCurrentDeviceCheckItem(JSONObject deviseJsonObject, JSONObject checkItemJsonObject) {
        String deviceModel = checkItemJsonObject.getStringOrDefault("deviceModel", "");
        return deviceModel.equals(deviseJsonObject.getStringOrDefault("deviceModel", "-")) && CHECK_ITEM_TRUST_LIST.getOrDefault(deviceModel, Collections.emptyList()).contains(checkItemJsonObject.getStringOrDefault("itemId", ""));
    }
}

