/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.utils;

import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.OSCmdUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.in.CommonMethod;
import com.huawei.ism.tool.obase.utils.in.ComponentDefine;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.zip.ZipInputStream;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.FilesUtil;

public final class FileAssistant {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileAssistant.class);
    private static final int EXECUTE_COMPRESS_SUCCESS = 1;
    private static final int EXECUTE_COMPRESS_FAILD = -1;
    private static final int MAX_NUM = 99999;
    private static final String LOGS = "logs";
    private static final String RUNLOG = "runlog";
    private static final String A_LINE_T7Z = " a -t7z";
    private static final String NULL_A_NULL = " a ";
    private static final String NULL_X_NULL = " x ";
    private static final String NULL_LINE_O = " -o";
    private static final String NULL_LINE_Y = " -y";
    private static final String LINE_R_LINE_Y = " -r -y";
    private static final String PASSWORD = "password";
    private static final String OS_POINT_NAME = "os.name";
    private static final String WINDOWS = "Windows";
    private static final String RD = "rd ";
    private static final String Q_NULL_S = "/Q /S";
    private static final String RM_NULL_RF = "rm -rf ";
    private static final String A_TZIP = " a -tzip";
    private static final String LINE_V = "-v";
    private static final Object LOCK = new Object();
    private static final String GZ_SUFFIX_REG = "\\.gz";
    private static final String BZ2_SUFFIX_REG = "\\.bz2";
    private static final String TAR_SUFFIX_REG = "\\.tar";
    private static final String TGZ_SUFFIX_REG = "\\.tgz";
    private static final String FILE_CODE_7Z = "377abcaf271c";

    private FileAssistant() {
    }

    public static void clearDir(String dir) {
        if (StringUtils.isNULLStr((String)dir)) {
            return;
        }
        File file = new File(dir);
        if (!file.exists()) {
            return;
        }
        FileUtils.deleteFile((File)file);
    }

    public static String getRandomTmpDir(String preFix) {
        if (StringUtils.isNULLStr((String)preFix)) {
            return "";
        }
        SecureRandom rad = new SecureRandom();
        int i = rad.nextInt(99999);
        String ret = preFix + "_" + i;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileContent(String filePath) {
        if (StringUtils.isNULLStr((String)filePath)) {
            return "";
        }
        FileInputStream in = null;
        String str = "";
        try {
            in = new FileInputStream(filePath);
            int len = in.available();
            byte[] bs = new byte[len];
            if (in.read(bs) <= 0) {
                String string = str;
                return string;
            }
            str = new String(bs, Charset.defaultCharset());
        }
        catch (IOException e) {
            LOGGER.error("Get file content error.", (Throwable)e);
        }
        finally {
            StreamUtils.closeStream(null, (InputStream)in);
        }
        return str;
    }

    public static void clearEmptyLogFile() {
        String workPath = ApplicationContext.getInstance().getWorkPath();
        File logDir = new File(workPath + File.separator + LOGS + File.separator + RUNLOG);
        File[] logsFiles = logDir.listFiles();
        if (null == logsFiles) {
            return;
        }
        for (File file : logsFiles) {
            if (0L != file.length() || file.delete()) continue;
            LOGGER.error("Delete file: " + file.getName() + " error!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compressFile7z(String aimFileName, String ... sourceDir) {
        Object object = LOCK;
        synchronized (object) {
            if (StringUtils.hasNULLStr((String[])sourceDir) || StringUtils.isNULLStr((String)aimFileName)) {
                LOGGER.info("path is null.");
                return false;
            }
            StringBuffer sb = new StringBuffer();
            for (String file : sourceDir) {
                sb.append(ComponentDefine.getMarks() + file + ComponentDefine.getMarks() + " ");
            }
            StringBuffer cmd = new StringBuffer().append(ComponentDefine.getMarks()).append(FileAssistant.get7zPath()).append(ComponentDefine.getMarks()).append(A_LINE_T7Z).append(" ").append(ComponentDefine.getMarks()).append(aimFileName).append(ComponentDefine.getMarks()).append(" ").append(sb.toString());
            if (!FileAssistant.executeCmd(cmd.toString(), true)) {
                LOGGER.error("Compress " + sb.toString() + " error");
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compressTgzFile(String aimFileName, String ... sourceDir) {
        Object object = LOCK;
        synchronized (object) {
            if (StringUtils.hasNULLStr((String[])sourceDir) || StringUtils.isNULLStr((String)aimFileName)) {
                LOGGER.info("path is null.");
                return false;
            }
            String tempName = aimFileName.replace(".tgz", ".tar");
            StringBuffer sb = new StringBuffer();
            for (String file : sourceDir) {
                sb.append(ComponentDefine.getMarks() + file + ComponentDefine.getMarks() + " ");
            }
            StringBuffer cmd = new StringBuffer().append(ComponentDefine.getMarks()).append(FileAssistant.get7zPath()).append(ComponentDefine.getMarks()).append(NULL_A_NULL).append(ComponentDefine.getMarks()).append(tempName).append(ComponentDefine.getMarks()).append(" ").append(sb.toString());
            if (!FileAssistant.executeCmd(cmd.toString(), true)) {
                LOGGER.error("Compress " + sb.toString() + " error");
                return false;
            }
            if (!FileAssistant.compressTarFile(tempName, aimFileName)) {
                FileUtils.deleteFile((File)new File(tempName));
                return false;
            }
            FileUtils.deleteFile((File)new File(tempName));
            return true;
        }
    }

    private static boolean compressTarFile(String tempName, String targetPath) {
        StringBuffer cmd = new StringBuffer().append(ComponentDefine.getMarks()).append(FileAssistant.get7zPath()).append(ComponentDefine.getMarks()).append(NULL_A_NULL).append(ComponentDefine.getMarks()).append(targetPath).append(ComponentDefine.getMarks()).append(" ").append(ComponentDefine.getMarks()).append(tempName).append(ComponentDefine.getMarks());
        if (!FileAssistant.executeCmd(cmd.toString(), true)) {
            LOGGER.error("Compress " + tempName + " error");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deCopmressZipFile(String targetPath, String zipSourceFilePath, String ... targetFiles) {
        Object object = LOCK;
        synchronized (object) {
            if (StringUtils.hasNULLStr((String[])targetFiles) || StringUtils.hasNULLStr((String[])new String[]{targetPath, zipSourceFilePath})) {
                LOGGER.info("path is null.");
                return;
            }
            if (!FileUtils.fileSize2GInvalid((File)new File(zipSourceFilePath))) {
                LOGGER.info("the file size is over 2G.{}", (Object)zipSourceFilePath);
                return;
            }
            StringBuffer targetFileSb = new StringBuffer();
            for (String targetFile : targetFiles) {
                targetFileSb.append(targetFile);
                targetFileSb.append(" ");
            }
            String targets = targetFileSb.toString().trim();
            StringBuffer cmdSb = new StringBuffer().append(ComponentDefine.getMarks()).append(FileAssistant.get7zPath()).append(ComponentDefine.getMarks()).append(NULL_X_NULL).append(ComponentDefine.getMarks()).append(zipSourceFilePath).append(ComponentDefine.getMarks()).append(NULL_LINE_O).append(ComponentDefine.getMarks()).append(targetPath).append(ComponentDefine.getMarks()).append(ComponentDefine.getMarks()).append(targets).append(LINE_R_LINE_Y);
            if (!FileAssistant.executeCmd(cmdSb.toString(), true)) {
                LOGGER.info("Decompress {} from zip file {} with 7z error !", (Object)targets, (Object)zipSourceFilePath);
            }
        }
    }

    public static boolean compress2Tar(String target, String ... sources) {
        String cmdTemp = "\"%s\" a -ttar \"%s\" -r \"%s\"";
        String cmd = String.format(Locale.ENGLISH, cmdTemp, FileAssistant.get7zPath(), target, String.join((CharSequence)"\" \"", sources));
        return FileAssistant.executeCmd(cmd, true);
    }

    public static boolean compress2Gz(String target, String source) {
        String cmdTemp = "\"%s\" a -tgzip \"%s\" \"%s\"";
        String cmd = String.format(Locale.ENGLISH, cmdTemp, FileAssistant.get7zPath(), target, source);
        return FileAssistant.executeCmd(cmd, true);
    }

    public static boolean compress2TGZ(String targetDir, String fileName, String[] sources) {
        String tarFileName = targetDir + File.separator + fileName + ".tar";
        if (!FileAssistant.compress2Tar(tarFileName, sources)) {
            return false;
        }
        String gzFileName = tarFileName + ".gz";
        if (!FileAssistant.compress2Gz(gzFileName, tarFileName)) {
            return false;
        }
        FileUtils.deleteAllInFolder((String)new File(gzFileName).getParent(), (File[])new File[]{new File(gzFileName)});
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int deCopmressZipFileWithPassword(String targetPath, String zipFilePath, String password, String ... targetFiles) {
        Object object = LOCK;
        synchronized (object) {
            if (StringUtils.hasNULLStr((String[])targetFiles) || StringUtils.hasNULLStr((String[])new String[]{targetPath, zipFilePath})) {
                LOGGER.info("path is null.");
                return 1;
            }
            if (!FileUtils.fileSize2GInvalid((File)new File(zipFilePath))) {
                LOGGER.info("the file size is over 2G,{}", (Object)zipFilePath);
                return 1;
            }
            StringBuffer targetFileSb = new StringBuffer();
            for (String targetFile : targetFiles) {
                targetFileSb.append(targetFile);
                targetFileSb.append(" ");
            }
            String targetFile = targetFileSb.toString().trim();
            StringBuffer cmdSb = new StringBuffer().append(ComponentDefine.getMarks()).append(FileAssistant.get7zPath()).append(ComponentDefine.getMarks()).append(NULL_X_NULL).append(ComponentDefine.getMarks()).append(zipFilePath).append(ComponentDefine.getMarks()).append(NULL_LINE_O).append(ComponentDefine.getMarks()).append(targetPath).append(ComponentDefine.getMarks()).append(" ").append(targetFile).append(LINE_R_LINE_Y);
            String result = FileAssistant.executeCmdWithPassword(cmdSb.toString(), password);
            if (-1 != result.indexOf("Wrong password")) {
                return -1;
            }
            LOGGER.info("Decompress {} from zip file {} with 7z result: {}", new Object[]{targetFile, zipFilePath, result});
            if (-1 != result.toLowerCase(Locale.ENGLISH).indexOf(PASSWORD)) {
                try {
                    if (!FileAssistant.executeCmd(password, false)) {
                        LOGGER.info("Decompress {} from zip file {} with 7z error !", (Object)targetFile, (Object)zipFilePath);
                    }
                }
                catch (RuntimeException e) {
                    LOGGER.error("executeCmd Password error!!!", (Throwable)e);
                }
            }
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deCopmressTotalZipFile(String targetWithPath, String zipFilePath, String[] pwds) {
        Object object = LOCK;
        synchronized (object) {
            StringBuffer cmd;
            String result;
            if (StringUtils.hasNULLStr((String[])new String[]{targetWithPath, zipFilePath})) {
                LOGGER.info("path is null.");
                return;
            }
            if (!FileUtils.fileSize2GInvalid((File)new File(zipFilePath))) {
                LOGGER.info("the file size is over 2G.{}", (Object)zipFilePath);
                return;
            }
            for (int i = 0; i < pwds.length && !FileAssistant.isExecuteSuccess(result = FileAssistant.executeCmdWithPassword((cmd = new StringBuffer().append(ComponentDefine.getMarks()).append(FileAssistant.get7zPath()).append(ComponentDefine.getMarks()).append(NULL_X_NULL).append(ComponentDefine.getMarks()).append(zipFilePath).append(ComponentDefine.getMarks()).append(NULL_LINE_O).append(ComponentDefine.getMarks()).append(targetWithPath).append(ComponentDefine.getMarks()).append(NULL_LINE_Y)).toString(), pwds[i])); ++i) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deCopmressTotalZipFile(String targetWithPath, String zipFilePath) {
        Object object = LOCK;
        synchronized (object) {
            if (StringUtils.hasNULLStr((String[])new String[]{targetWithPath, zipFilePath})) {
                LOGGER.info("path is null.");
                return;
            }
            if (!FileUtils.fileSize2GInvalid((File)new File(zipFilePath))) {
                LOGGER.info("the file size is over 2G, {}", (Object)zipFilePath);
                return;
            }
            StringBuffer cmd = new StringBuffer().append(ComponentDefine.getMarks()).append(FileAssistant.get7zPath()).append(ComponentDefine.getMarks()).append(NULL_X_NULL).append(ComponentDefine.getMarks()).append(zipFilePath).append(ComponentDefine.getMarks()).append(NULL_LINE_O).append(ComponentDefine.getMarks()).append(targetWithPath).append(ComponentDefine.getMarks()).append(NULL_LINE_Y);
            if (!FileAssistant.executeCmd(cmd.toString(), true)) {
                LOGGER.info("Decompress zip file {} with 7z error!", (Object)zipFilePath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deCompressTgz(String targetPath, String gzFilePath) {
        Object object = LOCK;
        synchronized (object) {
            if (StringUtils.hasNULLStr((String[])new String[]{targetPath, gzFilePath})) {
                LOGGER.info("path is null.");
                return false;
            }
            File gzFile = new File(gzFilePath);
            if (!FileUtils.fileSize2GInvalid((File)gzFile)) {
                LOGGER.info("the file size is over 2G, {}", (Object)gzFilePath);
                return false;
            }
            String tarFileName = targetPath + File.separator + gzFile.getName().replace(".tgz", ".tar");
            if (!FileAssistant.deCopmressAllZipFile(targetPath, gzFilePath)) {
                LOGGER.info("deCopmress tgz file to tar file failed!");
                return false;
            }
            if (!FileAssistant.deCopmressAllZipFile(targetPath, tarFileName)) {
                LOGGER.info("deCopmress tar file failed!");
                return false;
            }
            File tarFile = new File(tarFileName);
            if (!tarFile.delete()) {
                LOGGER.error("Delete file " + tarFileName + " error!");
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deCopmressAllZipFile(String targetWithPath, String zipFilePath) {
        Object object = LOCK;
        synchronized (object) {
            if (StringUtils.hasNULLStr((String[])new String[]{targetWithPath, zipFilePath})) {
                LOGGER.info("path is null.");
                return false;
            }
            if (!FileUtils.fileSize2GInvalid((File)new File(zipFilePath))) {
                LOGGER.info("the file size is over 2G, {}", (Object)zipFilePath);
                return false;
            }
            StringBuffer cmdBuffer = new StringBuffer().append(ComponentDefine.getMarks()).append(FileAssistant.get7zPath()).append(ComponentDefine.getMarks()).append(NULL_X_NULL).append(ComponentDefine.getMarks()).append(zipFilePath);
            cmdBuffer.append(ComponentDefine.getMarks()).append(NULL_LINE_O).append(ComponentDefine.getMarks()).append(targetWithPath).append(ComponentDefine.getMarks()).append(NULL_LINE_Y);
            if (!FileAssistant.executeCmd(cmdBuffer.toString(), true)) {
                LOGGER.info("Decompress zip file {} with 7z error!", (Object)zipFilePath);
                return false;
            }
            return true;
        }
    }

    public static String executeCmdWithPassword(String cmd, String pwssword) {
        Process pro = null;
        try {
            LOGGER.info("Execute command {}", (Object)cmd.replace(cmd, "******"));
            pro = OSCmdUtils.createCmdProcess((String[])new String[]{cmd});
        }
        catch (IOException e) {
            LOGGER.error("Execute " + cmd.replace(cmd, "******") + " error: ", (Throwable)e);
            return "";
        }
        catch (RuntimeException e) {
            LOGGER.error("Execute " + cmd.replace(cmd, "******") + " error: ", (Throwable)e);
            return "";
        }
        return CommonMethod.executePassword((Process)pro, (String)pwssword);
    }

    public static boolean executeCmdInPath(String cmd) {
        Process pro = null;
        try {
            LOGGER.info("Execute command: {}", (Object)cmd);
            pro = OSCmdUtils.createCmdProcess((String[])new String[]{"cmd.exe /C " + cmd});
        }
        catch (IOException e) {
            LOGGER.error("Execute " + cmd + " error: ", (Throwable)e);
            return false;
        }
        catch (RuntimeException e) {
            LOGGER.error("Execute " + cmd + " error: ", (Throwable)e);
            return false;
        }
        String result = CommonMethod.getProcessResult((Process)pro);
        LOGGER.info("executeCmd result:{}", (Object)result);
        return !result.toLowerCase(Locale.ENGLISH).contains("error");
    }

    public static boolean executeCmdInPathWithoutResult(String cmd) {
        String finalCmd = "cmd.exe /C " + cmd;
        try {
            LOGGER.info("Execute command {}", (Object)finalCmd);
            OSCmdUtils.executeCmd((String)finalCmd);
        }
        catch (RuntimeException e) {
            LOGGER.error("Execute " + finalCmd + " error: ", (Throwable)e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deCompressTarGzFile(String targetPath, String tarGzFilePath) {
        Object object = LOCK;
        synchronized (object) {
            if (StringUtils.hasNULLStr((String[])new String[]{targetPath, tarGzFilePath})) {
                LOGGER.info("path is null.");
                return;
            }
            if (!FileUtils.fileSize2GInvalid((File)new File(tarGzFilePath))) {
                LOGGER.info("the file size is over 2G, {}", (Object)tarGzFilePath);
                return;
            }
            String tarFileName = tarGzFilePath.split(GZ_SUFFIX_REG)[0];
            FileAssistant.deCopmressTotalZipFile(targetPath, tarGzFilePath);
            FileAssistant.deCopmressTotalZipFile(tarGzFilePath, tarFileName);
            File tarFile = new File(tarFileName);
            if (!tarFile.delete()) {
                LOGGER.error("Delete file " + tarFileName + " error!");
            }
        }
    }

    public static boolean createFile(File file) {
        if (Objects.isNull(file)) {
            return false;
        }
        if (Objects.nonNull(file.getParentFile()) && !file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            LOGGER.warn("create parent dir {} fail.", (Object)file.getParent());
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            LOGGER.error("creat file failed", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deCompressTarbz2File(String targetPath, String tarGzFilePath) {
        Object object = LOCK;
        synchronized (object) {
            if (StringUtils.hasNULLStr((String[])new String[]{targetPath, tarGzFilePath})) {
                LOGGER.info("path is null.");
                return;
            }
            if (!FileUtils.fileSize2GInvalid((File)new File(tarGzFilePath))) {
                LOGGER.info("the file size is over 2G. {}", (Object)tarGzFilePath);
                return;
            }
            if (!tarGzFilePath.endsWith(".bz2")) {
                return;
            }
            String tarFileName = tarGzFilePath.split(BZ2_SUFFIX_REG)[0];
            File file = new File(tarFileName);
            String tarbz2FileName = file.getName();
            String[] tmp = tarbz2FileName.split(TAR_SUFFIX_REG);
            FileAssistant.deCopmressTotalZipFile(targetPath, tarGzFilePath);
            FileAssistant.deCopmressTotalZipFile(targetPath + File.separator + tmp[0], tarFileName);
            File tarFile = new File(tarFileName);
            if (!tarFile.delete()) {
                LOGGER.error("Delete file " + tarFileName + " error!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deCompressTarbz2FileWithName(String targetPath, String tarGzFilePath) {
        Object object = LOCK;
        synchronized (object) {
            if (StringUtils.hasNULLStr((String[])new String[]{targetPath, tarGzFilePath})) {
                LOGGER.info("path is null.");
                return;
            }
            if (!FileUtils.fileSize2GInvalid((File)new File(tarGzFilePath))) {
                LOGGER.info("the file size is over 2G. {}", (Object)tarGzFilePath);
                return;
            }
            String tarFileName = tarGzFilePath.split(BZ2_SUFFIX_REG)[0];
            FileAssistant.deCopmressTotalZipFile(targetPath, tarGzFilePath);
            FileAssistant.deCopmressTotalZipFile(targetPath, tarFileName);
            File tarFile = new File(tarFileName);
            if (!tarFile.delete()) {
                LOGGER.error("Delete file " + tarFileName + " error!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deCompressTgzFile(String targetPath, String gzFilePath) {
        Object object = LOCK;
        synchronized (object) {
            if (StringUtils.hasNULLStr((String[])new String[]{targetPath, gzFilePath})) {
                LOGGER.info("path is null.");
                return;
            }
            File gzFile = new File(gzFilePath);
            if (!FileUtils.fileSize2GInvalid((File)gzFile)) {
                LOGGER.info("the file size is over 2G. {}", (Object)gzFilePath);
                return;
            }
            String tarFileName = targetPath + File.separator + gzFile.getName().replace(".tgz", ".tar");
            FileAssistant.deCopmressTotalZipFile(targetPath, gzFilePath);
            FileAssistant.deCopmressTotalZipFile(targetPath, tarFileName);
            File tarFile = new File(tarFileName);
            if (!tarFile.delete()) {
                LOGGER.error("Delete file " + tarFileName + " error!");
            }
        }
    }

    public static boolean delFile(String filePath) {
        if (StringUtils.hasNULLStr((String[])new String[]{filePath})) {
            LOGGER.info("path is null.");
            return false;
        }
        File sourceZipFile = new File(filePath);
        if (sourceZipFile.exists()) {
            return sourceZipFile.delete();
        }
        LOGGER.error("the filePath is not exist!:" + filePath);
        return true;
    }

    public static boolean delDirAndFile(String fileDir) {
        if (StringUtils.hasNULLStr((String[])new String[]{fileDir})) {
            LOGGER.info("path is null.");
            return false;
        }
        LOGGER.info("delete dir and file:{}", (Object)fileDir);
        File file2Del = new File(fileDir);
        FileAssistant.clearFileDir(file2Del);
        if (!file2Del.delete()) {
            FileAssistant.delDirWithOsCmd(FilesUtil.getCanonicalPath((File)file2Del));
        }
        return true;
    }

    public static boolean delDirWithOsCmd(String dirPath) {
        if (StringUtils.hasNULLStr((String[])new String[]{dirPath})) {
            LOGGER.info("path is null.");
            return false;
        }
        String osName = System.getProperty(OS_POINT_NAME);
        if (null == osName) {
            throw new NullPointerException("Get OS name fail!");
        }
        if (osName.contains(WINDOWS)) {
            return FileAssistant.executeCmdInPath(RD + ComponentDefine.getMarks() + dirPath + ComponentDefine.getMarks() + " " + Q_NULL_S);
        }
        if (osName.contains("Linux")) {
            return FileAssistant.executeCmd(RM_NULL_RF + dirPath, true);
        }
        return false;
    }

    public static void clearFileDir(File filetoDelete) {
        if (null == filetoDelete) {
            return;
        }
        if (!filetoDelete.isDirectory()) {
            return;
        }
        File tmpFile = new File(filetoDelete.toURI().getPath());
        File[] files = tmpFile.listFiles();
        boolean isDelectSuccess = false;
        if (null == files || files.length == 0) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                FileAssistant.clearFileDir(file);
            }
            try {
                isDelectSuccess = file.delete();
            }
            catch (SecurityException e) {
                LOGGER.error("Delete file exception", (Throwable)e);
            }
            if (isDelectSuccess) continue;
            LOGGER.error("Delete file " + file.getName() + " error");
        }
    }

    public static Collection<String> listAllFile(String parentPath, String ... fileSuffix) {
        ArrayList<String> result = new ArrayList<String>();
        File path = new File(parentPath);
        File[] subFiles = path.listFiles();
        if (null == subFiles) {
            LOGGER.info("subFiles is null!");
            return result;
        }
        for (File file : subFiles) {
            String fileName = file.getName();
            String filePath = FilesUtil.getCanonicalPath((File)file);
            if (FileAssistant.isMathFileSuffix(fileName, fileSuffix)) {
                result.add(filePath);
                continue;
            }
            if (!file.isDirectory()) continue;
            result.addAll(FileAssistant.listAllFile(filePath, fileSuffix));
        }
        return result;
    }

    private static boolean isMathFileSuffix(String fileName, String ... fileSuffixs) {
        for (String suffix : fileSuffixs) {
            if (!fileName.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    public static Collection<String> listAllFileWithNameIndex(String parentPath, String nameIndex) {
        ArrayList<String> result = new ArrayList<String>();
        File path = new File(parentPath);
        File[] subFiles = path.listFiles();
        if (null == subFiles) {
            LOGGER.info("subFiles is null!");
            return result;
        }
        for (File file : subFiles) {
            String fileName = file.getName();
            String filePath = FilesUtil.getCanonicalPath((File)file);
            if (file.isDirectory() || -1 == fileName.indexOf(nameIndex)) continue;
            result.add(filePath);
        }
        return result;
    }

    public static void clearFileDir(File filetoDelete, String except) {
        if (null == filetoDelete) {
            return;
        }
        URI uri = filetoDelete.toURI();
        File tmpFile = null;
        try {
            tmpFile = new File(uri.toURL().getPath());
        }
        catch (MalformedURLException e1) {
            LOGGER.error("Create file error.", (Throwable)e1);
        }
        if (null == tmpFile) {
            return;
        }
        if (!tmpFile.isDirectory()) {
            return;
        }
        File[] files = tmpFile.listFiles();
        if (null == files) {
            return;
        }
        boolean isDeleteSuccss = false;
        for (File file : files) {
            if (file.isDirectory()) {
                FileAssistant.clearFileDir(file);
            }
            if (-1 != file.getName().indexOf(except)) continue;
            try {
                isDeleteSuccss = file.delete();
            }
            catch (SecurityException e) {
                LOGGER.error("Delete file exception", (Throwable)e);
            }
            if (isDeleteSuccss) continue;
            LOGGER.error("Delete file " + file.getName() + " error");
        }
    }

    public static void mergeFiles(String sourceFile, String resultFile) {
        if (StringUtils.hasNULLStr((String[])new String[]{sourceFile, resultFile})) {
            LOGGER.info("path is null.");
            return;
        }
        String osName = System.getProperty(OS_POINT_NAME);
        StringBuffer cmdSb = new StringBuffer();
        if (null == osName) {
            throw new NullPointerException("Get OS name fail!");
        }
        if (osName.contains(WINDOWS)) {
            cmdSb.append("type").append(" ").append(ComponentDefine.getMarks()).append(sourceFile).append(ComponentDefine.getMarks()).append(">>").append(ComponentDefine.getMarks()).append(resultFile).append(ComponentDefine.getMarks());
        } else if (osName.contains("Linux")) {
            cmdSb.append("cat").append(" ").append(ComponentDefine.getMarks()).append(sourceFile).append(ComponentDefine.getMarks()).append(">>").append(ComponentDefine.getMarks()).append(resultFile).append(ComponentDefine.getMarks());
        }
        if (!FileAssistant.executeCmdInPath(cmdSb.toString())) {
            LOGGER.info("Merge file {} to {} error!", (Object)sourceFile, (Object)resultFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deCompressFiles(String rootPath, List<String> includePaths) {
        Object object = LOCK;
        synchronized (object) {
            if (StringUtils.hasNULLStr((String[])new String[]{rootPath})) {
                LOGGER.info("path is null.");
                return;
            }
            File file = new File(rootPath);
            File[] childrens = file.listFiles();
            if (null == childrens) {
                return;
            }
            for (File child : childrens) {
                if (!includePaths.contains(child.getName())) continue;
                File[] listFiles = child.listFiles();
                if (null == listFiles) {
                    LOGGER.info("listFiles is null!");
                    return;
                }
                for (File item : listFiles) {
                    if (!item.getName().endsWith(".tgz")) continue;
                    try {
                        FileAssistant.deCompressTgzFile(child.getCanonicalPath(), item.getCanonicalPath());
                    }
                    catch (IOException e) {
                        LOGGER.error("Get CanonicalPath Error: ", (Throwable)e);
                    }
                    if (item.delete()) continue;
                    LOGGER.error("Can not delete file: " + item.getName());
                }
            }
        }
    }

    private static String get7zPath() {
        return com.huawei.ism.tool.obase.utils.FileAssistant.get7zPath();
    }

    private static String getLinux7zPath() {
        return ApplicationContext.getInstance().isWindowsOS() ? "" : "linux" + File.separator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compressFile7zToSplitVolume(String size, String aimFileName, String ... sourceDir) {
        Object object = LOCK;
        synchronized (object) {
            if (StringUtils.hasNULLStr((String[])sourceDir)) {
                LOGGER.info("path is null.");
                return;
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (String file : sourceDir) {
                stringBuffer.append(ComponentDefine.getMarks() + file + ComponentDefine.getMarks() + " ");
            }
            StringBuffer cmdFor7z = new StringBuffer().append(ComponentDefine.getMarks()).append(FileAssistant.get7zPath()).append(ComponentDefine.getMarks()).append(A_TZIP).append(" ").append(ComponentDefine.getMarks()).append(aimFileName).append(ComponentDefine.getMarks()).append(" ").append(stringBuffer.toString()).append(LINE_V).append(size);
            boolean reslut = FileAssistant.executeCmd(cmdFor7z.toString(), true);
            if (!reslut) {
                LOGGER.error("Compress " + stringBuffer.toString() + " error");
            } else {
                LOGGER.info("Compressed files has succeed!");
            }
        }
    }

    public static boolean executeCmd(String cmd, boolean log) {
        Process pro = null;
        String actualCmd = cmd;
        try {
            LOGGER.info("Execute command {}", (Object)actualCmd);
            actualCmd = Normalizer.normalize(actualCmd, Normalizer.Form.NFKC);
            pro = OSCmdUtils.createCmdProcess((String[])new String[]{actualCmd});
        }
        catch (IOException e) {
            LOGGER.error("Execute " + actualCmd + " error: ", (Throwable)e);
            return false;
        }
        catch (RuntimeException e) {
            LOGGER.error("Execute " + actualCmd + " error: ", (Throwable)e);
            return false;
        }
        LOGGER.info("Execute command over{}", (Object)actualCmd);
        String result = CommonMethod.getProcessResult((Process)pro);
        LOGGER.info("executeCmd result:{}", (Object)result);
        return FileAssistant.isExecuteSuccess(result);
    }

    private static boolean isExecuteSuccess(String result) {
        return !result.toLowerCase(Locale.ENGLISH).contains("error");
    }

    private static void closeStream(Object obj) {
        if (null == obj) {
            return;
        }
        try {
            if (obj instanceof ZipInputStream) {
                ((ZipInputStream)obj).closeEntry();
            } else if (obj instanceof DataOutputStream) {
                ((DataOutputStream)obj).close();
            } else if (obj instanceof FileOutputStream) {
                ((FileOutputStream)obj).close();
            }
        }
        catch (IOException e) {
            ToolLoggerFactory.getLogger(FileAssistant.class).error("close stream error!" + e);
        }
    }

    public static boolean checkDiskFreeSpace(File destFile, int miniCapacity) {
        long capacity = (long)miniCapacity * 1024L * 1024L;
        long destFileFreeSpace = destFile.getFreeSpace();
        return destFileFreeSpace >= capacity;
    }

    public static boolean copyRight(String srcPath, String destPath, int srcLimitCapacity, int destMiniCapacity) {
        File destFile = new File(destPath);
        File srcFile = new File(srcPath);
        if (!srcFile.exists()) {
            LOGGER.info("src file is not exists.");
            return false;
        }
        if (!destFile.exists() && !destFile.mkdirs()) {
            LOGGER.info("make destFile failed.");
            return false;
        }
        if (!FileAssistant.checkFileSize(srcFile, srcLimitCapacity)) {
            LOGGER.info("the size of srcfile : {} is more than 2G , file size :{}", (Object)srcPath, (Object)srcFile.length());
            return false;
        }
        if (!destFile.canWrite()) {
            LOGGER.info("the file can not write.");
            return false;
        }
        if (!FileAssistant.checkDiskFreeSpace(destFile, destMiniCapacity)) {
            LOGGER.info("the file FreeSpace is less than {}M.", (Object)destMiniCapacity);
            return false;
        }
        if (!FileAssistant.checkDiskFull(srcFile, destFile)) {
            LOGGER.info("the diskspace is not enough");
            return false;
        }
        return true;
    }

    public static boolean checkFileSize(File srcFile, int srcLimitCapacity) {
        return srcFile.length() <= (long)srcLimitCapacity * 1024L * 1024L;
    }

    public static boolean checkDiskFull(File srcFile, File destFile) {
        return srcFile.length() < destFile.getFreeSpace();
    }

    public static File copyFile(File targetFile, String toPath) {
        if (null == targetFile) {
            return null;
        }
        Object targetChannel = null;
        Object newChannel = null;
        File result = null;
        File copyToDir = new File(toPath);
        if (!copyToDir.exists() && !copyToDir.mkdirs()) {
            return null;
        }
        String newFile = copyToDir + File.separator + targetFile.getName();
        if (targetFile.isDirectory()) {
            if (!new File(newFile).mkdirs()) {
                return null;
            }
        } else {
            try (FileInputStream tfin = new FileInputStream(targetFile);
                 FileOutputStream nfout = new FileOutputStream(newFile);){
                FileAssistant.doChannelTransfer(tfin, nfout);
                result = new File(newFile);
            }
            catch (FileNotFoundException e) {
                LOGGER.error("Exception: target file or new file not found. targetFile:{} newFile:{}", (Object)targetFile.getName(), (Object)new File(newFile).getName());
            }
            catch (IOException e) {
                LOGGER.error("transfer data from ", new Object[]{targetFile, " fail.", e.getMessage()});
            }
        }
        return result;
    }

    private static void doChannelTransfer(FileInputStream tfin, FileOutputStream nfout) throws IOException {
        FileChannel targetChannel = tfin.getChannel();
        FileChannel newChannel = nfout.getChannel();
        try {
            newChannel.transferFrom(targetChannel, 0L, targetChannel.size());
        }
        catch (IOException e) {
            LOGGER.error("transfer channel failed.");
            throw e;
        }
        finally {
            FileAssistant.closeChannel(targetChannel, newChannel);
        }
    }

    private static void closeChannel(FileChannel targetChannel, FileChannel newChannel) {
        try {
            if (targetChannel != null) {
                targetChannel.close();
            }
        }
        catch (IOException e) {
            LOGGER.error("IOException", (Throwable)e);
        }
        try {
            if (newChannel != null) {
                newChannel.close();
            }
        }
        catch (IOException e) {
            LOGGER.error("IOException", (Throwable)e);
        }
    }

    public static boolean checkPatch(JDialog mainDialog, String path) {
        if (!FilesUtil.checkNormalPath((String)path)) {
            DialogUtils.showInfoDialog((JDialog)mainDialog, (String)ResourceUtil.getString((String)"selsect.path.check"));
            return false;
        }
        return true;
    }
}

