/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.utils;

import com.huawei.ism.tool.inspect.entity.ConstantField;
import com.huawei.ism.tool.inspect.entity.DevInfo4Exp;
import com.huawei.ism.tool.inspect.entity.FsNodeExpansionConfig;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DiskTypeEnum;
import com.huawei.ism.tool.obase.entity.FusionStorDiskInfo;
import com.huawei.ism.tool.obase.entity.FusionStorStoragePool;
import java.util.HashMap;
import java.util.Map;

public class FsExpansionUtils {
    public static void cleanExpansionClusterNodeList(FusionStorStoragePool storagePool) {
        storagePool.getExpansionClusterNode().forEach(node -> InspectContext.getInstance().getFsExpansionConfig((ClusterNode)node).setExpansionJoinStoragePool(null));
        storagePool.cleanExpansionClusterNode();
    }

    public static void cleanExpansionNodeList(FusionStorStoragePool storagePool) {
        storagePool.getExpansionNodeList().forEach(node -> InspectContext.getInstance().getFsExpansionConfig((DevNode)node).setExpansionJoinStoragePool(null));
        storagePool.cleanExpansionNodeList();
    }

    public static void cleanPoolAllNode(FusionStorStoragePool storagePool) {
        FsExpansionUtils.cleanExpansionClusterNodeList(storagePool);
        FsExpansionUtils.cleanExpansionNodeList(storagePool);
        storagePool.getDiskPools().forEach(diskPool -> FsExpansionUtils.cleanPoolAllNode(diskPool));
    }

    public static boolean isFreeNode(DevNode devNode) {
        return InspectContext.getInstance().getFsExpansionConfig(devNode).getExpansionJoinStoragePool() == null;
    }

    public static boolean isFreeNode(ClusterNode clusterNode) {
        return InspectContext.getInstance().getFsExpansionConfig(clusterNode).getExpansionJoinStoragePool() == null;
    }

    public static void cleanExpansionConfig(DevNode devNode) {
        FsNodeExpansionConfig config = InspectContext.getInstance().getFsExpansionConfig(devNode);
        config.setExpansionMainStorageDisk(new HashMap<FusionStorDiskInfo, Integer>());
        config.setExpansionCacheDisk(new HashMap<FusionStorDiskInfo, Integer>());
    }

    public static void cleanExpansionConfig(ClusterNode clusterNode) {
        FsNodeExpansionConfig config = InspectContext.getInstance().getFsExpansionConfig(clusterNode);
        config.setExpansionMainStorageDisk(new HashMap<FusionStorDiskInfo, Integer>());
        config.setExpansionCacheDisk(new HashMap<FusionStorDiskInfo, Integer>());
    }

    public static String getTotalCapacityByString(FusionStorStoragePool pool) {
        double[] capacity = FsExpansionUtils.getCapacityByAllDisk(pool, pool.getTotalCapacity());
        return FusionStorStoragePool.getCapacityByString((double[])capacity);
    }

    public static String getFreeCapacityByString(FusionStorStoragePool pool) {
        double[] freeCapacity = FsExpansionUtils.getFreeCapacityByDouble(pool);
        return FusionStorStoragePool.getCapacityByString((double[])freeCapacity);
    }

    private static double[] getFreeCapacityByDouble(FusionStorStoragePool pool) {
        return FsExpansionUtils.getCapacityByAllDisk(pool, pool.getTotalCapacity() - pool.getUsedCapacity());
    }

    private static double[] getCapacityByAllDisk(FusionStorStoragePool pool, long capacity) {
        double[] freeCapacity = new double[]{0.0, 0.0};
        FsExpansionUtils.addCapacityByPoolToArray(pool, freeCapacity);
        pool.getDiskPools().forEach(diskPool -> FsExpansionUtils.addCapacityByPoolToArray(diskPool, freeCapacity));
        if (DiskTypeEnum.SSD_CARD_AND_NVME_SSD.equals((Object)pool.getMainStorageDiskType())) {
            freeCapacity[0] = freeCapacity[0] + (double)capacity;
        } else {
            freeCapacity[1] = freeCapacity[1] + (double)capacity;
        }
        return freeCapacity;
    }

    private static double[] addCapacityByPoolToArray(FusionStorStoragePool pool, double[] freeCapacity) {
        pool.getJoinedClusterNode().forEach(node -> FsExpansionUtils.getCapacityByDiskList(freeCapacity, InspectContext.getInstance().getFsExpansionConfig((ClusterNode)node).getExpansionMainStorageDisk()));
        pool.getExpansionClusterNode().forEach(node -> FsExpansionUtils.getCapacityByDiskList(freeCapacity, InspectContext.getInstance().getFsExpansionConfig((ClusterNode)node).getExpansionMainStorageDisk()));
        pool.getExpansionNodeList().forEach(expansionNode -> FsExpansionUtils.getCapacityByDiskList(freeCapacity, InspectContext.getInstance().getFsExpansionConfig((DevNode)expansionNode).getExpansionMainStorageDisk()));
        return freeCapacity;
    }

    private static void getCapacityByDiskList(double[] freeCapacity, Map<FusionStorDiskInfo, Integer> diskMap) {
        diskMap.keySet().forEach(disk -> {
            Integer number = (Integer)diskMap.get(disk);
            FusionStorStoragePool.getCapacityByDisk((double[])freeCapacity, (FusionStorDiskInfo)disk, (Integer)number);
        });
    }

    public static boolean isNewDoradoHddDev(DevInfo4Exp devNode) {
        return ConstantField.NEW_DORADO_DEV.contains(devNode.getDevType()) && !ConstantField.NEW_DORADO_INTER_MODEL.contains(devNode.getInternalModel());
    }

    public static boolean isQLCProductDev(DevInfo4Exp devNode) {
        return ConstantField.QLC_PRODUCT_DEV.contains(devNode.getDevType());
    }

    public static boolean isNewDoraoFlashDev(DevInfo4Exp devNode) {
        return ConstantField.NEW_DORADO_INTER_MODEL.contains(devNode.getInternalModel());
    }

    public static boolean isMicroFlashDev(DevInfo4Exp devNode) {
        return ConstantField.MICRO_FLASHING_INTER_MODEL.contains(devNode.getInternalModel());
    }

    public static boolean isNotSupportExpCtrl(DevInfo4Exp devNode) {
        return ConstantField.NOT_SUPPORT_CTRL_INTER_MODEL.contains(devNode.getInternalModel());
    }
}

