/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.utils;

import com.huawei.ism.tool.inspect.fit.common.InspectScene;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.OemUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class HtmlResUtils {
    private static final String HTMLLANGUAGERESOURCE = "config/resource/html/htmlresource";
    private static final String EXP_EVAL_HTML_RESOURCE = "config/resource/html/exp_eval_resource";
    private static final String FUSION_EVAL_HTML_RESUORCE = "config/resource/html/fusion_eval_resource";
    private static final String FUSIONCUBE_EVAL_HTML_RESUORCE = "config/resource/html/fusioncube_eval_resource";
    private static final String FUSION_INSPECT_HTML_RESOURCE = "config/resource/html/fusion_inspect_resource";
    private static final String FS_EXPANSION_HTML_RESOURCE = "config/resource/html/fs_expansion_resource";
    private static final String STORAGE_CONFIG_RESOURCE = "config/resource/html/storage_config";
    private static ResourceBundle resource = null;

    public static void init() {
        String resFilePth = "";
        resFilePth = InspectUtils.isPreExpEvaluation() != false ? EXP_EVAL_HTML_RESOURCE : (InspectUtils.isFusionEval() ? FUSION_EVAL_HTML_RESUORCE : (InspectUtils.isFusionCubeEval() ? FUSIONCUBE_EVAL_HTML_RESUORCE : (InspectUtils.isFusionInspect() ? FUSION_INSPECT_HTML_RESOURCE : (InspectUtils.isFsExInspect() ? FS_EXPANSION_HTML_RESOURCE : HTMLLANGUAGERESOURCE))));
        resource = ResourceBundle.getBundle(resFilePth, ApplicationContext.getInstance().getCurrentLanguage());
    }

    public static void init(InspectScene scene) {
        if (scene == InspectScene.STORAGE_CONFIG) {
            resource = ResourceBundle.getBundle(STORAGE_CONFIG_RESOURCE, ApplicationContext.getInstance().getCurrentLanguage());
        }
    }

    private HtmlResUtils() {
    }

    public static String getString(String key) {
        if (ResourceUtil.isOemSupported() && ResourceUtil.isOemKey((String)key)) {
            return ResourceUtil.getString((String)key);
        }
        String value = null;
        try {
            value = resource.getString(key);
        }
        catch (MissingResourceException e) {
            ToolLoggerFactory.getLogger(ResourceUtil.class).error("Can not find resource:" + key);
        }
        return null == value ? "--" : value;
    }

    public static String getStringWithParam(String key, Object ... param) {
        String msg = HtmlResUtils.getString(key);
        return StringUtils.fillValues((String)msg, (Object[])param);
    }

    public static String getOEMString(String key) {
        return HtmlResUtils.getString(key + "." + OemUtils.getVender().toLowerCase(Locale.ENGLISH));
    }

    public static String escapeHtmlContent(String content) {
        String tempContent = "";
        if (StringUtils.isNULLStr((String)content)) {
            return tempContent;
        }
        tempContent = content.replaceAll(">", "&gt;").replaceAll("<", "&lt;");
        return tempContent;
    }

    static {
        HtmlResUtils.init();
    }
}

