/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.utils;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(IPUtils.class);

    public static String getNormalIPv6(String ipv6) {
        byte[] ret = new byte[16];
        ret[0] = 0;
        int ib = 15;
        String actualIpv6 = ipv6.startsWith(":") ? ipv6.substring(1) : ipv6;
        String[] groups = actualIpv6.split(":");
        for (int ig = groups.length - 1; ig > -1; --ig) {
            if ("".equals(groups[ig])) {
                int zlg = 9 - groups.length;
                while (zlg-- > 0) {
                    ret[ib--] = 0;
                    ret[ib--] = 0;
                }
                continue;
            }
            int temp = Integer.parseInt(groups[ig], 16);
            ret[ib--] = (byte)temp;
            ret[ib--] = (byte)(temp >> 8);
        }
        String ipv6New = "";
        try {
            ipv6New = InetAddress.getByAddress(ret).toString();
        }
        catch (UnknownHostException e) {
            LOGGER.error("parse ipv6:{} error:", (Object)ipv6New, (Object)e);
        }
        return ipv6New.substring(ipv6New.indexOf(47) + 1).trim();
    }
}

