/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.utils;

import com.huawei.ism.tool.base.utils.IniReader;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.common.data.ToolUserRole;
import com.huawei.ism.tool.framework.platform.context.AbstractContext;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.entity.ScenePathValue;
import com.huawei.ism.tool.framework.pubservice.entity.TaskResult;
import com.huawei.ism.tool.framework.pubservice.sceneimpl.SceneEnvironmentImpl;
import com.huawei.ism.tool.inspect.entity.A800ExpansionDiskInfo;
import com.huawei.ism.tool.inspect.entity.BureauFile;
import com.huawei.ism.tool.inspect.entity.CardModelEnum;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.entity.CollectModule;
import com.huawei.ism.tool.inspect.entity.DevInfo4Exp;
import com.huawei.ism.tool.inspect.entity.DiskDomain;
import com.huawei.ism.tool.inspect.entity.Enclosure;
import com.huawei.ism.tool.inspect.entity.FsNodeExpansionConfig;
import com.huawei.ism.tool.inspect.entity.HyperHostManualCheckItem;
import com.huawei.ism.tool.inspect.entity.HyperQuoServerManualCheckItem;
import com.huawei.ism.tool.inspect.entity.InspectUserOpData;
import com.huawei.ism.tool.inspect.entity.InspectionGradientGuidance;
import com.huawei.ism.tool.inspect.entity.SupportScenes;
import com.huawei.ism.tool.inspect.entity.UiUpdatePair;
import com.huawei.ism.tool.inspect.fit.util.DevUtil;
import com.huawei.ism.tool.inspect.fit.util.ProductUtil;
import com.huawei.ism.tool.inspect.logic.config.FusionStorageConfig;
import com.huawei.ism.tool.inspect.logic.config.HostSupportVersionParser;
import com.huawei.ism.tool.inspect.logic.config.IProductParser;
import com.huawei.ism.tool.inspect.logic.config.InspectSceneValue;
import com.huawei.ism.tool.inspect.logic.config.Product;
import com.huawei.ism.tool.inspect.logic.config.SupportVersion;
import com.huawei.ism.tool.inspect.logic.inspector.checkmodel.CheckModelInfo;
import com.huawei.ism.tool.inspect.service.implement.CloseObserver;
import com.huawei.ism.tool.inspect.ui.logic.BureauDocuService;
import com.huawei.ism.tool.inspect.ui.logic.Strategy;
import com.huawei.ism.tool.inspect.ui.wizard.PerformInspectCard;
import com.huawei.ism.tool.inspect.ui.wizard.SelectDeviceCard;
import com.huawei.ism.tool.inspect.utils.DirectoryFileFilter;
import com.huawei.ism.tool.inspect.utils.FileAssistant;
import com.huawei.ism.tool.inspect.utils.InspectConstans;
import com.huawei.ism.tool.inspect.utils.InspectUIUtil;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.inspect.utils.SupportScenesComparator;
import com.huawei.ism.tool.inspect.worktaker.InspectWorktaker;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.entity.KeyValue;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.ui.component.wizard.ToolWizardDialog;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.protocol.utils.RestUtil;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import com.huawei.ism.tool.service.patch.dstorage.Context;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import javax.swing.JRadioButton;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.python.core.PyDictionary;
import org.slf4j.Logger;
import utils.Products;

public final class InspectContext
extends AbstractContext {
    public static final String SCENE_TYPE_KEY = "sceneType";
    public static final String SUPPORT_SCENE_KEY = "supportScene";
    public static final String SCENE_EXP_CTRL = "expCtrl";
    public static final String SCENE_EXP_DISK = "expDisk";
    public static final String SCENE_EXP_LINK = "expLink";
    public static final String SCENE_EXP_DD = "expDD";
    public static final String SCENE_EXP_SCM = "expScm";
    public static final Map<String, String> ISVERSION = new HashMap<String, String>();
    public static final String INSPECT_CONFPATH = com.huawei.ism.tool.obase.utils.ApplicationContext.getInstance().getWorkPath() + File.separator + "packages" + File.separator + "inspector";
    public static final String HOT_PATCH_FILE = INSPECT_CONFPATH + File.separator + "products" + File.separator + "productHotPatch.xml";
    public static final Map<DevNode, String> DEVNODE_TYPE = new HashMap<DevNode, String>();
    public static final String ENCLO_MAX_DEPTH = "enclo_max_depth";
    public static final String HYPER_QUO_SERVER_AND_NOT_ADD_HOST_INFO = "HYPER_QUO_SERVER_AND_NOT_ADD_HOST_INFO";
    public static final String QUO_SERVER_LIST = "QUO_SERVER_LIST";
    public static final String NOT_ADD_HOST_LIST = "NOT_ADD_HOST_LIST";
    public static final ReentrantLock fileReadLock = new ReentrantLock();
    private static final String ENTRY_DIR = "entry";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(InspectContext.class);
    private static final Map<String, String> CHECK_ITEM_TO_CHECK_TYPE_MAP = new HashMap<String, String>();
    private static final DateTimeFormatter RANDOM_DIR_NAME_PATTERN = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS");
    private static final String PACKAGE_INI = "package.ini";
    private static final String SCENE_TOOL_ID = "Inspect";
    private static final int NUM_100 = 100;
    private static final int MAX_ITEM_PROGRESS = 95;
    private static final int MAX_INSPECT_NUM = 10;
    private static final String HOST_MAPPED_ARRAY_SN = "host_mapped_array_sn";
    private static final String ARRAY_SN = "array_sn";
    private static final int MAX_LENTH_EN = 50;
    private static final int MAX_LENTH_ZH = 26;
    private static InspectContext context = new InspectContext();
    private static Map<String, String> checkItemToRepairInfoMap = new HashMap<String, String>();
    private ScenePathValue scenePathValue = null;
    private InspectSceneValue inspectSceneValue = null;
    private String silentWorkPath = "";
    private boolean isOemOutTool = false;
    private boolean inMemoryInspectionSence = false;
    private String checkPeriodStartTime;
    private String qualityCheckUser = "";
    private InspectionGradientGuidance inspectionGradientGuidance = new InspectionGradientGuidance();
    private String memoryTaskDbPath;
    private String workPath;
    private String expCtrlEnv = "";
    private boolean checkVeritas = true;
    private boolean requireInnerMetro = false;
    private Map<String, String> scmExpInfo = new HashMap<String, String>();
    private Map<String, List<CheckItem>> innerCheckResultMap = new HashMap<String, List<CheckItem>>();
    private List<DevNode> newExpansionNode = new ArrayList<DevNode>();
    private Map<DevNode, FsNodeExpansionConfig> nodeExpansionConfigMap = new ConcurrentHashMap<DevNode, FsNodeExpansionConfig>();
    private Map<ClusterNode, FsNodeExpansionConfig> clusterNodeExpansionConfigMap = new ConcurrentHashMap<ClusterNode, FsNodeExpansionConfig>();
    private int expCtrlOri = 0;
    private String expModeOri = "";
    private String expMode = "";
    private String ctrlBom = "";
    private String encBom = "";
    private String interfaceBom = "";
    private String interfaceCardBom = "";
    private String diskEnclosureBom = "";
    private String repairInput = "";
    private DevInfo4Exp devInfo = null;
    private boolean openHelpFile = false;
    private ArrayList<Enclosure> statisticEncloureList = null;
    private String encloMaxDepth = null;
    private ArrayList<DiskDomain> statisticDDList = null;
    private ArrayList<DiskDomain> smartPoolDisks = null;
    private List<CheckItem> silenceCallCheckItems = null;
    private boolean isNfvMode = false;
    private String checkMode = "merge_check";
    private int inspectStep;
    private boolean isNeedCheckHighUsage = true;
    private Map<String, TableRow<?, ?>> devRows = new HashMap();
    private List<Object> hostLauncherWwnList = Collections.synchronizedList(new ArrayList());
    private Map<DevNode, Product> dStorageProduct = new ConcurrentHashMap<DevNode, Product>();
    private String include12HighEnclosure = "";
    private ArrayList<HashMap<String, String>> expDiskListEnv = new ArrayList();
    private ArrayList<Strategy> expStrategyList = new ArrayList();
    private Map<String, Integer> hyperMetroLockMap = new ConcurrentHashMap<String, Integer>();
    private String title;
    private String extendInspectScene;
    private String expScene;
    private String[] supportItems;
    private final Object lock = new Object();
    private boolean foreground = false;
    private boolean toolkitZhCn = false;
    private boolean havingRightPatchTool = false;
    private PerformInspectCard performInspectCard = null;
    private Map<File, JythonExecuter> requireCheckMap = new HashMap<File, JythonExecuter>();
    private Map<DevNode, Map<String, String>> hotPatchVersionWarningDevs = new ConcurrentHashMap<DevNode, Map<String, String>>();
    private ConcurrentHashMap<String, HashMap<String, Object>> allStrgHyprMtrLns = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Object> objectForPy = new ConcurrentHashMap();
    private boolean useApply = false;
    private Map<CheckDevNode, List<Strategy>> extendStrategies = new ConcurrentHashMap<CheckDevNode, List<Strategy>>();
    private Map<String, Boolean> isScenesInspect = new HashMap<String, Boolean>();
    private JDialog mainDialog;
    private CloseObserver closeObserver;
    private boolean timingCreateInspect;
    private List<Product> inspectProducts;
    private List<SupportVersion> supportVersions;
    private List<SupportVersion> extendVersions;
    private Set<String> supportVers;
    private Map<String, List<String>> hostSupportVers;
    private Map<CheckDevNode, UiUpdatePair> uiUpdatePairs = new ConcurrentHashMap<CheckDevNode, UiUpdatePair>();
    private List<InspectUserOpData> useropList = new ArrayList<InspectUserOpData>();
    private InspectWorktaker inspectWorktaker = new InspectWorktaker();
    private final Map<String, InspectWorktaker> workTaker = new ConcurrentHashMap<String, InspectWorktaker>();
    private String tempPath = "";
    private boolean isForeProcessRunning = false;
    private boolean isBackProcessRunning = false;
    private boolean decompressHelpcaseionFinish = false;
    private Locale loc = null;
    private int progress = 0;
    private Integer score = null;
    private Map<String, Float> passRateMap = new HashMap<String, Float>();
    private Map<String, Integer> scoreMap = new HashMap<String, Integer>();
    private boolean isAllSilentTaskOver = true;
    private boolean bureauCheckSelected = false;
    private boolean bureauCheck = false;
    private Map<DevNode, BureauFile> bureauFiles = new ConcurrentHashMap<DevNode, BureauFile>();
    private boolean finishHyperManualCheck = false;
    private List<String> resultFileList = new ArrayList<String>();
    private List<A800ExpansionDiskInfo> expansionA800DiskInfos = new ArrayList<A800ExpansionDiskInfo>();
    private String selectSeceneInSecondCard = "";
    private String eventReportFileName;

    private InspectContext() {
    }

    public List<CheckItem> getSilenceCallCheckItems() {
        return this.silenceCallCheckItems;
    }

    public void setSilenceCallCheckItems(List<CheckItem> checkItems) {
        this.silenceCallCheckItems = checkItems;
    }

    public String getInclude12HighEnclosure() {
        return this.include12HighEnclosure;
    }

    public List<CheckItem> getInnerCheckResult(String ip) {
        if (this.innerCheckResultMap.containsKey(ip)) {
            return this.innerCheckResultMap.get(ip);
        }
        return Collections.emptyList();
    }

    public void cleanInnerCheckResult() {
        this.innerCheckResultMap.clear();
    }

    public void cleanBom() {
        InspectContext.getInstance().setCtrlBom("");
        InspectContext.getInstance().setEncBom("");
        InspectContext.getInstance().setInterfaceBom("");
        InspectContext.getInstance().setInterfaceCardBom("");
        InspectContext.getInstance().setDiskEnclosureBom("");
    }

    public void setInnerCheckResult(String ip, CheckItem checkItem) {
        if (this.innerCheckResultMap.containsKey(ip)) {
            if (!this.innerCheckResultMap.get(ip).contains(checkItem)) {
                this.innerCheckResultMap.get(ip).add(checkItem);
            }
        } else {
            ArrayList<CheckItem> checkItems = new ArrayList<CheckItem>();
            checkItems.add(checkItem);
            this.innerCheckResultMap.put(ip, checkItems);
        }
    }

    public String getCheckType(String checkItemId) {
        if (CHECK_ITEM_TO_CHECK_TYPE_MAP.containsKey(checkItemId)) {
            return CHECK_ITEM_TO_CHECK_TYPE_MAP.get(checkItemId);
        }
        return "";
    }

    public String getRepairInfoKey(String checkItemId) {
        return checkItemToRepairInfoMap.getOrDefault(checkItemId, "");
    }

    public boolean isSupportRepairItem(String checkItemId) {
        return CHECK_ITEM_TO_CHECK_TYPE_MAP.containsKey(checkItemId);
    }

    public void setInclude12HighEnclosure(String include12HighEnclosure) {
        this.include12HighEnclosure = include12HighEnclosure;
    }

    public List<DevNode> getNewExpansionNode() {
        return this.newExpansionNode;
    }

    public void setNewExpansionNode(List<DevNode> newExpansionNode) {
        this.newExpansionNode = newExpansionNode;
    }

    public String getExpMode() {
        return this.expMode;
    }

    public int getExpCtrlOri() {
        return this.expCtrlOri;
    }

    public void setExpCtrlOri(int expCtrlOri) {
        this.expCtrlOri = expCtrlOri;
    }

    public void setExpMode(String expMode) {
        this.expMode = expMode;
    }

    public String getExpCtrlEnv() {
        return this.expCtrlEnv;
    }

    public void setExpCtrlEnv(String expCtrlEnv) {
        this.expCtrlEnv = expCtrlEnv;
    }

    public boolean isCheckVeritasEnv() {
        return this.checkVeritas;
    }

    public void setCheckVeritasEnv(boolean checkVerita) {
        this.checkVeritas = checkVerita;
    }

    public boolean isRequireInnerMetro() {
        return this.requireInnerMetro;
    }

    public void setRequireInnerMetro(boolean reqInnerMetro) {
        this.requireInnerMetro = reqInnerMetro;
    }

    public ArrayList<HashMap<String, String>> getExpDiskListEnv() {
        return this.expDiskListEnv;
    }

    public void setExpDiskListEnv(ArrayList<HashMap<String, String>> expDiskListEnv) {
        this.expDiskListEnv = expDiskListEnv;
    }

    public void setCtrlBom(String ctrlBom) {
        this.ctrlBom = ctrlBom;
    }

    public String getCtrlBom() {
        return this.ctrlBom;
    }

    public void setEncBom(String encBom) {
        this.encBom = encBom;
    }

    public String getEncBom() {
        return this.encBom;
    }

    public String getExpModeOri() {
        return this.expModeOri;
    }

    public void setExpModeOri(String expModeOri) {
        this.expModeOri = expModeOri;
    }

    public ArrayList<Strategy> getExpStrategyList() {
        return this.expStrategyList;
    }

    public void setExpStrategyList(ArrayList<Strategy> expStrategyList) {
        this.expStrategyList = expStrategyList;
    }

    public void initToolScene() {
        String extendModelJson = InspectContext.getArgsParamFormSceneConfig("effectiveScene");
        if (InspectUtils.isFusionEval() || InspectUtils.isFusionCubeEval()) {
            this.title = ResourceUtil.getString((String)"inspect.title.fustion.eval");
            this.extendInspectScene = null;
        } else if (this.isInspectScene(extendModelJson)) {
            this.title = ResourceUtil.getString((String)"inspect.title.inspect");
            this.extendInspectScene = null;
        } else if (InspectUtils.isFsExInspect()) {
            this.title = ResourceUtil.getString((String)"inspect.title.fs.extend");
            this.extendInspectScene = null;
        } else {
            this.extendInspectScene = extendModelJson.trim();
            this.title = ResourceUtil.getString((String)"inspect.title.extend");
        }
        LOGGER.info("title: {} extendInspectScene: {}", (Object)this.title, (Object)this.extendInspectScene);
        this.expScene = InspectContext.getArgsParamFormSceneConfig(SCENE_TYPE_KEY);
        LOGGER.info("sceneType: {}", (Object)this.expScene);
    }

    private boolean isInspectScene(String extendModelJson) {
        return InspectUtils.isFusionInspect() || null == extendModelJson || extendModelJson.trim().isEmpty();
    }

    public String getTitle() {
        return this.title;
    }

    public void setExtendInspectScene(String extendInspectScene) {
        this.extendInspectScene = extendInspectScene;
    }

    public String getExtendInspectScene() {
        return this.extendInspectScene;
    }

    public String getSilentWorkPath() {
        return this.silentWorkPath;
    }

    public void setSilentWorkPath(String silentWorkPath) {
        this.silentWorkPath = silentWorkPath;
    }

    public int calcAllItemSize(CheckDevNode devNode) {
        int count = 0;
        List<CheckDevNode> allNodes = devNode.getAllCheckNode();
        for (CheckDevNode node : allNodes) {
            Map<String, List<CheckItem>> items = node.getCheckItems();
            for (List<CheckItem> value : items.values()) {
                count += value.size();
            }
        }
        return count;
    }

    public String getSelectSeceneInSecondCard() {
        return this.selectSeceneInSecondCard;
    }

    public void setSelectSeceneInSecondCard(String selectSeceneInSecondCard) {
        this.selectSeceneInSecondCard = selectSeceneInSecondCard;
    }

    public static InspectContext getInstance() {
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyContext() {
        Object object = this.lock;
        synchronized (object) {
            this.cancelTasks();
            this.clearTempFile();
            this.uiUpdatePairs.clear();
            this.inspectWorktaker.clear();
            FileUtils.deleteAllInFolder((String)this.getDstorageTmpPath());
            File file = new File(InspectUtils.getItemDumpTempPath());
            FileUtils.deleteFile((File)file);
            if (!this.dStorageProduct.isEmpty()) {
                for (Product p : this.dStorageProduct.values()) {
                    FileUtils.deleteFile((File)p.getConfigDir());
                }
            }
        }
    }

    public void clearTempFile() {
        try {
            String reportPath = InspectContext.getInstance().getTempPath();
            FileUtils.deleteFile((File)new File(reportPath));
            String hypermetroPath = com.huawei.ism.tool.obase.utils.ApplicationContext.getInstance().getWorkPath() + File.separator + "hypermetroData" + File.separator + InspectUtils.getCurrentPid();
            FileUtils.deleteFile((File)new File(hypermetroPath));
            ConcurrentHashMap<String, Object> pyObj = InspectContext.getInstance().getObjectForPy();
            Iterator iterator = ((ConcurrentHashMap.KeySetView)pyObj.keySet()).iterator();
            while (iterator.hasNext()) {
                String iteratorKey = (String)iterator.next();
                if (iteratorKey.startsWith("SQLITE_CONN_DICT")) {
                    PyDictionary allConnDict = (PyDictionary)pyObj.get(iteratorKey);
                    for (Object sn : allConnDict.keySet()) {
                        this.clearDb(allConnDict, (String)sn);
                    }
                    iterator.remove();
                    continue;
                }
                if (!iteratorKey.startsWith("running data ")) continue;
                iterator.remove();
            }
            String sqliteDbPath = com.huawei.ism.tool.obase.utils.ApplicationContext.getInstance().getWorkPath() + File.separator + "temp" + File.separator + "sqlite_db" + File.separator + InspectUtils.getCurrentPid();
            FileUtils.deleteFile((File)new File(sqliteDbPath));
        }
        catch (Exception e) {
            LOGGER.error("delete temp file error", (Throwable)e);
        }
    }

    private void clearDb(PyDictionary allConnDict, String sn) {
        try {
            PyDictionary sqlConnMap = (PyDictionary)allConnDict.get((Object)sn);
            Connection conn = (Connection)sqlConnMap.get((Object)"SQLITE_CONN");
            conn.close();
            String dbPath = (String)sqlConnMap.get((Object)"SQLITE_CONN_DB_PATH");
            FileUtils.deleteFile((File)new File(dbPath));
        }
        catch (SQLException e) {
            LOGGER.error("clearDb error");
        }
    }

    private void cancelTasks() {
        this.inspectWorktaker.cancelInspectTasks();
    }

    public Set<String> getSupportVers() {
        this.supportVers = new HashSet<String>();
        for (Product p : this.inspectProducts) {
            for (SupportScenes scenes : p.getSencesList()) {
                if (!scenes.getScenesId().equalsIgnoreCase(this.getSelectInspectType())) continue;
                List<String> ls = p.getSupportDevModels();
                Collections.addAll(this.supportVers, ls.toArray(new String[ls.size()]));
            }
        }
        return this.supportVers;
    }

    public Map<String, List<String>> getHostSupportVers() {
        if (null == this.hostSupportVers) {
            this.hostSupportVers = HostSupportVersionParser.getHostSupportVers();
        }
        return this.hostSupportVers;
    }

    public Set<String> getSupportOrExcludeVersBySpecitySceneIDs(String[] sceneIDs, String type) {
        HashMap<String, Boolean> tempbak = new HashMap<String, Boolean>();
        tempbak.putAll(InspectContext.getInstance().getIsScenesInspect());
        HashSet<String> totalSupport = new HashSet<String>();
        for (int i = 0; i < sceneIDs.length; ++i) {
            for (String temp : InspectContext.getInstance().getIsScenesInspect().keySet()) {
                if (!InspectContext.getInstance().getIsScenesInspect().get(temp).booleanValue()) continue;
                InspectContext.getInstance().getIsScenesInspect().put(temp, false);
            }
            InspectContext.getInstance().getIsScenesInspect().put("realTimed_check " + sceneIDs[i], true);
            Set<String> tempSet = null;
            tempSet = type.equalsIgnoreCase("support") ? InspectContext.getInstance().getSupportVers() : InspectContext.getInstance().getExcludeVers();
            HashSet<String> tempTypeSet = new HashSet<String>();
            if (sceneIDs[i].equalsIgnoreCase("T3000") || sceneIDs[i].equalsIgnoreCase("UltraPath")) {
                for (String temp : tempSet) {
                    String tempType = sceneIDs[i] + "-" + temp;
                    tempTypeSet.add(tempType);
                }
                tempSet = tempTypeSet;
            }
            totalSupport.addAll(tempSet);
        }
        InspectContext.getInstance().getIsScenesInspect().clear();
        InspectContext.getInstance().getIsScenesInspect().putAll(tempbak);
        return totalSupport;
    }

    public Set<String> getExcludeVers() {
        HashSet<String> excludeVers = new HashSet<String>();
        for (Product p : this.inspectProducts) {
            for (SupportScenes scenes : p.getSencesList()) {
                if (!scenes.getScenesId().equals(this.getSelectInspectType())) continue;
                List<String> ls = p.getExcludeDevModels();
                Collections.addAll(excludeVers, ls.toArray(new String[ls.size()]));
            }
        }
        return excludeVers;
    }

    public List<DeviceType> getSupportTypes() {
        ArrayList<DeviceType> type = new ArrayList<DeviceType>();
        Set<String> vers = this.getSupportVers();
        for (String ver : vers) {
            type.add(DeviceType.valueOf((String)ver));
        }
        return type;
    }

    public String getSelectSceneId() {
        return null == this.inspectWorktaker.get("select_sceneId") ? "" : this.inspectWorktaker.get("select_sceneId");
    }

    public List<DeviceType> getExcludeTypes() {
        ArrayList<DeviceType> type = new ArrayList<DeviceType>();
        Set<String> vers = this.getExcludeVers();
        for (String ver : vers) {
            type.add(DeviceType.valueOf((String)ver));
        }
        return type;
    }

    public Map<DeviceType, String> getSupportModelVersions() {
        HashMap<DeviceType, String> typeMap = new HashMap<DeviceType, String>();
        for (SupportVersion ver : this.supportVersions) {
            typeMap.put(DeviceType.valueOf((String)ver.getModelVersion()), ver.getScript());
        }
        return typeMap;
    }

    public String getSelectInspectType() {
        for (String key : InspectContext.getInstance().isScenesInspect.keySet()) {
            if (!InspectContext.getInstance().isScenesInspect.get(key).booleanValue()) continue;
            return key;
        }
        return "";
    }

    public String getPeriod() {
        String language = com.huawei.ism.tool.obase.utils.ApplicationContext.getInstance().getCurrentLanguage().getLanguage();
        String period = "";
        period = "en".equals(language) ? "." : "\u3002";
        return period;
    }

    public boolean isSupportDev(DevNode dev) {
        String devModel = dev.getDeviceType() + " " + dev.getProductVersion();
        if (null != this.isScenesInspect.get("realTimed_check " + dev.getItDeviceType().getName()) && this.isScenesInspect.get("realTimed_check " + dev.getItDeviceType().getName()).booleanValue()) {
            try {
                return null != this.getProductByDevNode(dev);
            }
            catch (ToolException e) {
                return false;
            }
        }
        if (ItDeviceType.Host.equals((Object)dev.getItDeviceType())) {
            return this.isSupportHostDev(dev);
        }
        if (ItDeviceType.DStorage.equals((Object)dev.getItDeviceType())) {
            return this.isSupportDstorageDev(dev);
        }
        if (dev.isFusionCube()) {
            return this.isSupportFusionCubeDev(dev);
        }
        if (dev.isA3000()) {
            return this.isSupportA3000Dev(dev);
        }
        LOGGER.info("storage version : {} inspect support version : {}", (Object)devModel, (Object)Arrays.toString(this.supportVersions.toArray()));
        boolean isSupport = true;
        for (SupportVersion supportVersion : this.supportVersions) {
            if (!devModel.contains(supportVersion.getModelVersion())) continue;
            isSupport = this.checkVersionByScript(dev, supportVersion.getScript());
            break;
        }
        if (!isSupport) {
            return isSupport;
        }
        Set<String> excludeVers = this.getExcludeVers();
        for (String ver : excludeVers) {
            if (!devModel.contains(ver)) continue;
            return false;
        }
        Set<String> set = this.getSupportVers();
        for (String ver : set) {
            if (!Products.contains((String)devModel, (String)ver)) continue;
            return true;
        }
        return false;
    }

    private boolean isSupportDstorageDev(DevNode dev) {
        if (InspectUtils.isFsExInspect()) {
            return this.isSupportByFsExpansion(dev);
        }
        if ("realTimed_check".equals(this.getSelectSceneId())) {
            return true;
        }
        if ("bureau_check".equals(this.getSelectSceneId())) {
            String version = dev.getProductVersion();
            String type = dev.getDeviceType().toString();
            for (KeyValue<String, String> support : FusionStorageConfig.getBureauSupportTypeAndVer()) {
                if (!type.equals(support.getKey()) || !version.contains((CharSequence)support.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSupportByFsExpansion(DevNode dev) {
        return this.extendVersions.stream().filter(supportVersion -> supportVersion.getSupportInspectType().contains(FusionStorageConfig.getFsExpansionCheckId())).anyMatch(supportVersion -> {
            String version = dev.getProductVersion();
            for (String support : supportVersion.getVersion().split(",")) {
                if (!dev.getDeviceType().toString().equals(supportVersion.getModel()) || !version.contains(support)) continue;
                return true;
            }
            return false;
        });
    }

    public boolean isSupportHostDev(DevNode dev) {
        Product product = this.getHostProduct(dev);
        if (null != product) {
            List<SupportScenes> supportScenesList = product.getSencesList();
            for (SupportScenes supportScenes : supportScenesList) {
                if (!this.getSelectInspectType().contains(supportScenes.getScenesId())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean checkVersionByScript(DevNode dev, String scriptPath) {
        JythonExecuter executer = null;
        try {
            File pyFile = new File(scriptPath);
            executer = new JythonExecuter();
            executer.compileScript(pyFile);
            HashMap<String, DevNode> paramMap = new HashMap<String, DevNode>();
            paramMap.put("dev", dev);
            Object ret = executer.simpleInvokeFunction("execute", paramMap);
            return Boolean.valueOf(ret.toString());
        }
        catch (FileNotFoundException e) {
            ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Check version error. file is not found");
            return false;
        }
        catch (ToolException e) {
            ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Check version error.");
            return false;
        }
        catch (RuntimeException e) {
            ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Check version error.", (Throwable)e);
            return false;
        }
    }

    public boolean existDistributedProduct(DevNode dev) {
        return this.dStorageProduct.containsKey(dev);
    }

    public Product getProductByDevNode(DevNode dev) throws ToolException {
        if (ItDeviceType.Host.equals((Object)dev.getItDeviceType())) {
            return this.getHostProduct(dev);
        }
        if (ItDeviceType.A3000.equals((Object)dev.getItDeviceType()) || dev.is2910V7()) {
            return this.getA3000OrOceanStor2910Product(dev);
        }
        if (ItDeviceType.DStorage.equals((Object)dev.getItDeviceType()) || dev.isFusionCube() || dev.isA800DpcOm()) {
            Product product = this.getDStorageProduct(dev);
            this.initBmcInfo(dev);
            return product;
        }
        int bestMatchNum = 0;
        Product bestMatchProduct = null;
        String deviceTypeHead = dev.getDeviceType().toString();
        if (ItDeviceType.Switch.equals((Object)dev.getItDeviceType()) && "OceanStor SNS".equalsIgnoreCase(dev.getDeviceName())) {
            deviceTypeHead = deviceTypeHead.split("\\.")[0];
        }
        String devModel = (deviceTypeHead + " " + dev.getProductVersion()).toLowerCase(Locale.US);
        for (Product product : this.inspectProducts) {
            List<String> supportVer = this.checkVer(product.getSupportDevModels());
            for (String v : supportVer) {
                if (!Products.containsIgnoreCase((String)devModel, (String)v.toLowerCase(Locale.US))) continue;
                boolean isSupportScene = this.checkScene(product);
                if (0 == bestMatchNum && isSupportScene) {
                    bestMatchNum = v.length();
                    bestMatchProduct = product;
                    continue;
                }
                if (v.length() < bestMatchNum || !isSupportScene) continue;
                bestMatchNum = v.length();
                bestMatchProduct = product;
            }
        }
        if (null == bestMatchProduct) {
            throw new ToolException("productparser.notsupportdevtype", false);
        }
        ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("geted support product, by dev :" + dev.getIp() + " " + devModel + " \n product:" + bestMatchProduct.getSupportDevModels());
        return bestMatchProduct;
    }

    private void initBmcInfo(DevNode devNode) {
        if (!InspectContext.getInstance().isBureauCheckSelected()) {
            return;
        }
        if (InspectUtils.isStartedByYingLong()) {
            return;
        }
        List clusterNodes = devNode.getClusterNodes();
        if (clusterNodes == null) {
            return;
        }
        boolean hasNedInitBmcNode = clusterNodes.stream().anyMatch(node -> node.getBmcNode() == null);
        if (!hasNedInitBmcNode) {
            return;
        }
        this.queryBmcInfo(devNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryBmcInfo(DevNode devNode) {
        try {
            String url = RestUtil.getDsQueryBmcInfo((DevNode)devNode);
            RestConnection conn = RestConnectionManager.getRestConnection((DevNode)devNode);
            ResponseInfo resp = conn.execGet(url);
            String content = resp.getContent();
            JSONObject jsonObj = new JSONObject(content);
            if (content.contains("data")) {
                JSONArray data = jsonObj.getJSONArray("data");
                this.buildBmcNode(devNode, data);
            }
        }
        catch (ToolException e) {
            LOGGER.error("Query BMC info error, ", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("Query BMC info error, ", (Throwable)e);
        }
        finally {
            RestConnectionManager.releaseConn((DevNode)devNode);
        }
    }

    private void buildBmcNode(DevNode devNode, JSONArray data) {
        Map<String, ClusterNode> nodeMap = devNode.getClusterNodes().stream().collect(Collectors.toMap(node -> node.getManagementIp(), node -> node, (key1, key2) -> key1));
        int dataLen = data.length();
        for (int i = 0; i < dataLen; ++i) {
            JSONObject obj = data.getJSONObject(i);
            String managementIp = obj.getString("management_ip");
            if (!nodeMap.containsKey(managementIp)) continue;
            DevNode bmcNode = new DevNode();
            bmcNode.setProductModel(obj.getString("model"));
            bmcNode.setIp(obj.getString("bmc_ip"));
            nodeMap.get(managementIp).setBmcNode(bmcNode);
        }
    }

    private Product getHostProduct(DevNode devNode) {
        String devModel = InspectUtils.isDpaInspectScene() ? devNode.getDeviceType().toString() : devNode.getDeviceName();
        for (Product product : this.inspectProducts) {
            List<String> supportVer = this.checkVer(product.getSupportDevModels());
            if (null == product.getProductName() || !product.getProductName().startsWith("Host")) continue;
            for (String version : supportVer) {
                if (!version.toLowerCase(Locale.ENGLISH).contains(devModel.toLowerCase(Locale.ENGLISH))) continue;
                return product;
            }
        }
        return null;
    }

    private Product getA3000OrOceanStor2910Product(DevNode devNode) {
        Product product = new Product();
        product.setProductName(devNode.getDeviceName());
        CheckModelInfo checkModelInfo = new CheckModelInfo();
        checkModelInfo.setModelType("rest");
        product.setCheckModelInfo(checkModelInfo);
        return product;
    }

    private synchronized Product getDStorageProduct(DevNode devNode) throws ToolException {
        ProductUtil productUtil = new ProductUtil();
        new DevUtil(null).initDistributedDevNode(devNode);
        if (!this.existDistributedProduct(devNode)) {
            Optional<Product> product = productUtil.initDistributedProduct(devNode);
            product.ifPresent(value -> this.dStorageProduct.put(devNode, (Product)value));
        }
        return this.dStorageProduct.get(devNode);
    }

    public void parsePackageIni(CheckDevNode checkDev, File targetProductConfigDir) {
        File packageFile = new File(targetProductConfigDir, PACKAGE_INI);
        if (packageFile.exists()) {
            IniReader iniReader = new IniReader(packageFile);
            checkDev.setSupportReentry(iniReader.getBoolean("package.patch.reentry"));
            checkDev.setCurPatchName(iniReader.getString("package.patch.name"));
            checkDev.setNeedCmsSignPath(iniReader.getBoolean("package.sign.verify"));
            Context.INS.getSupportUploadByNodeIdDevMap().put(checkDev.getDevNode(), iniReader.getBoolean("package.patch.node_ids"));
        }
    }

    public void updateDStorageProduct(CheckDevNode checkDevNode, boolean update) throws ToolException {
        DevNode devNode = checkDevNode.getDevNode();
        if (this.existDistributedProduct(devNode)) {
            Product oldProduct = this.dStorageProduct.get(devNode);
            FileUtils.deleteFile((File)oldProduct.getConfigDir());
        }
        try {
            ProductUtil util = new ProductUtil();
            Optional<Product> newProduct = util.initDistributedProduct(devNode);
            if (update && newProduct.isPresent()) {
                LOGGER.info("Update check item to check dev.");
                IProductParser parser = newProduct.get().getProductResolver();
                parser.updateCheckDevNode(checkDevNode, newProduct.get());
            }
        }
        catch (ToolException e) {
            LOGGER.error("get inspection resource or unzip resource exception:", (Throwable)e);
            throw e;
        }
    }

    public File getResourceFileAndAddProductFile(DevNode devNode) throws ToolException {
        String temp = this.getDstorageTmpPath() + File.separator + devNode.getDeviceSerialNumber() + "_" + InspectContext.getTimeStamp();
        try {
            RestConnection conn = RestConnectionManager.getRestConnection((DevNode)devNode);
            String getResourceFilesUri = RestUtil.getResourceUri((DevNode)devNode);
            HashMap<String, String> reqParam = new HashMap<String, String>();
            reqParam.put("resource_type", "inspection");
            ResponseInfo resp = conn.execGetFile(getResourceFilesUri, reqParam, temp);
            Map restContentMap = resp.getContentMap();
            Long errorCode = (Long)restContentMap.get("errorCode");
            if (null != errorCode && 0L != errorCode) {
                throw new ToolException("Get inspection resource file failed, error code:" + errorCode);
            }
            Iterator entryItr = restContentMap.entrySet().iterator();
            String resourceZipFileName = null;
            while (entryItr.hasNext()) {
                Map.Entry contentEntry = entryItr.next();
                String key = (String)contentEntry.getKey();
                if (null == key || !key.contains(".zip")) continue;
                resourceZipFileName = key;
            }
            boolean zipSucc = false;
            File zipToDir = null;
            LOGGER.info("resourceZipFileName = {}", resourceZipFileName);
            String productDir = null;
            if (null != resourceZipFileName) {
                productDir = INSPECT_CONFPATH + File.separator + "products" + File.separator + "DStorage_" + devNode.getDeviceSerialNumber();
                zipToDir = new File(productDir);
                File zipFile = new File(resourceZipFileName);
                zipSucc = FileAssistant.deCopmressAllZipFile(productDir, resourceZipFileName);
                zipFile.delete();
            }
            if (zipSucc) {
                File file = zipToDir;
                return file;
            }
            throw new ToolException("unzip inspection resource file failed.");
        }
        finally {
            RestConnectionManager.releaseConn((DevNode)devNode);
        }
    }

    public String getDstorageTmpPath() {
        return com.huawei.ism.tool.obase.utils.ApplicationContext.getInstance().getWorkPath() + File.separator + "temp" + File.separator + "Dstorage";
    }

    private static String getTimeStamp() {
        return RANDOM_DIR_NAME_PATTERN.format(LocalDateTime.now());
    }

    private List<String> checkVer(List<String> supportDevModels) {
        String[] supportModels = new String[supportDevModels.size()];
        for (int tmp = 0; tmp < supportDevModels.size(); ++tmp) {
            String stmp = supportDevModels.get(tmp);
            int verLen = stmp.length();
            byte[] tmpByte = new byte[verLen];
            int i = 0;
            int findCount = 0;
            byte[] bytes = stmp.getBytes(Charset.defaultCharset());
            for (int index = 0; index < verLen; ++index) {
                byte bTmp = bytes[index];
                if (92 != bTmp) {
                    tmpByte[i] = bTmp;
                } else if (index < verLen && 115 == bytes[index + 1]) {
                    tmpByte[i] = 32;
                    ++index;
                    ++findCount;
                }
                ++i;
            }
            supportModels[tmp] = new String(tmpByte, 0, tmpByte.length - findCount, Charset.defaultCharset());
        }
        return Arrays.asList(supportModels);
    }

    private boolean checkScene(Product product) {
        for (SupportScenes supportScenes : product.getSencesList()) {
            String selectType = this.getSelectInspectType();
            ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).info(selectType);
            if (!"".equals(selectType) && !supportScenes.getScenesId().equalsIgnoreCase(selectType)) continue;
            return true;
        }
        return false;
    }

    public List<SupportScenes> buildFirstJcombox(SupportScenes scenes, List<SupportScenes> sceneList) {
        HashMap<String, SupportScenes> temp = new HashMap<String, SupportScenes>();
        ArrayList<SupportScenes> ret = new ArrayList<SupportScenes>();
        String scenesId = scenes.getScenesId();
        String prefix = scenesId.split("[ ]")[0];
        for (SupportScenes supportScenes : sceneList) {
            String scenesIdTmp = supportScenes.getScenesId();
            if (!scenesIdTmp.startsWith(prefix)) continue;
            SupportScenes scenes2 = new SupportScenes();
            String scenesId1 = scenesIdTmp.split("[ ]")[1];
            scenes2.setScenesId(scenesId1);
            scenes2.setNameKey("inspsctor.wizard.welcome.head." + scenesId1);
            temp.put(scenesId1, scenes2);
        }
        ret.addAll(temp.values());
        Collections.sort(ret, new SupportScenesComparator());
        return ret;
    }

    public List<SupportScenes> buildSecondJcombox(SupportScenes scenes, List<SupportScenes> sceneList) {
        ArrayList<SupportScenes> ret = new ArrayList<SupportScenes>();
        if (null == scenes) {
            return ret;
        }
        String scenesId = scenes.getScenesId();
        String[] scenesIds = scenesId.split("[ ]");
        if (2 != scenesIds.length) {
            return ret;
        }
        String prefix = scenesIds[0] + " " + scenesIds[1];
        for (SupportScenes supportScenes : sceneList) {
            String scenesIdTmp = supportScenes.getScenesId();
            String[] scenesIdsTmp = scenesIdTmp.split("[ ]");
            if (!scenesIdTmp.startsWith(prefix) || 3 != scenesIdsTmp.length) continue;
            SupportScenes scenes2 = new SupportScenes();
            String scenesId1 = scenesIdTmp.split("[ ]")[2];
            scenes2.setScenesId(scenesId1);
            scenes2.setNameKey("inspsctor.wizard.welcome.head." + scenesId1);
            ret.add(scenes2);
        }
        Collections.sort(ret, new SupportScenesComparator());
        return ret;
    }

    public String getSelectType(List<JRadioButton> radioList) {
        for (JRadioButton jRadioButton : radioList) {
            if (!jRadioButton.isSelected()) continue;
            return jRadioButton.getName().split("[ ]")[0];
        }
        return "";
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Float> getPassRateMap() {
        Object object = this.lock;
        synchronized (object) {
            return this.passRateMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Integer> getScoreMap() {
        Object object = this.lock;
        synchronized (object) {
            return this.scoreMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPassRateMap(Map<String, Float> passRateMap) {
        Object object = this.lock;
        synchronized (object) {
            this.passRateMap.putAll(passRateMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScoreMap(Map<String, Integer> scoreMap) {
        Object object = this.lock;
        synchronized (object) {
            this.scoreMap.putAll(scoreMap);
        }
    }

    public Integer getScore() {
        return this.score;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getResultFileList() {
        Object object = this.lock;
        synchronized (object) {
            return this.resultFileList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResultFileList(String resultFileList) {
        Object object = this.lock;
        synchronized (object) {
            this.resultFileList.add(resultFileList);
        }
    }

    public void setScore(Integer score) {
        this.score = score;
    }

    public boolean isToolkitEnv() {
        String toolBase = com.huawei.ism.tool.obase.utils.ApplicationContext.getInstance().getWorkPath();
        File toolBaseFile = new File(toolBase);
        File[] files = toolBaseFile.listFiles(new DirectoryFileFilter());
        if (null == files) {
            return true;
        }
        for (File file : files) {
            if (!ENTRY_DIR.equals(file.getName())) continue;
            return false;
        }
        return true;
    }

    public UiUpdatePair getUiUpdatePair(CheckDevNode checkDevNode) {
        return this.uiUpdatePairs.get(checkDevNode);
    }

    public UiUpdatePair addUiUpdatePair(CheckDevNode key, UiUpdatePair ui) {
        return this.uiUpdatePairs.put(key, ui);
    }

    public JDialog getMainDialog() {
        return this.mainDialog;
    }

    public void setMainDialog(JDialog mainDialog) {
        this.mainDialog = mainDialog;
    }

    public boolean isForeProcessRunning() {
        return this.isForeProcessRunning;
    }

    public void setForeProcessRunning(boolean isForeProRunning) {
        this.isForeProcessRunning = isForeProRunning;
    }

    public boolean isBackProcessRunning() {
        return this.isBackProcessRunning;
    }

    public void setBackProcessRunning(boolean isBackProRunning) {
        this.isBackProcessRunning = isBackProRunning;
    }

    public List<Product> getInspectProducts() {
        return this.inspectProducts;
    }

    public void setInspectProducts(List<Product> inspectProducts) {
        this.inspectProducts = inspectProducts;
    }

    public List<SupportVersion> getSupportVersions() {
        return this.supportVersions;
    }

    public void setSupportVersions(List<SupportVersion> supportVersions) {
        this.supportVersions = supportVersions;
    }

    public InspectWorktaker getInspectWorktaker() {
        return this.inspectWorktaker;
    }

    public boolean isTimingCreateInspect() {
        return this.timingCreateInspect;
    }

    public void setTimingCreateInspect(boolean timingCreateInspect) {
        this.timingCreateInspect = timingCreateInspect;
    }

    public String getVDebugCommand(DevNode devNode) {
        if (devNode.getDeviceType().toString().contains("V1") && devNode.getProductVersion().contains("V100R001")) {
            return "debug bash";
        }
        return "debug";
    }

    public String getTempPath() {
        return this.tempPath;
    }

    public void setTempPath(String tempPath) {
        this.tempPath = tempPath;
    }

    public Map<String, Boolean> getIsScenesInspect() {
        return this.isScenesInspect;
    }

    public void setIsScenesInspect(Map<String, Boolean> isScenesInspect) {
        this.isScenesInspect = isScenesInspect;
    }

    public Locale getLoc() {
        return this.loc;
    }

    public void setLoc(Locale loc) {
        this.loc = loc;
    }

    public List<InspectUserOpData> getUseropList() {
        return this.useropList;
    }

    public void setUseropList(List<InspectUserOpData> useropList) {
        this.useropList = useropList;
    }

    public String getSceneCollectDir() {
        try {
            if (null == this.scenePathValue) {
                this.scenePathValue = (ScenePathValue)SceneEnvironmentImpl.getInstance().getEnvirValueByKey("jsonSceneResultPath");
            }
        }
        catch (com.huawei.ism.tool.framework.platform.exception.ToolException e) {
            LOGGER.error("can't get scene path value", (Throwable)e);
            return "";
        }
        catch (RuntimeException e) {
            LOGGER.error("can't get scene path value", (Throwable)e);
            return "";
        }
        if (null == this.scenePathValue) {
            return "";
        }
        return this.scenePathValue.getJsonSceneResultPathValue();
    }

    public boolean sceneSelectDevNode(DevNode devNode) {
        String jsonquery = "{\"toolId\":\"Inspect\",\"SN\":\"" + devNode.getDeviceSerialNumber() + "\"}";
        String res = null;
        try {
            res = SceneEnvironmentImpl.getInstance().getDataVarByKey(jsonquery);
        }
        catch (com.huawei.ism.tool.framework.platform.exception.ToolException e) {
            LOGGER.error("can't get device node map", (Throwable)e);
            return true;
        }
        catch (RuntimeException e) {
            LOGGER.error("can't get device node map", (Throwable)e);
            return true;
        }
        return !res.equals(TaskResult.Result.SUCCESS.toString());
    }

    public void finishedSceneTask(List<Map<String, String>> callBackMap) {
        TaskResult result = null;
        try {
            result = SceneEnvironmentImpl.getInstance().finishedSceneTask(callBackMap);
            if (null == result) {
                throw new NullPointerException();
            }
        }
        catch (com.huawei.ism.tool.framework.platform.exception.ToolException e) {
            LOGGER.error("write roll back data failed", (Throwable)e);
        }
        catch (RuntimeException e) {
            LOGGER.error("write roll back data failed", (Throwable)e);
        }
        if (null == result || null == result.getResult()) {
            LOGGER.info("scene call back faild!");
            return;
        }
        if (!TaskResult.Result.SUCCESS.equals((Object)result.getResult())) {
            LOGGER.info("scene call back faild!");
        }
    }

    public static String getArgsParamFormSceneConfig(String key) {
        String currentScenceToolBoxString = System.getProperty("jsonSceneArgsList");
        LOGGER.info("currentScenceToolBoxString {}", (Object)StringUtils.getCleanMessage((String)currentScenceToolBoxString));
        if (StringUtils.isNULLStr((String)currentScenceToolBoxString)) {
            currentScenceToolBoxString = System.getenv("jsonSceneArgsList");
        }
        if (!StringUtils.isNULLStr((String)currentScenceToolBoxString)) {
            try {
                JSONObject jsonObject = new JSONObject(currentScenceToolBoxString);
                currentScenceToolBoxString = jsonObject.getString(key);
                return currentScenceToolBoxString;
            }
            catch (JSONException e) {
                LOGGER.error("get {} failed.", (Object)key);
            }
            catch (RuntimeException e) {
                LOGGER.error("get {} failed.", (Object)key);
            }
        }
        return "";
    }

    public String getToolTip(String textIntro) {
        StringBuffer tipText = new StringBuffer();
        tipText.append("<div style='margin:5px'>");
        if (LanguageManager.getInstance().getCurrentLanguage() != Locale.ENGLISH) {
            for (int i = 26; i < textIntro.length() + 26; i += 26) {
                if (i < textIntro.length()) {
                    tipText.append("<p>" + textIntro.substring(i - 26, i) + "</p>");
                    continue;
                }
                tipText.append(textIntro.substring(i - 26));
            }
        } else if (textIntro.length() > 50) {
            int i = textIntro.lastIndexOf(32, 50);
            int line = 0;
            int start = 0;
            while (i < textIntro.length()) {
                ++line;
                tipText.append("<p>" + textIntro.substring(start, i + 1) + "</p>");
                start = i;
                if (i + 50 >= textIntro.length()) {
                    i = textIntro.length();
                    tipText.append(textIntro.substring(start, i));
                    continue;
                }
                i = textIntro.lastIndexOf(32, 50 * (line + 1));
            }
        } else {
            tipText.append(textIntro);
        }
        tipText.append("</div>");
        return tipText.toString();
    }

    public int accessConf(String secenID) {
        if (secenID.equalsIgnoreCase("realTimed_check")) {
            return 1004;
        }
        if (secenID.equalsIgnoreCase("bureau_check")) {
            return 1004;
        }
        if (secenID.equalsIgnoreCase("timed_check")) {
            return 1002;
        }
        if (secenID.equalsIgnoreCase("compass_check")) {
            return 1002;
        }
        if (0 == secenID.indexOf("warning_check")) {
            return 1002;
        }
        if (secenID.equalsIgnoreCase("renewal_check")) {
            return 1002;
        }
        LOGGER.info("access unkonw secen id -> {}", (Object)secenID);
        return 1004;
    }

    public boolean needShow(String scenesID, ToolUserRole userRole, String argsNeedWhenScenne) {
        if (SceneUtils.isScene()) {
            return argsNeedWhenScenne.contains(scenesID);
        }
        if (userRole != null && userRole.getCode() > InspectContext.getInstance().accessConf(scenesID)) {
            return false;
        }
        if (this.isOemOutTool) {
            return this.showSupportItems(scenesID);
        }
        return !com.huawei.ism.tool.obase.utils.ApplicationContext.isRunInSvp() || this.svpNeedShow(scenesID);
    }

    public boolean svpNeedShow(String scenesID) {
        if (!ApplicationContext.getInstance().getToolLoginUser().isBuildInUser()) {
            return true;
        }
        return this.showSupportItems(scenesID);
    }

    public boolean showSupportItems(String scenesID) {
        if (this.supportItems.length > 0) {
            for (String supportItem : this.supportItems) {
                if (!scenesID.equalsIgnoreCase(supportItem)) continue;
                return true;
            }
        }
        return false;
    }

    public void setSupportItems(String supportItems) {
        this.supportItems = supportItems.trim().split(",");
    }

    public boolean isBackgroundMode() {
        return !this.foreground;
    }

    public boolean isAllSilentTaskOver() {
        return this.isAllSilentTaskOver;
    }

    public void setAllSilentTaskOver(boolean isAllSilentTaskover) {
        this.isAllSilentTaskOver = isAllSilentTaskover;
    }

    public boolean isOemOutTool() {
        return this.isOemOutTool;
    }

    public boolean isInMemoryInspectionSence() {
        return this.inMemoryInspectionSence;
    }

    public void setInMemoryInspectionSence(boolean inMemoryInspectionSence) {
        this.inMemoryInspectionSence = inMemoryInspectionSence;
    }

    public void setOemOutTool(boolean isOemOuttool) {
        this.isOemOutTool = isOemOuttool;
    }

    public boolean isDecompressHelpcaseionFinish() {
        return this.decompressHelpcaseionFinish;
    }

    public void setDecompressHelpcaseionFinish(boolean decompressHelpcaseionFinish) {
        this.decompressHelpcaseionFinish = decompressHelpcaseionFinish;
    }

    public void waitDecompressHelpCaseFinish() {
        if (this.decompressHelpcaseionFinish) {
            return;
        }
        int timeout = 300;
        LOGGER.info("wait Decompress help case start.");
        while (!this.decompressHelpcaseionFinish && timeout-- > 0) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                if (!LOGGER.isErrorEnabled()) continue;
                LOGGER.error("" + e);
            }
        }
        LOGGER.info("wait Decompress help case over.");
    }

    public boolean isForeground() {
        return this.foreground;
    }

    public void setForeground(boolean isForeground) {
        this.foreground = isForeground;
    }

    public boolean isToolkitZhCn() {
        return this.toolkitZhCn;
    }

    public void setToolkitZhCn(boolean isToolkitZhCn) {
        this.toolkitZhCn = isToolkitZhCn;
    }

    public CloseObserver getCloseObserver() {
        return this.closeObserver;
    }

    public void setCloseObserver(CloseObserver closeObserver) {
        this.closeObserver = closeObserver;
    }

    public Map<DevNode, Map<String, String>> getHotPatchVersionWarningDevs() {
        return this.hotPatchVersionWarningDevs;
    }

    public boolean isHavingRightPatchTool() {
        return this.havingRightPatchTool;
    }

    public void setHavingRightPatchTool(boolean havingRightPatchTool) {
        this.havingRightPatchTool = havingRightPatchTool;
    }

    public PerformInspectCard getPerformInspectCard() {
        return this.performInspectCard;
    }

    public void setPerformInspectCard(PerformInspectCard performInspectCard) {
        this.performInspectCard = performInspectCard;
    }

    public boolean isBureauCheckSelected() {
        return this.bureauCheckSelected;
    }

    public boolean isBureauSupport() {
        return this.bureauCheckSelected && !this.isOemOutTool;
    }

    public void setBureauCheckSelected(boolean bureauCheckSelected) {
        this.bureauCheckSelected = bureauCheckSelected;
    }

    public BureauFile getBureauFile(DevNode node) {
        return null == node ? null : this.bureauFiles.get(node);
    }

    public void addBureauFile(DevNode node, BureauFile file) {
        if (null == node || null == file) {
            return;
        }
        this.bureauFiles.put(node, file);
    }

    public Map<DevNode, BureauFile> getBureauFiles() {
        return this.bureauFiles;
    }

    public boolean isBureauCheck() {
        return this.bureauCheck;
    }

    public void setBureauCheck(boolean bureauCheck) {
        this.bureauCheck = bureauCheck;
    }

    public void updateNavigationBar(SelectDeviceCard card) {
        boolean hasHyperMetro;
        if (null == card) {
            return;
        }
        List<DevNode> devs = card.getSelectDeviceCardLayout().getSelectedDevs();
        boolean hasSupport = BureauDocuService.INS.hasSupportedDev(devs);
        boolean insert = hasSupport && this.isBureauSupport();
        boolean needUpdateUI = InspectUIUtil.inserOrRemoveCard(insert, CardModelEnum.SELECTDEVICE, CardModelEnum.MANULY);
        this.setBureauCheck(insert);
        insert = devs.stream().anyMatch(DevNode::isLikeDsStorage);
        if (InspectUIUtil.inserOrRemoveCard(insert, CardModelEnum.SELECTDEVICE, CardModelEnum.SELECT_CLUSTER_NODES)) {
            needUpdateUI = true;
        }
        this.updateDetachCheckCard(insert);
        if (SceneUtils.isScene() && !InspectUtils.isDistributedFrw()) {
            this.insertSetResultCard();
        }
        boolean bl = insert = (hasHyperMetro = devs.stream().anyMatch(DevNode::isHyperMetro)) && InspectContext.havaHostOrServer();
        if (InspectUIUtil.inserOrRemoveCard(insert, CardModelEnum.SELECTDEVICE, CardModelEnum.HYPER_MANULY_CHECK)) {
            needUpdateUI = true;
        }
        if (needUpdateUI) {
            this.updateNavigationBar(InspectUIUtil.getStepsViewInfo());
        }
    }

    public void insertSetResultCard() {
        CardModelEnum cardModelEnum = this.getSetResultReferenceCard();
        if (!InspectConstans.getStepViews().contains((Object)cardModelEnum)) {
            LOGGER.warn("[{}] can't to insert the settings check policy card", (Object)SceneUtils.getCurrentStepId());
            return;
        }
        InspectUIUtil.inserOrRemoveCard(true, cardModelEnum, CardModelEnum.SETRESULT);
    }

    private void updateDetachCheckCard(boolean hasDistributedStorage) {
        if (!this.isInspectScene(InspectContext.getArgsParamFormSceneConfig("effectiveScene"))) {
            return;
        }
        if (hasDistributedStorage && "detach_check".equals(this.checkMode)) {
            this.updateNavigationBar("detach_check");
            return;
        }
        this.updateNavigationBar("merge_check");
    }

    public void updateNavigationBar(List<String[]> steps) {
        this.updateStep(steps);
    }

    public void updateStep(List<String[]> steps) {
        ((ToolWizardDialog)this.getMainDialog()).updateStepsGroup(steps, ResourceUtil.getStringWithParams((String)"inspsctor.wizard.title", (Object[])new Object[]{this.title, steps.size()}));
    }

    public void filterItemWhitScene(CheckDevNode checkDevNode, String realScene) {
        Set<Map.Entry<String, List<CheckItem>>> itemMap = checkDevNode.getCheckItems().entrySet();
        for (Map.Entry<String, List<CheckItem>> entry : itemMap) {
            List<CheckItem> items = entry.getValue();
            ArrayList<CheckItem> newItems = new ArrayList<CheckItem>();
            for (CheckItem checkItem : items) {
                newItems.add(checkItem);
                if (StringUtils.isNULLStr((String)checkItem.getEffectiveScene()) || checkItem.getEffectiveScene().contains(realScene)) continue;
                newItems.remove(checkItem);
            }
            entry.setValue(newItems);
        }
    }

    public List<CollectModule> getExtendSysExtCollectConfig(String devType) {
        List<CollectModule> extCollect = new ArrayList<CollectModule>();
        if (StringUtils.isNULLStr((String)devType) || null == this.getExtendVersions() || this.getExtendVersions().isEmpty()) {
            return extCollect;
        }
        for (SupportVersion version : this.getExtendVersions()) {
            if (!devType.equals(version.getModel())) continue;
            extCollect = version.getExtCollectItems();
            break;
        }
        return extCollect;
    }

    public boolean isUseApply() {
        return this.useApply;
    }

    public void setUseApply(boolean useApply) {
        this.useApply = useApply;
    }

    public boolean isOpenHelpFile() {
        return this.openHelpFile;
    }

    public void setOpenHelpFile(boolean openHelpFile) {
        this.openHelpFile = openHelpFile;
    }

    public Map<CheckDevNode, List<Strategy>> getExtendStrategies() {
        return this.extendStrategies;
    }

    public InspectSceneValue getInspectSceneValue() {
        return this.inspectSceneValue;
    }

    public void setInspectSceneValue(InspectSceneValue inspectSceneValue) {
        this.inspectSceneValue = inspectSceneValue;
    }

    public ConcurrentHashMap<String, HashMap<String, Object>> getAllStrgHyprMtrLns() {
        return this.allStrgHyprMtrLns;
    }

    public void setAllStrgHyprMtrLns(ConcurrentHashMap<String, HashMap<String, Object>> allStrgHyprMtrLns) {
        this.allStrgHyprMtrLns = allStrgHyprMtrLns;
    }

    public DevInfo4Exp getDevInfo() {
        return this.devInfo;
    }

    public void setDevInfo(DevInfo4Exp devInfo) {
        this.devInfo = devInfo;
    }

    public void addRow(String sn, TableRow<?, ?> row) {
        this.devRows.put(sn, row);
    }

    public TableRow<?, ?> getRow(String sn) {
        return this.devRows.get(sn);
    }

    public void removeRow(String sn) {
        if (null != sn && !sn.trim().isEmpty()) {
            this.devRows.remove(sn);
        }
    }

    public void removeAllRows() {
        this.devRows.clear();
    }

    public Map<String, TableRow<?, ?>> getDevRows() {
        return this.devRows;
    }

    public ArrayList<Enclosure> getStatisticEncloureList() {
        return this.statisticEncloureList;
    }

    public void setStatisticEncloureList(ArrayList<Enclosure> statisticEncloureList) {
        this.statisticEncloureList = statisticEncloureList;
    }

    public String getEncloMaxDepth() {
        return this.encloMaxDepth;
    }

    public void setEncloMaxDepth(String encloMaxDepth) {
        this.encloMaxDepth = encloMaxDepth;
    }

    public ArrayList<DiskDomain> getStatisticDDList() {
        return this.statisticDDList;
    }

    public void setStatisticDDList(ArrayList<DiskDomain> statisticDDList) {
        this.statisticDDList = statisticDDList;
    }

    public String getExpScene() {
        return this.expScene;
    }

    public List<Object> getHostLauncherWwnList() {
        return this.hostLauncherWwnList;
    }

    public void setHostLauncherWwnList(List<Object> hostLauncherWwnList) {
        this.hostLauncherWwnList = hostLauncherWwnList;
    }

    public ConcurrentHashMap<String, Object> getObjectForPy() {
        return this.objectForPy;
    }

    public static boolean havaHostOrServer() {
        Map serverAndHost = (Map)InspectContext.getDataByTmpObj(HYPER_QUO_SERVER_AND_NOT_ADD_HOST_INFO);
        if (null == serverAndHost) {
            return false;
        }
        if (serverAndHost.containsKey(QUO_SERVER_LIST)) {
            List serverList = (List)serverAndHost.get(QUO_SERVER_LIST);
            for (Map serverInfo : serverList) {
                if (!serverInfo.containsKey("quoServerName") || !serverInfo.containsKey("ip") || !serverInfo.containsKey("sn")) continue;
                return true;
            }
        }
        if (serverAndHost.containsKey(NOT_ADD_HOST_LIST)) {
            List hostList = (List)serverAndHost.get(NOT_ADD_HOST_LIST);
            for (Map hostInfo : hostList) {
                if (!hostInfo.containsKey("hostName") || !hostInfo.containsKey("initiator") || !hostInfo.containsKey("hostType") || !hostInfo.containsKey("sn")) continue;
                return true;
            }
        }
        return false;
    }

    public static List<HyperQuoServerManualCheckItem> getServerItemListByContext() {
        ArrayList<HyperQuoServerManualCheckItem> hyperQuoServerManualCheckItemList = new ArrayList<HyperQuoServerManualCheckItem>();
        Map serverAndHost = (Map)InspectContext.getDataByTmpObj(HYPER_QUO_SERVER_AND_NOT_ADD_HOST_INFO);
        if (null == serverAndHost) {
            return hyperQuoServerManualCheckItemList;
        }
        List serverList = (List)serverAndHost.get(QUO_SERVER_LIST);
        if (null == serverList) {
            return hyperQuoServerManualCheckItemList;
        }
        for (Map serverInfo : serverList) {
            HyperQuoServerManualCheckItem serverItem = new HyperQuoServerManualCheckItem(serverInfo);
            hyperQuoServerManualCheckItemList.add(serverItem);
        }
        return hyperQuoServerManualCheckItemList;
    }

    public static List<String> getStorageProductByHost(CheckDevNode checkDevNode) {
        DevNode hostDev = checkDevNode.getDevNode();
        if (hostDev == null) {
            return null;
        }
        Map hostMappedArraySn = (Map)InspectContext.getDataByTmpObj(HOST_MAPPED_ARRAY_SN);
        if (hostMappedArraySn == null) {
            return null;
        }
        String hostSn = hostDev.getDeviceSerialNumber();
        Map mappedArraySn = (Map)hostMappedArraySn.get(hostSn);
        if (mappedArraySn == null) {
            return null;
        }
        List arraySN = (List)mappedArraySn.get(ARRAY_SN);
        if (arraySN == null || arraySN.isEmpty()) {
            return null;
        }
        ArrayList<String> vsersionList = new ArrayList<String>();
        List devNodeList = (List)InspectContext.getInstance().getInspectWorktaker().get("select_dev_nodes");
        if (devNodeList == null) {
            return null;
        }
        for (String maopedSn : arraySN) {
            for (DevNode dev : devNodeList) {
                if (!maopedSn.equals(dev.getDeviceSerialNumber())) continue;
                vsersionList.add(dev.getProductVersion());
            }
        }
        return vsersionList;
    }

    public static List<HyperHostManualCheckItem> getHostItemListByContext() {
        ArrayList<HyperHostManualCheckItem> hyperHostManualCheckItemList = new ArrayList<HyperHostManualCheckItem>();
        Map serverAndHost = (Map)InspectContext.getDataByTmpObj(HYPER_QUO_SERVER_AND_NOT_ADD_HOST_INFO);
        if (null == serverAndHost) {
            return hyperHostManualCheckItemList;
        }
        List hostList = (List)serverAndHost.get(NOT_ADD_HOST_LIST);
        if (null == hostList) {
            return hyperHostManualCheckItemList;
        }
        for (Map hostInfo : hostList) {
            HyperHostManualCheckItem hostItem = new HyperHostManualCheckItem(hostInfo);
            hyperHostManualCheckItemList.add(hostItem);
        }
        return hyperHostManualCheckItemList;
    }

    private static Object getDataByTmpObj(String key) {
        ConcurrentHashMap<String, Object> tmpObj = InspectContext.getInstance().getObjectForPy();
        return tmpObj.get(key);
    }

    public Map<DevNode, Product> getdStorageProduct() {
        return this.dStorageProduct;
    }

    public List<SupportVersion> getExtendVersions() {
        return this.extendVersions;
    }

    public void setExtendVersions(List<SupportVersion> extendVersions) {
        this.extendVersions = extendVersions;
    }

    public boolean isFinishHyperManualCheck() {
        return this.finishHyperManualCheck;
    }

    public void setFinishHyperManualCheck(boolean finishHyperManualCheck) {
        this.finishHyperManualCheck = finishHyperManualCheck;
    }

    public CheckDevNode matchCheckDevNode(DevNode node) {
        List<CheckDevNode> checkDevNodes = this.inspectWorktaker.getCheckDevNodes();
        if (checkDevNodes == null) {
            return null;
        }
        for (CheckDevNode checkDevNode : checkDevNodes) {
            if (checkDevNode.isIntegration() || null == checkDevNode.getDevNode() || !node.equals((Object)checkDevNode.getDevNode())) continue;
            return checkDevNode;
        }
        return null;
    }

    public Map<String, String> getScmExpInfo() {
        return this.scmExpInfo;
    }

    public void setScmExpInfo(Map<String, String> scmExpInfo) {
        this.scmExpInfo = scmExpInfo;
    }

    public void setCheckPeriodStartTime(String checkPeriodStartTime) {
        this.checkPeriodStartTime = checkPeriodStartTime;
    }

    public String getCheckPeriodStartTime() {
        return this.checkPeriodStartTime;
    }

    public String getMemoryTaskDbPath() {
        return this.memoryTaskDbPath;
    }

    public void setMemoryTaskDbPath(String memoryTaskDbPath) {
        this.memoryTaskDbPath = memoryTaskDbPath;
    }

    public String getWorkPath() {
        return this.workPath;
    }

    public void setWorkPath(String workPath) {
        this.workPath = workPath;
    }

    public boolean isNfvMode() {
        return this.isNfvMode;
    }

    public void setNfvMode(boolean nfvMode) {
        this.isNfvMode = nfvMode;
    }

    public boolean isSupportFusionCubeDev(DevNode dev) {
        String deviceModel = dev.getDeviceType().toString();
        String version = dev.getProductVersion();
        if (CollectionUtils.isEmpty(this.extendVersions) || StringUtils.hasNULLStr((String[])new String[]{deviceModel, version})) {
            return false;
        }
        return this.extendVersions.stream().filter(Objects::nonNull).anyMatch(supportVersion -> {
            if (StringUtils.hasNULLStr((String[])new String[]{supportVersion.getVersion()}) || !deviceModel.equals(supportVersion.getModel())) {
                return false;
            }
            return Arrays.stream(supportVersion.getVersion().split(",")).anyMatch(version::contains);
        });
    }

    public boolean isSupportA3000Dev(DevNode dev) {
        String inspectType = InspectContext.getInstance().getSelectInspectType();
        if ("bureau_check".equals(inspectType)) {
            return false;
        }
        String deviceModel = dev.getDeviceType().toString();
        String version = dev.getProductVersion();
        if (CollectionUtils.isEmpty(this.extendVersions) || StringUtils.hasNULLStr((String[])new String[]{deviceModel, version})) {
            return false;
        }
        return this.extendVersions.stream().filter(Objects::nonNull).anyMatch(supportVersion -> {
            if (StringUtils.hasNULLStr((String[])new String[]{supportVersion.getVersion()}) || !deviceModel.equals(supportVersion.getModel())) {
                return false;
            }
            return Arrays.stream(supportVersion.getVersion().split(",")).anyMatch(version::contains);
        });
    }

    public FsNodeExpansionConfig getFsExpansionConfig(DevNode devNode) {
        if (this.nodeExpansionConfigMap.containsKey(devNode)) {
            return this.nodeExpansionConfigMap.get(devNode);
        }
        FsNodeExpansionConfig config = new FsNodeExpansionConfig();
        this.nodeExpansionConfigMap.put(devNode, config);
        return config;
    }

    public FsNodeExpansionConfig getFsExpansionConfig(ClusterNode clusterNode) {
        if (this.clusterNodeExpansionConfigMap.containsKey(clusterNode)) {
            return this.clusterNodeExpansionConfigMap.get(clusterNode);
        }
        FsNodeExpansionConfig config = new FsNodeExpansionConfig();
        this.clusterNodeExpansionConfigMap.put(clusterNode, config);
        return config;
    }

    public void updateNavigationBar(String key) {
        if ("detach_check".equals(key)) {
            this.insertDetachCheckCard();
        } else {
            this.resetToMergeCheckCard();
        }
        this.updateNavigationBar(InspectUIUtil.getStepsViewInfo());
    }

    private void resetToMergeCheckCard() {
        CardModelEnum card = this.getReferenceCard();
        InspectUIUtil.inserOrRemoveCard(false, card, CardModelEnum.SELECT_SOFT_ITEM);
        InspectUIUtil.inserOrRemoveCard(false, card, CardModelEnum.PERFORM_SOFT_INSPECT);
        InspectUIUtil.inserOrRemoveCard(false, card, CardModelEnum.SELECT_HARDWARE_ITEM);
        InspectUIUtil.inserOrRemoveCard(false, card, CardModelEnum.AUTH_CLUSTER_NODES);
        InspectUIUtil.inserOrRemoveCard(true, CardModelEnum.SELECTDEVICE, CardModelEnum.SELECTITEM);
    }

    private CardModelEnum getSetResultReferenceCard() {
        return InspectConstans.getStepViews().contains((Object)CardModelEnum.SELECTITEM) ? CardModelEnum.SELECTITEM : CardModelEnum.SELECT_CLUSTER_NODES;
    }

    private CardModelEnum getReferenceCard() {
        return InspectConstans.getStepViews().contains((Object)CardModelEnum.SETRESULT) ? CardModelEnum.SETRESULT : CardModelEnum.SELECT_CLUSTER_NODES;
    }

    private void insertDetachCheckCard() {
        CardModelEnum card = this.getReferenceCard();
        InspectUIUtil.inserOrRemoveCard(false, CardModelEnum.SELECT_CLUSTER_NODES, CardModelEnum.SELECTITEM);
        InspectUIUtil.inserOrRemoveCard(true, card, CardModelEnum.SELECT_SOFT_ITEM);
        InspectUIUtil.inserOrRemoveCard(true, CardModelEnum.SELECT_SOFT_ITEM, CardModelEnum.PERFORM_SOFT_INSPECT);
        InspectUIUtil.inserOrRemoveCard(true, CardModelEnum.PERFORM_SOFT_INSPECT, CardModelEnum.SELECT_HARDWARE_ITEM);
        InspectUIUtil.inserOrRemoveCard(true, CardModelEnum.SELECT_HARDWARE_ITEM, CardModelEnum.AUTH_CLUSTER_NODES);
    }

    public boolean isDetachCheck() {
        return "detach_check".equals(this.checkMode);
    }

    public boolean isHardwareInspect() {
        return this.isDetachCheck() && this.isPerformInspectStep();
    }

    private boolean isPerformInspectStep() {
        return this.getInspectStep() == InspectUIUtil.getCardIndex(CardModelEnum.PERFORMINSPECT);
    }

    public boolean isSoftInspect() {
        return this.isDetachCheck() && this.isPerformSoftInspectStep();
    }

    private boolean isPerformSoftInspectStep() {
        return this.getInspectStep() == InspectUIUtil.getCardIndex(CardModelEnum.PERFORM_SOFT_INSPECT);
    }

    public void initScene(String sceneArg) {
        this.isScenesInspect.clear();
        String scene = sceneArg;
        if (StringUtils.isNULLStr((String)sceneArg)) {
            scene = "realTimed_check";
        }
        this.isScenesInspect.put(scene, true);
        this.inspectWorktaker.put("select_sceneId", scene);
        this.setBureauCheckSelected("bureau_check".equalsIgnoreCase(scene));
    }

    public InspectWorktaker getWorkTaker(String taskId) {
        return this.workTaker.computeIfAbsent(taskId, key -> new InspectWorktaker());
    }

    public void checkDeviceRunning(List<DevNode> selectDevs, List<String> activeTaskIds, String currentTaskId) throws ToolException {
        Set devIds = selectDevs.stream().map(DevNode::getDeviceSerialNumber).collect(Collectors.toSet());
        String existsIp = this.workTaker.keySet().stream().filter(key -> !key.equals(currentTaskId)).filter(activeTaskIds::contains).map(this.workTaker::get).map(InspectWorktaker::getSelectedDevNodes).flatMap(Collection::stream).filter(node -> devIds.contains(node.getDeviceSerialNumber())).map(DevNode::getIp).collect(Collectors.joining(","));
        if (!existsIp.isEmpty()) {
            throw new ToolException("node.is.running", new Object[]{String.join((CharSequence)",", existsIp)});
        }
    }

    public Set<String> getExistsTaskIds() {
        return this.workTaker.keySet();
    }

    public void removeTask(String taskId) {
        this.workTaker.remove(taskId);
    }

    @Generated
    public void setQualityCheckUser(String qualityCheckUser) {
        this.qualityCheckUser = qualityCheckUser;
    }

    @Generated
    public String getQualityCheckUser() {
        return this.qualityCheckUser;
    }

    @Generated
    public void setInspectionGradientGuidance(InspectionGradientGuidance inspectionGradientGuidance) {
        this.inspectionGradientGuidance = inspectionGradientGuidance;
    }

    @Generated
    public InspectionGradientGuidance getInspectionGradientGuidance() {
        return this.inspectionGradientGuidance;
    }

    @Generated
    public void setInterfaceBom(String interfaceBom) {
        this.interfaceBom = interfaceBom;
    }

    @Generated
    public String getInterfaceBom() {
        return this.interfaceBom;
    }

    @Generated
    public void setInterfaceCardBom(String interfaceCardBom) {
        this.interfaceCardBom = interfaceCardBom;
    }

    @Generated
    public String getInterfaceCardBom() {
        return this.interfaceCardBom;
    }

    @Generated
    public void setDiskEnclosureBom(String diskEnclosureBom) {
        this.diskEnclosureBom = diskEnclosureBom;
    }

    @Generated
    public String getDiskEnclosureBom() {
        return this.diskEnclosureBom;
    }

    @Generated
    public void setRepairInput(String repairInput) {
        this.repairInput = repairInput;
    }

    @Generated
    public String getRepairInput() {
        return this.repairInput;
    }

    @Generated
    public void setSmartPoolDisks(ArrayList<DiskDomain> smartPoolDisks) {
        this.smartPoolDisks = smartPoolDisks;
    }

    @Generated
    public ArrayList<DiskDomain> getSmartPoolDisks() {
        return this.smartPoolDisks;
    }

    @Generated
    public void setCheckMode(String checkMode) {
        this.checkMode = checkMode;
    }

    @Generated
    public int getInspectStep() {
        return this.inspectStep;
    }

    @Generated
    public void setInspectStep(int inspectStep) {
        this.inspectStep = inspectStep;
    }

    @Generated
    public void setNeedCheckHighUsage(boolean isNeedCheckHighUsage) {
        this.isNeedCheckHighUsage = isNeedCheckHighUsage;
    }

    @Generated
    public boolean isNeedCheckHighUsage() {
        return this.isNeedCheckHighUsage;
    }

    @Generated
    public Map<String, Integer> getHyperMetroLockMap() {
        return this.hyperMetroLockMap;
    }

    @Generated
    public Map<File, JythonExecuter> getRequireCheckMap() {
        return this.requireCheckMap;
    }

    @Generated
    public void setInspectWorktaker(InspectWorktaker inspectWorktaker) {
        this.inspectWorktaker = inspectWorktaker;
    }

    @Generated
    public List<A800ExpansionDiskInfo> getExpansionA800DiskInfos() {
        return this.expansionA800DiskInfos;
    }

    @Generated
    public void setExpansionA800DiskInfos(List<A800ExpansionDiskInfo> expansionA800DiskInfos) {
        this.expansionA800DiskInfos = expansionA800DiskInfos;
    }

    @Generated
    public String getEventReportFileName() {
        return this.eventReportFileName;
    }

    @Generated
    public void setEventReportFileName(String eventReportFileName) {
        this.eventReportFileName = eventReportFileName;
    }

    static {
        CHECK_ITEM_TO_CHECK_TYPE_MAP.put("DiagnoseCliProcessCheck", "DiagnoseCliClean");
        CHECK_ITEM_TO_CHECK_TYPE_MAP.put("ToolCheckFreeMemForOfed", "EthMemoryRepair");
        CHECK_ITEM_TO_CHECK_TYPE_MAP.put("SwmCheckPkgUpd", "SwmCheckPkgUpdRepair");
        checkItemToRepairInfoMap.put("DiagnoseCliProcessCheck", "inspect.wizard.inspectDetailDialog.repair.info.cli.process.check");
        checkItemToRepairInfoMap.put("ToolCheckFreeMemForOfed", "inspect.wizard.inspectDetailDialog.repair.info.free.mem.for.ofed");
        checkItemToRepairInfoMap.put("SwmCheckPkgUpd", "inspect.wizard.inspectDetailDialog.repair.info.swm.check");
    }
}

