/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.utils;

import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.inspect.entity.CardModelEnum;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.entity.DstorageSceneCheckItems;
import com.huawei.ism.tool.inspect.entity.InspectStatus;
import com.huawei.ism.tool.inspect.entity.Item;
import com.huawei.ism.tool.inspect.entity.RItem;
import com.huawei.ism.tool.inspect.entity.Record;
import com.huawei.ism.tool.inspect.entity.RecordStatus;
import com.huawei.ism.tool.inspect.entity.ResultFlag;
import com.huawei.ism.tool.inspect.entity.ResultItem;
import com.huawei.ism.tool.inspect.entity.UiUpdatePair;
import com.huawei.ism.tool.inspect.logic.inspector.IUiObserver;
import com.huawei.ism.tool.inspect.ui.logic.SetResultSaveCardRunnable;
import com.huawei.ism.tool.inspect.ui.wizard.InspectCard;
import com.huawei.ism.tool.inspect.ui.wizard.PerformInspectCard;
import com.huawei.ism.tool.inspect.ui.wizard.PerformSoftInspectCard;
import com.huawei.ism.tool.inspect.ui.wizard.SelectHardwareItemCard;
import com.huawei.ism.tool.inspect.ui.wizard.SelectSoftItemCard;
import com.huawei.ism.tool.inspect.utils.InspectConstans;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.ui.component.wizard.ToolWizardDialog;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.pyengine.utils.PyJavaUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.TextInputDialog;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InspectUIUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InspectUIUtil.class);
    private static final String PRE_UPGRADE_CHECK_SCENE = "pre_upgrade_check";
    private static final ToolWizardDialog.Navigation[] FIRST_CARD_NAVS = new ToolWizardDialog.Navigation[]{ToolWizardDialog.Navigation.Next, ToolWizardDialog.Navigation.Cancel};
    private static final ToolWizardDialog.Navigation[] LAST_CARD_NAVS = new ToolWizardDialog.Navigation[]{ToolWizardDialog.Navigation.Previous, ToolWizardDialog.Navigation.Complete};
    private static final ToolWizardDialog.Navigation[] HAVE_STOP_LAST_CARD_NAVS = new ToolWizardDialog.Navigation[]{ToolWizardDialog.Navigation.Previous, ToolWizardDialog.Navigation.Next, ToolWizardDialog.Navigation.Complete};
    private static final ToolWizardDialog.Navigation[] COMMON_NAVS = new ToolWizardDialog.Navigation[]{ToolWizardDialog.Navigation.Cancel, ToolWizardDialog.Navigation.Next, ToolWizardDialog.Navigation.Previous};
    private static final ToolWizardDialog.Navigation[] SOFT_HARDWARE_SPLIT_NAVS = new ToolWizardDialog.Navigation[]{ToolWizardDialog.Navigation.Cancel, ToolWizardDialog.Navigation.Skip, ToolWizardDialog.Navigation.Next, ToolWizardDialog.Navigation.Previous};

    public static CardModelEnum getFirstCard() {
        return InspectConstans.getStepViews().getFirst();
    }

    public static CardModelEnum getLastCard() {
        return InspectConstans.getStepViews().getLast();
    }

    public static int getCardIndex(CardModelEnum card) {
        return InspectConstans.getStepViews().indexOf((Object)card);
    }

    public static void insertStepCard(CardModelEnum desCard, CardModelEnum srcCard) {
        if (!InspectConstans.getStepViews().contains((Object)srcCard)) {
            InspectConstans.getStepViews().add(InspectConstans.getStepViews().indexOf((Object)desCard) + 1, srcCard);
        }
    }

    public static boolean inserOrRemoveCard(boolean insert, CardModelEnum desCard, CardModelEnum srcCard) {
        if (!insert) {
            return InspectUIUtil.removeStepCard(srcCard);
        }
        if (!InspectConstans.getStepViews().contains((Object)srcCard)) {
            InspectUIUtil.insertStepCard(desCard, srcCard);
            return true;
        }
        return false;
    }

    public static boolean removeStepCard(CardModelEnum card) {
        return InspectConstans.getStepViews().remove((Object)card);
    }

    public static List<String[]> getStepsViewInfo() {
        ArrayList<String[]> stepsViewInfo = new ArrayList<String[]>();
        for (CardModelEnum info : InspectConstans.getStepViews()) {
            stepsViewInfo.add(info.getDes());
        }
        return stepsViewInfo;
    }

    public static ToolWizardDialog.Card getNextCard(CardModelEnum card, ToolWizardDialog.Card preCard) {
        ToolWizardDialog.Navigation[] navs = InspectUIUtil.getCardNavs(InspectConstans.getStepViews().get(InspectConstans.getStepViews().indexOf((Object)card) + 1).getCardClazz());
        return InspectUIUtil.getNextCard(card, preCard, navs);
    }

    public static ToolWizardDialog.Card getNextCard(CardModelEnum card, ToolWizardDialog.Card preCard, ToolWizardDialog.Navigation[] navs) {
        if (card.equals((Object)InspectConstans.getStepViews().getLast())) {
            log.info("current card is last card,card : {}", (Object)((Object)((Object)card)).getClass().getName());
            return null;
        }
        InspectCard nextCard = InspectUIUtil.getCardInstance(InspectConstans.getStepViews().get(InspectConstans.getStepViews().indexOf((Object)card) + 1).getCardClazz(), preCard, navs);
        if (Objects.isNull((Object)nextCard)) {
            return null;
        }
        if (InspectUIUtil.needStartInspect(nextCard)) {
            SwingUtilities.invokeLater(new SetResultSaveCardRunnable((PerformInspectCard)nextCard));
        }
        nextCard.initData();
        return nextCard;
    }

    private static boolean needStartInspect(ToolWizardDialog.Card nextCard) {
        return (InspectUIUtil.isLastCard(nextCard) || InspectUIUtil.isPerformSoftInspectCard(nextCard)) && nextCard instanceof PerformInspectCard;
    }

    private static boolean isPerformSoftInspectCard(ToolWizardDialog.Card nextCard) {
        return PerformSoftInspectCard.class.equals(nextCard.getClass());
    }

    private static boolean isLastCard(ToolWizardDialog.Card nextCard) {
        return InspectConstans.getStepViews().getLast().getCardClazz() == nextCard.getClass();
    }

    public static ToolWizardDialog.Navigation[] getCardNavs(Class<? extends InspectCard> clazz) {
        ToolWizardDialog.Navigation[] localNavs;
        ToolWizardDialog.Navigation.Previous.setName(null);
        ToolWizardDialog.Navigation.Next.setName(null);
        if (clazz.equals(InspectConstans.getStepViews().getLast().getCardClazz())) {
            if (clazz.equals(PerformInspectCard.class) && InspectUtils.isSupportActiveStopInspect()) {
                InspectUIUtil.reSetLabelNameForStopCard();
                localNavs = HAVE_STOP_LAST_CARD_NAVS;
            } else {
                InspectUIUtil.reSetLabelNameForLastCard(clazz);
                localNavs = LAST_CARD_NAVS;
            }
        } else if (clazz.equals(InspectUIUtil.getFirstCard().getCardClazz())) {
            localNavs = FIRST_CARD_NAVS;
        } else if (clazz.equals(SelectSoftItemCard.class) || clazz.equals(SelectHardwareItemCard.class)) {
            localNavs = SOFT_HARDWARE_SPLIT_NAVS;
        } else {
            if (clazz.equals(PerformSoftInspectCard.class)) {
                ToolWizardDialog.Navigation.Previous.setName(ResourceUtil.getString((String)"inspsctor.wizard.performinspect.reinspect"));
            }
            localNavs = COMMON_NAVS;
        }
        return localNavs;
    }

    private static void reSetLabelNameForLastCard(Class<? extends InspectCard> clazz) {
        if (PerformInspectCard.class.equals(clazz)) {
            ToolWizardDialog.Navigation.Previous.setName(ResourceUtil.getString((String)"inspsctor.wizard.performinspect.reinspect"));
        }
    }

    private static void reSetLabelNameForStopCard() {
        ToolWizardDialog.Navigation.Previous.setName(ResourceUtil.getString((String)"inspsctor.wizard.performinspect.reinspect"));
        ToolWizardDialog.Navigation.Next.setName(ResourceUtil.getString((String)"inspsctor.wizard.performinspect.stopinspect"));
    }

    public static InspectCard getCardInstance(Class<? extends InspectCard> clazz, ToolWizardDialog.Card preCard, ToolWizardDialog.Navigation[] navs) {
        try {
            Constructor<? extends InspectCard> cons = clazz.getConstructor(ToolWizardDialog.Card.class, ToolWizardDialog.Navigation[].class);
            return cons.newInstance(preCard, navs);
        }
        catch (Exception e) {
            log.error("relf inpsct card failed", (Throwable)e);
            return null;
        }
    }

    public static JComponent getLayoutInstance(Class<? extends JComponent> clazz) {
        try {
            Constructor<? extends JComponent> cons = clazz.getConstructor(new Class[0]);
            return cons.newInstance(new Object[0]);
        }
        catch (Exception e) {
            log.error("relf inpsct card layout failed", (Throwable)e);
            return null;
        }
    }

    public static JComponent getFirstCardLayoutInstance() {
        return InspectUIUtil.getLayoutInstance(InspectUIUtil.getFirstCard().getLayoutClazz());
    }

    public static UiUpdatePair initUiUpdatePair(UiUpdatePair ui, CheckDevNode checkDev, int progressStep) {
        if (null != ui) {
            ui.setFinished(false);
            int progress = ui.getProgress() + progressStep;
            ui.setProgress(Math.min(progress, 99));
            return ui;
        }
        UiUpdatePair result = new UiUpdatePair();
        result.setFinished(false);
        result.setCheckDevNode(checkDev);
        result.setListMode(new DefaultListModel());
        result.setProgress(progressStep);
        result.setInspectStatus(InspectStatus.EXECUTING);
        result.setInspectStatus(InspectStatus.EXECUTING);
        InspectContext.getInstance().addUiUpdatePair(checkDev, result);
        return result;
    }

    public static void updateRecordStatus(UiUpdatePair ui, CheckItem checkItem, RecordStatus status, List<Record> records) {
        InspectUIUtil.updateItemRecordStatus(ui, checkItem, status);
        DefaultListModel model = ui.getListMode();
        if (RecordStatus.RUNNING == status || RecordStatus.PROCESSING == status) {
            ui.addAllRecords(records);
            return;
        }
        ArrayList<Record> remainRecords = new ArrayList<Record>();
        String tipMsg = ResourceUtil.getString((String)"inspector.wizard.fusion.inspect.system.inner.chek");
        if (RecordStatus.INTERRUPPED != status) {
            int recordSize = ui.getRecordSize();
            for (int i = 0; i < recordSize; ++i) {
                Record record = ui.getRecord(i);
                if (tipMsg.equals(record.getMessage())) {
                    remainRecords.add(record);
                    continue;
                }
                if (checkItem != null && record.getCheckItem() != null && !checkItem.getItemId().equals(record.getCheckItem().getItemId())) {
                    remainRecords.add(record);
                    continue;
                }
                model.removeElement(record);
            }
        }
        ui.clearAllRecords();
        ui.addAllRecords(remainRecords);
    }

    public static void updateItemRecordStatus(UiUpdatePair ui, CheckItem checkItem, RecordStatus status) {
        String tipMsg = ResourceUtil.getString((String)"inspector.wizard.fusion.inspect.system.inner.chek");
        int size = ui.getRecordSize();
        for (int i = 0; i < size; ++i) {
            Record record = ui.getRecord(i);
            if (tipMsg.equals(record.getMessage()) || checkItem != null && record.getCheckItem() != null && !checkItem.getItemId().equals(record.getCheckItem().getItemId())) continue;
            record.setStatus(status);
        }
    }

    private static boolean isSysInnerCheckMsg(Record record) {
        return ResourceUtil.getString((String)"inspector.wizard.fusion.inspect.system.inner.chek").equals(record.getMessage());
    }

    public static List<Record> initRecords(CheckDevNode checkDev, CheckItem checkItem, String msg, Calendar time, RecordStatus status) {
        ArrayList<Record> records = new ArrayList<Record>();
        if (null == checkItem) {
            records.add(InspectUIUtil.getCommonStepRecord(checkDev, msg, time, status));
            return records;
        }
        ResultItem result = checkItem.getCheckResult();
        if (checkDev.getProduct().isOld()) {
            records.add(InspectUIUtil.getOldProductItemRecord(checkDev, checkItem, time));
            return records;
        }
        if (checkItem.isSingleElement()) {
            records.add(InspectUIUtil.getSingleItemRecord(checkDev, checkItem, time));
            return records;
        }
        List<Item> items = checkItem.getItems();
        for (Item item : items) {
            Record record = new Record();
            RItem ret = InspectUIUtil.getRet(result, item);
            String name = checkDev.getNameByRes(checkItem.getItemId() + "." + item.getId());
            record.setCheckItem(checkItem);
            record.setMessage(name);
            record.setCheckDevNode(checkDev);
            record.setItem(ret);
            record.setDate(time.getTime());
            records.add(record);
        }
        return records;
    }

    private static Record getCommonStepRecord(CheckDevNode checkDev, String msg, Calendar time, RecordStatus status) {
        Record record = new Record();
        record.setDate(time.getTime());
        record.setMessage(msg);
        record.setCheckDevNode(checkDev);
        if (status == RecordStatus.FAILED || status == RecordStatus.INFO || status == RecordStatus.PROCESSING) {
            record.setStatus(status);
        }
        return record;
    }

    private static Record getOldProductItemRecord(CheckDevNode checkDev, CheckItem checkItem, Calendar time) {
        Record record = new Record();
        record.setDate(time.getTime());
        String name = checkItem.getName();
        record.setCheckItem(checkItem);
        record.setMessage(name);
        record.setCheckDevNode(checkDev);
        List<RItem> retItem = checkItem.getCheckResult().getItems();
        if (null != retItem && !retItem.isEmpty()) {
            record.setItem(retItem.get(0));
        }
        return record;
    }

    private static Record getSingleItemRecord(CheckDevNode checkDev, CheckItem checkItem, Calendar time) {
        Record record = new Record();
        ResultItem result = checkItem.getCheckResult();
        RItem ritem = new RItem();
        ritem.setItemId("0");
        ritem.syncResult(result);
        record.setCheckItem(checkItem);
        record.setMessage(checkItem.getName());
        record.setCheckDevNode(checkDev);
        record.setItem(ritem);
        record.setDate(time.getTime());
        return record;
    }

    public static List<CheckItem> convertMsg2CheckItems(Map<String, Object> jsonMsg) {
        List mpItems = PyJavaUtils.convertPyList2Jlist((Object)jsonMsg.get("checkitems"));
        return mpItems.stream().map(InspectUIUtil::getCheckItem).collect(Collectors.toList());
    }

    @NotNull
    private static CheckItem getCheckItem(Map<String, Object> jsonMap) {
        CheckItem checkItem = new CheckItem();
        checkItem.setItemId(jsonMap.get("nameId").toString());
        checkItem.setRiskWeight("high");
        checkItem.setEnableMark("true");
        checkItem.setSelected(true);
        checkItem.setName(jsonMap.get("name").toString());
        checkItem.setSingleElement(true);
        checkItem.setItemType(jsonMap.get("itemType").toString());
        ResultItem ret = new ResultItem();
        ret.setCheckItem(checkItem);
        int status = Integer.parseInt(jsonMap.get("status").toString());
        ResultFlag resultFlag = ResultFlag.valueOf(status);
        InspectUIUtil.setResultStatus(ret, resultFlag);
        checkItem.setCheckResult(ret);
        String suggession = jsonMap.get("suggession").toString();
        if (!ResultFlag.PASS.equals((Object)resultFlag)) {
            checkItem.setErrorInfo(suggession);
        }
        checkItem.setItems(InspectUIUtil.getItems(jsonMap));
        return checkItem;
    }

    @NotNull
    private static List<Item> getItems(Map<String, Object> jsonMap) {
        Item item = new Item();
        item.setId(jsonMap.get("nameId").toString());
        item.setName(jsonMap.get("name").toString());
        ArrayList<Item> items = new ArrayList<Item>();
        items.add(item);
        return items;
    }

    public static void setResultStatus(ResultItem ret, ResultFlag resultFlag) {
        if (ResultFlag.NOSUPPORT.equals((Object)resultFlag)) {
            ret.setNoSupport(true);
            ret.setRecordStatus(RecordStatus.FINISHED);
        } else if (ResultFlag.NOCHECK.equals((Object)resultFlag)) {
            ret.setNoCheck(true);
            ret.setRecordStatus(RecordStatus.FAILED);
        } else if (ResultFlag.PASS.equals((Object)resultFlag)) {
            ret.setNormal(true);
            ret.setRecordStatus(RecordStatus.NORMAL);
        } else if (ResultFlag.WAITING.equals((Object)resultFlag) || ResultFlag.NOSTART.equals((Object)resultFlag)) {
            ret.setRecordStatus(RecordStatus.RUNNING);
        } else if (ResultFlag.STOPPED.equals((Object)resultFlag)) {
            ret.setNormal(false);
            ret.setStop(true);
            ret.setRecordStatus(RecordStatus.STOPPED);
        } else {
            ret.setNormal(false);
            ret.setRecordStatus(RecordStatus.FAILED);
        }
    }

    private static RItem getRet(ResultItem result, Item item) {
        RItem rItem = new RItem();
        rItem.setItemId(item.getId());
        rItem.setName(item.getName());
        if (null == result) {
            return rItem;
        }
        rItem.syncResult(result);
        return result.getItems().stream().filter(ret -> ret.getItemId().equals(item.getId())).findFirst().orElse(rItem);
    }

    public static void syncItemFailedWhenExecFailed(IUiObserver uiObserver, CheckDevNode checkDev, UiUpdatePair ui) {
        if (checkDev == null || !checkDev.getDevNodeSafe().isDsStorage() || checkDev.isExecuteSuc() || ui.getInspectStatus() != InspectStatus.EXEFALID) {
            return;
        }
        checkDev.getCheckItems().values().stream().filter(items -> items != null && !items.isEmpty()).flatMap(Collection::stream).forEach(item -> InspectUIUtil.setResultItemFailed(uiObserver, checkDev, item));
    }

    private static void setResultItemFailed(IUiObserver uiObserver, CheckDevNode checkDev, CheckItem item) {
        ResultItem resultItem = item.getCheckResult();
        if (resultItem == null || resultItem.isFinished()) {
            return;
        }
        resultItem.setStatus(RecordStatus.INTERRUPPED);
        resultItem.setProgress(100);
        resultItem.setNoCheck(true);
        resultItem.setFinished(true);
        uiObserver.update(checkDev, item, item.getName(), 0, resultItem.getStartTime());
    }

    public static UiUpdatePair updateUiUpdatePairWhenFinished(CheckDevNode checkDev) {
        UiUpdatePair ui = InspectContext.getInstance().getUiUpdatePair(checkDev);
        if (ui == null) {
            ui = new UiUpdatePair();
            ui.setFinished(false);
            InspectContext.getInstance().addUiUpdatePair(checkDev, ui);
        }
        ui.setInspectStatus(InspectUIUtil.getInspectStatusByCheckDevNode(checkDev));
        if (checkDev.isExecuteSuc()) {
            ui.setProgress(100);
            int faultNum = InspectUtils.checkFaultItemNum(checkDev);
            ui.setItemStatus(faultNum == 0 ? InspectStatus.EXECPASS : InspectStatus.EXECNOTPASS);
        } else if (checkDev.isStop()) {
            ui.setItemStatus(InspectStatus.STOPPED);
        }
        ui.setCheckDevNode(checkDev);
        return ui;
    }

    @NotNull
    private static InspectStatus getInspectStatusByCheckDevNode(CheckDevNode checkDev) {
        if (checkDev.isExecuteSuc()) {
            return InspectStatus.EXESUC;
        }
        return checkDev.isStop() ? InspectStatus.STOPPED : InspectStatus.EXEFALID;
    }

    public static boolean displaySignatureBox() {
        if (InspectUIUtil.needShowCheckUserDialog()) {
            JDialog mainDialog = InspectContext.getInstance().getMainDialog();
            TextInputDialog textInputDialog = DialogUtils.createTextInputDialog((JDialog)mainDialog);
            if (textInputDialog.getCloseEventValue() == 0) {
                InspectContext.getInstance().setQualityCheckUser(textInputDialog.getInputTextValue());
                return true;
            }
            return false;
        }
        return true;
    }

    private static boolean needShowCheckUserDialog() {
        return InspectUIUtil.isBureauCheck() && StringUtils.isNULLStr((String)InspectContext.getInstance().getQualityCheckUser());
    }

    private static boolean isBureauCheck() {
        return InspectUtils.isBureauCheckInspect() || "bureau_check".equals(InspectContext.getInstance().getSelectSceneId());
    }

    public static boolean isNeedPreUpgradeTable(CheckDevNode checkDevNode) {
        return checkDevNode != null && checkDevNode.getDevNode() != null && CollectionUtils.isNotEmpty(checkDevNode.getDstorageSceneCheckItemsList()) && InspectUIUtil.isPreUpgradeScene(InspectUIUtil.getCheckItemsSceneId(checkDevNode)) && !checkDevNode.getDevNode().isFusionCube() && !InspectUtils.isDistributedFrw() && !SceneUtils.isA800SceneInTool();
    }

    private static String getCheckItemsSceneId(CheckDevNode node) {
        return node.getDstorageSceneCheckItemsList().stream().filter(InspectUIUtil::isEnable).findFirst().map(DstorageSceneCheckItems::getSceneId).orElse("");
    }

    private static boolean isEnable(DstorageSceneCheckItems dsci) {
        return dsci.getCheckItems().values().stream().flatMap(Collection::stream).anyMatch(CheckItem::isEnable);
    }

    public static boolean isPreUpgradeScene(String sceneId) {
        return PRE_UPGRADE_CHECK_SCENE.equals(sceneId);
    }

    public static void removeOtherZoneInnerCheckItems(List<CheckDevNode> checkDevNodes) {
        String minId = checkDevNodes.stream().filter(checkDevNode -> "OceanStor A800".equals(checkDevNode.getDevNode().getProductModel())).map(checkDevNode -> checkDevNode.getDevNode().getUuid()).min(Comparator.naturalOrder()).orElse("0");
        checkDevNodes.stream().filter(checkDevNode -> "OceanStor A800".equals(checkDevNode.getDevNode().getProductModel()) && !minId.equals(checkDevNode.getDevNode().getUuid())).forEach(checkDevNode -> checkDevNode.getCheckItems().remove(ResourceUtil.getString((String)"innerCheck", (ResourceBundle[])new ResourceBundle[]{checkDevNode.getResourceBundle()})));
    }

    @Generated
    private InspectUIUtil() {
    }
}

