/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.utils;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.framework.platform.common.data.ToolUserRole;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.scenedata.SceneXmlData;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.entity.ConstantField;
import com.huawei.ism.tool.inspect.entity.DevInfo4Exp;
import com.huawei.ism.tool.inspect.entity.HelpKey;
import com.huawei.ism.tool.inspect.entity.RItem;
import com.huawei.ism.tool.inspect.entity.ResultItem;
import com.huawei.ism.tool.inspect.fit.common.InspectScene;
import com.huawei.ism.tool.inspect.logic.config.FusionStorageConfig;
import com.huawei.ism.tool.inspect.logic.config.InspectSceneValue;
import com.huawei.ism.tool.inspect.ui.wizard.InspectCard;
import com.huawei.ism.tool.inspect.utils.InspectConstans;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectLock;
import com.huawei.ism.tool.inspect.utils.KeyNumCounter;
import com.huawei.ism.tool.inspect.worktaker.InspectWorktaker;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.KeyOrderedHashMap;
import com.huawei.ism.tool.obase.utils.ListOrderedMap;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.json.JSONObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.FilesUtil;
import utils.Products;

public final class InspectUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InspectUtils.class);
    public static final String PRE_INSPECT_MARK = "pre_inspect_";
    private static final Logger LOGGER = LoggerFactory.getLogger(InspectUtils.class);
    private static final String RESULT_SUFFIX = ".html";
    private static final String RESULT_FILE_NAME = "InspectorResult";
    private static final String EXP_EVAL_RET_FILE_NAME = "ExpansionEvaluationResult";
    private static final String RESULT_FILE_NAME_PRE_CHECK = "PrecautionResult";
    private static final String STORAGE_CONFIG_NAME = "StorageConfigResult";
    private static final String ZIP_SUFFIX = ".zip";
    private static final String SOURCE_NAME = "source";
    private static final String BUREAU_SCENE = "Opening Delivery";
    private static final String ROUTINE_SCENE = "Routine Maintain";
    private static final int MAX = 99999;
    private static final String PATCHVERSION = "10.03.02.038";
    private static Boolean callPacth = null;
    private static final Object LOCK = new Object();
    private static final Object LOCAL_RECORD_SN_LOCK = new Object();
    private static final Map<String, InspectLock> DEVLOCKPOOL = new HashMap<String, InspectLock>();
    private static Map<String, Map<String, Integer>> nummap = new HashMap<String, Map<String, Integer>>();
    private static Boolean isPreExpEvaluation = null;
    private static Boolean toolkitTimingTask = null;
    private static Boolean eClient = null;

    private InspectUtils() {
    }

    public static Map<String, Map<String, Integer>> getNumberMap() {
        return nummap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InspectLock getDevLock(String ip) {
        Object object = LOCK;
        synchronized (object) {
            InspectLock lock = DEVLOCKPOOL.get(ip);
            if (null != lock) {
                return lock;
            }
            lock = new InspectLock();
            DEVLOCKPOOL.put(ip, lock);
            return lock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void alarmDevLock(String ip) {
        Object object = LOCK;
        synchronized (object) {
            InspectLock lock = DEVLOCKPOOL.get(ip);
            if (null != lock) {
                lock.setOwnedByOther(true);
            }
        }
    }

    public static String getCurrentPid() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        String pid = name.split("@")[0];
        LOGGER.info("pid name is:{};pid is :{}", (Object)name, (Object)pid);
        return pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseDevLock(String ip) {
        Object object = LOCK;
        synchronized (object) {
            InspectLock lock = DEVLOCKPOOL.get(ip);
            if (null != lock) {
                lock.setOwnedByOther(false);
            }
        }
    }

    public static File buildResultFileName(String path) {
        String reportPrefixName = InspectUtils.getReportPrefixName();
        File file = Paths.get(path, reportPrefixName + "_" + StringUtils.getDateFormat((String)"yyyyMMddHHmmss") + ZIP_SUFFIX).toFile();
        FileUtils.createDir((String)file.getParent());
        return file;
    }

    private static String getReportPrefixName() {
        String currentScene = InspectContext.getArgsParamFormSceneConfig("sceneInsepctObject");
        if ("warning_check".equalsIgnoreCase(currentScene)) {
            return RESULT_FILE_NAME_PRE_CHECK;
        }
        String sceneArgVal = ResourceUtil.getArgsParamFormSceneConfig((String)"effectiveScene");
        if ("exInspect".equalsIgnoreCase(sceneArgVal)) {
            return EXP_EVAL_RET_FILE_NAME;
        }
        if (InspectUtils.isStorageConfig()) {
            return STORAGE_CONFIG_NAME;
        }
        return RESULT_FILE_NAME;
    }

    public static File buildInspectFileName(String paretnPath, DevNode devNode) {
        return new File(paretnPath + File.separator + devNode.getIp() + "_" + devNode.getDeviceName() + RESULT_SUFFIX);
    }

    public static List<CheckDevNode> getAllDevs(Map<String, List<CheckDevNode>> checkDevs) {
        ArrayList<CheckDevNode> allDevs = new ArrayList<CheckDevNode>();
        ArrayList<String> types = new ArrayList<String>(checkDevs.keySet());
        for (String type : types) {
            CheckDevNode typeDev = new CheckDevNode();
            typeDev.setNodeName(type);
            List<CheckDevNode> devs = checkDevs.get(type);
            for (CheckDevNode dev : devs) {
                allDevs.addAll(dev.getAllCheckNode());
            }
        }
        return allDevs;
    }

    public static File buildSourceFileName(String paretnPath, DevNode devNode) {
        return new File(paretnPath + File.separator + devNode.getIp() + "_" + SOURCE_NAME + RESULT_SUFFIX);
    }

    public static File getTmpResultFilePath() {
        String suffix = null;
        suffix = InspectUtils.isToolKitDC() ? File.separator + InspectUtils.getEnv("silenceCallPid") : File.separator + System.currentTimeMillis() + new SecureRandom().nextInt(99999);
        File tempPath = new File(FilePathUtils.checkFile((String)(ApplicationContext.getInstance().getTmpPath() + File.separator + "report" + suffix)));
        try {
            return tempPath.getCanonicalFile();
        }
        catch (IOException e) {
            ToolLoggerFactory.getLogger(InspectUtils.class).error("create system temp file path error .");
            return null;
        }
        catch (RuntimeException e) {
            ToolLoggerFactory.getLogger(InspectUtils.class).error("create system temp file path error .", (Throwable)e);
            return null;
        }
    }

    public static String getItemDumpTempPath() {
        File file = new File(ApplicationContext.getInstance().getTmpPath() + File.separator + "Record" + File.separator + InspectUtils.getCurrentPid());
        return FilesUtil.getCanonicalPath((File)file);
    }

    public static ListOrderedMap<String, List<CheckDevNode>> classifyDevs(List<CheckDevNode> checkNodes) {
        KeyOrderedHashMap checkTypeNodes = new KeyOrderedHashMap();
        if (null == checkNodes) {
            return checkTypeNodes;
        }
        KeyNumCounter counter = new KeyNumCounter();
        for (CheckDevNode checkNode : checkNodes) {
            ArrayList<CheckDevNode> list;
            String productName;
            if (checkNode.isIntegration()) {
                InspectUtils.addIntegeration((ListOrderedMap<String, List<CheckDevNode>>)checkTypeNodes, counter, checkNode);
                continue;
            }
            String typeKey = productName = checkNode.getProduct().getProductName();
            if (InspectContext.getInstance().isOemOutTool()) {
                typeKey = checkNode.getDevNode().getOemModel();
            }
            if (InspectContext.ISVERSION.containsKey(checkNode.getDevNode().getIp())) {
                String checkFuncName = checkNode.getScriptDir().getName();
                typeKey = productName + '(' + checkFuncName + ')';
            }
            if (EntityUtils.isComputeStorageDevLoginThroughFcv((DevNode)checkNode.getDevNode()) && !checkNode.getDevNode().is2910V7()) {
                typeKey = String.format(Locale.ROOT, "%s MetaVision", typeKey);
            }
            if (null == (list = (ArrayList<CheckDevNode>)checkTypeNodes.get((Object)typeKey))) {
                list = new ArrayList<CheckDevNode>();
                list.add(checkNode);
                checkTypeNodes.put((Object)typeKey, list);
                continue;
            }
            list.add(checkNode);
        }
        return InspectUtils.secondOrderedMap((ListOrderedMap<String, List<CheckDevNode>>)checkTypeNodes, false);
    }

    private static ListOrderedMap<String, List<CheckDevNode>> secondOrderedMap(ListOrderedMap<String, List<CheckDevNode>> checkTypeNodes, boolean isTpyeOrder) {
        KeyOrderedHashMap checkTypeNodesTmp = new KeyOrderedHashMap();
        block0: for (String key : checkTypeNodes.keyList()) {
            List checkDevNodes = (List)checkTypeNodes.get((Object)key);
            if (null != checkDevNodes && !checkDevNodes.isEmpty() && ((CheckDevNode)checkDevNodes.get(0)).isIntegration()) {
                checkTypeNodesTmp.put((Object)key, (Object)checkDevNodes);
                continue;
            }
            HashMap<File, ArrayList<CheckDevNode>> mapTmp = new HashMap<File, ArrayList<CheckDevNode>>();
            if (null == checkDevNodes) {
                throw new NullPointerException();
            }
            for (CheckDevNode checkDevNode : checkDevNodes) {
                File checkListFile = checkDevNode.getCheckListFile();
                ArrayList<CheckDevNode> checkDevNodeTmps = (ArrayList<CheckDevNode>)mapTmp.get(checkListFile);
                if (null == checkDevNodeTmps) {
                    checkDevNodeTmps = new ArrayList<CheckDevNode>();
                    checkDevNodeTmps.add(checkDevNode);
                    mapTmp.put(checkListFile, checkDevNodeTmps);
                    continue;
                }
                if (isTpyeOrder) continue;
                checkDevNodeTmps.add(checkDevNode);
            }
            Iterator newKeys = mapTmp.keySet().iterator();
            int index = 0;
            while (newKeys.hasNext()) {
                if (1 == mapTmp.size()) {
                    checkTypeNodesTmp.put((Object)key, mapTmp.get(newKeys.next()));
                    continue block0;
                }
                checkTypeNodesTmp.put((Object)(key + "(" + ++index + ")"), mapTmp.get(newKeys.next()));
            }
        }
        return checkTypeNodesTmp;
    }

    public static ListOrderedMap<String, List<CheckDevNode>> classifyDevsTypes(List<CheckDevNode> checkNodes) {
        KeyOrderedHashMap checkTypeNodesTmp = new KeyOrderedHashMap();
        if (null == checkNodes) {
            return checkTypeNodesTmp;
        }
        KeyNumCounter counter = new KeyNumCounter();
        for (CheckDevNode checkNode : checkNodes) {
            ArrayList<CheckDevNode> list;
            String productName;
            if (checkNode.isIntegration()) {
                InspectUtils.addIntegerationTypes((ListOrderedMap<String, List<CheckDevNode>>)checkTypeNodesTmp, counter, checkNode);
                continue;
            }
            String typeKey = productName = checkNode.getProduct().getProductName();
            if (InspectContext.ISVERSION.containsKey(checkNode.getDevNode().getIp())) {
                String checkFuncName = checkNode.getScriptDir().getName();
                typeKey = productName + '(' + checkFuncName + ')';
            }
            if (null == (list = (ArrayList<CheckDevNode>)checkTypeNodesTmp.get((Object)typeKey))) {
                list = new ArrayList<CheckDevNode>();
                list.add(checkNode);
                checkTypeNodesTmp.put((Object)typeKey, list);
                continue;
            }
            list.add(checkNode);
        }
        return InspectUtils.secondOrderedMap((ListOrderedMap<String, List<CheckDevNode>>)checkTypeNodesTmp, true);
    }

    private static void addIntegerationTypes(ListOrderedMap<String, List<CheckDevNode>> checkTypeNodes, KeyNumCounter counter, CheckDevNode checkNode) {
        String type = checkNode.getProduct().getProductName();
        ArrayList<CheckDevNode> devsType = new ArrayList<CheckDevNode>();
        HashMap<String, CheckDevNode> types = new HashMap<String, CheckDevNode>();
        for (CheckDevNode checkDevNode : checkNode.getChildrens()) {
            types.put(checkDevNode.toString(), checkDevNode);
        }
        for (Map.Entry e : types.entrySet()) {
            CheckDevNode val = (CheckDevNode)e.getValue();
            devsType.add(val);
        }
        int num = counter.getEqKeyNum(checkNode);
        checkTypeNodes.put((Object)(type + '(' + num + ')'), devsType);
    }

    private static void addIntegeration(ListOrderedMap<String, List<CheckDevNode>> checkTypeNodes, KeyNumCounter counter, CheckDevNode checkNode) {
        String type = checkNode.getProduct().getProductName();
        ArrayList<CheckDevNode> devs = new ArrayList<CheckDevNode>();
        devs.addAll(checkNode.getChildrens());
        int num = counter.getEqKeyNum(checkNode);
        checkTypeNodes.put((Object)(type + '(' + num + ')'), devs);
    }

    public static CheckItem findCheckItem(CheckDevNode node, CheckItem findCheckItem, String parentItemName) {
        List<CheckItem> checkItems = node.getCheckItems().get(parentItemName);
        return Optional.ofNullable(checkItems).orElse(Collections.emptyList()).stream().filter(checkItem -> checkItem.getName().equals(findCheckItem.getName())).findAny().orElse(null);
    }

    public static List<CheckItem> getAllCheckItem(CheckDevNode node) {
        Map<String, List<CheckItem>> checkItemTypes = node.getCheckItems();
        ArrayList<String> keys = new ArrayList<String>(checkItemTypes.keySet());
        ArrayList<CheckItem> items = new ArrayList<CheckItem>();
        for (String key : keys) {
            List<CheckItem> ciList = checkItemTypes.get(key);
            for (CheckItem ci : ciList) {
                if (!ci.isEnable()) continue;
                items.add(ci);
            }
        }
        return items;
    }

    public static List<CheckItem> getAllCheckItemRemoveNoUsePreInspectScrips(CheckDevNode node) {
        Set<String> preInspectScrips = InspectUtils.getPreInspectScrips(node);
        return node.getCheckItems().values().stream().flatMap(Collection::stream).filter(checkItem -> checkItem.isEnable() || preInspectScrips.contains(checkItem.getItemId())).collect(Collectors.toList());
    }

    public static Set<String> getPreInspectScrips(CheckDevNode node) {
        List containPreInspectScripItems = InspectUtils.getAllCheckItem(node).stream().filter(checkItem -> !StringUtils.isNULLStr((String)checkItem.getPreInspectionScrip())).collect(Collectors.toList());
        return containPreInspectScripItems.stream().map(checkItem -> checkItem.getPreInspectionScrip()).collect(Collectors.toSet());
    }

    public static int getItemArraySize(CheckDevNode node) {
        Map<String, List<CheckItem>> checkItemTypes = node.getCheckItems();
        int itemArraySize = checkItemTypes.size();
        return itemArraySize;
    }

    public static int haveNoCheckdItem(CheckDevNode node) {
        int noCheckCount = 0;
        List<CheckItem> items = InspectUtils.getAllCheckItem(node);
        boolean startInspect = false;
        for (CheckItem item : items) {
            if (!item.isEnable()) continue;
            startInspect = true;
            ResultItem res = item.getCheckResult();
            if (null != res) continue;
            ++noCheckCount;
        }
        return startInspect ? noCheckCount : items.size();
    }

    public static int getPassedDeviceNum(List<CheckDevNode> checkDevs) {
        int passedDevNum = 0;
        for (CheckDevNode devs : checkDevs) {
            for (CheckDevNode dev : devs.getAllCheckNode()) {
                int faultNum = InspectUtils.checkFaultItemNum(dev);
                if (0 != faultNum) continue;
                ++passedDevNum;
            }
        }
        return passedDevNum;
    }

    public static int checkFaultItemNum(CheckDevNode node) {
        List<CheckItem> items = InspectUtils.getAllCheckItem(node);
        int faultSize = 0;
        for (CheckItem item : items) {
            if (!item.isEnable()) continue;
            ResultItem result = item.getCheckResult();
            faultSize = InspectUtils.checkElement(faultSize, item, result);
        }
        return faultSize;
    }

    private static int checkElement(int faultSize, CheckItem item, ResultItem result) {
        int resultFaultSize = faultSize;
        if (item.isSingleElement()) {
            resultFaultSize += null == result || result.isFailed() ? 1 : 0;
        } else if (null == result || result.getItems().isEmpty()) {
            resultFaultSize += item.getItems().size();
        } else {
            for (RItem ritem : result.getItems()) {
                resultFaultSize += ritem.isFailed() ? 1 : 0;
            }
        }
        return resultFaultSize;
    }

    public static Map<String, List<HelpKey>> getHelpKeys(String key) {
        HashMap<String, List<HelpKey>> helpKeys = new HashMap<String, List<HelpKey>>();
        try {
            String[] keys;
            if (StringUtils.isNULLStr((String)key)) {
                return helpKeys;
            }
            for (String valString : keys = key.split("&&")) {
                int index = 1;
                String[] vals = valString.split("\\{");
                String keyString = vals[0].trim();
                String urlString = vals[1].trim();
                int urlLen = urlString.length();
                urlString = urlString.substring(0, urlLen - 1);
                ArrayList<HelpKey> hKeys = new ArrayList<HelpKey>();
                for (String url : urlString.split(",")) {
                    HelpKey helpKey = new HelpKey();
                    helpKey.setKey(keyString);
                    helpKey.setUrl(url);
                    helpKey.setLocation(index++);
                    hKeys.add(helpKey);
                }
                helpKeys.put(keyString, hKeys);
            }
        }
        catch (RuntimeException e) {
            ToolLoggerFactory.getLogger(InspectUtils.class).error("inspect get help key error!", (Throwable)e);
        }
        return helpKeys;
    }

    public static String replaceKeysByMap(String value, String path, Map<String, List<HelpKey>> helpKeys) {
        String tmp = value;
        for (Map.Entry<String, List<HelpKey>> entry : helpKeys.entrySet()) {
            List<HelpKey> hKeys = entry.getValue();
            tmp = InspectUtils.replaceKeys(tmp, path, hKeys);
        }
        return tmp;
    }

    public static String replaceKeys(String value, String path, List<HelpKey> helpKeys) {
        StringBuffer tmp = new StringBuffer();
        int ind = 1;
        String actualPath = path.replaceAll("\\\\", "/");
        String actualValue = value;
        for (HelpKey helpKey : helpKeys) {
            String keyString = helpKey.getKey();
            String urlString = helpKey.getUrl();
            int index = helpKey.getLocation();
            if (StringUtils.isNULLStr((String)urlString)) {
                ++ind;
                continue;
            }
            if (!(urlString.contains("http") || urlString.contains("www") || urlString.contains(".com"))) {
                urlString = StringUtils.isNULLStr((String)actualPath) ? urlString.substring(1, urlString.length()) : actualPath + urlString;
            }
            StringBuffer replaceBuffer = new StringBuffer();
            replaceBuffer.append("<a class=\"link\" href=\"").append(urlString).append("\" target=\"_blank\">").append(keyString).append("</a>");
            int keyLoc = actualValue.indexOf(keyString);
            if (-1 == keyLoc) {
                ++ind;
                continue;
            }
            String sum = actualValue.substring(0, keyLoc + keyString.length());
            if (ind == index) {
                String targetString = sum.replaceFirst(keyString, replaceBuffer.toString());
                tmp.append(targetString);
                actualValue = actualValue.replace(sum, "");
            }
            ++ind;
        }
        tmp.append(actualValue);
        return tmp.toString();
    }

    public static String getTypeFolderName(CheckDevNode checkDevNode) {
        File file = checkDevNode.getCheckListFile();
        while (!file.getParentFile().getName().equals("products")) {
            file = file.getParentFile();
        }
        return file.getName();
    }

    public static Map<String, Map<String, Integer>> getNummap() {
        return nummap;
    }

    public static boolean checkUploadRight() {
        String code = System.getenv("toolRunRole");
        LOGGER.info("toolRunRole : {}", (Object)com.huawei.ism.tool.base.utils.StringUtils.getCleanMessage((String)code));
        return !InspectContext.getInstance().isOemOutTool() && InspectContext.getInstance().isForeground() && ToolUserRole.isRoleCanUplaod((String)code) && InspectContext.getInstance().isToolkitZhCn();
    }

    private static boolean containsIndependentTool(String toolId) {
        File file = new File(new File(ApplicationContext.getInstance().getWorkPath()).getParent());
        File[] files = file.listFiles();
        if (null == files || files.length == 0) {
            throw new NullPointerException();
        }
        for (File f : files) {
            String fileName = f.getName();
            if (!toolId.equals(fileName)) continue;
            return true;
        }
        return false;
    }

    public static boolean existTool(String toolName) {
        boolean existTool = InspectUtils.containsIndependentTool(toolName);
        LOGGER.info("{} exist ? {}", (Object)toolName, (Object)existTool);
        return existTool;
    }

    public static boolean checkToolVersion(String toolName, String propertiesKey) {
        String toolVersion = UserOpDataSaveUtil.getToolIniProp((String)toolName, (String)propertiesKey);
        LOGGER.info("{} tool version : {}", (Object)toolName, (Object)toolVersion);
        return toolVersion.compareToIgnoreCase(PATCHVERSION) > 0;
    }

    public static synchronized boolean callPatch() {
        if (callPacth != null) {
            return callPacth;
        }
        InspectUtils.filtDevs();
        InspectUtils.filtLoginingWay();
        callPacth = !InspectContext.getInstance().isOemOutTool() && !InspectContext.getInstance().getHotPatchVersionWarningDevs().isEmpty() && InspectContext.getInstance().isHavingRightPatchTool() && InspectUtils.checkToolRight(System.getenv("toolRunRole"), String.valueOf(1001), String.valueOf(1002));
        return callPacth;
    }

    public static boolean checkToolRight(String toolRunRole, String ... accessableRoles) {
        if (StringUtils.isNULLStr((String)toolRunRole)) {
            LOGGER.info("current tool run role is null or empty. ");
            return false;
        }
        LOGGER.info("current tool run role {}", (Object)com.huawei.ism.tool.base.utils.StringUtils.getCleanMessage((String)toolRunRole));
        StringBuffer acRole = new StringBuffer();
        for (String accessableRole : accessableRoles) {
            acRole.append(accessableRole).append(',');
        }
        return acRole.toString().contains(toolRunRole);
    }

    public static void filtDevs() {
        if (ApplicationContext.getInstance().isSpecificDeviceMode()) {
            return;
        }
        Set<Map.Entry<DevNode, Map<String, String>>> devs = InspectContext.getInstance().getHotPatchVersionWarningDevs().entrySet();
        ArrayList<DevNode> devList = new ArrayList<DevNode>();
        for (Map.Entry<DevNode, Map<String, String>> dev : devs) {
            String deviceType = dev.getKey().getDeviceType().toString();
            if (!deviceType.contains("18") && !deviceType.contains("HVS")) continue;
            devList.add(dev.getKey());
            LOGGER.info("remove specific device out of SVP env. deviceIp : {}", (Object)dev.getKey().getIp());
        }
        for (DevNode devNode : devList) {
            InspectContext.getInstance().getHotPatchVersionWarningDevs().remove(devNode);
        }
    }

    public static void filtLoginingWay() {
        Map<DevNode, Map<String, String>> devs = InspectContext.getInstance().getHotPatchVersionWarningDevs();
        Set<Map.Entry<DevNode, Map<String, String>>> devsEntry = devs.entrySet();
        ArrayList<DevNode> devList = new ArrayList<DevNode>();
        for (Map.Entry<DevNode, Map<String, String>> dev : devsEntry) {
            if (!dev.getKey().isNotSocks5Proxy()) {
                devList.add(dev.getKey());
                LOGGER.info("remove socks5 dev. deviceIp : {}", (Object)dev.getKey().getIp());
                continue;
            }
            if (dev.getKey() != null && !StringUtils.isNULLStr((String)dev.getKey().getLoginUser().getPassword())) continue;
            devList.add(dev.getKey());
            LOGGER.info("remove publicKey dev. deviceIp : {}", (Object)dev.getKey().getIp());
        }
        for (DevNode devNode : devList) {
            devs.remove(devNode);
        }
    }

    public static Boolean isPreExpEvaluation() {
        if (null != isPreExpEvaluation) {
            return isPreExpEvaluation;
        }
        isPreExpEvaluation = "exInspect".equalsIgnoreCase(InspectContext.getArgsParamFormSceneConfig("effectiveScene"));
        return isPreExpEvaluation;
    }

    public static void setIsPreExpEvaluation(Boolean isPreExpEvaluation) {
        InspectUtils.isPreExpEvaluation = isPreExpEvaluation;
    }

    public static boolean isFusionStorage2Update() {
        InspectSceneValue sceneValue = InspectContext.getInstance().getInspectSceneValue();
        if (null == sceneValue) {
            return false;
        }
        return "Upgrade".equals(sceneValue.getMainScene()) && "FusionStorage Upgrade".equals(sceneValue.getSubScene()) && sceneValue.getArgsList().contains("toUpdateTool");
    }

    public static boolean isFusionCubeEval() {
        InspectSceneValue sceneValue = InspectContext.getInstance().getInspectSceneValue();
        if (null == sceneValue) {
            return false;
        }
        return "Upgrade".equals(sceneValue.getMainScene()) && "FusionCube Upgrade".equals(sceneValue.getSubScene());
    }

    public static boolean isFusionEval() {
        InspectSceneValue sceneValue = InspectContext.getInstance().getInspectSceneValue();
        if (null == sceneValue) {
            return false;
        }
        return "Upgrade".equals(sceneValue.getMainScene()) && "FusionStorage Upgrade".equals(sceneValue.getSubScene()) && sceneValue.getArgsList().contains("FusionStorageUpdateEval");
    }

    public static boolean isFusionInspect() {
        InspectSceneValue sceneValue = InspectContext.getInstance().getInspectSceneValue();
        if (sceneValue == null) {
            return false;
        }
        return ROUTINE_SCENE.equals(sceneValue.getMainScene()) && "FusionStorage Inspect".equals(sceneValue.getSubScene());
    }

    public static boolean isFsExInspect() {
        InspectSceneValue sceneValue = InspectContext.getInstance().getInspectSceneValue();
        if (sceneValue == null) {
            return false;
        }
        return "Expansion".equals(sceneValue.getMainScene()) && "Fusionstorage Expansion Evaluation".equals(sceneValue.getSubScene());
    }

    public static boolean isDistributedFru() {
        InspectSceneValue sceneValue = InspectContext.getInstance().getInspectSceneValue();
        if (sceneValue == null) {
            return false;
        }
        return "Parts Replacement".equals(sceneValue.getMainScene()) && "Distributed FRU".equals(sceneValue.getSubScene());
    }

    public static boolean isSnsInspect() {
        InspectSceneValue sceneValue = InspectContext.getInstance().getInspectSceneValue();
        if (Objects.isNull(sceneValue)) {
            return false;
        }
        if (ROUTINE_SCENE.equals(sceneValue.getMainScene()) && "Switch Inspector".equals(sceneValue.getSubScene())) {
            return true;
        }
        return BUREAU_SCENE.equals(sceneValue.getMainScene()) && "Switch Quality Checks".equalsIgnoreCase(sceneValue.getSubScene());
    }

    public static boolean isDistributedFrw() {
        InspectSceneValue sceneValue = InspectContext.getInstance().getInspectSceneValue();
        if (sceneValue == null) {
            return false;
        }
        return "Upgrade".equals(sceneValue.getMainScene()) && "Upgrade_FSFW".equals(sceneValue.getSubScene());
    }

    public static boolean isDistributedBatchUpgrade() {
        return Arrays.asList("IntelligentCompute_A800_dpc_upgrade", "Upgrade_Batch").contains(SceneUtils.getCurrentSubScene());
    }

    public static boolean isBatchPreUpgradeScene() {
        String jsonScene = System.getenv("jsonScene");
        if (StringUtils.isNULLStr((String)jsonScene)) {
            return false;
        }
        return InspectUtils.isDistributedBatchUpgrade() && "PerInspector".equals(JSON.parseObject((String)jsonScene).getOrDefault((Object)"stepID", (Object)"").toString());
    }

    public static boolean isBatchPostUpgradeScene() {
        String jsonScene = System.getenv("jsonScene");
        if (StringUtils.isNULLStr((String)jsonScene)) {
            return false;
        }
        return InspectUtils.isDistributedBatchUpgrade() && "Inspector".equals(JSON.parseObject((String)jsonScene).getOrDefault((Object)"stepID", (Object)"").toString());
    }

    public static boolean isBatchUpgradeScene() {
        return InspectUtils.isDistributedBatchUpgrade();
    }

    public static boolean isBureauCheckInspect() {
        InspectSceneValue sceneValue = InspectContext.getInstance().getInspectSceneValue();
        if (sceneValue == null) {
            return false;
        }
        return BUREAU_SCENE.equals(sceneValue.getMainScene()) && "Quality Checks".equals(sceneValue.getSubScene());
    }

    public static boolean isSupportNfv() {
        if (!InspectUtils.isBureauCheckInspect()) {
            return false;
        }
        List devNodesList = DefaultNodeProviderImpl.getInstance().getNodeList();
        if (VerifyUtil.isEmpty((Collection)devNodesList)) {
            return false;
        }
        return devNodesList.stream().filter(dev -> dev.isDsStorage() && !dev.isFusionCube()).anyMatch(dev -> Products.compareVersion((String)dev.getProductVersion(), (String)FusionStorageConfig.getNfvVersion("compareversionfornfv")) >= 0);
    }

    public static List<DevNode> getHyperMetroDevNodeList() {
        List newNodeLists = SceneXmlData.getInstance().loadSceneFromFile("sceneRelatedDeviceList.xml");
        if (null == newNodeLists) {
            LOGGER.error("scene read data from sceneRelatedDeviceList.xml is failed");
            return null;
        }
        List nodeList = EntityUtils.toOldDevList((List)newNodeLists);
        if (null == nodeList) {
            LOGGER.error("scene read data from sceneRelatedDeviceList.xml is failed");
            return null;
        }
        if (nodeList.isEmpty()) {
            return null;
        }
        return nodeList;
    }

    public static void initSceneData() {
        if (SceneUtils.isScene()) {
            try {
                String sceneData = InspectUtils.getEnv("jsonScene");
                JSONObject jsonObject = new JSONObject(sceneData);
                String mainScene = jsonObject.getString("mainScene");
                String subScene = jsonObject.getString("subScene");
                String field = jsonObject.getString("field");
                String argsList = InspectUtils.getEnv("jsonSceneArgsList");
                InspectSceneValue inspectSceneValue = new InspectSceneValue(mainScene, subScene, field);
                inspectSceneValue.setArgsList(argsList);
                InspectContext.getInstance().setInspectSceneValue(inspectSceneValue);
            }
            catch (Exception e) {
                LOGGER.error("load scene error.", (Throwable)e);
            }
        }
    }

    public static String getEnv(String key) {
        String value = System.getProperty(key);
        return value == null ? System.getenv(key) : value;
    }

    public static synchronized boolean isToolkitTimingTask() {
        if (null != toolkitTimingTask) {
            return toolkitTimingTask;
        }
        toolkitTimingTask = "toolkit".equals(InspectUtils.getEnv("callTool")) && "basic".equals(InspectUtils.getEnv("sence"));
        return toolkitTimingTask;
    }

    public static boolean isToolKitDC() {
        return "toolkitDC".equals(InspectUtils.getEnv("callTool"));
    }

    public static synchronized boolean isEClient() {
        if (null != eClient) {
            return eClient;
        }
        eClient = "cloudservice".equals(InspectUtils.getEnv("callTool"));
        return eClient;
    }

    public static Boolean isNewOceanStor(DevInfo4Exp devInfo) {
        return ConstantField.NEW_DORADO_DEV.contains(devInfo.getDevType());
    }

    public static Boolean isMicro(DevInfo4Exp devInfo) {
        return ConstantField.MICRO_DEV.contains(devInfo.getDevType().toUpperCase());
    }

    public static Boolean isMicroHybridFlash(DevInfo4Exp devInfo) {
        return ConstantField.MICRO_DEV.contains(devInfo.getDevType().toUpperCase()) && ConstantField.MICRO_FLASHING_INTER_MODEL.contains(devInfo.getInternalModel());
    }

    public static Boolean isMicroPassThrouthMode(DevInfo4Exp devInfo) {
        return InspectUtils.isMicro(devInfo) != false && devInfo.isPassThrouthMode();
    }

    public static List<CheckDevNode> getDistributedStorageCheckDev(List<CheckDevNode> checkDevNodes) {
        return checkDevNodes.stream().filter(InspectUtils::isDistributeNode).collect(Collectors.toList());
    }

    private static boolean isDistributeNode(CheckDevNode checkDevNode) {
        return !checkDevNode.isIntegration() && !Objects.isNull(checkDevNode.getDevNode()) && checkDevNode.getDevNode().isLikeDsStorage();
    }

    public static String getDevNodeIpInReport(CheckDevNode devNode) {
        if (EntityUtils.isComputeStorageDevLoginThroughFcv((DevNode)devNode.getDevNodeSafe())) {
            return devNode.getDevNode().getComputeStorageDevNode().getFcvIp();
        }
        if (devNode.getDevNode().getDeviceSerialNumber() != null && devNode.getDevNode().getDeviceSerialNumber().endsWith("MetaVision")) {
            return "MetaVision:" + devNode.getDevNode().getIp();
        }
        return devNode.getDevNode().getIp();
    }

    public static boolean isDpaInspectScene() {
        return SceneUtils.isSpecialScence((String)System.getenv("jsonScene"), (String[])new String[]{"DPA Inspector"});
    }

    public static boolean isCyberEngineDev(CheckDevNode checkDevNode) {
        return ItDeviceType.OCEAN_CYBER.equals((Object)checkDevNode.getDevNodeSafe().getItDeviceType());
    }

    public static boolean isStartedByYingLong() {
        return "yinglong".equalsIgnoreCase(System.getProperty("framework.scene"));
    }

    public static boolean isStorageConfig() {
        InspectSceneValue sceneValue = InspectContext.getInstance().getInspectSceneValue();
        if (sceneValue == null) {
            return false;
        }
        return BUREAU_SCENE.equals(sceneValue.getMainScene()) && "Storage Config".equals(sceneValue.getSubScene());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeExecuteInfoLocal(CheckDevNode node) {
        Object object = LOCAL_RECORD_SN_LOCK;
        synchronized (object) {
            String sn = node.getDevNode().getDeviceSerialNumber();
            if (!node.isDistributed() || InspectUtils.isRecordSnToLocal(sn)) {
                LOGGER.info("The device is not a distributed device or the SN has been recorded.");
                return;
            }
            try {
                org.apache.commons.io.FileUtils.write((File)InspectConstans.HISTORY_DEVICE_RECORD_FILE, (CharSequence)sn.concat(System.lineSeparator()), (Charset)StandardCharsets.UTF_8, (boolean)true);
            }
            catch (IOException e) {
                LOGGER.error("Record the device sn {} failed", (Object)sn, (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isRecordSnToLocal(String sn) {
        Object object = LOCAL_RECORD_SN_LOCK;
        synchronized (object) {
            File file = InspectConstans.HISTORY_DEVICE_RECORD_FILE;
            if (!file.exists() || file.isDirectory()) {
                return false;
            }
            try (Stream<String> stream = Files.lines(file.toPath(), StandardCharsets.UTF_8);){
                boolean bl = stream.anyMatch(line -> Objects.equals(line, sn));
                return bl;
            }
            catch (IOException e) {
                LOGGER.error("check the device {} failed", (Object)sn, (Object)e);
                return false;
            }
        }
    }

    public static boolean isSceneNeedRecord(InspectWorktaker inspectWorktaker) {
        List<InspectScene> inspectScenes = Arrays.asList(InspectScene.REAL_TIME_CHECK, InspectScene.PRE_UPGRADE_CHECK);
        return inspectScenes.contains((Object)inspectWorktaker.getInspectScene()) && InspectUtils.isSupportActiveStopInspect();
    }

    public static boolean isSupportActiveStopInspect() {
        String jsonScene = InspectUtils.getEnv("jsonScene");
        return StringUtils.isNULLStr((String)jsonScene) || !SceneUtils.isSpecialScence((String)jsonScene, (String[])new String[]{"Switch Inspector", "Switch Quality Checks", "FusionStorage Inspect", "FusionStorage Upgrade", "FusionCube Upgrade", "Expansion Evaluation"});
    }

    public static boolean isDistributedAndAllNodeSelect(CheckDevNode node) {
        if (Objects.isNull(node) || Objects.isNull(node.getDevNode())) {
            return false;
        }
        return node.isDistributed() && node.getDevNode().isAllClusterNodeSelect();
    }

    public static void addSHA256SignFile(File parentFile) {
        if (Objects.isNull(parentFile)) {
            log.error("add sign file fail,because the directory is null");
            return;
        }
        String directoryName = parentFile.getName();
        if (!parentFile.exists() || !parentFile.isDirectory()) {
            log.error("add sign file fail for file:{},file is not exist or is not a directory", (Object)directoryName);
            return;
        }
        File signFile = new File(parentFile, "sha256sum.txt");
        if (signFile.exists()) {
            log.error("sha256sum.txt is already exists for directory {}", (Object)directoryName);
            return;
        }
        log.info("start to calculate SHA256 for directory:{}", (Object)directoryName);
        StringJoiner joiner = new StringJoiner(System.lineSeparator());
        String childPath = String.join((CharSequence)File.separator, "pkginfo", "desc");
        InspectUtils.calculateSHA256(new File(parentFile, childPath), childPath).ifPresent(joiner::add);
        InspectUtils.getExcelSignValue(parentFile).ifPresent(joiner::add);
        try (FileWriter writer = new FileWriter(signFile);){
            writer.write(joiner.toString());
            log.info("calculate SHA256 and write success for directory:{}", (Object)directoryName);
        }
        catch (IOException e) {
            log.error("write file sha256sum.txt error", (Throwable)e);
        }
    }

    private static Optional<String> getExcelSignValue(File parentFile) {
        return Arrays.stream(parentFile.listFiles()).filter(file -> file.isFile() && (file.getName().startsWith("StorageConfigResult_") || file.getName().startsWith("InspectorResult_")) && file.getName().endsWith(".xls")).findAny().map(file -> InspectUtils.calculateSHA256(file, file.getName())).orElse(Optional.empty());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Optional<String> calculateSHA256(File targetFile, String prefix) {
        if (!targetFile.exists()) {
            log.error("target file:{} is not exist,can not calculate SHA256", (Object)targetFile.getName());
            return Optional.empty();
        }
        try (FileInputStream inputStream = new FileInputStream(targetFile);){
            Optional<String> optional = Optional.of(prefix + " " + DigestUtils.sha256Hex((InputStream)inputStream));
            return optional;
        }
        catch (IOException e) {
            log.error("calculate sha256 error for file:{}", (Object)targetFile.getName(), (Object)e);
            return Optional.empty();
        }
    }

    public static String dealWriteIpForCancelNode(String insepctReselt, String ip) {
        return "CANCELED".equals(insepctReselt) ? ip + "_CANCELED" : ip;
    }

    public static List<List<String>> getBatchNodes(List<ClusterNode> selectNodes, int storageBatchSize, int otherBatchSize) {
        ArrayList<List<String>> resultList = new ArrayList<List<String>>();
        Map<Boolean, List> collectMap = selectNodes.stream().collect(Collectors.groupingBy(ClusterNode::isStorageNode, Collectors.collectingAndThen(Collectors.toList(), list -> list.stream().map(ClusterNode::getManagementIp).collect(Collectors.toList()))));
        List<String> storageNodes = collectMap.getOrDefault(true, Collections.emptyList());
        List<String> otherNodes = collectMap.getOrDefault(false, Collections.emptyList());
        if (CollectionUtils.isNotEmpty(storageNodes)) {
            resultList.add(Collections.singletonList(storageNodes.get(0)));
        }
        if (CollectionUtils.isNotEmpty(otherNodes)) {
            resultList.add(Collections.singletonList(otherNodes.get(0)));
        }
        resultList.addAll(InspectUtils.batchRemainList(storageNodes, storageBatchSize));
        resultList.addAll(InspectUtils.batchRemainList(otherNodes, otherBatchSize));
        return resultList;
    }

    private static List<List<String>> batchRemainList(List<String> nodeList, int nodeBatchSize) {
        if (nodeList.size() <= 1) {
            return Collections.emptyList();
        }
        return Lists.partition(nodeList.subList(1, nodeList.size()), (int)nodeBatchSize);
    }

    public static List<Integer> getSelectZoneIDs() {
        List checkDevNodes = (List)InspectCard.WORKTAKER.get("check_dev_nodes");
        List<Integer> zoneIdList = checkDevNodes.stream().filter(checkDevNode -> "OceanStor A800".equals(checkDevNode.getDevNode().getProductModel())).map(checkDevNode -> checkDevNode.getDevNode().getUuid()).map(Integer::parseInt).collect(Collectors.toList());
        log.info("List of zone IDs to be executed: {}", zoneIdList);
        return zoneIdList;
    }

    public static String getDevIpAndSnKey(DevNode devNode) {
        return devNode.getIp() + devNode.getDeviceSerialNumber();
    }
}

