/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.utils;

import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.connection.MultiRouteNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.PriKeyInfo;
import com.huawei.ism.tool.obase.entity.Socks5Proxy;
import com.huawei.ism.tool.obase.utils.Base64EncodeUtils;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public class Jump2InfoCollUtils {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(Jump2InfoCollUtils.class);

    public String buildSetEnvString(List<DevNode> devNodes) {
        JSONArray jsonArr = new JSONArray();
        for (DevNode device : devNodes) {
            try {
                JSONObject json = this.getDeviceJsonStr(device, null);
                jsonArr.put((Object)json);
            }
            catch (Exception e) {
                LOGGER.error("Get device json error:" + device.getIp(), (Throwable)e);
            }
        }
        return jsonArr.toString();
    }

    public String buildSetEnvString(Map<DevNode, Map<String, String>> map) {
        JSONArray jsonArr = new JSONArray();
        Set<Map.Entry<DevNode, Map<String, String>>> devs = map.entrySet();
        for (Map.Entry<DevNode, Map<String, String>> device : devs) {
            try {
                JSONObject json = this.getDeviceJsonStr(device.getKey(), device.getValue());
                jsonArr.put((Object)json);
            }
            catch (Exception e) {
                LOGGER.error("Get device json error:" + device.getKey().getIp(), (Throwable)e);
            }
        }
        return jsonArr.toString();
    }

    private JSONObject getDeviceJsonStr(DevNode device, Map<String, String> devInfo) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("devIp", (Object)device.getIp());
        json.put("itDeviceTypeName", (Object)device.getItDeviceType().getName());
        json.put("devType", (Object)device.getDeviceType().toString());
        json.put("devVersion", (Object)device.getProductVersion());
        json.put("devName", (Object)this.encodeByBase64(device.getDeviceName()));
        json.put("username", (Object)this.encodeByBase64(device.getLoginUser().getUserName()));
        String pwd = device.getLoginUser().getPassword();
        json.put("password", (Object)AESEncrypt.encrypt((String)pwd));
        json.put("port", device.getPort());
        json.put("serialNo", (Object)device.getDeviceSerialNumber());
        String debugPwd = device.getDeveloperPwd();
        json.put("developerPwd", (Object)AESEncrypt.encrypt((String)debugPwd));
        if (null != device.getSocks5Proxy()) {
            JSONObject st = this.toSocks5ProxyJson(device.getSocks5Proxy());
            json.put("sock5", (Object)st.toString());
        }
        if (null != device.getSshForwardList()) {
            json.put("sshForward", (Object)this.toListSshForwardJson(device.getSshForwardList()));
        }
        if (null != device.getPriKey()) {
            json.put("priKey", (Object)this.toPriKey(device.getPriKey()));
        }
        JSONArray ipList = new JSONArray();
        for (String ip : device.getIpList()) {
            ipList.put((Object)ip);
        }
        json.put("devInnerIps", (Object)ipList);
        if (null != devInfo) {
            Set<Map.Entry<String, String>> infos = devInfo.entrySet();
            for (Map.Entry<String, String> info : infos) {
                json.put(info.getKey(), (Object)info.getValue());
            }
        }
        return json;
    }

    private String toPriKey(PriKeyInfo priKey) {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("keyname", (Object)this.encodeByBase64(priKey.getKeyName()));
        jsonObj.put("keypath", (Object)this.encodeByBase64(priKey.getKeyPath()));
        String pwd = priKey.getKeyPwd();
        jsonObj.put("keypwd", (Object)AESEncrypt.encrypt((String)pwd));
        return jsonObj.toString();
    }

    private JSONObject toSocks5ProxyJson(Socks5Proxy socks5Proxy) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("uuid", (Object)socks5Proxy.getUuid());
        json.put("name", (Object)this.encodeByBase64(socks5Proxy.getName()));
        json.put("serverIp", (Object)socks5Proxy.getServerIp());
        json.put("port", (Object)socks5Proxy.getPort());
        json.put("user", (Object)this.encodeByBase64(socks5Proxy.getUser()));
        String pass = socks5Proxy.getPass();
        json.put("pass", (Object)AESEncrypt.encrypt((String)pass));
        json.put("authentic", socks5Proxy.isAuthentic());
        return json;
    }

    private String toListSshForwardJson(List<MultiRouteNode> sshForwardList) throws JSONException {
        JSONArray jsonArray = new JSONArray();
        for (MultiRouteNode mu : sshForwardList) {
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("port", mu.getPort());
            jsonObj.put("host", (Object)mu.getHost());
            String pwd = mu.getPwd();
            jsonObj.put("pwd", (Object)AESEncrypt.encrypt((String)pwd));
            pwd = null;
            jsonObj.put("uname", (Object)this.encodeByBase64(mu.getUname()));
            jsonArray.put((Object)jsonObj);
        }
        return jsonArray.toString();
    }

    private String encodeByBase64(String content) {
        return Base64EncodeUtils.encode((String)content);
    }
}

