/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.utils;

import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.inspect.utils.FileAssistant;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.FilesUtil;

public class PackageUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(PackageUtils.class);
    private static final int EXECUTE_COMPRESS_SUCCESS = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String deCompressPackage(String packagePath, String[] pwds) {
        Class<FileAssistant> clazz = FileAssistant.class;
        synchronized (FileAssistant.class) {
            File originalFile = new File(packagePath);
            if (!originalFile.exists()) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return "";
            }
            String dir = originalFile.getName();
            String collectPath = originalFile.getParent() + File.separator + dir.substring(0, dir.lastIndexOf("."));
            File dataCollectFile = new File(collectPath);
            if (!dataCollectFile.exists() && !dataCollectFile.mkdir()) {
                LOGGER.error("Create dir error.file path: " + collectPath);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return "";
            }
            FileAssistant.deCopmressTotalZipFile(collectPath, packagePath, pwds);
            this.deCompressAllFilesRecu(dataCollectFile, pwds);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return collectPath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String compressPackage(String collectPath) {
        Class<FileAssistant> clazz = FileAssistant.class;
        synchronized (FileAssistant.class) {
            File file = new File(collectPath);
            if (!file.exists()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return "";
            }
            String z7ResultFile = collectPath + ".7z";
            FileAssistant.compressFile7z(z7ResultFile, collectPath);
            File z7Result = new File(z7ResultFile);
            if (z7Result.exists()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return z7Result.getName();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return "";
        }
    }

    private void deCompressAllFilesRecu(File dataCollectFile, String[] pwds) {
        File[] files = dataCollectFile.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) continue;
            this.deCompressFile(file.getParent(), file, pwds);
        }
        files = dataCollectFile.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        for (File file : files) {
            if (!file.isDirectory()) continue;
            this.deCompressAllFilesRecu(file, pwds);
        }
    }

    private void deCompressFile(String targetPath, File tarFilePath, String[] pwds) {
        String filePath = FilesUtil.getCanonicalPath((File)tarFilePath);
        if (filePath.endsWith(".tar.bz2")) {
            FileAssistant.deCompressTarbz2File(tarFilePath.getParent(), filePath);
            if (!FileAssistant.delFile(filePath)) {
                LOGGER.error("Delete zip file error.Dir path : " + tarFilePath.getName());
            }
        } else if (filePath.endsWith(".tgz") || filePath.endsWith(".zip") || filePath.endsWith(".rar") || filePath.endsWith(".bz2") || filePath.endsWith(".tar")) {
            this.deCompressFile(tarFilePath, pwds);
        }
    }

    private void deCompressFile(File tarFilePath, String[] pwds) {
        String tmpFileStr;
        String dir = tarFilePath.getName();
        String collectPath = tarFilePath.getParent() + File.separator + dir.substring(0, dir.lastIndexOf("."));
        File tmpFile = null;
        if (FilesUtil.getCanonicalPath((File)tarFilePath).endsWith(".tgz") && !(tmpFile = new File(tmpFileStr = collectPath + "_tmp")).exists() && !tmpFile.mkdir()) {
            LOGGER.error("Create dir error.file path: " + collectPath);
            return;
        }
        File dataCollectFile = new File(collectPath);
        if (!dataCollectFile.exists() && !dataCollectFile.mkdir()) {
            LOGGER.error("Create dir error.file path: " + collectPath);
            return;
        }
        this.deCompressZipFile(tarFilePath, pwds, collectPath, tmpFile);
        boolean del = tarFilePath.delete();
        ToolLoggerFactory.getLogger(this.getClass()).info("delete file error" + del);
    }

    private void deCompressZipFile(File tarFile, String[] pwds, String collectPath, File tmpFile) {
        if (tmpFile != null) {
            this.deCompressAndCopyFile(tarFile, pwds, collectPath, tmpFile);
        } else {
            String tarFilePath = "";
            try {
                tarFilePath = tarFile.getCanonicalPath();
            }
            catch (IOException e) {
                LOGGER.error("get tempFile ptah error.", (Throwable)e);
                return;
            }
            FileAssistant.deCopmressTotalZipFile(collectPath, tarFilePath, pwds);
        }
    }

    private void deCompressAndCopyFile(File tarFile, String[] pwds, String collectPath, File tmpFile) {
        String tempFilePath = "";
        String tarFilePath = "";
        try {
            tempFilePath = tmpFile.getCanonicalPath();
            tarFilePath = tarFile.getCanonicalPath();
            FileAssistant.deCopmressTotalZipFile(tempFilePath, tarFilePath, pwds);
            File[] files = tmpFile.listFiles();
            if (null == files) {
                LOGGER.error("files in " + tempFilePath + " is null");
                return;
            }
            if (0 != files.length) {
                if (files.length == 1) {
                    String fileName = files[0].getName();
                    if (!files[0].isDirectory() && tarFile.getName().contains(fileName.substring(0, fileName.lastIndexOf(".")))) {
                        FileAssistant.deCopmressTotalZipFile(collectPath, files[0].getCanonicalPath(), pwds);
                        boolean del = files[0].delete();
                        ToolLoggerFactory.getLogger(this.getClass()).info("delete file error" + del);
                    } else {
                        FileUtils.copyDir((String)tempFilePath, (String)collectPath);
                        FileUtils.deleteAllInFolder((String)tempFilePath);
                    }
                } else {
                    FileUtils.copyDir((String)tempFilePath, (String)collectPath);
                    FileUtils.deleteAllInFolder((String)tempFilePath);
                }
                boolean del = tmpFile.delete();
                LOGGER.info("delete file result :{}", (Object)del);
            }
        }
        catch (IOException e) {
            LOGGER.error("get tempFile ptah error.", (Throwable)e);
            return;
        }
    }

    private void executeDecompress(String[] pwds, File file) {
        int ret = 0;
        File decompressTmp = new File(file.getParentFile(), file.getName() + "_tmp");
        if (!decompressTmp.mkdir()) {
            LOGGER.info("Create decompressTmp error.");
        }
        String decompressTmpPath = "";
        try {
            decompressTmpPath = decompressTmp.getCanonicalPath();
        }
        catch (Exception e) {
            LOGGER.error("get path error.", (Throwable)e);
            return;
        }
        String filePath = FilesUtil.getCanonicalPath((File)file);
        if (null != pwds && pwds.length > 0) {
            for (String pwd : pwds) {
                ret = FileAssistant.deCopmressZipFileWithPassword(decompressTmpPath, filePath, pwd, "*.bz2");
                LOGGER.info("Decompress {} from zip file {} with 7z result: {}", new Object[]{file, file.getParent(), ret});
                if (1 != ret) continue;
                LOGGER.info("Decompress {} from zip file {} with 7z result: {}", new Object[]{file, file.getParent(), ret});
                break;
            }
            if (1 != ret) {
                ret = FileAssistant.deCopmressZipFileWithPassword(decompressTmpPath, filePath, "", "*.bz2");
            }
        } else {
            ret = FileAssistant.deCopmressZipFileWithPassword(decompressTmpPath, filePath, "", "*.bz2");
        }
        if (1 == ret) {
            FileUtils.copyDir((String)decompressTmpPath, (String)file.getParent());
            FileAssistant.delFile(filePath);
            LOGGER.error("Delete bz2 file error.Dir path : " + filePath);
        }
        FileUtils.deleteAllInFolder((String)decompressTmpPath);
        if (!decompressTmp.delete()) {
            LOGGER.error("Delete file error" + decompressTmp);
        }
    }
}

