/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.utils;

import com.huawei.ism.tool.framework.pubservice.entity.TaskResult;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.logic.config.FusionStorageConfig;
import com.huawei.ism.tool.inspect.logic.fusionstor.inspector.PatchAutoBuilder;
import com.huawei.ism.tool.inspect.logic.fusionstor.inspector.UpdateItemHandle;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.service.patch.dstorage.Context;
import com.huawei.ism.tool.service.patch.dstorage.entity.DstoragePatchInfo;
import com.huawei.ism.tool.service.patch.dstorage.service.PatchImportImp;
import com.huawei.ism.tool.service.patch.dstorage.service.RemovePatchImp;
import com.huawei.ism.tool.service.patch.service.IHandler;
import com.huawei.ism.tool.service.patch.service.IPatchImport;
import com.huawei.ism.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchImport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PatchImport.class);
    private List<CheckDevNode> checkDevNodes;

    public List<TaskResult> autoImport() {
        if (this.checkDevNodes == null || this.checkDevNodes.isEmpty()) {
            log.info("checkDevNodes is null or empty!");
            return Collections.emptyList();
        }
        try {
            List nodeList = this.getDistributedStorageCheckDev().stream().map(CheckDevNode::getDevNode).collect(Collectors.toList());
            Map autoInstallMap = Context.INS.findBestMatchPatch(nodeList, DstoragePatchInfo.Type.INSPECT);
            if (autoInstallMap.isEmpty()) {
                log.info("Auto install map is empty.");
                return Collections.emptyList();
            }
            autoInstallMap.forEach((dev, patch) -> Context.INS.registerPatch(dev, patch));
            return Context.INS.autoImport(this.buildTasks(autoInstallMap));
        }
        catch (Exception e) {
            log.error("Auto import task failed.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private List<IPatchImport<Pair<DevNode, DstoragePatchInfo>, TaskResult>> buildTasks(Map<DevNode, DstoragePatchInfo> autoInstallMap) {
        ArrayList<IPatchImport<Pair<DevNode, DstoragePatchInfo>, TaskResult>> tasks = new ArrayList<IPatchImport<Pair<DevNode, DstoragePatchInfo>, TaskResult>>(autoInstallMap.size());
        autoInstallMap.forEach((dev, patch) -> {
            CheckDevNode checkDev = InspectContext.getInstance().matchCheckDevNode((DevNode)dev);
            if (checkDev != null) {
                patch.setNeedCmsSign(checkDev.isNeedCmsSignPath());
                if (!checkDev.isSupportReentry()) {
                    this.updateHaveInstallPatch(InspectContext.getInstance().matchCheckDevNode((DevNode)dev), (DstoragePatchInfo)patch);
                }
                if (patch.isNeedInstallPatch(dev.getSelectClusterNodeIds(), dev)) {
                    PatchImportImp task = new PatchImportImp(dev, patch, (IHandler)new UpdateItemHandle((DevNode)dev, patch.getType(), true));
                    tasks.add((IPatchImport<Pair<DevNode, DstoragePatchInfo>, TaskResult>)task);
                }
            } else {
                log.error("matchCheckDevNode is null with devNode:{}", (Object)dev.getIp());
            }
        });
        return tasks;
    }

    private void updateHaveInstallPatch(CheckDevNode checkDevNode, DstoragePatchInfo patchInfo) {
        if (checkDevNode == null) {
            log.warn("CheckDevNode is null.");
            return;
        }
        List itemIds = patchInfo.getItemIdList();
        if (itemIds.isEmpty()) {
            log.info("Patch item id config is empty.");
            return;
        }
        HashMap<String, Boolean> itemExistMap = new HashMap<String, Boolean>();
        itemIds.forEach(item -> itemExistMap.put((String)item, Boolean.FALSE));
        Set<String> allSceneItems = FusionStorageConfig.getAllSceneItems(checkDevNode.getDevNode());
        if (!CollectionUtils.isEmpty(allSceneItems)) {
            allSceneItems.forEach(itemId -> itemExistMap.put((String)itemId, itemExistMap.containsKey(itemId)));
        } else {
            checkDevNode.getDstorageSceneCheckItemsList().forEach(sceneDstorageCheckItems -> sceneDstorageCheckItems.getCheckItems().forEach((type, itemList) -> itemList.forEach(item -> this.updateItemExistMap(itemExistMap, (CheckItem)item))));
        }
        this.itemCheck(checkDevNode, patchInfo, itemExistMap);
    }

    private void updateItemExistMap(Map<String, Boolean> itemExistMap, CheckItem item) {
        if (itemExistMap.containsKey(item.getItemId())) {
            itemExistMap.put(item.getItemId(), Boolean.TRUE);
        }
    }

    private void itemCheck(CheckDevNode checkDevNode, DstoragePatchInfo patchInfo, Map<String, Boolean> itemExistMap) {
        boolean existItem = itemExistMap.containsValue(Boolean.TRUE);
        boolean lessItem = itemExistMap.containsValue(Boolean.FALSE);
        if (existItem && !lessItem) {
            if (RemovePatchImp.removePatch((DstoragePatchInfo)patchInfo, (DevNode)checkDevNode.getDevNode(), (IHandler)new UpdateItemHandle(checkDevNode, DstoragePatchInfo.Type.INSPECT, false))) {
                patchInfo.updateDevInstalledStatus(checkDevNode.getDevNode(), DstoragePatchInfo.InstallStatus.NONE);
                log.info("auto remove exist patch success, set status as none");
                return;
            }
            patchInfo.updateDevInstalledStatus(checkDevNode.getDevNode(), DstoragePatchInfo.InstallStatus.INSTALLED);
            log.info("auto remove exist patch fail, set status as installer");
            return;
        }
        if (existItem) {
            Set<String> conflictItemId = itemExistMap.keySet().stream().filter(key -> itemExistMap.getOrDefault(key, Boolean.FALSE)).collect(Collectors.toSet());
            log.info("Conflict Item {} ", conflictItemId);
            if (FusionStorageConfig.isMatchFixVersion(checkDevNode.getDevNode()) && this.tryFixConflictItem(checkDevNode, conflictItemId)) {
                patchInfo.updateDevInstalledStatus(checkDevNode.getDevNode(), DstoragePatchInfo.InstallStatus.NONE);
                return;
            }
            patchInfo.updateDevInstalledStatus(checkDevNode.getDevNode(), DstoragePatchInfo.InstallStatus.PART);
            return;
        }
        patchInfo.updateDevInstalledStatus(checkDevNode.getDevNode(), DstoragePatchInfo.InstallStatus.NONE);
    }

    private boolean tryFixConflictItem(CheckDevNode checkDevNode, Set<String> conflictItemId) {
        log.info("Try to fix item for {} .", (Object)checkDevNode.getDevNode().getIp());
        try {
            DstoragePatchInfo patch = PatchAutoBuilder.autoBuildRemovePatch(checkDevNode.getDevNode(), conflictItemId);
            if (patch == null) {
                return false;
            }
            PatchImportImp removeTask = new PatchImportImp(checkDevNode.getDevNode(), patch, (IHandler)new UpdateItemHandle(checkDevNode, DstoragePatchInfo.Type.INSPECT, true));
            return TaskResult.Result.SUCCESS.equals((Object)removeTask.importPatch().getResult());
        }
        catch (Exception e) {
            log.error("Fix {} failed is error.", (Object)checkDevNode.getDevNode().getIp(), (Object)e);
            return false;
        }
    }

    private List<CheckDevNode> getDistributedStorageCheckDev() {
        return InspectUtils.getDistributedStorageCheckDev(this.checkDevNodes);
    }

    @Generated
    PatchImport(List<CheckDevNode> checkDevNodes) {
        this.checkDevNodes = checkDevNodes;
    }

    @Generated
    public static PatchImportBuilder builder() {
        return new PatchImportBuilder();
    }

    @Generated
    public List<CheckDevNode> getCheckDevNodes() {
        return this.checkDevNodes;
    }

    @Generated
    public void setCheckDevNodes(List<CheckDevNode> checkDevNodes) {
        this.checkDevNodes = checkDevNodes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PatchImport)) {
            return false;
        }
        PatchImport other = (PatchImport)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<CheckDevNode> this$checkDevNodes = this.getCheckDevNodes();
        List<CheckDevNode> other$checkDevNodes = other.getCheckDevNodes();
        return !(this$checkDevNodes == null ? other$checkDevNodes != null : !((Object)this$checkDevNodes).equals(other$checkDevNodes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PatchImport;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<CheckDevNode> $checkDevNodes = this.getCheckDevNodes();
        result = result * 59 + ($checkDevNodes == null ? 43 : ((Object)$checkDevNodes).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PatchImport(checkDevNodes=" + this.getCheckDevNodes() + ")";
    }

    @Generated
    public static class PatchImportBuilder {
        @Generated
        private List<CheckDevNode> checkDevNodes;

        @Generated
        PatchImportBuilder() {
        }

        @Generated
        public PatchImportBuilder checkDevNodes(List<CheckDevNode> checkDevNodes) {
            this.checkDevNodes = checkDevNodes;
            return this;
        }

        @Generated
        public PatchImport build() {
            return new PatchImport(this.checkDevNodes);
        }

        @Generated
        public String toString() {
            return "PatchImport.PatchImportBuilder(checkDevNodes=" + this.checkDevNodes + ")";
        }
    }
}

