/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.utils;

import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.logic.config.IProductParser;
import com.huawei.ism.tool.inspect.logic.config.Product;
import com.huawei.ism.tool.inspect.ui.componet.observer.ProcessStepObserver;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectLock;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.inspect.utils.QueryItemThread;
import com.huawei.ism.tool.inspect.worktaker.InspectWorktaker;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.threadpool.ThreadPoolHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.slf4j.Logger;

public class QueryItemTask {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(QueryItemTask.class);
    private Map<String, List<DevNode>> cseGroups = new ConcurrentHashMap<String, List<DevNode>>();
    private List<DevNode> notConnectDevNodes = Collections.synchronizedList(new ArrayList());
    private List<CheckDevNode> checkDevNodes = Collections.synchronizedList(new ArrayList());
    private ProcessStepObserver progressDialog;
    private InspectWorktaker worktaker;
    private int total = 0;

    public QueryItemTask(InspectWorktaker worktaker, ProcessStepObserver progressDialog) {
        this.worktaker = worktaker;
        this.progressDialog = progressDialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CheckDevNode> executeTasks() throws ToolException {
        ExecutorService queryItemsPool = ThreadPoolHelper.getFixedNumThreadPool((int)20, (String)"queryitems_thread_pool");
        try {
            List devs = (List)this.worktaker.get("select_dev_nodes");
            this.total = devs.size();
            LOGGER.info(String.format(Locale.ROOT, "Total check dev num is %s", devs.size()));
            ArrayList<Future<Boolean>> fus = new ArrayList<Future<Boolean>>();
            for (DevNode devNode : devs) {
                QueryItemThread thread = new QueryItemThread(devNode, this);
                LOGGER.info("----add task to future----");
                fus.add(queryItemsPool.submit(thread));
            }
            for (Future future : fus) {
                try {
                    future.get();
                }
                catch (Exception e) {
                    LOGGER.error("invokeAll InterruptedException error.", (Throwable)e);
                }
            }
        }
        finally {
            queryItemsPool.shutdown();
        }
        this.worktaker.put("exception_dev_nodes", this.notConnectDevNodes);
        if (!this.cseGroups.isEmpty()) {
            this.initCheckDevByXml();
        }
        this.dislodgeDuplicateDevs(this.checkDevNodes);
        return this.checkDevNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCheckDevByXml() throws ToolException {
        ArrayList<String> keys = new ArrayList<String>(this.cseGroups.keySet());
        for (String key : keys) {
            List<DevNode> cseNodes = this.cseGroups.get(key);
            if (cseNodes.isEmpty()) continue;
            DevNode dev = cseNodes.get(0);
            Product product = InspectContext.getInstance().getProductByDevNode(dev);
            IProductParser parser = product.getProductResolver();
            InspectLock mutex = InspectUtils.getDevLock(InspectUtils.getDevIpAndSnKey(dev));
            CheckDevNode checkDev = null;
            InspectLock inspectLock = mutex;
            synchronized (inspectLock) {
                try {
                    checkDev = parser.initCheckDevByXml(product, cseNodes.toArray(new DevNode[cseNodes.size()]));
                }
                catch (ToolException e) {
                    LOGGER.error("init CheckDev ByXml error.", (Throwable)e);
                }
                catch (RuntimeException e) {
                    LOGGER.error("init CheckDev ByXml error.", (Throwable)e);
                }
            }
            if (null == checkDev) continue;
            this.checkDevNodes.add(checkDev);
        }
    }

    private void dislodgeDuplicateDevs(List<CheckDevNode> checkDevs) {
        ArrayList<CheckDevNode> integrationDevs = new ArrayList<CheckDevNode>();
        for (CheckDevNode checkDev : checkDevs) {
            if (null == checkDev || !checkDev.isIntegration()) continue;
            integrationDevs.add(checkDev);
        }
        checkDevs.removeAll(integrationDevs);
        List<DevNode> integratedDevNodes = this.getAllChildNodes(integrationDevs);
        List<DevNode> otherDevNodes = this.getAllChildNodes(checkDevs);
        ArrayList<DevNode> deleted = new ArrayList<DevNode>();
        for (DevNode dev : integratedDevNodes) {
            for (DevNode other : otherDevNodes) {
                if (!dev.equals((Object)other)) continue;
                deleted.add(other);
            }
        }
        for (DevNode delete : deleted) {
            Iterator<CheckDevNode> iter = checkDevs.iterator();
            while (iter.hasNext()) {
                DevNode node = iter.next().getDevNode();
                if (!delete.equals((Object)node)) continue;
                iter.remove();
            }
        }
        checkDevs.addAll(integrationDevs);
    }

    private List<DevNode> getAllChildNodes(List<CheckDevNode> checkDevs) {
        ArrayList<DevNode> nodes = new ArrayList<DevNode>();
        for (CheckDevNode checkDev : checkDevs) {
            if (null == checkDev) {
                LOGGER.error("check dev is null.");
                continue;
            }
            List<CheckDevNode> devs = checkDev.getAllCheckNode();
            for (CheckDevNode dev : devs) {
                nodes.add(dev.getDevNode());
            }
        }
        return nodes;
    }

    public void updatePro() {
        if (null != this.progressDialog) {
            this.progressDialog.stepOne();
        }
    }

    public List<DevNode> getNotConnectDevNodes() {
        return this.notConnectDevNodes;
    }

    public Map<String, List<DevNode>> getCseGroups() {
        return this.cseGroups;
    }

    public List<CheckDevNode> getCheckDevNodes() {
        return this.checkDevNodes;
    }
}

