/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.huawei.ism.tool.bizpack.wizardparse.factory.ConnectorFactory;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.fusioncube.service.MetaVisionInspectService;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.ConstantField;
import com.huawei.ism.tool.inspect.entity.DevInfo4Exp;
import com.huawei.ism.tool.inspect.entity.Disk;
import com.huawei.ism.tool.inspect.entity.DiskEnclosure;
import com.huawei.ism.tool.inspect.entity.EngineDiskInfo;
import com.huawei.ism.tool.inspect.entity.SCMDisk;
import com.huawei.ism.tool.inspect.entity.SmartPoolShowDisk;
import com.huawei.ism.tool.inspect.logic.config.ArrayProductParser;
import com.huawei.ism.tool.inspect.logic.config.IProductParser;
import com.huawei.ism.tool.inspect.logic.config.Product;
import com.huawei.ism.tool.inspect.logic.inspector.SshManager;
import com.huawei.ism.tool.inspect.logic.inspector.checkmodel.InnerISshJudge;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectLock;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.inspect.utils.QueryItemTask;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.ISshJudge;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.python.core.PyDictionary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.Products;

public class QueryItemThread
implements Callable<Boolean> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueryItemThread.class);
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(QueryItemThread.class);
    private static final Pattern ERROR_CODE_PATTERN = Pattern.compile("Exception:\\s*\\(u'([0-9]+)',.*");
    private DevNode dev;
    private QueryItemTask queryItemTask;
    private DevInfo4Exp devInfo = new DevInfo4Exp();
    private Map<String, Object> params = new HashMap<String, Object>();
    private JythonExecuter executer;
    private static final String DORADO_TYPE = "Dorado";

    public QueryItemThread(DevNode dev, QueryItemTask queryItemTask) {
        this.dev = dev;
        this.queryItemTask = queryItemTask;
    }

    @Override
    public Boolean call() {
        Thread.currentThread().setName("QueryItemTask dev = " + this.dev.getIp());
        LOGGER.info("----start QueryItemThread----");
        if (InspectUtils.isPreExpEvaluation().booleanValue() && !ItDeviceType.Host.equals((Object)this.dev.getItDeviceType())) {
            this.devInfo.setErrMsg(null);
            this.initDevInfo();
            InspectContext.getInstance().setDevInfo(this.devInfo);
        }
        Product product = null;
        try {
            product = InspectContext.getInstance().getProductByDevNode(this.dev);
        }
        catch (Exception e) {
            this.queryItemTask.getNotConnectDevNodes().add(this.dev);
            LOGGER.error("getproduct failed.", (Throwable)e);
            return false;
        }
        IProductParser parser = product.getProductResolver();
        List<DevNode> notConnectDevNodes = this.queryItemTask.getNotConnectDevNodes();
        this.initCheckDevInfo(parser, notConnectDevNodes, product);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCheckDevInfo(IProductParser parser, List<DevNode> notConnectDevNodes, Product product) {
        CheckDevNode checkDev = null;
        try {
            if (this.dev.isA3000() || this.dev.is2910V7()) {
                checkDev = new CheckDevNode();
                checkDev.setProduct(product);
                checkDev.setNodeName(this.dev.getDeviceName());
                checkDev.setDevNode(this.dev);
                checkDev.setViewAble(true);
            } else {
                InspectLock mutex;
                InspectLock inspectLock = mutex = InspectUtils.getDevLock(InspectUtils.getDevIpAndSnKey(this.dev));
                synchronized (inspectLock) {
                    checkDev = parser.initCheckDevByXml(product, this.dev);
                }
            }
            checkDev.setDevInfo4Exp(this.devInfo);
        }
        catch (ToolException e) {
            notConnectDevNodes.add(this.dev);
            ToolLoggerFactory.getLogger(this.getClass()).error("initCheckDevByXml error.", (Throwable)e);
        }
        catch (Exception e) {
            notConnectDevNodes.add(this.dev);
            ToolLoggerFactory.getLogger(this.getClass()).error("initCheckDevByXml error.", (Throwable)e);
        }
        finally {
            if (this.dev.isA3000() || this.dev.is2910V7() || product.getProductResolver().getClass().getSuperclass().equals(ArrayProductParser.class)) {
                this.queryItemTask.updatePro();
            }
        }
        if (null != checkDev) {
            if (this.dev.isA3000() || this.dev.is2910V7()) {
                this.addMetaVisionNode(product, checkDev);
                log.info("initCheckDevInfo add nodes by MetaVision.");
                return;
            }
            StringBuffer packagePath = new StringBuffer(InspectContext.INSPECT_CONFPATH);
            packagePath.append(File.separator);
            packagePath.append("products");
            packagePath.append(File.separator);
            packagePath.append("DStorage_");
            packagePath.append(this.dev.getDeviceSerialNumber());
            File targetProductConfigDir = new File(packagePath.toString());
            InspectContext.getInstance().parsePackageIni(checkDev, targetProductConfigDir);
            this.queryItemTask.getCheckDevNodes().add(checkDev);
            this.addFusionCubeMetaVisionNode(product, checkDev);
        }
    }

    private void addFusionCubeMetaVisionNode(Product product, CheckDevNode checkDev) {
        if (!MetaVisionInspectService.isSupportsMetaVisionNodeInspection(this.dev) || InspectContext.getInstance().isBureauCheckSelected()) {
            log.info("Device {} does not support MetaVision node inspection.", (Object)this.dev.getIp());
            return;
        }
        try {
            MetaVisionInspectService.createFusionCubeMetaVisionCheckDevNode(checkDev, product, this.dev).ifPresent(devNode -> this.queryItemTask.getCheckDevNodes().add((CheckDevNode)devNode));
        }
        catch (ToolException e) {
            log.error("create fusion cube node error, IP : {}", (Object)this.dev.getIp());
        }
        catch (CloneNotSupportedException e) {
            log.error("clone product info error, IP : {}", (Object)this.dev.getIp());
        }
    }

    private void addMetaVisionNode(Product product, CheckDevNode checkDevNode) {
        try {
            MetaVisionInspectService.createFusionCubeMetaVisionCheckDevNode(checkDevNode, product, this.dev).ifPresent(devNode -> this.queryItemTask.getCheckDevNodes().add((CheckDevNode)devNode));
        }
        catch (ToolException e) {
            log.error("create a3000 node error, IP : {}", (Object)this.dev.getIp(), (Object)e);
        }
        catch (CloneNotSupportedException e) {
            log.error("clone product info error, IP : {}", (Object)this.dev.getIp(), (Object)e);
        }
    }

    private boolean initParams() {
        ICliConnection cliConnection;
        this.params.put("logger", LOGGER);
        this.params.put("lang", ApplicationContext.getInstance().getCurrentLanguage());
        InnerISshJudge ender = new InnerISshJudge();
        try {
            cliConnection = SshConnectionManager.getSshConnection((DevNode)this.dev, (ISshJudge)ender, (boolean)true, (boolean)false);
        }
        catch (ToolException e) {
            LOGGER.error("get ssh connection error!", (Throwable)e);
            this.devInfo.setErrMsg(ResourceUtil.getStringWithParams((String)"pre.expansion.cannotconnect2device", (Object[])new Object[]{this.dev.getIp()}));
            return false;
        }
        this.params.put("ssh", cliConnection);
        this.params.put("devType", this.dev.getDeviceType().toString());
        this.params.put("productVersion", this.dev.getProductVersion());
        this.params.put("devInfo", this.dev);
        this.params.put("sshManager", SshManager.INS);
        ArrayList<File> fl = new ArrayList<File>();
        String inspectConfPath = InspectContext.INSPECT_CONFPATH;
        String expInfoPath = inspectConfPath + File.separator + "products" + File.separator + "expinfo";
        String pyframe = inspectConfPath + File.separator + "products" + File.separator + "pyframe";
        String jythonFile = expInfoPath + File.separator + "script";
        String scriptFilePath = jythonFile + File.separator + "getExpInfo.py";
        String packagePath = inspectConfPath + File.separator + "products" + File.separator + "V3V300R003C00";
        fl.add(new File(pyframe));
        fl.add(new File(jythonFile));
        fl.add(new File(packagePath));
        this.executer = new JythonExecuter(fl);
        try {
            this.executer.compileScript(new File(scriptFilePath));
        }
        catch (SignException e) {
            LOGGER.error("verify Script error!", (Throwable)e);
            this.devInfo.setErrMsg(ResourceUtil.getString((String)"inspsctor.wizard.exp.qry.dev.and.loadconfigerror"));
            return false;
        }
        catch (FileNotFoundException e) {
            LOGGER.error("py file not found!scriptFilePath:{}", (Object)new File(scriptFilePath).getName());
            this.devInfo.setErrMsg(ResourceUtil.getString((String)"inspsctor.wizard.exp.qry.dev.and.loadconfigerror"));
            return false;
        }
        return true;
    }

    private void setWhiteItemList() {
        String expInfoPath = InspectContext.INSPECT_CONFPATH + File.separator + "products" + File.separator + "expinfo";
        String whiteCheckItemPath = expInfoPath + File.separator + "whitechecklist.xml";
        ArrayList<String> whiteItemList = ArrayProductParser.getWhiteItems(whiteCheckItemPath);
        this.devInfo.setWhiteItemList(whiteItemList);
        LOGGER.info("whitle list = {}", whiteItemList);
    }

    private boolean initCtrlNum() throws ToolException {
        List ret = this.executer.invokeFunction("getDevCtrlsNum", this.params);
        LOGGER.info("getDevCtrlsNum Ret={}", (Object)ret);
        String flag = ret.get(0).toString();
        if ("false".equals(flag.toLowerCase(Locale.US))) {
            this.devInfo.setErrMsg(ret.get(2).toString());
            this.devInfo.setSuccess(false);
            return false;
        }
        String rs = ret.get(1).toString();
        int i = rs.length();
        while (--i >= 0) {
            if (Character.isDigit(rs.charAt(i))) continue;
            this.devInfo.setSuccess(false);
            return false;
        }
        this.devInfo.setDevCtrlsNum(Integer.parseInt(rs));
        return true;
    }

    private boolean initDDCtrsInfo() throws ToolException {
        String deviceType = this.devInfo.getDevType();
        if (!ConstantField.MOVECARD_TYPE.contains(deviceType.toUpperCase(Locale.ENGLISH))) {
            return true;
        }
        String version = this.devInfo.getProductVersion();
        if (!version.contains(".") && this.getVrc(version).compareTo("V300R002C10") < 0) {
            return true;
        }
        HashMap<String, List<String>> ctrsDD = new HashMap<String, List<String>>();
        List ret = this.executer.invokeFunction("getDDInfo", this.params);
        LOGGER.info("DDCtrsInfo Ret={}", (Object)ret);
        String flag = ret.get(0).toString();
        if ("false".equals(flag.toLowerCase(Locale.US))) {
            this.devInfo.setErrMsg(ret.get(2).toString());
            this.devInfo.setSuccess(false);
            return false;
        }
        if (ret.get(1) instanceof PyDictionary) {
            PyDictionary pyDict = (PyDictionary)ret.get(1);
            for (Object key : pyDict.keySet()) {
                List value = (List)pyDict.get(key);
                ctrsDD.put(key.toString(), value);
            }
        }
        this.devInfo.setCtrlsDD(ctrsDD);
        return true;
    }

    private boolean initExpSpec() throws ToolException {
        this.params.putAll(this.getDevMap(this.dev));
        String sceneType = InspectContext.getArgsParamFormSceneConfig("sceneType");
        if ("expDisk".equalsIgnoreCase(sceneType) || "expLink".equalsIgnoreCase(sceneType) || "expDD".equalsIgnoreCase(sceneType)) {
            return true;
        }
        if (Products.isOceanStoComputingDev((String)this.dev.getDeviceType().toString())) {
            return true;
        }
        List ret = this.executer.invokeFunction("getExpSpec", this.params);
        LOGGER.info("getExpSpec Ret={}", (Object)ret);
        String flag = ret.get(0).toString();
        if ("false".equals(flag.toLowerCase(Locale.ENGLISH))) {
            this.devInfo.setErrMsg(ret.get(2).toString());
            this.devInfo.setSuccess(false);
            return true;
        }
        String rs = ret.get(1).toString();
        if (!"".equals(rs)) {
            ArrayList<String> expSpec = new ArrayList<String>(Arrays.asList(rs.split(",")));
            this.devInfo.setExpSpec(expSpec);
        } else {
            this.devInfo.setErrMsg(ret.get(2).toString());
        }
        return true;
    }

    private boolean initSASCard() throws ToolException {
        List ret = this.executer.invokeFunction("hasSASbigCard", this.params);
        LOGGER.info("hasSASbigCard Ret={}", (Object)ret);
        String flag = ret.get(0).toString();
        if ("false".equals(flag.toLowerCase(Locale.ENGLISH))) {
            this.devInfo.setErrMsg(ret.get(2).toString());
            this.devInfo.setSuccess(false);
            return false;
        }
        String rs = ret.get(1).toString();
        if ("true".equals(rs.toLowerCase(Locale.ENGLISH))) {
            this.devInfo.setHasSASbigCard(true);
        }
        return true;
    }

    private boolean isNVMe() {
        String flag = "";
        List ret = null;
        try {
            ret = this.executer.invokeFunction("isNVMeEnclosure", this.params);
            LOGGER.info("getControllerEnclosure Ret={}", (Object)ret);
        }
        catch (ToolException e) {
            LOGGER.error("get enclouse type failed.");
            this.devInfo.setErrMsg(ResourceUtil.getString((String)"inspsctor.wizard.exp.qry.dev.and.loadenclosure"));
        }
        if (ret != null && ret.get(0) != null) {
            flag = ret.get(0).toString();
        }
        if ("false".equals(flag.toLowerCase(Locale.ENGLISH))) {
            this.devInfo.setErrMsg(ret.get(2).toString());
            this.devInfo.setSuccess(false);
            return false;
        }
        String rs = "";
        if (ret != null && ret.get(1) != null) {
            rs = ret.get(1).toString();
        }
        if ("true".equals(rs.toLowerCase(Locale.ENGLISH))) {
            this.devInfo.setNVMe(true);
        }
        return true;
    }

    private boolean initInternalProductModel() {
        String devType = (String)this.params.get("devType");
        String productVersion = (String)this.params.get("productVersion");
        if (!ConstantField.DORADO_DEV.contains(devType.toUpperCase(Locale.ENGLISH))) {
            return true;
        }
        if (!productVersion.contains(".") && this.getVrc(productVersion).compareTo("V300R001C21") < 0) {
            return true;
        }
        List ret = null;
        try {
            ret = this.executer.invokeFunction("getInternalProductModel", this.params);
            LOGGER.info("getInternalProductModel Ret={}", (Object)ret);
        }
        catch (ToolException e) {
            LOGGER.error("get internal product model failed.");
            String errorCode = this.getErrorCode(e.getMessage());
            if (Objects.equals(errorCode, "1073793463")) {
                this.devInfo.setErrMsg(ResourceUtil.getString((String)"inspsctor.wizard.exp.qry.dev.and.loadinternalmodel.insufficient.permissions"));
                return false;
            }
            this.devInfo.setErrMsg(ResourceUtil.getString((String)"inspsctor.wizard.exp.qry.dev.and.loadinternalmodel"));
            return false;
        }
        String flag = ret.get(0).toString();
        if ("false".equals(flag.toLowerCase(Locale.ENGLISH))) {
            this.devInfo.setErrMsg(ret.get(2).toString());
            this.devInfo.setSuccess(false);
            return false;
        }
        String rs = ret.get(1).toString();
        if (rs.endsWith("_F")) {
            rs = rs.replace("_F", "");
        }
        this.devInfo.setInternalModel(rs);
        this.devInfo.setProductVersion((String)this.params.get("productVersion"));
        return true;
    }

    private String getErrorCode(String str) {
        Matcher matcher = ERROR_CODE_PATTERN.matcher(str);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    private Map<String, Object> getDevMap(DevNode devNode) {
        HashMap<String, String> deviceiInfo = new HashMap<String, String>();
        deviceiInfo.put("user", devNode.getLoginUser().getUserName());
        deviceiInfo.put("pawd", devNode.getLoginUser().getPassword());
        deviceiInfo.put("ip", devNode.getIp());
        deviceiInfo.put("sn", devNode.getDeviceSerialNumber());
        HashMap<String, Object> devObj = new HashMap<String, Object>();
        devObj.put("newDev", deviceiInfo);
        devObj.put("lang", this.params.get("lang"));
        devObj.put("connectorFactory", ConnectorFactory.getInstance());
        devObj.put("productVersion", this.params.get("productVersion"));
        return devObj;
    }

    private boolean initDomainIds() throws ToolException {
        if (InspectUtils.isMicroPassThrouthMode(this.devInfo).booleanValue()) {
            return true;
        }
        List ret = this.executer.invokeFunction("getDevDomains", this.params);
        LOGGER.info("getDevDomains Ret={}", (Object)ret);
        String flag = ret.get(0).toString();
        if ("false".equals(flag.toLowerCase(Locale.ENGLISH))) {
            this.devInfo.setErrMsg(ret.get(2).toString());
            this.devInfo.setSuccess(false);
            return false;
        }
        String rs = ret.get(1).toString();
        if (!"".equals(rs)) {
            ArrayList<String> devDomains = new ArrayList<String>(Arrays.asList(rs.split(",")));
            this.devInfo.setDevDomains(devDomains);
        }
        return true;
    }

    private boolean initPoolsAndMapping() throws ToolException {
        if (InspectUtils.isMicroPassThrouthMode(this.devInfo).booleanValue()) {
            return true;
        }
        this.params.put("is_new_oceanstor", InspectUtils.isNewOceanStor(this.devInfo));
        List ret = this.executer.invokeFunction("get_pools_and_mapping", this.params);
        LOGGER.info("getPoolsAndMapping Ret={}", (Object)ret);
        String flag = ret.get(0).toString();
        if ("false".equals(flag.toLowerCase(Locale.ENGLISH))) {
            this.devInfo.setErrMsg(ret.get(3).toString());
            this.devInfo.setSuccess(false);
            return false;
        }
        String poolIdListStr = ret.get(1).toString().replaceAll("u'", "'");
        List poolIdList = JSON.parseArray((String)poolIdListStr, String.class);
        ArrayList<String> poolIdArrayList = new ArrayList<String>(poolIdList);
        this.devInfo.setDevPools(poolIdArrayList);
        String poolAndDiskDomainMappingStr = ret.get(2).toString().replaceAll("u'", "'");
        TypeReference<HashMap<String, String>> type = new TypeReference<HashMap<String, String>>(){};
        HashMap poolAndDiskDomainMapping = (HashMap)JSONObject.parseObject((String)poolAndDiskDomainMappingStr, (TypeReference)type, (Feature[])new Feature[0]);
        this.devInfo.setDevPoolAndDiskDomainMapping(poolAndDiskDomainMapping);
        String smartPool2IsUniquePerformanceStr = ret.get(4).toString().replaceAll("u'", "'");
        TypeReference<HashMap<String, String>> tr = new TypeReference<HashMap<String, String>>(){};
        Map smartPool2IsUniquePerformance = (Map)JSONObject.parseObject((String)smartPool2IsUniquePerformanceStr, (TypeReference)tr, (Feature[])new Feature[0]);
        this.devInfo.setSmartPool2IsUniquePerformance(smartPool2IsUniquePerformance);
        return true;
    }

    private boolean initEngineDiskInfo() throws ToolException {
        for (String pool : this.devInfo.getDevPools()) {
            String diskDomainId = this.devInfo.getDevPoolAndDiskDomainMapping().get(pool);
            this.params.put("poolId", pool);
            this.params.put("diskDomainId", diskDomainId);
            List ret = this.executer.invokeFunction("get_all_engine_disk_info", this.params);
            LOGGER.info("initEngineDiskInfo Ret={}", (Object)ret);
            Boolean flag = (Boolean)ret.get(0);
            if (!flag.booleanValue()) {
                return false;
            }
            String memberListStr = ret.get(2).toString();
            List memberList = JSONObject.parseArray((String)memberListStr, EngineDiskInfo.class);
            this.devInfo.getDevEngineDiskInfo().addAll(memberList);
        }
        return true;
    }

    private boolean initEngs() throws ToolException {
        List ret = this.executer.invokeFunction("getEngs", this.params);
        LOGGER.info("getEngs Ret={}", (Object)ret);
        String flag = ret.get(0).toString();
        if ("false".equals(flag.toLowerCase(Locale.ENGLISH))) {
            this.devInfo.setErrMsg(ret.get(2).toString());
            this.devInfo.setSuccess(false);
            return false;
        }
        String rs = ret.get(1).toString();
        if ("".equals(rs)) {
            this.devInfo.setSuccess(false);
            return false;
        }
        ArrayList<String> engList = new ArrayList<String>(Arrays.asList(rs.split(",")));
        this.devInfo.setEngs(engList);
        return true;
    }

    private boolean initEngHeight() throws ToolException {
        List ret = this.executer.invokeFunction("getEngHeight", this.params);
        LOGGER.info("getEngHeight Ret={}", (Object)ret);
        String flag = ret.get(0).toString();
        if ("false".equals(flag.toLowerCase(Locale.ENGLISH))) {
            this.devInfo.setErrMsg(ret.get(2).toString());
            this.devInfo.setSuccess(false);
            return false;
        }
        String rs = ret.get(1).toString();
        if ("".equals(rs) || !org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)rs)) {
            this.devInfo.setSuccess(false);
            return false;
        }
        int devHeight = Integer.parseInt(rs);
        this.devInfo.setDevHeight(devHeight);
        return true;
    }

    private boolean initCreateDiskFlag() throws ToolException {
        List ret = this.executer.invokeFunction("isExistedCreateDomain", this.params);
        LOGGER.info("isExistedCreateDomain Ret={}", (Object)ret);
        String flag = ret.get(0).toString();
        this.devInfo.setCreateDomain(Boolean.parseBoolean(flag));
        return true;
    }

    boolean initAaWorkModeCheck() {
        String productVersion = (String)this.params.get("productVersion");
        if (productVersion.contains(".") || productVersion.startsWith("V700")) {
            this.devInfo.setAaWorkModeOn(true);
            return true;
        }
        if (this.getVrc(productVersion).compareTo("V500R007C50") < 0) {
            return true;
        }
        List ret = null;
        try {
            ret = this.executer.invokeFunction("checkAaWorkMode", this.params);
            LOGGER.info("checkAaWorkMode Ret={}", (Object)ret);
        }
        catch (ToolException e) {
            LOGGER.error("check A/A work mode exception.");
            this.devInfo.setErrMsg(ResourceUtil.getString((String)"inspsctor.wizard.exp.qry.dev.and.loadaaworkmode"));
            return false;
        }
        String excuteFlag = ret.get(0).toString();
        if ("false".equals(excuteFlag.toLowerCase(Locale.ENGLISH))) {
            LOGGER.error("check A/A work mode failed.");
            this.devInfo.setErrMsg(ResourceUtil.getString((String)"inspsctor.wizard.exp.qry.dev.and.loadaaworkmode"));
            return false;
        }
        String flag = ret.get(1).toString();
        if ("true".equals(flag.toLowerCase(Locale.ENGLISH))) {
            this.devInfo.setAaWorkModeOn(true);
        }
        return true;
    }

    private boolean initExpModeInfo() throws ToolException {
        List ret = this.executer.invokeFunction("getExpModeInfo", this.params);
        LOGGER.info("getExpModeInfo Ret={}", (Object)ret);
        String flag = ret.get(0).toString();
        if ("false".equals(flag.toLowerCase(Locale.ENGLISH))) {
            this.devInfo.setErrMsg(ret.get(3).toString());
            this.devInfo.setSuccess(false);
            return false;
        }
        if (!"".equalsIgnoreCase(ret.get(1).toString())) {
            this.devInfo.setExpModeInfoList(ret.get(1).toString().split(","));
        }
        if (!"".equalsIgnoreCase(ret.get(2).toString())) {
            this.devInfo.setDdInfoList(ret.get(2).toString().split(","));
        }
        return true;
    }

    private boolean initDisksOfNVMe() throws ToolException {
        List ret = this.executer.invokeFunction("getDisksOfNVMe", this.params);
        LOGGER.info("getDisksOfNVMe Ret={}", (Object)ret);
        String flag = ret.get(0).toString();
        if ("false".equals(flag.toLowerCase(Locale.ENGLISH))) {
            this.devInfo.setErrMsg(ret.get(2).toString());
            this.devInfo.setSuccess(false);
            return false;
        }
        if (!"".equalsIgnoreCase(ret.get(1).toString())) {
            this.devInfo.setDisk4NVMe(ret.get(1).toString().split(","));
        }
        return true;
    }

    private boolean queryInnerMetroLicense() {
        String devType = (String)this.params.get("devType");
        if (!ConstantField.DORADO_V6_HIGH.contains(devType.toUpperCase(Locale.ENGLISH))) {
            return true;
        }
        List ret = null;
        try {
            ret = this.executer.invokeFunction("hasInnerMetroLicense", this.params);
            LOGGER.info("hasInnerMetroLicense Ret={}", (Object)ret);
        }
        catch (ToolException e) {
            LOGGER.error("get inner hypermetro license failed.");
            this.devInfo.setErrMsg(ResourceUtil.getString((String)"inspsctor.wizard.exp.qry.dev.and.loadlicense"));
            return false;
        }
        String flag = ret.get(0).toString();
        if ("false".equals(flag.toLowerCase(Locale.ENGLISH))) {
            this.devInfo.setErrMsg(ret.get(2).toString());
            return false;
        }
        String rs = ret.get(1).toString();
        this.devInfo.setHasInnerMetroLicense("true".equals(rs.toLowerCase(Locale.ENGLISH)));
        return true;
    }

    private void closeCliConnection() {
        ICliConnection cliConnection = (ICliConnection)this.params.get("ssh");
        if (null != cliConnection) {
            cliConnection.close();
        }
    }

    private boolean initDevInfo() {
        this.devInfo.setSuccess(true);
        this.devInfo.setDevType(this.dev.getDeviceType().toString());
        this.devInfo.setProductVersion(this.dev.getProductVersion());
        this.devInfo.setDevNode(this.dev);
        if (!this.initParams()) {
            this.devInfo.setSuccess(false);
            return false;
        }
        try {
            this.setWhiteItemList();
            if (!this.initCommonInfo()) {
                LOGGER.error("Init common info failed.");
                boolean bl = false;
                return bl;
            }
            if (InspectUtils.isMicro(this.devInfo).booleanValue() && !this.initSmartPool()) {
                LOGGER.error("Init smart pool failed.");
                boolean bl = false;
                return bl;
            }
            if (!this.initDoradoV6Info()) {
                LOGGER.error("Init Dorado V6 info failed.");
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (ToolException e) {
            LOGGER.error("Init some config exception.");
            this.devInfo.setErrMsg(ResourceUtil.getString((String)"inspsctor.wizard.exp.qry.dev.and.loadconfigerror"));
            LOGGER.error("init devInfo error!", (Throwable)e);
            this.devInfo.setSuccess(false);
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeCliConnection();
        }
    }

    private boolean initDomainRedundancyStrategy() throws ToolException {
        ArrayList<String> diskDomainList = this.devInfo.getDevDomains();
        this.params.put("devDomains", diskDomainList);
        List ret = this.executer.invokeFunction("getRedundancyStrategy", this.params);
        LOGGER.info("getDomainRedundancyStrategy Ret={}", (Object)ret);
        String msg = ret.get(1).toString();
        if (!StringUtils.isNULLStr((String)msg)) {
            this.devInfo.setErrMsg(ret.get(1).toString());
            this.devInfo.setSuccess(false);
            return false;
        }
        TypeReference<HashMap<String, String>> type = new TypeReference<HashMap<String, String>>(){};
        HashMap domainRedundancyStrategyMapping = (HashMap)JSONObject.parseObject((String)ret.get(0).toString(), (TypeReference)type, (Feature[])new Feature[0]);
        this.devInfo.setDomainRedundancyStrategy(domainRedundancyStrategyMapping);
        this.devInfo.setEncryptionDiskDomainList(ret.get(2).toString().split(","));
        return true;
    }

    private boolean initFreeDiskEnclosureId() throws ToolException {
        List ret = this.executer.invokeFunction("getFreeDiskEnclosureID", this.params);
        LOGGER.info("getDiskEnclosureID Ret={}", (Object)ret);
        String flag = ret.get(0).toString();
        if ("false".equals(flag.toLowerCase(Locale.ENGLISH))) {
            this.devInfo.setErrMsg(ret.get(2).toString());
            this.devInfo.setSuccess(false);
            return false;
        }
        String freerListStr = ret.get(1).toString();
        List freeList = JSONObject.parseArray((String)freerListStr, EngineDiskInfo.class);
        String sceneType = InspectContext.getArgsParamFormSceneConfig("sceneType");
        if ("expDD".equalsIgnoreCase(sceneType) && null == freeList) {
            this.devInfo.setErrMsg(ResourceUtil.getString((String)"inspsctor.wizard.exp.qry.dev.and.loadfreediskerr"));
            this.devInfo.setSuccess(false);
            return false;
        }
        this.devInfo.getFreeDevEngineDiskInfo().clear();
        HashMap<String, ArrayList<String>> diskEnclosureIdMap = new HashMap<String, ArrayList<String>>();
        if (null != freeList) {
            this.devInfo.getFreeDevEngineDiskInfo().addAll(freeList);
            for (EngineDiskInfo engDiskInfo : freeList) {
                diskEnclosureIdMap = this.dealEngDiskEnclosureInfo(diskEnclosureIdMap, engDiskInfo);
            }
        }
        this.devInfo.setDiskEnclosureIdMap(diskEnclosureIdMap);
        return true;
    }

    private boolean initSmartCachePool() throws ToolException {
        List ret = this.executer.invokeFunction("get_smart_cache_pool_for_nas", this.params);
        LOGGER.info("getSmartCachePool Ret={}", (Object)ret);
        String flag = ret.get(0).toString();
        if ("false".equals(flag.toLowerCase(Locale.ENGLISH))) {
            this.devInfo.setErrMsg(ret.get(2).toString());
            this.devInfo.setSuccess(false);
            return false;
        }
        String smartCachePoolId = ret.get(1).toString();
        this.devInfo.getSmartCachePoolInfoForNas().setPoolId(smartCachePoolId);
        this.params.put("SmartCachePoolID", smartCachePoolId);
        return true;
    }

    private boolean initSmartPool() throws ToolException {
        if (!InspectUtils.isNewOceanStor(this.devInfo).booleanValue() && !InspectUtils.isMicro(this.devInfo).booleanValue()) {
            LOGGER.info("get_smart_pool not new oceanStor, no need get smart pool info.");
            return true;
        }
        if (!this.getSmartPoolDiskInfo()) {
            this.devInfo.setSuccess(false);
            return false;
        }
        this.params.putIfAbsent("is_new_oceanstor", InspectUtils.isNewOceanStor(this.devInfo));
        List ret = this.executer.invokeFunction("get_smart_pool", this.params);
        LOGGER.info("get_smart_pool Ret={}", (Object)ret);
        String flag = ret.get(0).toString();
        if ("false".equals(flag.toLowerCase(Locale.ENGLISH))) {
            this.devInfo.setErrMsg(ret.get(2).toString());
            this.devInfo.setSuccess(false);
            return false;
        }
        String performanceIdListStr = ret.get(1).toString().replaceAll("u'", "'");
        List performanceIds = JSON.parseArray((String)performanceIdListStr, String.class);
        this.devInfo.getSmartPool().addAll(performanceIds);
        this.params.put("smartPoolId", performanceIdListStr);
        String isEncryption = ret.get(2).toString().replaceAll("u'", "'");
        TypeReference<HashMap<String, String>> type = new TypeReference<HashMap<String, String>>(){};
        HashMap performance2DiskEncryptionSwitch = (HashMap)JSONObject.parseObject((String)isEncryption, (TypeReference)type, (Feature[])new Feature[0]);
        this.devInfo.setPerformance2DiskEncryptionSwitch(performance2DiskEncryptionSwitch);
        List redundantRet = this.executer.invokeFunction("get_performance_layer_redundant_strategy", this.params);
        LOGGER.info("get_performance_layer_redundant_strategy Ret={}", (Object)redundantRet);
        HashMap performanceRedundancyStrategyMapping = (HashMap)JSONObject.parseObject((String)redundantRet.get(0).toString(), (TypeReference)type, (Feature[])new Feature[0]);
        this.devInfo.setPerformanceRedundancyStrategy(performanceRedundancyStrategyMapping);
        return true;
    }

    private boolean getSmartPoolDiskInfo() throws ToolException {
        this.params.putIfAbsent("is_new_oceanstor", InspectUtils.isNewOceanStor(this.devInfo));
        List ret = this.executer.invokeFunction("get_smart_pool_disk_info", this.params);
        LOGGER.info("get_smart_pool_disk_info Ret={}", (Object)ret);
        String flag = ret.get(0).toString();
        if ("false".equals(flag.toLowerCase(Locale.ENGLISH))) {
            this.devInfo.setSuccess(false);
            return false;
        }
        String diskMaxCap = ret.get(1).toString();
        if ("0".equals(diskMaxCap)) {
            return true;
        }
        this.devInfo.setSmartPoolMaxCap(diskMaxCap);
        String diskCapTypeNum = ret.get(2).toString();
        this.devInfo.setSmartPoolDiskCapNum(Integer.valueOf(diskCapTypeNum));
        String[] diskTypeList = ret.get(3).toString().split(",");
        this.devInfo.setSmartPoolExpPoolList(diskTypeList);
        String[] memberDiskList = ret.get(4).toString().split("#");
        this.devInfo.setSmartPoolMemberDiskList(memberDiskList);
        String diskStr = ret.get(5).toString().replaceAll("u'", "'");
        List showDiskList = JSONObject.parseArray((String)diskStr, SmartPoolShowDisk.class);
        this.devInfo.setSmartPoolShowDiskList((ArrayList)showDiskList);
        return true;
    }

    private boolean initScmDiskInSmartCachePool() throws ToolException {
        List ret = this.executer.invokeFunction("get_smart_cache_pool_disk_for_nas", this.params);
        LOGGER.info("getSmartCachePoolDisk Ret={}", (Object)ret);
        String flag = ret.get(0).toString();
        if ("false".equals(flag.toLowerCase(Locale.ENGLISH))) {
            this.devInfo.setErrMsg(ret.get(2).toString());
            this.devInfo.setSuccess(false);
            return false;
        }
        String diskInPoolListStr = ret.get(1).toString();
        List diskInPoolList = JSONObject.parseArray((String)diskInPoolListStr, SCMDisk.class);
        this.devInfo.getSmartCachePoolInfoForNas().getInPoolDiskList().clear();
        this.devInfo.getSmartCachePoolInfoForNas().getInPoolDiskList().addAll(diskInPoolList);
        return true;
    }

    private boolean initScmDiskFree() throws ToolException {
        List ret = this.executer.invokeFunction("get_free_scm_disk", this.params);
        LOGGER.info("getFreeSCMDisk Ret={}", (Object)ret);
        String flag = ret.get(0).toString();
        if ("false".equals(flag.toLowerCase(Locale.ENGLISH))) {
            this.devInfo.setErrMsg(ret.get(2).toString());
            this.devInfo.setSuccess(false);
            return false;
        }
        String diskFreeListStr = ret.get(1).toString();
        List diskFreeList = JSONObject.parseArray((String)diskFreeListStr, SCMDisk.class);
        this.devInfo.getSmartCachePoolInfoForNas().getNotInPoolDiskList().clear();
        this.devInfo.getSmartCachePoolInfoForNas().getNotInPoolDiskList().addAll(diskFreeList);
        return true;
    }

    private HashMap<String, ArrayList<String>> dealEngDiskEnclosureInfo(HashMap<String, ArrayList<String>> diskEnclosureIdMap, EngineDiskInfo engDiskInfo) {
        HashMap<String, String> diskEnclosureInnerOutNameMap = this.devInfo.getDiskEnclosureInnerOutNameMap();
        for (String engId : engDiskInfo.getEngineIds()) {
            if (!diskEnclosureIdMap.containsKey(engId)) {
                ArrayList diskInfos = new ArrayList();
                diskEnclosureIdMap.put(engId, diskInfos);
            }
            for (Disk diskInfo : engDiskInfo.getDisks()) {
                for (DiskEnclosure diskEnclosure : diskInfo.getEnclosureInfo()) {
                    String diskEnclosureName = diskEnclosure.getName();
                    String diskEnclosureId = diskEnclosure.getId();
                    if (!diskEnclosureIdMap.get(engId).contains(diskEnclosureName)) {
                        diskEnclosureIdMap.get(engId).add(diskEnclosureName);
                    }
                    diskEnclosureInnerOutNameMap.put(diskEnclosureName, diskEnclosureId);
                }
            }
        }
        return diskEnclosureIdMap;
    }

    private boolean initCommonInfo() throws ToolException {
        if (this.checkInitCommonInfo()) {
            return false;
        }
        this.initCreateDiskFlag();
        if (!this.initAaWorkModeCheck()) {
            LOGGER.error("Check A/A work mode failed.");
            return false;
        }
        if (!this.initExpModeInfo()) {
            LOGGER.error("Init exp mode info failed.");
            return false;
        }
        if (!this.initDisksOfNVMe()) {
            LOGGER.error("Init disk of nvme failed.");
            return false;
        }
        if (!this.queryInnerMetroLicense()) {
            LOGGER.error("Check inner metro license failed.");
            return false;
        }
        if (!this.initDiskBom()) {
            LOGGER.error("Init bom of disk failed.");
            return false;
        }
        return true;
    }

    private boolean checkInitCommonInfo() throws ToolException {
        this.setMicroWorkMode();
        if (!this.initCtrlNum()) {
            LOGGER.error("Init ctrl num failed.");
            return true;
        }
        if (!this.initDDCtrsInfo()) {
            LOGGER.error("Get disk doamin and ctroller info failed.");
            return true;
        }
        if (!this.isNVMe()) {
            LOGGER.error("Init controller enclosure type failed.");
            return true;
        }
        if (!Products.isOceanStoComputingDev((String)this.dev.getDeviceType().toString()) && !this.initSASCard()) {
            LOGGER.error("Init sas card failed.");
            return true;
        }
        if (!this.initDomainIds()) {
            LOGGER.error("Init domain id failed.");
            return true;
        }
        if (!this.initEngs()) {
            LOGGER.error("Init engines failed.");
            return true;
        }
        if (!this.initEngHeight()) {
            LOGGER.error("Init engine height failed.");
            return true;
        }
        if (!this.initExpSpec()) {
            LOGGER.error("Init ctrl expansion spec failed.");
            return true;
        }
        if (!this.initInternalProductModel()) {
            LOGGER.error("Init internal version failed.");
            return true;
        }
        return false;
    }

    private void setMicroWorkMode() throws ToolException {
        if (!InspectUtils.isMicro(this.devInfo).booleanValue()) {
            this.devInfo.setPassThrouthMode(false);
            return;
        }
        List ret = this.executer.invokeFunction("is_micro_pass_though_mode", this.params);
        if ("true".equals(ret.get(0).toString().toLowerCase(Locale.ENGLISH))) {
            this.devInfo.setPassThrouthMode(true);
            return;
        }
        this.devInfo.setPassThrouthMode(false);
    }

    private boolean initDiskBom() throws ToolException {
        List ret = this.executer.invokeFunction("get_disk_bom_list", this.params);
        String diskBomListStr = ret.get(1).toString();
        List diskBomList = JSON.parseArray((String)diskBomListStr, Disk.class);
        for (Disk diskBom : diskBomList) {
            String bom = diskBom.getBom();
            this.devInfo.getDevDiskBom().put(bom, diskBom);
        }
        return true;
    }

    private boolean initDoradoV6Info() throws ToolException {
        if (ConstantField.DORADO_V6_DEV.contains(this.devInfo.getDevType().toUpperCase(Locale.ENGLISH))) {
            if (!this.initPoolsAndMapping()) {
                LOGGER.error("Init pool info failed.");
                return false;
            }
            if (!this.initEngineDiskInfo()) {
                LOGGER.error("Init engine disk info failed.");
                return false;
            }
            if (!this.initFreeDiskEnclosureId()) {
                LOGGER.error("Init disk enclosure ID failed.");
                return false;
            }
            if (!this.initDomainRedundancyStrategy()) {
                LOGGER.error("Init domain redundancy strategy failed.");
                return false;
            }
            if (Products.compareVersion((String)this.devInfo.getProductVersion(), (String)"6.1.RC3") >= 0) {
                if (!this.initSmartPool()) {
                    LOGGER.error("Init smart pool failed.");
                    return false;
                }
                if (!this.initSmartCachePool()) {
                    LOGGER.error("Init smart cache pool failed.");
                    return false;
                }
                if (!this.initScmDiskInSmartCachePool()) {
                    LOGGER.error("Init SCM disk in smart cache pool failed.");
                    return false;
                }
                if (!this.initScmDiskFree()) {
                    LOGGER.error("Init free SCM disk failed.");
                    return false;
                }
            }
        }
        return true;
    }

    private String getVrc(String vrc) {
        return vrc.substring(0, 11);
    }

    @Generated
    public void setParams(Map<String, Object> params) {
        this.params = params;
    }
}

