/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.utils;

import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.inspect.ui.action.SelectNodesByCheckBoxAction;
import com.huawei.ism.tool.inspect.ui.wizard.model.listener.ClusterNodeListListener;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.InfoDialog;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.UCD;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScrollCardUiUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScrollCardUiUtil.class);
    private static final int EN_GAP = 410;
    private static final int CH_GAP = 465;
    private static final int CLUSTER_DEVICE_WIDTH = 220;
    private static final int NODES_TBL_WIDTH = 415;
    private static final int HEIGHE_BY_FS_EXPANSION = 420;
    private static final int DEVICE_WIDTH_BY_FS_EXPANSION = 300;
    private static final int NODES_TBL_WIDTH_BY_FS_EXPANSION = 500;
    private static final int HIGH = 387;
    private static final int SECIFIC_DEVICE_HIGH = 448;
    private static final int CHECK_ITEM_DEVICE_WIDTH = 255;
    private static final int ITEM_WIDTH = 370;
    private static final String MGT_IP = "cluster.nodes.table.mgt.ip";
    private static final String ROLES = "cluster.nodes.table.roles";
    private static final String NAME = "cluster.nodes.table.name";
    private static final String ID = "cluster.nodes.table.id";
    private static final String BMC_IP = "cluster.nodes.table.bmc.ip";
    private static final String CABINET = "cluster.nodes.table.cabinet";
    private static final String OPERATION = "cluster.nodes.table.bmc.operation";

    public static JComponent createCheckItemScrollUI(JScrollPane deviceScroll, JScrollPane rightScroll, JComponent rightLabel, ToolHyperLinkLabel modifyLbl, JButton applyBtn) {
        JLabel suggestion = ScrollCardUiUtil.createSuggestionLabel("inspsctor.wizard.selectitem.suggestion");
        JComponent leftPane = ScrollCardUiUtil.buildLeftPane(deviceScroll);
        JComponent rightPane = ScrollCardUiUtil.buildRightPane(rightScroll, rightLabel);
        JComponent bottomPane = ScrollCardUiUtil.createBottomPane(modifyLbl, applyBtn);
        return ScrollCardUiUtil.buildView(suggestion, leftPane, rightPane, bottomPane);
    }

    private static JComponent buildView(JLabel suggestion, JComponent leftPane, JComponent rightPane, JComponent bottomPane) {
        Box northBox = UCD.buildHorizontalBoxLeft((Component)suggestion);
        JComponent centerComponent = UCD.buildHorizotalBox(null, (int)8, (Component[])new Component[]{leftPane, rightPane});
        return UCD.buildVerticalBox(null, (Component[])new Component[]{northBox, centerComponent, bottomPane});
    }

    private static JComponent createBottomPane(ToolHyperLinkLabel modifyLbl, JButton applyBtn) {
        JPanel depthAndApply = ScrollCardUiUtil.createDepthAndApplyPane(applyBtn);
        JComponent modifyCon = ScrollCardUiUtil.createModifyCom(modifyLbl);
        ScrollCardUiUtil.setModifyLabelUnable(modifyLbl);
        return ScrollCardUiUtil.buildBottomPane(depthAndApply, modifyCon);
    }

    private static JComponent buildBottomPane(JPanel depthAndApply, JComponent modifyCon) {
        if (!ApplicationContext.getInstance().isSpecificDeviceMode()) {
            return UCD.buildVerticalBox(null, (int)8, (Component[])new Component[]{modifyCon, depthAndApply});
        }
        return UCD.buildVerticalBox(null, (int)8, (Component[])new Component[]{depthAndApply});
    }

    private static void setModifyLabelUnable(ToolHyperLinkLabel modifyLbl) {
        String selectSeceneInSecondCard = InspectContext.getInstance().getSelectSeceneInSecondCard();
        if (ScrollCardUiUtil.needShowModifyLabel(selectSeceneInSecondCard)) {
            modifyLbl.setEnabled(false);
        }
    }

    private static boolean needShowModifyLabel(String selectSeceneInSecondCard) {
        return SceneUtils.isScene() || selectSeceneInSecondCard.contains("T3000") || selectSeceneInSecondCard.contains("UltraPath");
    }

    private static JPanel createDepthAndApplyPane(JButton applyBtn) {
        JPanel depthAndApply = new JPanel();
        Component gap = ScrollCardUiUtil.createGap();
        depthAndApply.add(gap);
        depthAndApply.add((Component)applyBtn, "East");
        return depthAndApply;
    }

    private static JComponent createModifyCom(ToolHyperLinkLabel modifyLbl) {
        return ScrollCardUiUtil.buildModifyComponent(ScrollCardUiUtil.buildModifyBoxy(modifyLbl));
    }

    private static Box buildModifyBoxy(ToolHyperLinkLabel modifyLbl) {
        Box box = Box.createHorizontalBox();
        ScrollCardUiUtil.initBox(modifyLbl, box);
        return box;
    }

    private static JComponent buildModifyComponent(Box box) {
        JComponent modifyBox = UiMethod.buildFrameSpace((JComponent)UCD.buildHBoxLeft((Component[])new Component[]{box}), (int)5);
        modifyBox.setBorder(BorderFactory.createTitledBorder(ResourceUtil.getString((String)"inspsctor.wizard.selectitem.options.modify.title")));
        return modifyBox;
    }

    private static void initBox(ToolHyperLinkLabel modifyLbl, Box box) {
        box.add(new JLabel(ResourceUtil.getString((String)"inspsctor.wizard.selectitem.options.modify.desc")));
        box.add((Component)modifyLbl);
        box.add(new JLabel(ResourceUtil.getString((String)"inspsctor.wizard.selectitem.options.modify.dot")));
    }

    private static Component createGap() {
        Locale locale = ApplicationContext.getInstance().getCurrentLanguage();
        if (Locale.CHINA.equals(locale)) {
            return Box.createHorizontalStrut(465);
        }
        return Box.createHorizontalStrut(410);
    }

    private static JComponent buildRightPane(JComponent rightScroll, JComponent rightLabel) {
        JComponent itemScrollPane = ScrollCardUiUtil.buildRightScrollPane(rightScroll);
        return UCD.buildVerticalBox(null, (int)0, (Component[])new Component[]{UCD.buildHorizontalBoxLeft((Component)rightLabel), itemScrollPane});
    }

    private static JComponent buildRightScrollPane(JComponent itemScroll) {
        return UCD.buildVerticalBox(null, (Component[])new Component[]{UiMethod.buildFrameSpace((JComponent)itemScroll, (int)4)});
    }

    private static JComponent buildLeftPane(JScrollPane leftScroll) {
        JLabel deviceStringLabel = ScrollCardUiUtil.createDeviceStringLabel();
        JComponent deviceScrollPane = ScrollCardUiUtil.buildDeviceScrollPane(leftScroll);
        return UCD.buildVerticalBox(null, (int)0, (Component[])new Component[]{UCD.buildHorizontalBoxLeft((Component)deviceStringLabel), deviceScrollPane});
    }

    private static int getHeight() {
        return ApplicationContext.getInstance().isSpecificDeviceMode() ? 448 : 387;
    }

    private static JComponent buildDeviceScrollPane(JScrollPane leftScroll) {
        return UCD.buildVerticalBox(null, (Component[])new Component[]{UiMethod.buildFrameSpace((JComponent)leftScroll, (int)4)});
    }

    private static JLabel createDeviceStringLabel() {
        return new JLabel(ResourceUtil.getString((String)"inspsctor.wizard.selectitem.inpectdev"));
    }

    private static JLabel createSuggestionLabel(String suggestion) {
        return new JLabel(ResourceUtil.getString((String)suggestion));
    }

    public static boolean showNoAuthConfirmDialog(Map<String, List<String>> needBmcAuthDev) {
        String prompt = ScrollCardUiUtil.buildNoAuthTipsInfo(needBmcAuthDev);
        JDialog mainDialog = InspectContext.getInstance().getMainDialog();
        InfoDialog infoDialog = DialogUtils.showYesNoInfoDialog((Window)mainDialog, (String)prompt, (Dimension)new Dimension(300, 125), (boolean)false);
        return infoDialog.getValue() == 0;
    }

    private static String buildNoAuthTipsInfo(Map<String, List<String>> needBmcAuthDev) {
        return ResourceUtil.getString((String)"check.need.bmc.auth.massege.head") + System.lineSeparator() + ScrollCardUiUtil.buildErrorMassage(needBmcAuthDev) + System.lineSeparator() + ResourceUtil.getString((String)"check.need.bmc.auth.massege.tailing");
    }

    private static String buildErrorMassage(Map<String, List<String>> needBmcAuthDev) {
        String splitStr = ResourceUtil.getString((String)"check.need.bmc.auth.massege.splitStr");
        return needBmcAuthDev.keySet().stream().map(floatIp -> ScrollCardUiUtil.buildNoAuthIpsInfo(floatIp, needBmcAuthDev, splitStr)).collect(Collectors.joining(splitStr));
    }

    private static String buildNoAuthIpsInfo(String floatIp, Map<String, List<String>> needBmcAuthDev, String splitStr) {
        return floatIp + "(" + String.join((CharSequence)splitStr, (Iterable<? extends CharSequence>)needBmcAuthDev.get(floatIp)) + ")";
    }

    public static void showNoSelectItemDialog(List<String> noSelectNodeIp) {
        String devs = StringUtils.deleteFirstLast((String)noSelectNodeIp.toString());
        JDialog mainDialog = InspectContext.getInstance().getMainDialog();
        DialogUtils.showInfoDialog((JDialog)mainDialog, (String)ResourceUtil.getStringWithParams((String)"inspsctor.wizard.selectitem.nocheckitemselect", (Object[])new Object[]{ScrollCardUiUtil.enCommaToZhComma(devs)}));
    }

    public static String enCommaToZhComma(String str) {
        if (StringUtils.isNULLStr((String)str)) {
            return "";
        }
        String enComma = ",";
        String zhComma = "\uff0c";
        if (!ApplicationContext.getInstance().isEnglishEnv() && str.contains(enComma)) {
            return str.replace(enComma, zhComma);
        }
        return str;
    }

    public static JComponent createClusterNodeScrollUi(JScrollPane deviceScroll, JPanel nodesScroll, JComponent rightLabel, JComponent bottom) {
        JLabel suggestion = ScrollCardUiUtil.createSuggestionLabel("inspsctor.wizard.selectcluster.nodes");
        JComponent leftPane = ScrollCardUiUtil.buildLeftPane(deviceScroll);
        JComponent rightPane = ScrollCardUiUtil.buildRightPane(nodesScroll, rightLabel);
        return ScrollCardUiUtil.buildView(suggestion, leftPane, rightPane, bottom);
    }

    public static void setScrollPaneSize(JScrollPane deviceScroll, TableScrollPane nodesScroll) {
        int height;
        int n = height = ApplicationContext.getInstance().isSpecificDeviceMode() ? 448 : 387;
        if (InspectUtils.isFsExInspect()) {
            UiMethod.setComponentSize((Dimension)new Dimension(300, 420), (Component[])new Component[]{deviceScroll});
            UiMethod.setComponentSize((Dimension)new Dimension(500, 420), (Component[])new Component[]{nodesScroll});
        } else {
            UiMethod.setComponentSize((Dimension)new Dimension(220, height), (Component[])new Component[]{deviceScroll});
            UiMethod.setComponentSize((Dimension)new Dimension(415, height), (Component[])new Component[]{nodesScroll});
        }
    }

    public static void setScrollPaneSize(JScrollPane deviceScroll, JScrollPane itemScroll) {
        int height = ScrollCardUiUtil.getHeight();
        UiMethod.setComponentSize((Dimension)new Dimension(255, height), (Component[])new Component[]{deviceScroll});
        UiMethod.setComponentSize((Dimension)new Dimension(370, height), (Component[])new Component[]{itemScroll});
    }

    public static TableScrollPane buildNodesScrollPane(IsmTable clusterNodesTbl) {
        JCheckBox computeCheckBox = ScrollCardUiUtil.buildComputeCheckBox(clusterNodesTbl);
        JCheckBox storageCheckBox = ScrollCardUiUtil.buildStorageCheckBox(clusterNodesTbl);
        ClusterNodeListListener selectListener = new ClusterNodeListListener(clusterNodesTbl, computeCheckBox, storageCheckBox);
        ScrollCardUiUtil.initTableModelListener(clusterNodesTbl, selectListener);
        TableScrollPane nodesScroll = TableScrollPane.createTablePane((IsmTable)clusterNodesTbl, (boolean)true, (ListSelectionListener)selectListener);
        ScrollCardUiUtil.addBoxToScroll(nodesScroll, computeCheckBox, storageCheckBox);
        nodesScroll.getFilterFiled().setClearSelection(false);
        return nodesScroll;
    }

    private static void initTableModelListener(IsmTable clusterNodesTbl, ClusterNodeListListener listener) {
        clusterNodesTbl.getSelectionModel().addListSelectionListener(listener);
    }

    private static void addBoxToScroll(TableScrollPane nodesScroll, JCheckBox computeCheckBox, JCheckBox storageCheckBox) {
        if (InspectUtils.isDistributedFrw()) {
            nodesScroll.addComponent2CheckBoxArea(6, new JComponent[]{UCD.buildHorizotalBox(null, (Component[])new Component[]{storageCheckBox})});
            return;
        }
        if (SceneUtils.isA800SceneInTool()) {
            computeCheckBox.setVisible(false);
            storageCheckBox.setVisible(false);
        }
        nodesScroll.addComponent2CheckBoxArea(6, new JComponent[]{UCD.buildHorizotalBox(null, (Component[])new Component[]{computeCheckBox, storageCheckBox})});
    }

    private static JCheckBox buildStorageCheckBox(IsmTable clusterNodesTbl) {
        JCheckBox storageCheckBox = ScrollCardUiUtil.createCheckBoxByType("cluster.nodes.checkBox.storageNodes", "storage");
        ScrollCardUiUtil.initCheckBoxListener(clusterNodesTbl, storageCheckBox);
        return storageCheckBox;
    }

    private static JCheckBox buildComputeCheckBox(IsmTable clusterNodesTbl) {
        JCheckBox computeCheckBox = ScrollCardUiUtil.createCheckBoxByType("cluster.nodes.checkBox.computeNodes", "compute");
        ScrollCardUiUtil.initCheckBoxListener(clusterNodesTbl, computeCheckBox);
        return computeCheckBox;
    }

    private static void initCheckBoxListener(IsmTable clusterNodesTbl, JCheckBox computeCheckBox) {
        computeCheckBox.addActionListener(new SelectNodesByCheckBoxAction(clusterNodesTbl));
    }

    private static JCheckBox createCheckBoxByType(String nodeType, String boxName) {
        JCheckBox computeCheckBox = new JCheckBox(ResourceUtil.getString((String)nodeType));
        computeCheckBox.setName(boxName);
        return computeCheckBox;
    }

    public static IsmTable createClusterNodeTbl(BooleanSupplier authFilterFunc) {
        if (SceneUtils.isA800SceneInTool()) {
            return ScrollCardUiUtil.createA800DpcNodeIsmTable(authFilterFunc);
        }
        IsmTable clusterNodesTbl = new IsmTable((TableModel)ScrollCardUiUtil.createClusterNodeModel(authFilterFunc));
        ScrollCardUiUtil.setTableHeaderSize(clusterNodesTbl);
        return clusterNodesTbl;
    }

    private static IsmTable createA800DpcNodeIsmTable(BooleanSupplier authFilterFunc) {
        String[] tableHeader = ScrollCardUiUtil.getTableHeader(authFilterFunc);
        boolean isNeedFourColumn = InspectContext.getInstance().isBureauCheckSelected();
        DefaultTableModel defaultTableModel = isNeedFourColumn ? new DefaultTableModel(tableHeader, new int[]{0, 1, 2, 3}) : new DefaultTableModel(tableHeader, new int[]{0, 1, 2});
        IsmTable clusterNodesTbl = new IsmTable((TableModel)defaultTableModel);
        TableColumnModel colModel = clusterNodesTbl.getColumnModel();
        colModel.getColumn(0).setPreferredWidth(70);
        colModel.getColumn(1).setPreferredWidth(60);
        colModel.getColumn(2).setPreferredWidth(70);
        if (isNeedFourColumn) {
            colModel.getColumn(3).setPreferredWidth(55);
        }
        return clusterNodesTbl;
    }

    private static DefaultTableModel createClusterNodeModel(BooleanSupplier authFilterFunc) {
        String[] tableHeader = ScrollCardUiUtil.getTableHeader(authFilterFunc);
        return new DefaultTableModel(tableHeader, new int[]{0, 1, 2, 3});
    }

    private static String[] getTableHeader(BooleanSupplier authFilterFunc) {
        if (InspectContext.getInstance().isBureauCheckSelected()) {
            return ScrollCardUiUtil.createBureauCheckTableHeader(authFilterFunc);
        }
        return ScrollCardUiUtil.createCommonTableHeader();
    }

    private static String[] createCommonTableHeader() {
        return new String[]{ResourceUtil.getString((String)MGT_IP), ResourceUtil.getString((String)ROLES), ResourceUtil.getString((String)NAME), ResourceUtil.getString((String)ID)};
    }

    private static String[] createBureauCheckTableHeader(BooleanSupplier authFilterFunc) {
        if (ScrollCardUiUtil.notAuthCard(authFilterFunc)) {
            return ScrollCardUiUtil.createNothColumnHeader();
        }
        return new String[]{ResourceUtil.getString((String)MGT_IP), ResourceUtil.getString((String)ROLES), ResourceUtil.getString((String)BMC_IP), ResourceUtil.getString((String)OPERATION), ResourceUtil.getString((String)ID), ResourceUtil.getString((String)CABINET), ResourceUtil.getString((String)NAME)};
    }

    private static boolean notAuthCard(BooleanSupplier authFilterFunc) {
        return Objects.nonNull(authFilterFunc) && authFilterFunc.getAsBoolean();
    }

    private static String[] createNothColumnHeader() {
        return new String[]{ResourceUtil.getString((String)MGT_IP), ResourceUtil.getString((String)ROLES), ResourceUtil.getString((String)BMC_IP), ResourceUtil.getString((String)ID), ResourceUtil.getString((String)CABINET), ResourceUtil.getString((String)NAME)};
    }

    private static void setTableHeaderSize(IsmTable clusterNodesTbl) {
        TableColumnModel colModel = clusterNodesTbl.getColumnModel();
        colModel.getColumn(0).setPreferredWidth(70);
        colModel.getColumn(1).setPreferredWidth(60);
        colModel.getColumn(2).setPreferredWidth(70);
        colModel.getColumn(3).setPreferredWidth(55);
    }

    @Generated
    private ScrollCardUiUtil() {
    }
}

