/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.utils;

import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableRow;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.RowSorter;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TableUtils.class);

    public static List<TableRow> getSelectRowsByType(List<TableRow> allRows, String targetContent) {
        return allRows.stream().filter(row -> TableUtils.isContainsRole(row, targetContent)).collect(Collectors.toList());
    }

    private static boolean isContainsRole(TableRow tableRow, String role) {
        return IntStream.range(0, tableRow.getColumnCount()).filter(index -> tableRow.getValueAt(index) instanceof String).anyMatch(index -> ((String)tableRow.getValueAt(index)).contains(role));
    }

    public static List<TableRow> getAllFilteredRows(IsmTable clusterNodesTbl) {
        RowSorter rowSorter = clusterNodesTbl.getRowSorter();
        if (rowSorter == null) {
            log.error("rowSorter is null!");
            return new ArrayList<TableRow>();
        }
        return IntStream.range(0, rowSorter.getViewRowCount()).mapToObj(index -> (TableRow)clusterNodesTbl.getAllRows().get(rowSorter.convertRowIndexToModel(index))).collect(Collectors.toList());
    }

    @Generated
    private TableUtils() {
    }
}

