/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.web.adaptor.controller;

import com.huawei.ism.tool.inspect.web.application.entity.InspectResultDto;
import com.huawei.ism.tool.inspect.web.application.entity.InspectTaskDTO;
import com.huawei.ism.tool.inspect.web.application.entity.InspectTaskDetailDTO;
import com.huawei.ism.tool.inspect.web.application.entity.param.BasicConfigInfo;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.service.rest.model.entity.Response;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@RequestMapping(value={"task"}, produces={"application/json"})
public interface InspectTaskController {
    @PostMapping
    public Response<String> createInspectTask(@RequestBody @Validated BasicConfigInfo var1) throws ToolException;

    @GetMapping
    public Response<InspectTaskDTO> queryActiveTask(@RequestParam String var1) throws ToolException;

    @GetMapping(value={"{taskId}"})
    public Response<InspectTaskDTO> queryById(@PathVariable String var1) throws ToolException;

    @GetMapping(value={"/{taskId}/steps"})
    public Response<List<String>> querySteps(@PathVariable(value="taskId") String var1) throws ToolException;

    @PutMapping(value={"/{taskId}/start"})
    public Response<String> start(@PathVariable(value="taskId") String var1) throws ToolException;

    @GetMapping(value={"/{taskId}/result"})
    public Response<InspectResultDto> queryResult(@PathVariable(value="taskId") String var1) throws ToolException;

    @GetMapping(value={"/{taskId}/result/detail/{deviceId}"})
    public Response<List<InspectTaskDetailDTO>> queryDeviceDetail(@PathVariable(value="taskId") String var1, @PathVariable(value="deviceId") String var2) throws ToolException;

    @GetMapping(value={"/{taskId}/report"})
    public void downloadReport(@PathVariable(value="taskId") String var1, HttpServletResponse var2) throws ToolException;
}

