/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.web.adaptor.controller.impl;

import com.huawei.ism.tool.devicemanager.service.INodeObserver;
import com.huawei.ism.tool.framework.pubservice.listener.INodeSupport;
import com.huawei.ism.tool.inspect.service.implement.InspectINodeSupport;
import com.huawei.ism.tool.inspect.web.adaptor.controller.DeviceController;
import com.huawei.ism.tool.inspect.web.application.entity.CheckItemDTO;
import com.huawei.ism.tool.inspect.web.application.entity.ClusterNodeDTO;
import com.huawei.ism.tool.inspect.web.application.entity.DeviceInitResult;
import com.huawei.ism.tool.inspect.web.application.entity.HyperManualCheckDTO;
import com.huawei.ism.tool.inspect.web.application.entity.NodeAuthParam;
import com.huawei.ism.tool.inspect.web.application.service.DeviceService;
import com.huawei.ism.tool.inspect.web.application.service.InspectTaskService;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.service.rest.common.DeviceObs;
import com.huawei.ism.tool.service.rest.controller.BaseDeviceController;
import com.huawei.ism.tool.service.rest.model.entity.Response;
import com.huawei.ism.tool.service.rest.model.entity.vo.DevNodeVO;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class DeviceControllerImpl
extends BaseDeviceController
implements DeviceController {
    @Resource
    private DeviceService deviceService;
    @Resource
    private InspectTaskService inspectTaskService;

    public DeviceControllerImpl() {
        super((INodeSupport)new InspectINodeSupport(), (INodeObserver)DeviceObs.INS);
    }

    @Override
    public Response<String> initDevice(String taskId, List<String> deviceIds) throws ToolException {
        this.inspectTaskService.checkTaskActive(taskId);
        this.deviceService.initDevice(taskId, deviceIds);
        return Response.success((Object)"");
    }

    @Override
    public Response<List<DevNodeVO>> querySelectDevices(String taskId) throws ToolException {
        this.inspectTaskService.checkTaskActive(taskId);
        return Response.success(this.deviceService.querySelectDevices(taskId));
    }

    @Override
    public Response<DeviceInitResult> queryResult(String taskId) throws ToolException {
        this.inspectTaskService.checkTaskActive(taskId);
        return Response.success((Object)this.deviceService.queryInitResult(taskId));
    }

    @Override
    public Response<List<CheckItemDTO>> queryCheckItem(String deviceId, String taskId) throws ToolException {
        this.inspectTaskService.checkTaskActive(taskId);
        return Response.success(this.deviceService.queryCheckItem(deviceId, taskId));
    }

    @Override
    public Response<String> selectCheckItem(String deviceId, String taskId, Set<String> itemIds) throws ToolException {
        if (CollectionUtil.isEmpty(itemIds)) {
            throw new ToolException("not.choose.item.error");
        }
        this.inspectTaskService.checkTaskActive(taskId);
        this.deviceService.selectCheckItems(deviceId, taskId, itemIds);
        return Response.success((Object)"");
    }

    @Override
    public Response<List<ClusterNodeDTO>> queryClusterNode(String deviceId, String taskId) throws ToolException {
        this.inspectTaskService.checkTaskActive(taskId);
        return Response.success(this.deviceService.queryClusterNodes(deviceId, taskId));
    }

    @Override
    public Response<String> selectClusterNodes(String deviceId, String taskId, List<Integer> clusterNodeIds) throws ToolException {
        this.inspectTaskService.checkTaskActive(taskId);
        this.deviceService.selectClusterNodes(deviceId, taskId, clusterNodeIds);
        return Response.success((Object)"");
    }

    @Override
    public Response<String> bmcAuth(String deviceId, String taskId, NodeAuthParam authParam) throws ToolException {
        this.inspectTaskService.checkTaskActive(taskId);
        this.deviceService.authBmc(taskId, deviceId, authParam);
        return Response.success((Object)"");
    }

    @Override
    public Response<HyperManualCheckDTO> queryManualCheckDevice(String taskId) throws ToolException {
        this.inspectTaskService.checkTaskActive(taskId);
        return Response.success((Object)this.deviceService.queryManualCheckDevice(taskId));
    }

    @Override
    public Response<String> configManualCheck(String taskId, HyperManualCheckDTO hyperManualCheckParam) throws ToolException {
        this.inspectTaskService.checkTaskActive(taskId);
        this.deviceService.configManualCheck(taskId, hyperManualCheckParam);
        return Response.success((Object)"");
    }
}

