/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.web.adaptor.controller.impl;

import com.huawei.ism.tool.inspect.web.adaptor.controller.InspectTaskController;
import com.huawei.ism.tool.inspect.web.application.entity.InspectResultDto;
import com.huawei.ism.tool.inspect.web.application.entity.InspectTaskDTO;
import com.huawei.ism.tool.inspect.web.application.entity.InspectTaskDetailDTO;
import com.huawei.ism.tool.inspect.web.application.entity.param.BasicConfigInfo;
import com.huawei.ism.tool.inspect.web.application.entity.param.QueryTaskParam;
import com.huawei.ism.tool.inspect.web.application.service.InspectTaskService;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.service.rest.model.entity.Response;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.compress.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class InspectTaskControllerImpl
implements InspectTaskController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InspectTaskControllerImpl.class);
    private final InspectTaskService inspectTaskService;

    @Override
    public Response<String> createInspectTask(BasicConfigInfo basicConfigInfo) throws ToolException {
        return Response.success((Object)this.inspectTaskService.createInspectTask(basicConfigInfo));
    }

    @Override
    public Response<InspectTaskDTO> queryActiveTask(String userName) throws ToolException {
        return Response.success((Object)this.inspectTaskService.queryActivateTask(new QueryTaskParam(userName)));
    }

    @Override
    public Response<InspectTaskDTO> queryById(String taskId) throws ToolException {
        return Response.success((Object)this.inspectTaskService.queryById(taskId));
    }

    @Override
    public Response<List<String>> querySteps(String taskId) throws ToolException {
        this.inspectTaskService.checkTaskActive(taskId);
        return Response.success(this.inspectTaskService.querySteps(taskId));
    }

    @Override
    public Response<String> start(String taskId) throws ToolException {
        this.inspectTaskService.checkTaskActive(taskId);
        this.inspectTaskService.startInspect(taskId);
        return Response.success((Object)"");
    }

    @Override
    public Response<InspectResultDto> queryResult(String taskId) throws ToolException {
        return Response.success((Object)this.inspectTaskService.queryTaskResult(taskId));
    }

    @Override
    public Response<List<InspectTaskDetailDTO>> queryDeviceDetail(String taskId, String deviceId) throws ToolException {
        return Response.success(this.inspectTaskService.queryDetailByDevice(taskId, deviceId));
    }

    @Override
    public void downloadReport(String taskId, HttpServletResponse response) throws ToolException {
        try {
            InspectTaskDTO inspectTask = this.inspectTaskService.queryById(taskId);
            File file = new File(inspectTask.getResultPath(), inspectTask.getReportFileName());
            if (!file.exists()) {
                throw new ToolException("report.file.not.exists");
            }
            this.writeFileToResponse(file, response);
        }
        catch (IOException e) {
            log.error("create export report failed", (Throwable)e);
            throw new ToolException("download.file.error");
        }
    }

    private void writeFileToResponse(File reportFile, HttpServletResponse response) throws IOException {
        response.reset();
        response.setContentType("application/octet-stream");
        response.addHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(reportFile.getName(), StandardCharsets.UTF_8.name()));
        ServletOutputStream outputStream = response.getOutputStream();
        try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(reportFile.toPath(), new OpenOption[0]));){
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
    }

    @Generated
    public InspectTaskControllerImpl(InspectTaskService inspectTaskService) {
        this.inspectTaskService = inspectTaskService;
    }
}

