/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.web.application.observer;

import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.entity.RecordStatus;
import com.huawei.ism.tool.inspect.entity.UiUpdatePair;
import com.huawei.ism.tool.inspect.fit.TaskRunningObserver;
import com.huawei.ism.tool.inspect.fit.entity.task.ResultStatus;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.web.application.entity.DeviceInspectResult;
import com.huawei.ism.tool.inspect.web.application.entity.InspectResult;
import com.huawei.ism.tool.inspect.web.application.entity.InspectResultStatistic;
import com.huawei.ism.tool.inspect.web.application.enums.TaskStatusEnum;
import com.huawei.ism.tool.inspect.web.domain.po.InspectTaskPO;
import com.huawei.ism.tool.inspect.web.domain.repository.InspectTaskRepository;
import com.huawei.ism.tool.inspect.worktaker.InspectWorktaker;
import com.huawei.ism.tool.obase.entity.DevNode;
import java.io.File;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InspectObserver
extends TaskRunningObserver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InspectObserver.class);
    private InspectResult inspectResult = new InspectResult();
    private final int totalDeviceCount;
    private final String taskId;
    private final InspectTaskRepository inspectTaskRepository;

    public InspectObserver(InspectWorktaker workTaker, String taskId, InspectTaskRepository inspectTaskRepository) {
        super(workTaker);
        this.totalDeviceCount = workTaker.getSelectedDevNodes().size();
        this.taskId = taskId;
        this.inspectTaskRepository = inspectTaskRepository;
        this.initDeviceResult(workTaker);
    }

    private void initDeviceResult(InspectWorktaker workTaker) {
        workTaker.getCheckDevNodes().forEach(checkDevNode -> this.inspectResult.getDeviceResults().put(checkDevNode.getDevNodeSafe().getDeviceSerialNumber(), this.buildResult((CheckDevNode)checkDevNode)));
    }

    @Override
    public void update(CheckDevNode checkDev, CheckItem checkItem, String message, int step, Calendar happenTime) {
        this.update(checkDev, checkItem, message, step, happenTime, RecordStatus.NORMAL);
    }

    private DeviceInspectResult buildResult(CheckDevNode checkDev) {
        DevNode devNode = checkDev.getDevNode();
        return DeviceInspectResult.builder().deviceId(devNode.getDeviceSerialNumber()).ip(devNode.getIp()).sn(devNode.getDeviceSerialNumber()).productModel(devNode.getProductModel()).name(devNode.getDeviceName()).result(ResultStatus.WAITED.getKey()).progress(0).deviceType(devNode.getItDeviceType().getName()).build();
    }

    @Override
    public void update(CheckDevNode checkDev, CheckItem checkItem, String message, int step, Calendar happenTime, RecordStatus recordStatus) {
        super.update(checkDev, checkItem, message, step, happenTime, recordStatus);
        this.updateResult(checkDev);
    }

    private void updateResult(CheckDevNode checkDev) {
        DeviceInspectResult result = this.inspectResult.getDeviceResults().get(checkDev.getDevNodeSafe().getDeviceSerialNumber());
        this.updateDeviceResult(checkDev, result);
        this.updateStatistic();
    }

    private void updateStatistic() {
        Map<String, List<DeviceInspectResult>> resultMap = this.inspectResult.getDeviceResults().values().stream().collect(Collectors.groupingBy(DeviceInspectResult::getResult));
        InspectResultStatistic statistic = this.inspectResult.getStatistic();
        statistic.setFailedCount(this.getFailedCount(resultMap));
        statistic.setSuccessCount(this.getSuccessCount(resultMap));
        statistic.setTotalCount(this.totalDeviceCount);
        statistic.setProgress(this.calculateProgress());
    }

    private void updateDeviceResult(CheckDevNode checkDev, DeviceInspectResult deviceInspectResult) {
        UiUpdatePair ui = InspectContext.getInstance().getUiUpdatePair(checkDev);
        deviceInspectResult.setProgress(ui.getProgress());
        deviceInspectResult.setResult(ResultStatus.of(ui.getInspectStatus().getKey(), ResultStatus.FAILED));
    }

    @Override
    public void finished(CheckDevNode checkDev) {
        super.finished(checkDev);
        this.updateResult(checkDev);
    }

    private int getSuccessCount(Map<String, List<DeviceInspectResult>> resultMap) {
        return resultMap.getOrDefault(ResultStatus.SUCCESS.getKey(), Collections.emptyList()).size() + resultMap.getOrDefault(ResultStatus.PASS.getKey(), Collections.emptyList()).size();
    }

    private int getFailedCount(Map<String, List<DeviceInspectResult>> resultMap) {
        return resultMap.getOrDefault(ResultStatus.FAILED.getKey(), Collections.emptyList()).size() + resultMap.getOrDefault(ResultStatus.NOT_PASS.getKey(), Collections.emptyList()).size();
    }

    private int calculateProgress() {
        return this.inspectResult.getDeviceResults().values().stream().mapToInt(DeviceInspectResult::getProgress).sum() / this.totalDeviceCount;
    }

    @Override
    public void finishAll(long during) {
        super.finishAll(during);
        InspectTaskPO taskPO = InspectTaskPO.builder().id(this.taskId).taskStatus(TaskStatusEnum.CLOSE.toString()).build();
        this.inspectTaskRepository.batchUpdate(Collections.singletonList(taskPO));
    }

    @Override
    public void setReportFile(File reportFile) {
        InspectTaskPO task = InspectTaskPO.builder().id(this.taskId).reportFileName(reportFile.getName()).build();
        this.inspectTaskRepository.batchUpdate(Collections.singletonList(task));
    }

    @Generated
    public InspectResult getInspectResult() {
        return this.inspectResult;
    }

    @Generated
    public int getTotalDeviceCount() {
        return this.totalDeviceCount;
    }

    @Generated
    public String getTaskId() {
        return this.taskId;
    }

    @Generated
    public InspectTaskRepository getInspectTaskRepository() {
        return this.inspectTaskRepository;
    }

    @Generated
    public void setInspectResult(InspectResult inspectResult) {
        this.inspectResult = inspectResult;
    }
}

