/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.web.application.service.impl;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.devicemanager.service.DeviceAddService;
import com.huawei.ism.tool.devicemanager.service.DeviceOpr;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.entity.HyperHostManualCheckItem;
import com.huawei.ism.tool.inspect.entity.HyperQuoServerManualCheckItem;
import com.huawei.ism.tool.inspect.entity.InspectPreCheckFailedInfo;
import com.huawei.ism.tool.inspect.fit.service.device.auth.entity.AuthStatusEnum;
import com.huawei.ism.tool.inspect.ui.componet.observer.ProcessStepObserver;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.PreInspectUtil;
import com.huawei.ism.tool.inspect.web.application.entity.CheckItemDTO;
import com.huawei.ism.tool.inspect.web.application.entity.ClusterNodeDTO;
import com.huawei.ism.tool.inspect.web.application.entity.DeviceInitResult;
import com.huawei.ism.tool.inspect.web.application.entity.HostManualCheckDTO;
import com.huawei.ism.tool.inspect.web.application.entity.HyperManualCheckDTO;
import com.huawei.ism.tool.inspect.web.application.entity.InspectTaskDTO;
import com.huawei.ism.tool.inspect.web.application.entity.ManualCheckHostInfo;
import com.huawei.ism.tool.inspect.web.application.entity.ManualCheckServerDTO;
import com.huawei.ism.tool.inspect.web.application.entity.NodeAuthParam;
import com.huawei.ism.tool.inspect.web.application.entity.QuorumServerCheckDTO;
import com.huawei.ism.tool.inspect.web.application.observer.DevicePreCheckObserver;
import com.huawei.ism.tool.inspect.web.application.service.DeviceQueryService;
import com.huawei.ism.tool.inspect.web.application.service.DeviceService;
import com.huawei.ism.tool.inspect.web.application.service.InspectTaskService;
import com.huawei.ism.tool.inspect.web.domain.service.InspectStepsService;
import com.huawei.ism.tool.inspect.worktaker.InspectWorktaker;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.service.rest.model.entity.vo.DevNodeVO;
import com.huawei.ism.tool.service.rest.service.device.RedfishConnectionManager;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DeviceServiceImpl
implements DeviceService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeviceServiceImpl.class);
    private static final Lock LOCK = new ReentrantLock();
    private final InspectTaskService inspectTaskService;
    private final InspectStepsService inspectStepsService;
    private final DeviceQueryService deviceQueryService;
    private final DeviceAddService deviceAddService;

    @Override
    public void initDevice(String taskId, List<String> deviceIds) throws ToolException {
        InspectWorktaker workTaker = InspectContext.getInstance().getWorkTaker(taskId);
        List<DevNode> allDevs = this.deviceQueryService.queryDevice();
        List<DevNode> selectDevs = this.getSelectDevices(allDevs, deviceIds);
        this.selectDevice(workTaker, selectDevs, taskId);
        AsyncExcutor.submit(() -> this.doPreCheck(workTaker, allDevs, taskId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectDevice(InspectWorktaker workTaker, List<DevNode> selectDevs, String taskId) throws ToolException {
        LOCK.lock();
        try {
            this.checkOtherTaskRunningSameDevice(selectDevs, taskId);
            this.checkThisTaskRunning(workTaker);
            workTaker.clear();
            workTaker.put("select_dev_nodes", selectDevs);
        }
        finally {
            LOCK.unlock();
        }
    }

    private void checkThisTaskRunning(InspectWorktaker workTaker) throws ToolException {
        ProcessStepObserver processStepObserver = workTaker.getProcessStepObserver();
        if (Objects.isNull(processStepObserver)) {
            DevicePreCheckObserver observer = new DevicePreCheckObserver();
            workTaker.setProcessStepObserver(observer);
            return;
        }
        if (!(processStepObserver instanceof DevicePreCheckObserver)) {
            return;
        }
        DeviceInitResult result = ((DevicePreCheckObserver)processStepObserver).getResult();
        if (!result.isFinish()) {
            throw new ToolException("current task running", false);
        }
    }

    private void checkOtherTaskRunningSameDevice(List<DevNode> selectDevs, String taskId) throws ToolException {
        Set<String> taskIds = InspectContext.getInstance().getExistsTaskIds();
        List<String> activeTaskIds = this.inspectTaskService.queryActiveTaskByIds(taskIds).stream().map(InspectTaskDTO::getTaskId).collect(Collectors.toList());
        InspectContext.getInstance().checkDeviceRunning(selectDevs, activeTaskIds, taskId);
    }

    @Override
    public DeviceInitResult queryInitResult(String taskId) throws ToolException {
        ProcessStepObserver processStepObserver = InspectContext.getInstance().getWorkTaker(taskId).getProcessStepObserver();
        if (Objects.isNull(processStepObserver) || !(processStepObserver instanceof DevicePreCheckObserver)) {
            throw new ToolException("inspect.task.not.execute");
        }
        return ((DevicePreCheckObserver)processStepObserver).getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPreCheck(InspectWorktaker workTaker, List<DevNode> allDevs, String taskId) {
        ProcessStepObserver processStepObserver = workTaker.getProcessStepObserver();
        DevicePreCheckObserver observer = new DevicePreCheckObserver();
        if (processStepObserver instanceof DevicePreCheckObserver) {
            observer = (DevicePreCheckObserver)workTaker.getProcessStepObserver();
        }
        DeviceInitResult result = new DeviceInitResult();
        observer.setResult(result);
        List<DevNode> selectDevs = workTaker.getSelectedDevNodes();
        try {
            PreInspectUtil.preCheck(selectDevs, allDevs);
            Optional<InspectPreCheckFailedInfo> failedInfo = PreInspectUtil.doPreLoadDevNodeConfig(observer, workTaker, allDevs);
            workTaker.initDebugPwdDevs();
            InspectContext.getInstance().setFinishHyperManualCheck(false);
            failedInfo.ifPresent(inspectPreCheckFailedInfo -> DeviceServiceImpl.updateResult(result, inspectPreCheckFailedInfo));
            List<String> involveSteps = this.inspectStepsService.queryTaskInvolveSteps(taskId, selectDevs);
            this.inspectTaskService.updateTaskSteps(taskId, involveSteps);
        }
        catch (ToolException e) {
            result.setFailedMsg(e.getErrorLocaleDescription());
            result.setCode(1);
        }
        finally {
            result.setFinish(true);
        }
    }

    private static void updateResult(DeviceInitResult result, InspectPreCheckFailedInfo inspectPreCheckFailedInfo) {
        result.setFailedInfo(inspectPreCheckFailedInfo);
        if (inspectPreCheckFailedInfo.hasFailedInfo()) {
            result.setCode(2);
            return;
        }
        result.setCode(0);
    }

    private List<DevNode> getSelectDevices(List<DevNode> allDevice, List<String> deviceIds) {
        return allDevice.stream().filter(node -> deviceIds.contains(node.getDeviceSerialNumber())).collect(Collectors.toList());
    }

    @Override
    public List<CheckItemDTO> queryCheckItem(String deviceId, String taskId) throws ToolException {
        InspectWorktaker workTaker = InspectContext.getInstance().getWorkTaker(taskId);
        List<CheckDevNode> checkDevNodes = workTaker.getCheckDevNodes();
        if (CollectionUtil.isEmpty(checkDevNodes)) {
            throw new ToolException("device.not.selected");
        }
        return checkDevNodes.stream().filter(node -> deviceId.equals(node.getDevNodeSafe().getDeviceSerialNumber())).findFirst().orElseThrow(() -> new ToolException("device.not.selected")).getCheckItems().entrySet().stream().map(this::buildCheckItem).filter(item -> CollectionUtils.isNotEmpty(item.getChildren())).collect(Collectors.toList());
    }

    private CheckItemDTO buildCheckItem(Map.Entry<String, List<CheckItem>> entry) {
        return CheckItemDTO.builder().description(entry.getKey()).children(entry.getValue().stream().map(this::buildItem).collect(Collectors.toList())).build();
    }

    private CheckItemDTO buildItem(CheckItem item) {
        return CheckItemDTO.builder().id(item.getItemId()).description(item.getName()).selected(item.isEnable()).build();
    }

    @Override
    public void selectCheckItems(String deviceId, String taskId, Set<String> itemIds) throws ToolException {
        this.selectItems(this.findCheckDevNode(deviceId, taskId), itemIds);
    }

    private CheckDevNode findCheckDevNode(String deviceId, String taskId) throws ToolException {
        InspectWorktaker workTaker = InspectContext.getInstance().getWorkTaker(taskId);
        List<CheckDevNode> checkDevNodes = workTaker.getCheckDevNodes();
        if (CollectionUtil.isEmpty(checkDevNodes)) {
            throw new ToolException("device.not.init.error");
        }
        return checkDevNodes.stream().filter(node -> node.getDevNodeSafe().getDeviceSerialNumber().equals(deviceId)).findFirst().orElseThrow(() -> new ToolException("device.not.init.error"));
    }

    private void selectItems(CheckDevNode node, Set<String> itemIds) throws ToolException {
        Map<String, List<CheckItem>> checkItems = node.getCheckItems();
        long count = checkItems.values().stream().flatMap(Collection::stream).peek(item -> item.setEnable(false)).filter(item -> itemIds.contains(item.getItemId())).peek(item -> item.setEnable(true)).count();
        if (count == 0L) {
            checkItems.values().stream().flatMap(Collection::stream).forEach(item -> item.setEnable(true));
            throw new ToolException("check.item.select.error");
        }
    }

    @Override
    public List<ClusterNodeDTO> queryClusterNodes(String deviceId, String taskId) throws ToolException {
        CheckDevNode checkDevNode = this.findCheckDevNode(deviceId, taskId);
        DevNode devNode = checkDevNode.getDevNode();
        this.checkDsNodeOnly(devNode);
        List clusterNodes = devNode.getClusterNodes();
        if (!CollectionUtil.isEmpty((Collection)clusterNodes)) {
            return this.mapToClusterDto(clusterNodes);
        }
        TaskResult taskResult = this.deviceAddService.addDeviceByRest(devNode, DeviceOpr.ADD);
        if (!TaskResult.Result.SUCCESS.equals((Object)taskResult.getResult())) {
            throw new ToolException(taskResult.getErrorId());
        }
        return this.mapToClusterDto(devNode.getClusterNodes());
    }

    private void checkDsNodeOnly(DevNode devNode) throws ToolException {
        if (!devNode.isDsStorage()) {
            throw new ToolException("cluster.node.support.ds.device.only");
        }
    }

    @Override
    public void selectClusterNodes(String deviceId, String taskId, List<Integer> clusterNodeIds) throws ToolException {
        CheckDevNode checkDevNode = this.findCheckDevNode(deviceId, taskId);
        List clusterNodes = checkDevNode.getDevNode().getClusterNodes();
        clusterNodes.stream().peek(node -> node.setSelected(false)).filter(clusterNode -> clusterNodeIds.contains(clusterNode.getId())).forEach(node -> node.setSelected(true));
    }

    private List<ClusterNodeDTO> mapToClusterDto(List<ClusterNode> clusterNodes) {
        return clusterNodes.stream().map(this::buildNodeDto).collect(Collectors.toList());
    }

    private ClusterNodeDTO buildNodeDto(ClusterNode node) {
        return ClusterNodeDTO.builder().id(node.getId()).bmcIp(node.getBmcIp()).managementIp(node.getManagementIp()).selected(node.isSelected()).roles(node.getRoles()).bmcAuthStatus(node.getBmcAuthStatus()).build();
    }

    @Override
    public HyperManualCheckDTO queryManualCheckDevice(String taskId) {
        return HyperManualCheckDTO.builder().hostConfig(this.buildHostConfig()).quorumServer(this.buildQuorumServer()).build();
    }

    @Override
    public void configManualCheck(String taskId, HyperManualCheckDTO hyperManualCheckParam) {
        this.setHostConfig(hyperManualCheckParam.getHostConfig());
        this.setQuorumServerConfig(hyperManualCheckParam.getQuorumServer());
    }

    private void setQuorumServerConfig(List<QuorumServerCheckDTO> quorumServer) {
        Map quorumServers = quorumServer.stream().map(QuorumServerCheckDTO::getServerInfos).flatMap(Collection::stream).collect(Collectors.toMap(ManualCheckServerDTO::getIp, Function.identity()));
        InspectContext.getServerItemListByContext().forEach(item -> this.setServerConfig(quorumServers, (HyperQuoServerManualCheckItem)item));
    }

    private void setServerConfig(Map<String, ManualCheckServerDTO> quorumServers, HyperQuoServerManualCheckItem item) {
        ManualCheckServerDTO configParam = quorumServers.get(item.getQuoServerIp());
        if (Objects.isNull(configParam)) {
            log.warn("quorum server :{} config notfound", (Object)item.getQuoServerIp());
            return;
        }
        int isThirdPartStation = this.getConfigValue(configParam.getDeployThirdStation());
        int isUseStorageResource = this.getConfigValue(configParam.getStorageUseToQuorum());
        item.setIsThirdPartStation(isThirdPartStation);
        item.setIsUseStorageResource(isUseStorageResource);
        this.putConfigToPyMap(item, isThirdPartStation, isUseStorageResource);
    }

    private void putConfigToPyMap(HyperQuoServerManualCheckItem item, int isThirdPartStation, int isUseStorageResource) {
        Optional<Map> quorumServerPyMap = this.getQuorumServerPyMap(item.getQuoServerIp());
        if (!quorumServerPyMap.isPresent()) {
            return;
        }
        quorumServerPyMap.get().put("isThirdPartStation", isThirdPartStation);
        quorumServerPyMap.get().put("isUseStorage", isUseStorageResource);
    }

    private Optional<Map> getQuorumServerPyMap(String quoServerIp) {
        ConcurrentHashMap<String, Object> tmpObj = InspectContext.getInstance().getObjectForPy();
        Map serverAndHost = (Map)tmpObj.get("HYPER_QUO_SERVER_AND_NOT_ADD_HOST_INFO");
        List serverList = (List)serverAndHost.get("QUO_SERVER_LIST");
        return serverList.stream().filter(server -> quoServerIp.equals(server.get("ip"))).findFirst();
    }

    private void setHostConfig(List<HostManualCheckDTO> hyperManualCheckParam) {
        Map hostConfigs = hyperManualCheckParam.stream().map(HostManualCheckDTO::getHostConfigs).flatMap(Collection::stream).collect(Collectors.toMap(ManualCheckHostInfo::getStarterName, Function.identity(), this::handleRepeat));
        List<HyperHostManualCheckItem> hostItemListByContext = InspectContext.getHostItemListByContext();
        hostItemListByContext.forEach(hyperHostManualCheckItem -> this.setItemValue(hostConfigs, (HyperHostManualCheckItem)hyperHostManualCheckItem));
    }

    private void setItemValue(Map<String, ManualCheckHostInfo> hostConfigs, HyperHostManualCheckItem hyperHostManualCheckItem) {
        String hostInitiator = hyperHostManualCheckItem.getHostInitiator();
        ManualCheckHostInfo manualCheckHostInfo = hostConfigs.get(hostInitiator);
        if (Objects.isNull(manualCheckHostInfo)) {
            log.warn("config starter :{} not found in context", (Object)hyperHostManualCheckItem.getHostInitiator());
            return;
        }
        int singleNetValue = this.getConfigValue(manualCheckHostInfo.getSingleNet());
        int serverTypeCorrectValue = this.getConfigValue(manualCheckHostInfo.getServerTypeCorrect());
        int multiChannelForceValue = this.getConfigValue(manualCheckHostInfo.getMultiChannelForce());
        hyperHostManualCheckItem.setIsSingleNet(singleNetValue);
        hyperHostManualCheckItem.setHostTypeCheckRet(serverTypeCorrectValue);
        hyperHostManualCheckItem.setIsUseUtrapath(multiChannelForceValue);
        DeviceServiceImpl.setPyMapInfo(hostInitiator, singleNetValue, serverTypeCorrectValue, multiChannelForceValue);
    }

    private int getConfigValue(Boolean configValue) {
        return Objects.isNull(configValue) ? 0 : (configValue != false ? 1 : 2);
    }

    private static void setPyMapInfo(String hostInitiator, int singleNetValue, int serverTypeCorrectValue, int multiChannelForceValue) {
        ConcurrentHashMap<String, Object> tmpObj = InspectContext.getInstance().getObjectForPy();
        Map serverAndHost = (Map)tmpObj.get("HYPER_QUO_SERVER_AND_NOT_ADD_HOST_INFO");
        List hostList = (List)serverAndHost.get("NOT_ADD_HOST_LIST");
        hostList.stream().filter(host -> hostInitiator.equals(host.get("initiator").toString())).forEach(hostInfoContext -> {
            hostInfoContext.put("isSingleNet", singleNetValue);
            hostInfoContext.put("hostTypeCheckRet", serverTypeCorrectValue);
            hostInfoContext.put("isUseUtrapath", multiChannelForceValue);
        });
    }

    private ManualCheckHostInfo handleRepeat(ManualCheckHostInfo config, ManualCheckHostInfo repeatConfig) {
        log.error("host starter repeat config :{}", (Object)(config.getHostName() + config.getStarterName()));
        log.error("host starter repeat config :{}", (Object)(repeatConfig.getHostName() + repeatConfig.getStarterName()));
        return config;
    }

    private List<QuorumServerCheckDTO> buildQuorumServer() {
        Map<String, List<HyperQuoServerManualCheckItem>> groupServer = InspectContext.getServerItemListByContext().stream().collect(Collectors.groupingBy(HyperQuoServerManualCheckItem::getQuoServerIp));
        return groupServer.entrySet().stream().map(this::buildServerConfig).collect(Collectors.toList());
    }

    private QuorumServerCheckDTO buildServerConfig(Map.Entry<String, List<HyperQuoServerManualCheckItem>> item) {
        return QuorumServerCheckDTO.builder().ip(item.getKey()).serverInfos(this.buildServers(item.getValue())).build();
    }

    private List<ManualCheckServerDTO> buildServers(List<HyperQuoServerManualCheckItem> items) {
        return items.stream().map(this::buildServer).collect(Collectors.toList());
    }

    private ManualCheckServerDTO buildServer(HyperQuoServerManualCheckItem item) {
        return ManualCheckServerDTO.builder().serverName(item.getQuoServerName()).ip(item.getQuoServerIp()).sn(item.getQuoServerSN()).build();
    }

    private List<HostManualCheckDTO> buildHostConfig() {
        Map<String, List<HyperHostManualCheckItem>> hostInfos = InspectContext.getHostItemListByContext().stream().collect(Collectors.groupingBy(HyperHostManualCheckItem::getHostType));
        return hostInfos.entrySet().stream().map(this::buildHostManualCheckInfo).collect(Collectors.toList());
    }

    private HostManualCheckDTO buildHostManualCheckInfo(Map.Entry<String, List<HyperHostManualCheckItem>> item) {
        return HostManualCheckDTO.builder().hostType(item.getKey()).hostConfigs(this.buildHostInfos(item.getValue())).build();
    }

    private List<ManualCheckHostInfo> buildHostInfos(List<HyperHostManualCheckItem> items) {
        return items.stream().map(this::buildHostInfo).collect(Collectors.toList());
    }

    private ManualCheckHostInfo buildHostInfo(HyperHostManualCheckItem item) {
        return ManualCheckHostInfo.builder().hostName(item.getHostName()).starterName(item.getHostInitiator()).build();
    }

    @Override
    public void authBmc(String taskId, String deviceId, NodeAuthParam authParam) throws ToolException {
        CheckDevNode checkDevNode = this.findCheckDevNode(deviceId, taskId);
        DevNode devNode = checkDevNode.getDevNode();
        this.checkDsNodeOnly(devNode);
        devNode.getClusterNodes().stream().filter(clusterNode -> authParam.getNodeIds().contains(clusterNode.getId())).forEach(node -> CompletableFuture.runAsync(() -> this.submitAuthBmc((ClusterNode)node, authParam)));
    }

    @Override
    public List<DevNodeVO> querySelectDevices(String taskId) {
        List<CheckDevNode> checkDevNodes = InspectContext.getInstance().getWorkTaker(taskId).getCheckDevNodes();
        if (CollectionUtil.isEmpty(checkDevNodes)) {
            return Collections.emptyList();
        }
        return checkDevNodes.stream().map(CheckDevNode::getDevNode).map(DevNodeVO::new).collect(Collectors.toList());
    }

    private void submitAuthBmc(ClusterNode clusterNode, NodeAuthParam authParam) {
        clusterNode.setBmcAuthStatus(AuthStatusEnum.AUTHING.getKey());
        DevNode bmcNode = DeviceServiceImpl.buildBmcNode(clusterNode, authParam);
        try {
            RedfishConnectionManager.INS.getRedFishConnection(bmcNode);
            clusterNode.setBmcNode(bmcNode);
            clusterNode.setBmcAuthStatus(AuthStatusEnum.AUTHED.getKey());
        }
        catch (ToolException e) {
            log.error("auth bmc :{} failed", (Object)clusterNode.getBmcIp(), (Object)e);
            clusterNode.setBmcAuthStatus(AuthStatusEnum.AUTH_FAILED.getKey());
        }
    }

    @NotNull
    private static DevNode buildBmcNode(ClusterNode clusterNode, NodeAuthParam authParam) {
        DevNode bmcNode = new DevNode();
        bmcNode.setIp(clusterNode.getBmcIp());
        bmcNode.setLoginUser(new User(authParam.getUsername(), authParam.getPassword()));
        bmcNode.setDeviceSerialNumber(clusterNode.getSerialNumber());
        bmcNode.setPort(authParam.getPort());
        bmcNode.setRedFishPort(String.valueOf(authParam.getRedFishPort()));
        return bmcNode;
    }

    @Generated
    public DeviceServiceImpl(InspectTaskService inspectTaskService, InspectStepsService inspectStepsService, DeviceQueryService deviceQueryService, DeviceAddService deviceAddService) {
        this.inspectTaskService = inspectTaskService;
        this.inspectStepsService = inspectStepsService;
        this.deviceQueryService = deviceQueryService;
        this.deviceAddService = deviceAddService;
    }
}

