/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.web.application.service.impl;

import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.Record;
import com.huawei.ism.tool.inspect.fit.entity.task.ResultStatus;
import com.huawei.ism.tool.inspect.logic.inspector.IUiObserver;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.inspect.web.application.entity.CheckItemDTO;
import com.huawei.ism.tool.inspect.web.application.entity.CheckItemDetailResultDTO;
import com.huawei.ism.tool.inspect.web.application.entity.DeviceInspectResult;
import com.huawei.ism.tool.inspect.web.application.entity.InspectResult;
import com.huawei.ism.tool.inspect.web.application.entity.InspectResultDto;
import com.huawei.ism.tool.inspect.web.application.entity.InspectTaskDTO;
import com.huawei.ism.tool.inspect.web.application.entity.InspectTaskDetailDTO;
import com.huawei.ism.tool.inspect.web.application.entity.param.BasicConfigInfo;
import com.huawei.ism.tool.inspect.web.application.entity.param.QueryTaskParam;
import com.huawei.ism.tool.inspect.web.application.enums.TaskStatusEnum;
import com.huawei.ism.tool.inspect.web.application.enums.TaskStepEnum;
import com.huawei.ism.tool.inspect.web.application.observer.InspectObserver;
import com.huawei.ism.tool.inspect.web.application.service.InspectTaskService;
import com.huawei.ism.tool.inspect.web.application.utils.TaskInfoUtil;
import com.huawei.ism.tool.inspect.web.domain.po.InspectTaskPO;
import com.huawei.ism.tool.inspect.web.domain.repository.InspectTaskRepository;
import com.huawei.ism.tool.inspect.web.domain.service.InspectStepsService;
import com.huawei.ism.tool.inspect.web.manager.InspectTaskManager;
import com.huawei.ism.tool.inspect.worktaker.InspectWorktaker;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class InspectTaskServiceImpl
implements InspectTaskService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InspectTaskServiceImpl.class);
    private final InspectTaskRepository inspectTaskRepository;
    private final InspectStepsService inspectStepsService;

    @Override
    public String createInspectTask(BasicConfigInfo basicConfigInfo) throws ToolException {
        this.checkResultPathValid(basicConfigInfo.getResultPath());
        List<InspectTaskPO> existsTask = this.inspectTaskRepository.queryActiveTask(this.mapToTaskPo(new QueryTaskParam(basicConfigInfo.getUsername())));
        this.checkRunning(existsTask);
        this.closeTask(existsTask);
        InspectTaskPO inspectTaskPO = this.mapToTaskPo(basicConfigInfo);
        this.inspectTaskRepository.insert(inspectTaskPO);
        InspectContext.getInstance().initScene(basicConfigInfo.getCheckModel());
        return inspectTaskPO.getId();
    }

    private void checkResultPathValid(String resultPath) throws ToolException {
        File file = new File(resultPath);
        if (file.exists() && file.isFile()) {
            throw new ToolException("result.path.is.file");
        }
        if (file.exists()) {
            return;
        }
        try {
            Files.createDirectories(file.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            log.error("create result dir error.", (Throwable)e);
            throw new ToolException("create.result.path.error");
        }
    }

    private void closeTask(List<InspectTaskPO> existsTask) {
        if (CollectionUtil.isEmpty(existsTask)) {
            return;
        }
        existsTask.forEach(task -> task.setTaskStatus(TaskStatusEnum.CLOSE.toString()));
        this.inspectTaskRepository.batchUpdate(existsTask);
    }

    private void checkRunning(List<InspectTaskPO> existsTask) throws ToolException {
        List runningTask = existsTask.stream().filter(task -> InspectTaskManager.getInstance().isTaskRunning(task.getId())).collect(Collectors.toList());
        if (!CollectionUtil.isEmpty(runningTask)) {
            throw new ToolException("inspector.task.running.error", new Object[]{((InspectTaskPO)runningTask.get(0)).getId()});
        }
    }

    @Override
    public InspectTaskDTO queryActivateTask(QueryTaskParam queryTaskParam) throws ToolException {
        List<InspectTaskPO> inspectTaskPOS = this.inspectTaskRepository.queryActiveTask(this.mapToTaskPo(queryTaskParam));
        if (inspectTaskPOS.size() > 1) {
            inspectTaskPOS.forEach(task -> task.setTaskStatus(TaskStatusEnum.CLOSE.toString()));
            this.inspectTaskRepository.batchUpdate(inspectTaskPOS);
            throw new ToolException("inspect.task.multi.active");
        }
        return CollectionUtil.isEmpty(inspectTaskPOS) ? null : this.mapToDTO(inspectTaskPOS.get(0));
    }

    @Override
    public List<String> querySteps(String taskId) throws ToolException {
        InspectTaskPO inspectTaskPO = this.inspectTaskRepository.queryById(taskId);
        if (Objects.isNull(inspectTaskPO)) {
            throw new ToolException("inspect.task.not.found");
        }
        return inspectTaskPO.getInvolveSteps();
    }

    @Override
    public void checkTaskActive(String taskId) throws ToolException {
        InspectTaskPO inspectTaskPO = this.inspectTaskRepository.queryById(taskId);
        if (Objects.isNull(inspectTaskPO) || !TaskStatusEnum.ACTIVE.toString().equals(inspectTaskPO.getTaskStatus())) {
            throw new ToolException("inspect.task.not.active");
        }
    }

    @Override
    public List<InspectTaskDTO> queryActiveTaskByIds(Set<String> taskIds) {
        List<InspectTaskPO> inspectTaskPOS = this.inspectTaskRepository.queryActiveTaskByIds(taskIds);
        return inspectTaskPOS.stream().map(this::mapToDTO).collect(Collectors.toList());
    }

    @Override
    public void updateTaskSteps(String taskId, List<String> involveSteps) {
        InspectTaskPO taskPO = InspectTaskPO.builder().involveSteps(involveSteps).id(taskId).build();
        this.inspectTaskRepository.batchUpdate(Collections.singletonList(taskPO));
    }

    private InspectTaskPO mapToTaskPo(QueryTaskParam queryTaskParam) {
        return InspectTaskPO.builder().taskStatus(TaskStatusEnum.ACTIVE.toString()).username(queryTaskParam.getUsername()).build();
    }

    private InspectTaskDTO mapToDTO(InspectTaskPO inspectTaskPO) {
        return InspectTaskDTO.builder().taskId(inspectTaskPO.getId()).taskName(inspectTaskPO.getName()).currentStep(inspectTaskPO.getCurrentStep()).involveSteps(inspectTaskPO.getInvolveSteps()).resultPath(inspectTaskPO.getResultPath()).reportFileName(inspectTaskPO.getReportFileName()).build();
    }

    private InspectTaskPO mapToTaskPo(BasicConfigInfo basicConfigInfo) {
        return InspectTaskPO.builder().id(UUID.randomUUID().toString()).resultPath(basicConfigInfo.getResultPath()).createDate(new Date()).name(basicConfigInfo.getTaskName()).currentStep(TaskStepEnum.SELECT_DEVICE.getName()).taskStatus(TaskStatusEnum.ACTIVE.toString()).involveSteps(this.inspectStepsService.queryDefaultSteps()).username(basicConfigInfo.getUsername()).checkModel(basicConfigInfo.getCheckModel()).build();
    }

    @Override
    public void startInspect(String taskId) throws ToolException {
        InspectWorktaker workTaker = InspectContext.getInstance().getWorkTaker(taskId);
        InspectTaskPO inspectTaskPO = this.inspectTaskRepository.queryById(taskId);
        workTaker.put("check_savepath", new File(inspectTaskPO.getResultPath()));
        String defaultName = InspectUtils.buildResultFileName("").getName();
        workTaker.put("check_savepath_filename", defaultName);
        workTaker.startInspector(this.getObserver(taskId));
    }

    private synchronized IUiObserver getObserver(String taskId) throws ToolException {
        if (InspectTaskManager.getInstance().isTaskRunning(taskId)) {
            throw new ToolException("inspector.task.running.error", new Object[]{taskId});
        }
        return InspectTaskManager.getInstance().getObserver(taskId, this.inspectTaskRepository);
    }

    @Override
    public InspectResultDto queryTaskResult(String taskId) throws ToolException {
        List<CheckDevNode> checkDevNodes = InspectContext.getInstance().getWorkTaker(taskId).getCheckDevNodes();
        if (CollectionUtil.isEmpty(checkDevNodes)) {
            throw new ToolException("result.not.found");
        }
        IUiObserver observer = InspectTaskManager.getInstance().getObserver(taskId, this.inspectTaskRepository);
        if (observer instanceof InspectObserver) {
            InspectResult inspectResult = ((InspectObserver)observer).getInspectResult();
            return InspectResultDto.builder().deviceResults(new ArrayList<DeviceInspectResult>(inspectResult.getDeviceResults().values())).statistic(inspectResult.getStatistic()).build();
        }
        throw new ToolException("result.not.found");
    }

    @Override
    public List<InspectTaskDetailDTO> queryDetailByDevice(String taskId, String deviceId) throws ToolException {
        CheckDevNode devNode = InspectContext.getInstance().getWorkTaker(taskId).getCheckDevNodes().stream().filter(checkDevNode -> deviceId.equals(checkDevNode.getDevNodeSafe().getDeviceSerialNumber())).findFirst().orElseThrow(() -> new ToolException("result.not.found"));
        List<Record> records = TaskInfoUtil.getRecordList(devNode);
        return records.stream().map(this::buildDetailResult).collect(Collectors.toList());
    }

    @Override
    public InspectTaskDTO queryById(String taskId) {
        return this.mapToDTO(this.inspectTaskRepository.queryById(taskId));
    }

    private InspectTaskDetailDTO buildDetailResult(Record record) {
        CheckItemDetailResultDTO result = this.buildResult(record);
        return InspectTaskDetailDTO.builder().checkItemDTO(InspectTaskServiceImpl.buildItem(record)).itemResult(result).build();
    }

    private CheckItemDetailResultDTO buildResult(Record record) {
        CheckItemDetailResultDTO.CheckItemDetailResultDTOBuilder builder = CheckItemDetailResultDTO.builder();
        String status = TaskInfoUtil.getStatus(record);
        builder.result(status).startTime(record.getDate()).progress(record.getProgress()).build();
        if (record.isCommonStep()) {
            return builder.build();
        }
        if (!ResultStatus.RUNNING.getKey().equals(status)) {
            builder.errorInfo(record.getCheckItem().getErrorInfo()).suggestion(ResultStatus.PASS.getKey().equals(status) ? "" : record.getSuggestion()).originInfo(record.getOriginalInfo()).method(record.getMethod()).endTime(record.getEndTime()).criterion(record.getCriterion());
        }
        return builder.build();
    }

    private static CheckItemDTO buildItem(Record record) {
        CheckItemDTO.CheckItemDTOBuilder builder = CheckItemDTO.builder();
        builder.description(record.getMessage());
        if (Objects.nonNull(record.getCheckItem())) {
            builder.id(record.getCheckItem().getItemId());
        }
        return builder.build();
    }

    @Generated
    public InspectTaskServiceImpl(InspectTaskRepository inspectTaskRepository, InspectStepsService inspectStepsService) {
        this.inspectTaskRepository = inspectTaskRepository;
        this.inspectStepsService = inspectStepsService;
    }
}

