/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.worktaker;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.huawei.ism.tool.base.utils.ContextUtil;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.fit.common.InspectScene;
import com.huawei.ism.tool.inspect.logic.config.Product;
import com.huawei.ism.tool.inspect.logic.inspector.IUiObserver;
import com.huawei.ism.tool.inspect.logic.inspector.InspectExecuter;
import com.huawei.ism.tool.inspect.ui.componet.observer.ProcessStepObserver;
import com.huawei.ism.tool.inspect.utils.DebugInfoContext;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.inspect.utils.LockProduceUtils;
import com.huawei.ism.tool.inspect.utils.QueryItemTask;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class InspectWorktaker
extends HashMap<String, Object> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InspectWorktaker.class);
    public static final String PARAM_KEY_SAVEPATH = "check_savepath";
    public static final String PARAM_KEY_SAVE_FILENAME = "check_savepath_filename";
    public static final String PARAM_KEY_CHECKDEVNODES = "check_dev_nodes";
    public static final String PARAM_KEY_EXCEPTION_CHECKDEVNODES = "exception_dev_nodes";
    public static final String PARAM_KEY_SELECTDEVNODES = "select_dev_nodes";
    public static final String PARAM_KEY_ROOT_DEVS = "ssh_root_devs";
    public static final String PARAM_KEY_SCENEHYPERMETRONODES = "scene_hyper_metro_nodes";
    public static final String PARAM_KEY_NOT_CONNECT = "not_connected_devices";
    public static final String PARAM_KEY_SELECT_SCENEID = "select_sceneId";
    public static final String PARAM_KEY_SUPPORT_DEVICE = "supported_device";
    private static final long serialVersionUID = -4882572884140857939L;
    private static final String CLUSTER_FILE_NAME = "clusterDevice.json";
    private static final String DEVICELIST_PATH = String.join((CharSequence)File.separator, ContextUtil.getToolBoxPath(), "temp", "sceneTemplates", "server");
    private transient InspectExecuter executor;
    private final Map<String, String> targetVersions = new HashMap<String, String>();
    private final String uuid;
    private int deviceNums = 0;
    private ProcessStepObserver processStepObserver;
    private long startTimeStamp;
    private long endTimeStamp;

    public InspectWorktaker() {
        this.uuid = UUID.randomUUID().toString();
    }

    public InspectWorktaker(String id) {
        this.uuid = id;
    }

    public int getDeviceNums() {
        return this.deviceNums;
    }

    public void putExtra(String key, Object obj) {
        this.put(key, obj);
    }

    public void addTargetVersions(String sn, String version) {
        this.targetVersions.put(sn, version);
    }

    public List<CheckDevNode> getConnectedDev() {
        List allCheckDevNode = (List)this.get(PARAM_KEY_CHECKDEVNODES);
        this.deviceNums = allCheckDevNode.stream().mapToInt(dev -> dev.getAllCheckNode().size()).sum();
        List notConnectedDevNodes = (List)this.get("not_connected_devices_" + this.uuid);
        return this.excludeNoConnected(allCheckDevNode, notConnectedDevNodes);
    }

    public List<CheckDevNode> getCanFarwordDevs() {
        List allCheckDevNode = (List)this.get(PARAM_KEY_CHECKDEVNODES);
        List notConnectedDevNodes = (List)this.get("not_connected_devices_" + this.uuid);
        ArrayList<CheckDevNode> ret = new ArrayList<CheckDevNode>();
        for (CheckDevNode checkDevNode : allCheckDevNode) {
            for (CheckDevNode checkDevNodeTmp : checkDevNode.getAllCheckNode()) {
                if (this.checkInNotConnectedList(notConnectedDevNodes, checkDevNodeTmp)) continue;
                ret.add(checkDevNode);
            }
        }
        return ret;
    }

    private boolean checkInNotConnectedList(List<CheckDevNode> notConnectedDevNodes, CheckDevNode checkDevNodeTmp) {
        return notConnectedDevNodes.stream().anyMatch(checkDevNode2 -> this.compareDevNode(checkDevNodeTmp, (CheckDevNode)checkDevNode2));
    }

    private List<CheckDevNode> excludeNoConnected(List<CheckDevNode> allCheckDevNode, List<CheckDevNode> noConnectedCheckDevNodes) {
        return allCheckDevNode.stream().filter(checkDevNode -> !this.isExistNoConnectCheckDevNode((CheckDevNode)checkDevNode, noConnectedCheckDevNodes)).collect(Collectors.toList());
    }

    private boolean isExistNoConnectCheckDevNode(CheckDevNode checkDevNode, List<CheckDevNode> noConnectedCheckDevNodes) {
        List<CheckDevNode> checkDevNodes = checkDevNode.getAllCheckNode();
        if (checkDevNode.isIntegration() && checkDevNodes.size() > 1) {
            noConnectedCheckDevNodes.forEach((? super T failedCheckDevNode) -> this.removeUnconnectedDev(checkDevNode, (CheckDevNode)failedCheckDevNode));
            return checkDevNode.getChildrens().isEmpty();
        }
        for (CheckDevNode tempNode : noConnectedCheckDevNodes) {
            CheckDevNode noConnect = tempNode.getAllCheckNode().get(0);
            CheckDevNode child = checkDevNodes.get(0);
            if (!this.compareDevNode(child, noConnect)) continue;
            return true;
        }
        return false;
    }

    private void removeUnconnectedDev(CheckDevNode checkDevNode, CheckDevNode failedcdNode) {
        Iterator<CheckDevNode> ite = checkDevNode.getChildrens().iterator();
        while (ite.hasNext()) {
            CheckDevNode cdn = ite.next();
            if (!this.compareDevNode(cdn.getAllCheckNode().get(0), failedcdNode)) continue;
            ite.remove();
        }
    }

    public boolean compareDevNode(CheckDevNode target, CheckDevNode base) {
        return target.getDevNode().getDeviceSerialNumber().equals(base.getDevNode().getDeviceSerialNumber()) && target.getDevNode().getIp().equals(base.getDevNode().getIp());
    }

    public void clearNoConnected() {
        List noConnectedDev = (List)this.get("check_dev_nodes_" + this.uuid);
        if (null == noConnectedDev || noConnectedDev.isEmpty()) {
            return;
        }
        noConnectedDev.clear();
        this.put("check_dev_nodes_" + this.uuid, null);
    }

    public List<CheckDevNode> loadProductConfigByDevNode() throws ToolException {
        return this.loadProductConfigByDevNode(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CheckDevNode> loadProductConfigByDevNode(ProcessStepObserver progressDialog) throws ToolException {
        Object object = LockProduceUtils.getInstance().getLoadProductLock();
        synchronized (object) {
            return this.executeLoadProductConfigByDevNode(progressDialog);
        }
    }

    public void initDebugPwdDevsForNullReturn() {
        this.initDebugPwdDevs();
    }

    public List<String> initDebugPwdDevs() {
        log.info("----start to init debugPwdDevs----");
        ArrayList<String> needsDebugDevs = new ArrayList<String>();
        List<CheckDevNode> checkDevNodes = this.getAllSelectedDebugPwdNode(needsDebugDevs);
        for (CheckDevNode dev : checkDevNodes) {
            String ip = dev.getDevNode().getIp();
            HashMap<String, String> initAttuVal = new HashMap<String, String>();
            for (Element el : dev.getProduct().getAttus()) {
                String debugPwd = dev.getDevNode().getDeveloperPwd();
                if ("db".equals(el.getAttribute("defaultVla"))) {
                    initAttuVal.put(el.getAttribute("id"), debugPwd);
                } else if ("ds".equals(el.getAttribute("defaultVla"))) {
                    initAttuVal.put(el.getAttribute("id"), debugPwd);
                }
                DebugInfoContext.putDevInfo(ip, initAttuVal);
            }
        }
        return needsDebugDevs;
    }

    private List<CheckDevNode> getAllSelectedDebugPwdNode(List<String> needsDebugDevs) {
        List checkDevNodes = (List)this.get(PARAM_KEY_CHECKDEVNODES);
        ArrayList<CheckDevNode> debugSetDev = new ArrayList<CheckDevNode>();
        for (CheckDevNode rootDev : checkDevNodes) {
            CheckDevNode head = rootDev.getAllCheckNode().get(0);
            Product headProduct = head.getProduct();
            for (CheckDevNode dev : rootDev.getAllCheckNode()) {
                Product p = dev.getProduct();
                this.getDebugDev(needsDebugDevs, debugSetDev, rootDev, head, headProduct, dev, p);
            }
        }
        return debugSetDev;
    }

    private void getDebugDev(List<String> needsDebugDevs, List<CheckDevNode> debugSetDev, CheckDevNode rootDev, CheckDevNode head, Product headProduct, CheckDevNode dev, Product p) {
        if (p.getAttus().size() != 0) {
            String debugPwd = head.getDevNode().getDeveloperPwd();
            if (headProduct != null && "all".equals(headProduct.getApplyRange())) {
                dev.getDevNode().setDeveloperPwd(debugPwd);
            }
            debugSetDev.add(dev);
            if (rootDev.isIntegration() && rootDev.getAllCheckNode().size() > 1 && StringUtils.isNULLStr((String)debugPwd) && !needsDebugDevs.contains(head.getDevNode().getIp())) {
                needsDebugDevs.add(head.getDevNode().getIp());
            }
            boolean needDebug = this.checkNeedDebug(p, dev);
            String debugPwd2 = dev.getDevNode().getDeveloperPwd();
            if (StringUtils.isNULLStr((String)debugPwd2) && !needsDebugDevs.contains(dev.getDevNode().getIp()) && needDebug) {
                needsDebugDevs.add(dev.getDevNode().getIp());
            }
        }
    }

    private boolean checkNeedDebug(Product p, CheckDevNode dev) {
        List<String> verNotNeedDebug = p.getNotNeedDebug();
        String proVer = dev.getDevNode().getProductVersion();
        return verNotNeedDebug.stream().noneMatch(proVer::contains);
    }

    private List<CheckDevNode> executeLoadProductConfigByDevNode(ProcessStepObserver progressDialog) throws ToolException {
        QueryItemTask task = new QueryItemTask(this, progressDialog);
        return task.executeTasks();
    }

    public void startInspector(IUiObserver uiObserver) {
        this.executor = new InspectExecuter(this, uiObserver);
        this.executor.startInspect();
        this.executor.waitResult(true);
    }

    public boolean isFinished() {
        return null != this.executor && this.executor.isFinished();
    }

    public File getResultTmpPath() {
        return this.executor.getResultTmpFolder();
    }

    public void cancelInspectTasks() {
        if (null == this.executor) {
            return;
        }
        this.executor.cancelAllTask();
    }

    public boolean isRetFilewhether() {
        return this.executor.isRetFilewhether();
    }

    public boolean isConnectedDevEmpty() {
        return this.executor.isConnectedDevEmpty();
    }

    public String getUuid() {
        return this.uuid;
    }

    public Optional<DevNode> findDevNode(String devId) {
        return ((List)this.get(PARAM_KEY_SUPPORT_DEVICE)).stream().filter(dev -> dev.getDevKey().equals(devId)).findFirst();
    }

    public CheckDevNode findCheckDevNode(String devId) throws ToolException {
        return ((List)this.get(PARAM_KEY_CHECKDEVNODES)).stream().filter(checkDevNode -> devId.equals(checkDevNode.getDevNodeSafe().getDevKey())).findFirst().orElseThrow(() -> new ToolException("can not find dev " + devId));
    }

    public List<CheckDevNode> getCheckDevNodes() {
        return (List)this.get(PARAM_KEY_CHECKDEVNODES);
    }

    public CheckDevNode matchCheckDevNode(DevNode node) {
        List checkDevNodes = (List)this.get(PARAM_KEY_CHECKDEVNODES);
        return checkDevNodes.stream().filter(checkDevNode -> !checkDevNode.isIntegration() && checkDevNode.getDevNode() != null).filter(checkDevNode -> node.equals((Object)checkDevNode.getDevNode())).findFirst().orElse(null);
    }

    public List<DevNode> getSupportedDevNodes() {
        return (List)this.computeIfAbsent(PARAM_KEY_SUPPORT_DEVICE, key -> new ArrayList());
    }

    public List<DevNode> getSelectedDevNodes() {
        return (List)this.computeIfAbsent(PARAM_KEY_SELECTDEVNODES, key -> new ArrayList());
    }

    public File getResultTempDir() {
        return (File)this.computeIfAbsent(PARAM_KEY_SAVEPATH, key -> InspectUtils.getTmpResultFilePath());
    }

    public InspectScene getInspectScene() {
        return InspectScene.of(this.getOrDefault(PARAM_KEY_SELECT_SCENEID, InspectScene.REAL_TIME_CHECK.getSceneId()));
    }

    public List<DevNode> getExceptionNodes() {
        return this.getOrDefault(PARAM_KEY_EXCEPTION_CHECKDEVNODES, Collections.emptyList());
    }

    public void updateCluterBmcInfo(List<CheckDevNode> checkDevNodes) throws ToolException {
        if (!InspectUtils.isDistributedFrw()) {
            log.info("The BMC information does not need to be parsed in the current scenario.");
            return;
        }
        log.info("strat update bmc info");
        File filePath = Paths.get(DEVICELIST_PATH, CLUSTER_FILE_NAME).toFile();
        if (!filePath.exists()) {
            throw new ToolException("Failed to update the BMC information because no file is available.");
        }
        try {
            JSONArray clusters = JSONArray.parseArray((String)StreamUtils.readStringFormFile((File)filePath));
            Map<String, JSONObject> clusterNodeMap = clusters.stream().filter(clustNodeJson -> clustNodeJson instanceof JSONObject).map(clustNodeJson -> (JSONObject)clustNodeJson).collect(Collectors.toMap(jsonObject -> jsonObject.getString("floatIp"), jsonObject -> jsonObject));
            checkDevNodes.forEach((? super T checkDevNode) -> this.setBmcNodeInfo(clusterNodeMap, checkDevNode.getDevNode()));
        }
        catch (JSONException | IllegalStateException e) {
            throw new ToolException("Failed to initialize the BMC information.", e);
        }
        log.info("update bmc info success");
    }

    private void setBmcNodeInfo(Map<String, JSONObject> clusterNodeMap, DevNode devNode) {
        JSONObject clusterNodeJson = clusterNodeMap.get(devNode.getIp());
        if (clusterNodeJson != null) {
            JSONArray fsDevNodeList = clusterNodeJson.getJSONArray("fsDevNodeList");
            if (fsDevNodeList == null) {
                throw new JSONException("No node can be inspected.");
            }
            Map<String, JSONObject> fsDevNodeMap = fsDevNodeList.stream().filter(fsDevNodeJson -> fsDevNodeJson instanceof JSONObject).map(fsDevNodeJson -> (JSONObject)fsDevNodeJson).filter(jsonObject -> !StringUtils.isNULLStr((String)jsonObject.getString("BmcIP"))).collect(Collectors.toMap(jsonObject -> jsonObject.getString("BmcIP"), jsonObject -> jsonObject));
            devNode.getClusterNodes().forEach((? super T clusterNode) -> this.setBmcInfo((ClusterNode)clusterNode, fsDevNodeMap));
        }
    }

    private void setBmcInfo(ClusterNode clusterNode, Map<String, JSONObject> fsDevNodeMap) {
        JSONObject fsDevNodeJson = fsDevNodeMap.get(clusterNode.getBmcIp());
        if (fsDevNodeJson != null) {
            DevNode devNode = new DevNode();
            User user = new User();
            user.setUserName(fsDevNodeJson.getString("bmcUserName"));
            user.setEcptPassword(fsDevNodeJson.getString("bmcPassword"));
            devNode.setLoginUser(user);
            devNode.setIp(clusterNode.getBmcIp());
            clusterNode.setBmcNode(devNode);
        }
    }

    @Generated
    public Map<String, String> getTargetVersions() {
        return this.targetVersions;
    }

    @Generated
    public void setProcessStepObserver(ProcessStepObserver processStepObserver) {
        this.processStepObserver = processStepObserver;
    }

    @Generated
    public ProcessStepObserver getProcessStepObserver() {
        return this.processStepObserver;
    }

    @Generated
    public long getStartTimeStamp() {
        return this.startTimeStamp;
    }

    @Generated
    public void setStartTimeStamp(long startTimeStamp) {
        this.startTimeStamp = startTimeStamp;
    }

    @Generated
    public long getEndTimeStamp() {
        return this.endTimeStamp;
    }

    @Generated
    public void setEndTimeStamp(long endTimeStamp) {
        this.endTimeStamp = endTimeStamp;
    }
}

