/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.connection;

import com.huawei.ism.tool.bizpack.wizardparse.entity.rest.RequestInfo;
import com.huawei.ism.tool.bizpack.wizardparse.entity.rest.ResponseInfo;
import com.huawei.ism.tool.bizpack.wizardparse.entity.rest.UnsupProtocolException;
import com.huawei.ism.tool.certbase.ssl.MyTrustSslSocketFactoryTool;
import com.huawei.ism.tool.channel.utils.HttpsPropUtils;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.protocol.rest.HttpSession;
import com.huawei.ism.tool.protocol.rest.MyCustSSLSocketFactory;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Iterator;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.RedirectStrategy;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.io.EofSensorInputStream;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import org.apache.hc.core5.pool.PoolReusePolicy;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;

public class HttpSession {
    private static final String RIGHT_BRACKET = "]";
    private static final String LEFT_BRACKET = "[";
    private static final int HTTP_CONNECT_TIMEOUT = 30;
    private static final int HTTP_CONNECTION_REQUEST_TIMEOUT = 300;
    private static final int MAX_TIME = 8192;
    private static final int MAX_TOTOL_CON_NUM = 50;
    private static final int MAX_DEFAULT_CON_NUM = 20;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(HttpSession.class);
    private String sessionID;
    private CloseableHttpClient httpClient;

    private HttpSession(DevNode devNode) throws NoSuchAlgorithmException, KeyManagementException, CertificateException, KeyStoreException {
        this.httpClient = this.getHttpsClient(devNode);
        LOGGER.info("HttpClient is created successfully.");
    }

    public static HttpSession createNewSession(DevNode devNode) throws CertificateException {
        try {
            return new HttpSession(devNode);
        }
        catch (KeyManagementException e) {
            LOGGER.error("Key Management error.", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("No Such Algorithm error.", (Throwable)e);
        }
        catch (KeyStoreException e) {
            LOGGER.error("Key Store error.", (Throwable)e);
        }
        return null;
    }

    public static void closeSession(HttpSession httpSess) {
        if (null != httpSess) {
            httpSess.close();
        }
    }

    public void setSessionID(String sessionID) {
        this.sessionID = sessionID;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseInfo sendRequest1(RequestInfo request) throws IOException {
        CloseableHttpResponse resp = null;
        try {
            resp = this.execRequest(request);
        }
        catch (Exception e) {
            LOGGER.error("send cmd error:", (Throwable)e);
            throw new IOException(e);
        }
        HttpEntity entity = resp.getEntity();
        ContentType contentType = ContentType.parse((CharSequence)entity.getContentType());
        String type = contentType == null ? "" : contentType.getMimeType();
        ResponseInfo responseInfo = new ResponseInfo();
        responseInfo.setHeaders(resp.getHeaders());
        responseInfo.setLocale(resp.getLocale());
        responseInfo.setStatusLine(new StatusLine((HttpResponse)resp));
        responseInfo.setContentType(type);
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(resp.getEntity().getContent(), "UTF-8"), 8192);
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                responseInfo.setContent(line);
            }
            if (null != type && type.indexOf("text") >= 0) {
                responseInfo.setContent(EntityUtils.toString((HttpEntity)entity));
            } else {
                this.abortReading(entity.getContent());
            }
            responseInfo = this.parseResponse(responseInfo);
        }
        catch (IOException | ParseException e) {
            LOGGER.error("the IOException or ParseException ", e);
        }
        finally {
            if (null != bufferedReader) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    LOGGER.error("bufferedReader close IOException", (Throwable)e);
                }
            }
        }
        return responseInfo;
    }

    public ResponseInfo parseResponse(ResponseInfo resp) {
        String content = resp.getContent();
        if (content == null || content.isEmpty()) {
            return resp;
        }
        JSONObject json = new JSONObject(content);
        JSONObject jsonData1 = json.getJSONObject("error");
        JSONObject jsonData = null;
        try {
            jsonData = json.getJSONObject("data");
            resp.getContentMap().put("errorCode", jsonData1.getLong("code"));
        }
        catch (JSONException e) {
            Iterator nameItr1 = jsonData1.keys();
            while (nameItr1.hasNext()) {
                String name = (String)nameItr1.next();
                resp.getContentMap().put(name, jsonData1.get(name));
            }
            if (!content.contains(LEFT_BRACKET) || !content.contains(RIGHT_BRACKET)) {
                LOGGER.info("no BRACKET return resp.");
                return resp;
            }
            String dataString = content.substring(content.indexOf(LEFT_BRACKET), content.lastIndexOf(RIGHT_BRACKET) + 1);
            if (dataString.isEmpty()) {
                return resp;
            }
            JSONArray jsonArray = new JSONArray(dataString);
            if (jsonArray.length() == 0) {
                return resp;
            }
            JSONObject firstJsonObject = jsonArray.getJSONObject(0);
            Iterator nameItr2 = firstJsonObject.keys();
            while (nameItr2.hasNext()) {
                String name1 = (String)nameItr2.next();
                resp.getContentMap().put(name1, firstJsonObject.get(name1));
            }
            return resp;
        }
        this.checkContentMap(resp, jsonData1, jsonData);
        return resp;
    }

    void checkContentMap(ResponseInfo resp, JSONObject jsonData1, JSONObject jsonData) {
        String name;
        Iterator nameItr = jsonData.keys();
        while (nameItr.hasNext()) {
            name = (String)nameItr.next();
            resp.getContentMap().put(name, jsonData.get(name));
        }
        Iterator nameItr1 = jsonData1.keys();
        while (nameItr1.hasNext()) {
            name = (String)nameItr1.next();
            resp.getContentMap().put(name, jsonData1.get(name));
        }
    }

    public ResponseInfo sendRequest(RequestInfo req) throws IOException {
        CloseableHttpResponse response = this.execRequest(req);
        HttpEntity entity = response.getEntity();
        ContentType contentType = ContentType.parse((CharSequence)entity.getContentType());
        String type = contentType == null ? "" : contentType.getMimeType();
        ResponseInfo respInfo = new ResponseInfo();
        respInfo.setHeaders(response.getHeaders());
        respInfo.setLocale(response.getLocale());
        respInfo.setStatusLine(new StatusLine((HttpResponse)response));
        respInfo.setContentType(type);
        if (null != type && type.contains("text")) {
            try {
                respInfo.setContent(EntityUtils.toString((HttpEntity)entity));
            }
            catch (ParseException e) {
                LOGGER.error("Parse response error.", (Throwable)e);
            }
        } else {
            this.abortReading(entity.getContent());
        }
        return respInfo;
    }

    public CloseableHttpResponse execRequest(RequestInfo req) throws IOException {
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Sending request to " + req.getUrl() + " ... ");
            }
            CloseableHttpResponse resp = this.httpClient.execute((ClassicHttpRequest)req.toHttpUriRequest());
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Received " + req.toHttpUriRequest().getMethod() + " response successfully from " + req.getUrl() + ".");
            }
            return resp;
        }
        catch (ClientProtocolException e) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Unsupported protocol: " + req.getUrl() + ".", (Throwable)e);
            }
            throw new UnsupProtocolException(e);
        }
        catch (IOException e) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Failed to receive response from " + req.getUrl() + ".", (Throwable)e);
            }
            throw e;
        }
    }

    private void abortReading(InputStream is) throws IOException {
        if (is instanceof EofSensorInputStream) {
            try {
                ((EofSensorInputStream)is).abort();
            }
            catch (Exception e) {
                LOGGER.error("Exception happened in :", (Throwable)e);
            }
            try {
                ((EofSensorInputStream)is).close();
            }
            catch (Exception e) {
                LOGGER.error("Exception happened in :", (Throwable)e);
            }
        }
    }

    public void close() {
        if (null != this.httpClient) {
            try {
                this.httpClient.close();
            }
            catch (IOException e) {
                LOGGER.error("HttpClient is closed error.", (Throwable)e);
            }
            this.sessionID = null;
        }
        LOGGER.info("HttpClient is closed successfully.");
    }

    private CloseableHttpClient getHttpsClient(DevNode devNode) throws NoSuchAlgorithmException, KeyManagementException, CertificateException, KeyStoreException {
        TrustManager[] trustManagerArray;
        SSLContext sslcontext = SSLContext.getInstance("TLSv1.2");
        if (devNode.isVerifyCertificate()) {
            trustManagerArray = MyTrustSslSocketFactoryTool.getMySslX509TrustManager((String)this.getCertPath());
        } else {
            TrustManager[] trustManagerArray2 = new TrustManager[1];
            trustManagerArray = trustManagerArray2;
            trustManagerArray2[0] = new SimpleTrustManager();
        }
        sslcontext.init(null, trustManagerArray, SecureRandom.getInstanceStrong());
        MyCustSSLSocketFactory socketFactory = new MyCustSSLSocketFactory(sslcontext, devNode);
        Registry socketFactoryRegistry = RegistryBuilder.create().register(URIScheme.HTTP.id, (Object)socketFactory).register(URIScheme.HTTPS.id, (Object)socketFactory).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry, PoolConcurrencyPolicy.STRICT, PoolReusePolicy.LIFO, TimeValue.NEG_ONE_MILLISECOND, null, null, null);
        connManager.setDefaultMaxPerRoute(20);
        connManager.setMaxTotal(50);
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectionRequestTimeout(Timeout.ofSeconds((long)300L)).setConnectTimeout(Timeout.ofSeconds((long)30L)).build();
        CloseableHttpClient httpent = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).setDefaultCredentialsProvider((CredentialsProvider)credsProvider).setRedirectStrategy((RedirectStrategy)new NoRedirectStrategy()).setDefaultRequestConfig(defaultRequestConfig).setRetryStrategy((HttpRequestRetryStrategy)new HttpSession.RetryStrategy(5, TimeValue.ofSeconds((long)1L))).setDefaultHeaders(Collections.singletonList(new BasicHeader("User-Agent", (Object)"Apache-HttpClient"))).build();
        return httpent;
    }

    private String getCertPath() {
        File certDir = new File(ApplicationContext.getInstance().getCurrWorkPath(), HttpsPropUtils.getCertFileDir());
        if (!certDir.exists() || !certDir.isDirectory()) {
            return "";
        }
        try {
            return certDir.getCanonicalPath();
        }
        catch (IOException e) {
            LOGGER.error("getCertPath error.");
            return "";
        }
    }

    private static class NoRedirectStrategy
    implements RedirectStrategy {
        private NoRedirectStrategy() {
        }

        public boolean isRedirected(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext) throws HttpException {
            return false;
        }

        public URI getLocationURI(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext) throws HttpException {
            return null;
        }
    }

    private static class SimpleTrustManager
    implements X509TrustManager {
        private SimpleTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

