/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.context;

import com.huawei.ism.tool.bizpack.wizardparse.factory.ConnectorFactory;
import com.huawei.ism.tool.bizpack.wizardparse.intf.GetUserInputImpl;
import com.huawei.ism.tool.bizpack.wizardparse.util.AESUtil;
import com.huawei.ism.tool.bizpack.wizardparse.util.BizPackageSceneUtils;
import com.huawei.ism.tool.bizpack.wizardparse.util.DevGraphUtils;
import com.huawei.ism.tool.bizpack.wizardparse.util.DevNodeUtil;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JythonContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(JythonContext.class);
    private DevNode devNode;
    private String lan;
    private String errMsg;
    private String suggestion;
    private boolean succ;
    private Map<String, Object> dict = new HashMap<String, Object>();
    private Map<String, Object> userOpData = new HashMap<String, Object>();

    public JythonContext() {
        this.dict = this.createSsEnv();
    }

    public void putDev(DevNode node) {
        this.getDict().put("dev", DevNodeUtil.getDevMapDict(node));
    }

    Map<String, Object> createSsEnv() {
        HashMap<String, Object> ssEnv = new HashMap<String, Object>();
        this.lan = this.getLanguage();
        ssEnv.put("devNode", this.devNode);
        ssEnv.put("oemModel", "");
        ssEnv.put("lan", this.lan);
        ssEnv.put("errMsg", this.errMsg);
        ssEnv.put("suggestion", this.suggestion);
        ssEnv.put("succ", this.succ);
        ssEnv.put("connectorFactory", ConnectorFactory.getInstance());
        ssEnv.put("isOem", ApplicationContext.getInstance().isOEM());
        ssEnv.put("userOpData", this.userOpData);
        StringBuilder tmpPath = new StringBuilder();
        tmpPath.append(ApplicationContext.getInstance().getWorkPath());
        tmpPath.append(File.separator);
        tmpPath.append(ApplicationContext.getInstance().getTmpPath());
        tmpPath.append(File.separator);
        tmpPath.append("scriptTmp");
        File tmpFile = new File(tmpPath.toString());
        if (!tmpFile.exists() && !tmpFile.mkdirs()) {
            LOGGER.error("create script tmp path err");
        }
        ssEnv.put("tmpPath", tmpPath.toString());
        ssEnv.put("sceneArgsJsonObj", BizPackageSceneUtils.getArgsJsonObj());
        return ssEnv;
    }

    private String getLanguage() {
        return LanguageManager.getInstance().getCurrentLanguage().getLanguage();
    }

    public void putExtUtil() {
        GetUserInputImpl dialogUtil = new GetUserInputImpl();
        this.dict.put("dialogUtil", dialogUtil);
        AESUtil aesUtil = new AESUtil();
        this.dict.put("AESUtil", aesUtil);
        this.dict.put("DevGraphUtils", DevGraphUtils.getInstance());
        this.dict.put("oemModel", this.devNode == null ? "" : this.devNode.getOemModel());
    }

    public void clearMsgData() {
        this.dict.put("errMsg", "");
        this.dict.put("suggestion", "");
        this.dict.put("confirmMsg", "");
        ArrayList<String> retDataKeyList = new ArrayList<String>();
        for (Map.Entry<String, Object> iterable : this.dict.entrySet()) {
            String key = iterable.getKey();
            if (!key.contains("retData")) continue;
            retDataKeyList.add(key);
        }
        for (String key : retDataKeyList) {
            this.dict.put(key, "");
        }
    }

    public DevNode getDevNode() {
        return this.devNode;
    }

    public void setDevNode(DevNode devNode) {
        this.devNode = devNode;
    }

    public String getLan() {
        return this.lan;
    }

    public void setLan(String lan) {
        this.lan = lan;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public String getSuggestion() {
        return this.suggestion;
    }

    public void setSuggestion(String suggestion) {
        this.suggestion = suggestion;
    }

    public boolean isSucc() {
        return this.succ;
    }

    public void setSucc(boolean succ) {
        this.succ = succ;
    }

    public Map<String, Object> getDict() {
        return this.dict;
    }

    public void setDict(Map<String, Object> dict) {
        this.dict = dict;
    }

    public Map<String, Object> getUserOpData() {
        return this.userOpData;
    }

    public void setUserOpData(Map<String, Object> userOpData) {
        this.userOpData = userOpData;
    }
}

