/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.dialog;

import com.huawei.ism.autotest.AutoProcessConfig;
import com.huawei.ism.autotest.AutoProcessListener;
import com.huawei.ism.autotest.AutoProcessObserver;
import com.huawei.ism.autotest.AutoProcessResult;
import com.huawei.ism.autotest.AutoProcessStatus;
import com.huawei.ism.autotest.IAutoProcess;
import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.base.ui.component.wizard.IHelpActionCallBack;
import com.huawei.ism.tool.base.ui.component.wizard.WizardRootPaneUI;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.entity.BizPackGroup;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.OpenHelpCallBack;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.SelectGroupWizardDialogLayout;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.settingdialog.SelectGroupWizardSettingDialog;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.settingdialog.SelectGroupWizardSettingShowConfig;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.settingdialog.SettingContentPanel;
import com.huawei.ism.tool.bizpack.wizardparse.util.BizPackageSceneUtils;
import com.huawei.ism.tool.bizpack.wizardparse.util.PackagesResource;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.framework.pubservice.common.devmanage.ISceneBean;
import com.huawei.ism.tool.framework.pubservice.entity.SceneValue;
import com.huawei.ism.tool.framework.pubservice.sceneimpl.SceneEnvironmentImpl;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.plaf.RootPaneUI;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectGroupWizardDialog
extends JDialog
implements IAutoProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectGroupWizardDialog.class);
    private static final long serialVersionUID = 6577109290462943645L;
    private static final int THIS_WEIGHT = 815;
    private static final int THIS_WEIGHT_EN = 835;
    private static final int FRUTYPE_DESC_HEIGHT = 70;
    private static final int FRU_HEIGHT = 29;
    private static final int ADD_HEIGHT_EN = 30;
    private static final int FIX_HEIGHT = 50;
    private static final int ONE_LINE_DESC = 16;
    private static final int MAX_WIDTH = 315;
    private static final String PNG = ".png";
    private SelectGroupWizardDialogLayout layout;
    private List<AutoProcessObserver> observers = new ArrayList<AutoProcessObserver>();
    private String help = "";

    public SelectGroupWizardDialog(Window parent) {
        super(parent);
        this.setModal(true);
        this.init();
        BizPackageContext.getInstance().setSelectProcessDialog(this);
        this.initWindowListener();
        WizardRootPaneUI rootPaneUI = new WizardRootPaneUI();
        this.checkShowHelp(rootPaneUI);
        rootPaneUI.setShowSetting(SelectGroupWizardSettingShowConfig.isShowSettingButton());
        BizPackageContext.getInstance().setCheckItemHandleSwitch(SettingContentPanel.ConfirmSwitch.OFF);
        BizPackageContext.getInstance().setCheckRiskPowerSwitch(SettingContentPanel.ConfirmSwitch.OFF);
        this.getRootPane().setUI((RootPaneUI)rootPaneUI);
        this.help = OpenHelpCallBack.getHelpPath();
        if (!this.help.trim().equals("")) {
            rootPaneUI.setHelpActionCallBack((IHelpActionCallBack)new OpenHelpCallBack(this, this.help));
        }
        rootPaneUI.setSettingAction((Action)new AbstractAction(){
            private static final long serialVersionUID = 8889811747630932827L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectGroupWizardSettingDialog settingDialog = new SelectGroupWizardSettingDialog(SelectGroupWizardDialog.this.getOwner());
                settingDialog.setSelectGroupWizardDialog(SelectGroupWizardDialog.this);
                settingDialog.setVisible(true);
            }
        });
    }

    public SelectGroupWizardDialogLayout getGroupDialogLayout() {
        return this.layout;
    }

    private void checkShowHelp(WizardRootPaneUI rootPaneUI) {
        try {
            ISceneBean baseScene = SceneEnvironmentImpl.getInstance().getEnvirValueByKey("jsonScene");
            if (!(baseScene instanceof SceneValue)) {
                return;
            }
            SceneValue sv = (SceneValue)baseScene;
            ToolLoggerFactory.getLogger(SelectGroupWizardDialog.class).info("processId is:" + sv.getSubScene());
            if (BizPackageSceneUtils.isFruEvalScene()) {
                rootPaneUI.setShowHelp(false);
            }
        }
        catch (ToolException e) {
            ToolLoggerFactory.getLogger(SelectGroupWizardDialog.class).error("getEnvirValueByKey fail");
        }
    }

    private void init() {
        this.setDefaultCloseOperation(2);
        this.validate();
        String toolName = BizPackageContext.getInstance().getCurToolName();
        PackagesResource util = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
        if (BizPackageContext.getInstance().isSelfDefine()) {
            this.setIconImage(BizPackageContext.getInstance().getMultiModeRuningImg().getImage());
            String titleKey = BizPackageContext.getInstance().getMainDialogTitle();
            String title = util.getString(titleKey);
            this.setTitle(title);
        } else {
            this.setIconImage(ResourceUtil.getImage(toolName + PNG).getImage());
            String titleKey = BizPackageSceneUtils.isFruEvalScene() ? "fru.eval.title" : toolName + ".title";
            this.setTitle(ResourceUtil.getString(titleKey));
        }
        UiMethod.setComponentSize((Dimension)this.getThisSize(), (Component[])new Component[]{this});
        this.layout = new SelectGroupWizardDialogLayout();
        this.add(this.layout);
        this.setResizable(false);
        this.setModal(true);
    }

    private void initWindowListener() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                WarningDialog wdialog = DialogUtils.createWarningDialog((JDialog)SelectGroupWizardDialog.this, (String)ResourceUtil.getString("bizpackage.desc.quite"));
                if (0 == wdialog.getValue()) {
                    BizPackageContext.getInstance().setCheckItemHandleSwitch(SettingContentPanel.ConfirmSwitch.OFF);
                    BizPackageContext.getInstance().saveUserOpData();
                    String toolId = BizPackageContext.getInstance().getCurToolName();
                    BizPackageSceneUtils.finishedScene(toolId);
                    ApplicationContext.getInstance().fireToolStopped(toolId);
                }
            }
        });
        this.addComponentListener((ComponentListener)new AutoProcessListener((IAutoProcess)this));
        new AutoProcessObserver((IAutoProcess)this);
    }

    private Dimension getThisSize() {
        int seperatorNum = 0;
        List<BizPackGroup> groups = BizPackageContext.getInstance().getCurBizPackage().getGroupList();
        boolean buildHorizotalReadyFlag = false;
        BizPackGroup leftGroup = null;
        int height = 0;
        for (BizPackGroup bizPackGroup : groups) {
            if (bizPackGroup.isSeperator()) {
                if (buildHorizotalReadyFlag) {
                    height += this.countOneGroupHeight(leftGroup);
                }
                buildHorizotalReadyFlag = false;
                ++seperatorNum;
                continue;
            }
            if (buildHorizotalReadyFlag) {
                height += this.countOneLineGroupHeight(leftGroup, bizPackGroup);
                buildHorizotalReadyFlag = false;
                continue;
            }
            buildHorizotalReadyFlag = true;
            leftGroup = bizPackGroup;
        }
        if (buildHorizotalReadyFlag) {
            height += this.countOneGroupHeight(leftGroup);
        }
        int allseperatorHeight = 29 * seperatorNum;
        int layHeight = height + allseperatorHeight + 40;
        int layWeight = 815;
        if (LanguageManager.getInstance().getCurrentLanguage().equals(Locale.ENGLISH)) {
            layHeight += 30;
            layWeight = 835;
        }
        if (groups.size() <= 4) {
            layHeight += 50;
        }
        return new Dimension(layWeight, layHeight);
    }

    private int countOneLineGroupHeight(BizPackGroup left, BizPackGroup right) {
        int rightSize;
        int leftSize = this.countOneGroupHeight(left);
        return leftSize > (rightSize = this.countOneGroupHeight(right)) ? leftSize : rightSize;
    }

    private int countOneGroupHeight(BizPackGroup group) {
        PackagesResource util = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
        int descHeight = this.countExtDescHeight(util.getString(group.getDescription()));
        return (group.getBizWizardCfg().size() / 2 + group.getBizWizardCfg().size() % 2) * 29 + 70 + descHeight - 16;
    }

    private int countExtDescHeight(String desc) {
        JLabel lbl = new JLabel("<html>" + desc + "</html>");
        View view = BasicHTML.createHTMLView(lbl, lbl.getText());
        view.setSize(315.0f, 2.1474836E9f);
        return (int)view.getMinimumSpan(1);
    }

    public void onStepDialogDisplayed() {
        AutoProcessResult.getInstance().overwrite("\u5907\u4ef6\u66f4\u6362\u81ea\u52a8\u5316\u6d41\u7a0b");
        List processList = AutoProcessConfig.getInstance().getProcessList();
        for (String fruProcess : processList) {
            AutoProcessConfig.getInstance().setCurrentProcess(fruProcess);
            this.clickFruLink(fruProcess);
        }
        this.notifyObserver(AutoProcessStatus.SUCCESS);
    }

    private void clickFruLink(String fruProcess) {
        for (ToolHyperLinkLabel title : this.layout.getFruTitleList()) {
            if (!fruProcess.equalsIgnoreCase(title.getText())) continue;
            AutoProcessResult.getInstance().append(String.format(Locale.ROOT, "%s----process: %s", System.lineSeparator(), fruProcess));
            title.getClickListener().clickLink(null);
            return;
        }
    }

    public void onStepFinished(AutoProcessStatus status) {
        if (AutoProcessResult.getInstance().isAutoProcessSuccess()) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }

    public void addObserver(AutoProcessObserver observer) {
        this.observers.add(observer);
    }

    public void notifyObserver(AutoProcessStatus status) {
        for (AutoProcessObserver observer : this.observers) {
            observer.processStatus(status);
        }
    }
}

