/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.step.doitem;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.huawei.ism.autotest.AutoProcessConfig;
import com.huawei.ism.autotest.AutoProcessItem;
import com.huawei.ism.autotest.AutoProcessResult;
import com.huawei.ism.autotest.AutoProcessStatus;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.flow.IStep;
import com.huawei.ism.tool.base.flow.ui.IFlowUIState;
import com.huawei.ism.tool.base.ui.task.ServiceTask;
import com.huawei.ism.tool.base.ui.task.ServiceTaskExecutor;
import com.huawei.ism.tool.base.ui.task.TaskResult;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardCardLayout;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardDialog;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardState;
import com.huawei.ism.tool.base.ui.wizard.GuideFlowWizardDialog;
import com.huawei.ism.tool.base.ui.wizard.Navigation;
import com.huawei.ism.tool.base.utils.DateUtil;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.entity.BizStepConfig;
import com.huawei.ism.tool.bizpack.wizardparse.entity.ProcessStepType;
import com.huawei.ism.tool.bizpack.wizardparse.entity.item.Item;
import com.huawei.ism.tool.bizpack.wizardparse.entity.item.ItemResult;
import com.huawei.ism.tool.bizpack.wizardparse.intf.IDevgGraphInit;
import com.huawei.ism.tool.bizpack.wizardparse.task.DoItemsTask;
import com.huawei.ism.tool.bizpack.wizardparse.task.ExecPyScriptTask;
import com.huawei.ism.tool.bizpack.wizardparse.task.ExecPyUtils;
import com.huawei.ism.tool.bizpack.wizardparse.task.TaskManager;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.settingdialog.SelectGroupWizardSettingShowConfig;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.waitdialog.CompileAndExecOnePyFuncWaitDialog;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.waitdialog.WaitDialogResult;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.AbstractBizStep;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.DoItemsUiObserver;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.doitem.DoItemStepCfg;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.doitem.DoItemStepLayout;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.doitem.DoItemType;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.doitem.comp.ConfirmBord;
import com.huawei.ism.tool.bizpack.wizardparse.util.BasicDeviceInfo;
import com.huawei.ism.tool.bizpack.wizardparse.util.BizPackageSceneUtils;
import com.huawei.ism.tool.bizpack.wizardparse.util.CheckItem;
import com.huawei.ism.tool.bizpack.wizardparse.util.ConfirmBordUtil;
import com.huawei.ism.tool.bizpack.wizardparse.util.PackagesResource;
import com.huawei.ism.tool.bizpack.wizardparse.util.ReportBuilder;
import com.huawei.ism.tool.framework.platform.common.data.UserOpTaskResult;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.sceneimpl.SceneEnvironmentImpl;
import com.huawei.ism.tool.obase.connection.support.ConnUtils;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.util.UCD;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoItemStep
extends AbstractBizStep
implements DoItemsUiObserver,
IDevgGraphInit {
    private static final Logger LOGGER = LoggerFactory.getLogger(DoItemStep.class);
    public static final String SCENE_CHM_RECORD_CLOSE_DATA = "5";
    private static final String SUGGESTION_KEYWORD = "fru.report.suggestion.keyword";
    private DoItemStepLayout layout;
    private String scriptPath = "";
    private DoItemStepCfg cfg;
    private DoItemsTask itemTask;
    private List<Item> items;
    private int curItemIndex;
    private boolean showPro;
    private boolean showLeftTime;
    private DoItemType type;
    private boolean finish = true;
    private boolean isAllPass = true;
    private String pyName = "";
    private String preScriptPath = "";
    private ExecPyScriptTask confirmTask;
    private PackagesResource resource = BizPackageContext.getInstance().getCurBizPackage().getResUtil();

    private void reDetectPerform() {
        this.finish = false;
        this.layout.getBtnReDetect().setEnabled(false);
        this.layout.clearResultInfo();
        this.layout.setStatusPanelEnable(this.cfg.isShowPro(), this.cfg.isShowLeftTime());
        this.layout.updateUI();
        if (this.cfg.isFailedCheckAll()) {
            this.initAllItemWait();
        }
        this.autoExecItem();
    }

    private void ignorePerform(Item item) {
        this.setResultType(true, item);
        this.finish = false;
        this.layout.getBtnReDetect().setEnabled(false);
        this.layout.clearResultInfo();
        this.layout.setStatusPanelEnable(this.cfg.isShowPro(), this.cfg.isShowLeftTime());
        this.layout.updateUI();
        this.buildItemTask();
    }

    private void buildItemTask() {
        this.itemTask = new DoItemsTask(this.items, this, this.scriptPath, this.curItemIndex + 1);
        TaskManager.submitTask(this.itemTask);
        if (this.showPro) {
            new QueryProgressTask().start();
        }
        if (this.showLeftTime) {
            new QueryRemainTimeTask().start();
        }
        Thread updateUiTask = new Thread(new UpdateUITask());
        AsyncExcutor.submit((Runnable)updateUiTask);
    }

    public DoItemStepLayout getUILayout() {
        return this.layout;
    }

    protected FlowWizardCardLayout getLayout() {
        return this.layout;
    }

    @Override
    protected IFlowUIState getInitUIState() {
        FlowWizardState tmpState = this.getUIState(false, false);
        if (this.type.equals((Object)DoItemType.CONFIRM_CHECK)) {
            tmpState = this.getUIState(false, super.isBackwardAbs());
        }
        return tmpState;
    }

    protected boolean init() {
        this.setCurStepID();
        ProgressDialog progressDialog = new ProgressDialog(this.getParentWindow());
        ServiceTaskExecutor taskExecutor = new ServiceTaskExecutor(progressDialog);
        TaskResult taskResult = taskExecutor.execute((ServiceTask)new InitStepTask());
        if (taskResult != null && taskResult.getResult() == TaskResult.Result.FAILED) {
            DialogUtils.showErrorDialog((Window)this.getParentWindow(), (String)taskResult.getErrorLocaleDescription());
            if (!this.type.equals((Object)DoItemType.CONFIRM_CHECK)) {
                this.initAllItem();
                this.autoExecItem();
            }
        }
        return true;
    }

    private TaskResult initStep() {
        TaskResult taskResult;
        this.initByConfig(BizPackageContext.getInstance().getCurBizWizardCfg().getStepsById(this.getId()));
        this.setAllStageNum();
        super.setIndex(this.getStageIndex());
        this.curItemIndex = 0;
        this.layout.setStatusPanelEnable(this.cfg.isShowPro(), this.cfg.isShowLeftTime());
        List<ConfirmBord> confirmBordList = this.cfg.getConfirmBoardList();
        for (ConfirmBord bord : confirmBordList) {
            this.confirmBordInitData(bord);
            bord.getConfirmButton().setEnabled(true);
        }
        this.finish = true;
        this.layout.getListModel().removeAllElements();
        this.layout.clearUI();
        this.layout.setCurrentStatusTxt(ResourceUtil.getString("expansion.wizard.init"));
        this.layout.setCurrentLeftTime("");
        this.layout.setCurrentLeftTimeDes("");
        this.layout.setCurrentProgress("");
        if (this.type.equals((Object)DoItemType.CONFIRM_CHECK)) {
            return new TaskResult(TaskResult.Result.SUCCESS);
        }
        if (BizPackageContext.getInstance().getCurBizWizardCfg().getStepsById(this.getId()).isNeedDeviceGraph() && TaskResult.Result.FAILED == (taskResult = this.initDevGraph()).getResult()) {
            return taskResult;
        }
        this.clearList();
        this.initAllItem();
        this.autoExecItem();
        return new TaskResult(TaskResult.Result.SUCCESS);
    }

    private void clearList() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("the step title:" + this.cfg.getTitle());
        }
        while (this.layout.getListModel().size() != 0) {
            this.layout.getListModel().removeAllElements();
        }
    }

    private void autoExecItem() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("autoExecItem items num = " + this.items.size());
        }
        this.finish = false;
        this.setRunningUiStatus();
        this.layout.setCurrentLeftTime("");
        this.layout.setCurrentLeftTimeDes("");
        this.layout.setCurrentProgress("");
        this.layout.getErrMsg().clear();
        super.getSsEnv().getDict().put("remainTime", null);
        super.getSsEnv().getDict().put("curProgressPer", null);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("failedCheckAll:" + this.cfg.isFailedCheckAll());
        }
        this.itemTask = this.cfg.isFailedCheckAll() ? new DoItemsTask(this.items, this, this.scriptPath, 0) : new DoItemsTask(this.items, this, this.scriptPath, this.curItemIndex);
        TaskManager.submitTask(this.itemTask);
        if (this.showPro) {
            new QueryProgressTask().start();
        }
        if (this.showLeftTime) {
            new QueryRemainTimeTask().start();
        }
        Thread updateUiTask = new Thread(new UpdateUITask());
        AsyncExcutor.submit((Runnable)updateUiTask);
    }

    private synchronized void initAllItem() {
        for (Item item : this.items) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("item id..:" + item.getId() + "item title..:" + item.getTitle());
            }
            item.setResult(ItemResult.WAITING);
            item.setDate("--");
            this.layout.getListModel().addElement(item);
        }
        this.layout.getItemList().updateUI();
        this.layout.getItemList().repaint();
    }

    private void initAllItemWait() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Item item : DoItemStep.this.items) {
                    item.setResult(ItemResult.WAITING);
                    item.setDate("--");
                }
            }
        });
    }

    public boolean ending() {
        if (BizPackageSceneUtils.isScene() && BizPackageSceneUtils.isFruEvalScene()) {
            BizPackageContext.getInstance().getBizpackageUserOpData().setTaskEndTime(DateUtil.toBeiJingTimeMillis(new Date()));
            BizPackageContext.getInstance().getBizpackageUserOpData().setTaskResult(UserOpTaskResult.SUCCESS);
            BizPackageContext.getInstance().saveJythonUserOpData();
            BizPackageContext.getInstance().saveOneUserOpData();
            BizPackageContext.getInstance().saveUserOpData();
            String result = this.isAllPass ? "SUCCESS" : "FAILED";
            BizPackageSceneUtils.putResult(result);
            String toolId = BizPackageContext.getInstance().getCurToolName();
            BizPackageSceneUtils.finishedScene(toolId);
            ApplicationContext.getInstance().fireToolStopped(toolId);
        }
        return true;
    }

    public boolean flowExiting() {
        if (!this.finish) {
            DialogUtils.showInfoDialog((Window)this.getParentWindow(), (String)ResourceUtil.getString("bizpackage.error.doitem.scriptrunning"));
            return false;
        }
        return this.cancel();
    }

    @Override
    public void initByConfig(BizStepConfig stepConfig) {
        this.scriptPath = this.getScriptPath();
        super.getSsEnv().getDict().put("importRootDir", this.scriptPath);
        if (stepConfig instanceof DoItemStepCfg) {
            this.cfg = (DoItemStepCfg)stepConfig;
            this.initLayout(this.cfg);
            this.items = this.cfg.getCheckItem();
            super.setParamAbs(this.cfg.getParam());
            super.setBackwardAbs(this.cfg.isBackward());
            if (this.cfg.getType().equals((Object)ProcessStepType.CHECK)) {
                this.type = DoItemType.CHECK;
            } else if (this.cfg.getType().equals((Object)ProcessStepType.EXEC_SETTING)) {
                this.type = DoItemType.EXEC;
                this.layout.getBtnReDetect().setText(ResourceUtil.getString("expansion.btn.reexec"));
                UCD.formatMnemonicDisplay((AbstractButton)this.layout.getBtnReDetect());
            } else if (this.cfg.getType().equals((Object)ProcessStepType.CONFIRM_REPLACED)) {
                this.type = DoItemType.CONFIRM_CHECK;
            }
            super.setCancelScriptAbs(this.cfg.getCancelScript());
            this.showLeftTime = this.cfg.isShowLeftTime();
            this.showPro = this.cfg.isShowPro();
            this.layout.setStatusPanel(this.showPro, this.showLeftTime);
            List<ConfirmBord> bords = this.cfg.getConfirmBoardList();
            this.pyName = this.cfg.getScriptFile();
            this.preScriptPath = this.getScriptPath();
            if (!bords.isEmpty()) {
                for (ConfirmBord bord : bords) {
                    this.initConfirmBordListener(bord);
                    if (!LOGGER.isInfoEnabled()) continue;
                    LOGGER.info("int bord listener" + bord);
                }
                this.layout.buildConfirmBord(bords, this.cfg);
            }
            this.setDocLinkParentWindow(this.cfg);
        }
    }

    @Override
    public TaskResult initDevGraph() {
        if (!ExecPyUtils.execInitScript(BizPackageContext.getInstance().getCurBizWizardCfg().getStepsById(this.getId()).getScriptFile(), this.getParamAbs(), "initDevGraph")) {
            TaskResult result = new TaskResult(TaskResult.Result.FAILED);
            String errorMsg = ResourceUtil.getString("bizpackage.error.preset.execscriptfailed");
            result.setErrorLocaleDescription(errorMsg);
            return result;
        }
        return this.getDevGraphExecResult();
    }

    private void initLayout(DoItemStepCfg initCfg) {
        this.layout = new DoItemStepLayout(initCfg);
        this.operators.clear();
        this.operators.add(this.layout.getBtnReDetect());
        this.layout.getBtnReDetect().setEnabled(false);
        this.layout.getBtnReDetect().addActionListener(new ReDetectActionLisnener());
        if (SelectGroupWizardSettingShowConfig.isShowHandleButton()) {
            this.operators.add(this.layout.getHandleItemNoPassBtn());
            this.layout.getHandleItemNoPassBtn().setEnabled(false);
            this.layout.getHandleItemNoPassBtn().addActionListener(this::handleExceptionActionPerformed);
        }
    }

    private void handleExceptionActionPerformed(ActionEvent event) {
        WarningDialog warningDialog = DialogUtils.showWarnConfirmDialog((Window)this.getParentWindow(), (String)ResourceUtil.getString("bizpack.wizard.doitem.warn.hand.exception"), (String)ResourceUtil.getString("bizpack.select.comfirm.dlg.checkbox"));
        if (0 == warningDialog.getValue()) {
            boolean onceCheckAll;
            BizStepConfig stepConfig = BizPackageContext.getInstance().getCurBizWizardCfg().getStepsById(BizPackageContext.getInstance().getCurStepId());
            boolean bl = onceCheckAll = stepConfig != null ? stepConfig.isOnceCheckAll() : false;
            if (onceCheckAll) {
                LOGGER.info("onceCheckAll. handle the noPass checkItem.");
                this.activatedNext();
            } else {
                LOGGER.info("handle one failed item {}", (Object)this.items.get(this.curItemIndex).toString());
                this.clearUIAndEnv();
                this.exeTaskAfterFailedItem();
            }
        }
    }

    private void activatedNext() {
        switch (this.cfg.getBackaftersuc()) {
            case ENABLE: {
                this.setStatus(true, true);
                break;
            }
            case DISABLE: {
                this.setStatus(true, false);
                break;
            }
            case NOT_SET: {
                this.chgWizState(true);
                break;
            }
        }
    }

    private void clearUIAndEnv() {
        this.finish = false;
        this.setRunningUiStatus();
        this.layout.setCurrentLeftTime("");
        this.layout.setCurrentLeftTimeDes("");
        this.layout.setCurrentProgress("");
        this.layout.getErrMsg().clear();
        this.layout.clearResultInfo();
        super.getSsEnv().getDict().put("remainTime", null);
        super.getSsEnv().getDict().put("curProgressPer", null);
    }

    private void exeTaskAfterFailedItem() {
        this.buildItemTask();
    }

    private void initConfirmBordListener(ConfirmBord bord) {
        this.removeAllConfirmBtnListener(bord);
        bord.getConfirmButton().addActionListener(new ConfirmBordListener(bord));
    }

    private void removeAllConfirmBtnListener(ConfirmBord bord) {
        ActionListener[] lsts;
        for (ActionListener actionListener : lsts = bord.getConfirmButton().getActionListeners()) {
            bord.getConfirmButton().removeActionListener(actionListener);
        }
    }

    private boolean confirmData(ConfirmBord bord) {
        this.confirmTask.execFunc("confirm", super.getParamAbs());
        Object confirm = super.getSsEnv().getDict().get("confirmMsg");
        if (null != confirm && "default".equals(((String)confirm).trim())) {
            return true;
        }
        if (null == confirm || "".equals(((String)confirm).trim())) {
            DialogUtils.showInfoDialog((Window)this.getParentWindow(), (String)ResourceUtil.getString("bizpackage.error.doitem.scriptexecerr"));
            return false;
        }
        Window parentWindows = this.getParentWindow();
        if (parentWindows instanceof JDialog) {
            WarningDialog wdialog = DialogUtils.createWarningDialog((JDialog)((JDialog)parentWindows), (String)((String)confirm));
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("getParentWindow = " + this.getParentWindow().getClass());
            }
            if (0 == wdialog.getValue()) {
                this.refreshConfirmBord(bord);
                return true;
            }
        }
        return false;
    }

    private void refreshConfirmBord(ConfirmBord bord) {
        Object retData;
        this.confirmTask.execFunc("refresh", super.getParamAbs());
        boolean succ = (Boolean)super.getSsEnv().getDict().get("succ");
        if (!succ) {
            bord.getConfirmButton().setEnabled(true);
        }
        if (null == (retData = super.getSsEnv().getDict().get("retData"))) {
            return;
        }
        String json = (String)retData;
        if (StringUtils.isNULLStr(json)) {
            return;
        }
        bord.getInfoBord().setTextData(json, this.cfg.isNeedDeviceGraph());
    }

    private void confirmBordInitData(final ConfirmBord bord) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BizPackageContext.getInstance().getJythonContext().clearMsgData();
                Window parent = DoItemStep.this.getParentWindow();
                List fs = AsyncExcutor.execute((Window)parent, (Callable[])new Callable[]{new CompileAndExecOnePyFuncWaitDialog(DoItemStep.this.preScriptPath, DoItemStep.this.pyName, "initData", DoItemStep.this.getParamAbs())});
                WaitDialogResult result = (WaitDialogResult)fs.get(0);
                if (!WaitDialogResult.handleResult(DoItemStep.this.getParentWindow(), result)) {
                    return;
                }
                DoItemStep.this.confirmTask = result.getTask();
                if (null == DoItemStep.this.confirmTask) {
                    DialogUtils.showErrorDialog((Window)DoItemStep.this.getParentWindow(), (String)ResourceUtil.getString("bizpackage.error.preset.scriptinitfailed"));
                    return;
                }
                if (!((Boolean)DoItemStep.this.getSsEnv().getDict().get("succ")).booleanValue()) {
                    String errText = (String)DoItemStep.this.getSsEnv().getDict().get("errMsg");
                    DialogUtils.showErrorDialog((Window)DoItemStep.this.getParentWindow(), (String)errText);
                    return;
                }
                Object retData = DoItemStep.this.getSsEnv().getDict().get("retData");
                if (null == retData) {
                    return;
                }
                String json = (String)retData;
                DoItemStep.this.getSsEnv().getDict().put("curData", retData);
                bord.getInfoBord().setTextData(json, DoItemStep.this.cfg.isNeedDeviceGraph());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        IStep currentStep = BizPackageContext.getInstance().getCurrentStep();
                        if (currentStep != null && currentStep instanceof DoItemStep) {
                            ((DoItemStep)currentStep).notifyObserver(AutoProcessStatus.DISPLAY);
                        }
                    }
                });
            }
        });
    }

    @Override
    public void refreshItemLoading(final Item item, final int curIndex) {
        item.setResult(ItemResult.LOADING);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("refresh item.....:" + item.getTitle());
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    LOGGER.info("refresh item1.....");
                    DoItemStep.this.layout.getListModel().setElementAt(item, curIndex);
                    DoItemStep.this.layout.getItemList().updateUI();
                    DoItemStep.this.layout.getItemList().repaint();
                }
                catch (Exception e) {
                    LOGGER.error("refresh item1 error....", (Throwable)e);
                    DoItemStep.this.retryRefreshItems(item, curIndex);
                }
            }
        });
    }

    private void retryRefreshItems(Item item, int curIndex) {
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Retry refresh item1....." + item);
            }
            this.layout.getListModel().setElementAt(item, curIndex);
            this.layout.getItemList().updateUI();
            this.layout.getItemList().repaint();
        }
        catch (Exception e) {
            LOGGER.error("refresh item1 error....", (Throwable)e);
        }
    }

    @Override
    public void fireException(Exception e, Item item, int curIndex) {
        BizStepConfig stepConfig = BizPackageContext.getInstance().getCurBizWizardCfg().getStepsById(BizPackageContext.getInstance().getCurStepId());
        boolean onceCheckAll = stepConfig != null ? stepConfig.isOnceCheckAll() : false;
        this.setResultType(false, item);
        ArrayList<String> msgs = new ArrayList<String>();
        msgs.add("failed");
        String errMsg = "";
        String suggestion = "";
        if (e instanceof FileNotFoundException) {
            errMsg = ResourceUtil.getString("bizpackage.error.doitem.scriptfilenotfound");
            suggestion = ResourceUtil.getString("bizpackage.error.doitem.scriptfilenotfound.suggestion");
        } else if (e instanceof SignException) {
            errMsg = ResourceUtil.getString("bizpackage.error.doitem.scriptfile.notsigned");
            suggestion = ResourceUtil.getString("bizpackage.error.doitem.scriptfile.notsigned.suggestion");
        } else {
            errMsg = ResourceUtil.getString("bizpackage.error.doitem.scriptexecerr");
            suggestion = ResourceUtil.getString("bizpackage.error.doitem.scriptexecerr.suggestion");
        }
        msgs.add(errMsg);
        msgs.add(suggestion);
        if (onceCheckAll) {
            this.layout.getErrMsg().put(curIndex, msgs);
        }
        item.setReason(errMsg);
        item.setSuggest(suggestion);
        this.layout.showResultInfo(msgs);
        this.finishRemainTime();
        this.finishPro();
        this.layout.setStatusPanelEnable(false, false);
        this.layout.setCurrentDesc("", this.showLeftTime);
        this.setCurrentStatusTxt(item.getTitleRes(this.resource) + ResourceUtil.getStringWithParams("expansion.wizard.doitem.failed", " "));
        this.layout.getBtnReDetect().setEnabled(true);
        this.chgWizState(false);
        this.finish = true;
        this.curItemIndex = curIndex;
        this.notifyObserver(AutoProcessStatus.FAILURE);
    }

    private boolean isFinished() {
        if (this.finish) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOGGER.error("sleep interrupt exception.");
            }
            LOGGER.info("task is finished, after 1 second value={}", (Object)this.finish);
            return this.finish;
        }
        return false;
    }

    @Override
    public void fireFinish(final Item item, final int curIndex) {
        boolean ignoreFlag;
        BizStepConfig stepConfig = BizPackageContext.getInstance().getCurBizWizardCfg().getStepsById(BizPackageContext.getInstance().getCurStepId());
        boolean onceCheckAll = stepConfig != null ? stepConfig.isOnceCheckAll() : false;
        String errMsg = (String)super.getSsEnv().getDict().get("errMsg");
        String suggestion = (String)super.getSsEnv().getDict().get("suggestion");
        Boolean successful = (Boolean)super.getSsEnv().getDict().get("succ");
        boolean bl = ignoreFlag = super.getSsEnv().getDict().get("ignoreFlag") != null && (Boolean)super.getSsEnv().getDict().get("ignoreFlag") != false;
        if (successful.booleanValue()) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("succ......" + curIndex);
            }
            this.setResultType(true, item);
        } else if (onceCheckAll) {
            this.setResultType(false, item);
            List<String> msgs = this.setFailInfo(item, errMsg, suggestion);
            this.layout.getErrMsg().put(curIndex, msgs);
        } else {
            this.setResultType(false, item);
            List<String> msgs = this.setFailInfo(item, errMsg, suggestion);
            this.layout.showResultInfo(msgs, ignoreFlag);
            this.layout.getBtnReDetect().setEnabled(true);
            this.layout.getHandleItemNoPassBtn().setEnabled(true);
            this.chgWizState(false);
            this.layout.setStatusPanelEnable(false, false);
            this.layout.setCurrentDesc("", this.showLeftTime);
            this.setCurrentStatusTxt(item.getTitleRes(this.resource) + ResourceUtil.getStringWithParams("expansion.wizard.doitem.failed", " "));
            this.finish = true;
            this.notifyObserver(AutoProcessStatus.FAILURE);
        }
        if (ignoreFlag) {
            this.layout.getIgnoreBtn().addActionListener(new IgnoreActionLisnener(item));
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LOGGER.info("fireInvokelater.....");
                DoItemStep.this.layout.getListModel().setElementAt(item, curIndex);
                DoItemStep.this.layout.getItemList().updateUI();
                DoItemStep.this.layout.getItemList().repaint();
                DoItemStep.this.curItemIndex = curIndex;
            }
        });
    }

    private List<String> setFailInfo(Item item, String errMsg, String suggestion) {
        ArrayList<String> msgs = new ArrayList<String>();
        msgs.add("failed");
        msgs.add(errMsg);
        msgs.add(suggestion);
        item.setReason(errMsg);
        item.setSuggest(suggestion);
        return msgs;
    }

    private String getTime(int minutes, int seconds) {
        SimpleDateFormat fo = new SimpleDateFormat("HH:mm:ss");
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, minutes);
        cal.set(13, seconds);
        return fo.format(cal.getTime());
    }

    @Override
    public void setCurrentStatusTxt(String txt) {
        this.layout.setCurrentStatusTxt(txt);
    }

    @Override
    public void setCurrentStatusIcon(ImageIcon icon) {
        this.layout.setCurrentStatusIcon(icon);
    }

    private void setResultType(boolean succ, Item item) {
        if (succ) {
            if (this.type.equals((Object)DoItemType.CHECK)) {
                item.setResult(ItemResult.PASS);
            } else if (this.type.equals((Object)DoItemType.EXEC)) {
                item.setResult(ItemResult.SUCCEED);
            } else if (this.type.equals((Object)DoItemType.CONFIRM_CHECK)) {
                item.setResult(ItemResult.PASS);
            }
        } else if (this.type.equals((Object)DoItemType.CHECK)) {
            item.setResult(ItemResult.NOT_PASS);
        } else if (this.type.equals((Object)DoItemType.EXEC)) {
            item.setResult(ItemResult.FAILED);
        } else if (this.type.equals((Object)DoItemType.CONFIRM_CHECK)) {
            item.setResult(ItemResult.NOT_PASS);
        }
    }

    public void buildReport(boolean isAllPass) {
        if (!BizPackageSceneUtils.isFruEvalScene()) {
            return;
        }
        try {
            LOGGER.info("start build html report.");
            String sceneDir = SceneEnvironmentImpl.getInstance().getSceneDir();
            if (StringUtils.isNULLStr(sceneDir)) {
                LOGGER.error("scene path get error");
                return;
            }
            DevNode curDevice = BizPackageContext.getInstance().getCurDevice();
            String outFilePath = sceneDir + File.separator + FileUtils.formatIpForPath((String)curDevice.getIp()) + System.currentTimeMillis();
            ReportBuilder reportBuilder = new ReportBuilder(outFilePath);
            HashMap<String, Object> data = new HashMap<String, Object>();
            this.buildHtmlReportData(data);
            if (!reportBuilder.buildHtmlList(data)) {
                LOGGER.error("build html list error");
            }
            reportBuilder.copyHtmlResource();
            reportBuilder.buildLogInfo();
        }
        catch (RuntimeException e) {
            LOGGER.error("buildReport error", (Throwable)e);
        }
    }

    private void buildHtmlReportData(Map<String, Object> data) {
        BasicDeviceInfo basicDeviceInfo = this.buildBasicDeviceInfo();
        basicDeviceInfo.setResult(this.layout.getErrMsg().isEmpty() ? "pass" : "fail");
        data.put("basicDeviceInfo", basicDeviceInfo);
        List<CheckItem> checkItems = this.buildCheckLitInfo();
        data.put("checkList", checkItems);
        data.put("genneratedate", basicDeviceInfo.getCollectionTime());
        data.put("toolversion", UserOpDataSaveUtil.getToolIniProp("tool.version"));
        data.put("toolBoxVersion", UserOpDataSaveUtil.getToolBoxIniProp("app.version"));
        ArrayList<BasicDeviceInfo> basicDeviceInfos = new ArrayList<BasicDeviceInfo>();
        basicDeviceInfos.add(basicDeviceInfo);
        data.put("deviceInformation", basicDeviceInfos);
        data.put("totalDeviceNumber", this.items.size());
        data.put("passDeviceNumber", this.items.size() - this.layout.getErrMsg().size());
        data.put("notPassDeviceNumber", this.layout.getErrMsg().size());
        data.put("optimizeDeviceNumber", "0");
    }

    private List<CheckItem> buildCheckLitInfo() {
        ArrayList<CheckItem> checkItems = new ArrayList<CheckItem>();
        PackagesResource resUtil = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
        Map<Integer, List<String>> errMsg = this.layout.getErrMsg();
        for (int i = 0; i < this.items.size(); ++i) {
            Item item = this.items.get(i);
            CheckItem checkItem = new CheckItem();
            checkItem.setName(item.getTitleRes(resUtil));
            checkItem.setResult(item.getResult().getKey());
            if (!"pass".equals(item.getResult().getKey())) {
                List<String> errStrings = errMsg.get(i);
                String keyWord = ResourceUtil.getStringWithParams(SUGGESTION_KEYWORD, new Object[0]);
                if (StringUtils.isNULLStr(errStrings.get(2)) && errStrings.get(1).contains(keyWord)) {
                    String[] parts = errStrings.get(1).split(keyWord);
                    checkItem.setErrorInfo(parts[0]);
                    checkItem.setRepairSuggestion(keyWord + parts[1]);
                } else {
                    checkItem.setErrorInfo(errStrings.get(1));
                    checkItem.setRepairSuggestion(errStrings.size() > 2 ? errStrings.get(2) : "");
                }
            }
            checkItems.add(checkItem);
        }
        return checkItems;
    }

    private BasicDeviceInfo buildBasicDeviceInfo() {
        DevNode curDevice = BizPackageContext.getInstance().getCurDevice();
        BasicDeviceInfo basicDeviceInfo = new BasicDeviceInfo();
        basicDeviceInfo.setId(this.getLocation());
        basicDeviceInfo.setDeviceModel(curDevice.getDeviceType().toString());
        basicDeviceInfo.setDeviceVersion(curDevice.getProductVersion());
        basicDeviceInfo.setName(curDevice.getDeviceName());
        basicDeviceInfo.setIp(curDevice.getIp());
        basicDeviceInfo.setSn(curDevice.getDeviceSerialNumber());
        basicDeviceInfo.setType(this.cfg.getProcessId());
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        basicDeviceInfo.setCollectionTime(df.format(new Date()));
        String date = this.items.get(0).getDate();
        String spendTime = "0";
        try {
            long startTime = df.parse(date).getTime();
            long time = System.currentTimeMillis() - startTime;
            int i = Integer.parseInt(String.valueOf(time));
            spendTime = String.valueOf(i / 1000);
        }
        catch (RuntimeException | ParseException e) {
            LOGGER.error("get spend time error", (Throwable)e);
        }
        basicDeviceInfo.setSpendTime(spendTime);
        return basicDeviceInfo;
    }

    private String getLocation() {
        ArrayList<String> locationList = new ArrayList<String>();
        try {
            Map<String, Object> dict = BizPackageContext.getInstance().getJythonContext().getDict();
            String inputChangedId = (String)dict.get("input_changed_id");
            Object retData = dict.get(inputChangedId);
            LOGGER.info("retData :{}", retData);
            Object objContext = JSON.parse((String)((String)retData));
            if (objContext instanceof JSONArray) {
                JSONArray fruContext = (JSONArray)objContext;
                fruContext.stream().forEach(node -> this.setLocationId(locationList, (JSONObject)node));
            } else if (objContext instanceof JSONObject) {
                this.setLocationId(locationList, (JSONObject)objContext);
            }
        }
        catch (JSONException e) {
            LOGGER.error("get location error", (Throwable)e);
        }
        return String.join((CharSequence)",", locationList);
    }

    private void setLocationId(List<String> locationList, JSONObject object) {
        JSONObject jsonObject = object;
        String location = jsonObject.getString("location");
        locationList.add(location);
    }

    @Override
    public void fireAllFinish() {
        String title = BizPackageContext.getInstance().getCurBizPackage().getResUtil().getString(this.cfg.getTitle());
        this.layout.setCurrentStatusTxt(title + ResourceUtil.getStringWithParams("expansion.wizard.doitem.finish", " "));
        this.layout.setStatusPanelEnable(false, false);
        this.layout.setCurrentDesc("", this.showLeftTime);
        this.finish = true;
        switch (this.cfg.getBackaftersuc()) {
            case ENABLE: {
                this.setStatus(true, true);
                break;
            }
            case DISABLE: {
                this.setStatus(true, false);
                break;
            }
            case NOT_SET: {
                this.chgWizState(true);
                break;
            }
        }
        DoItemStepCfg stepConfig = (DoItemStepCfg)BizPackageContext.getInstance().getCurBizWizardCfg().getStepsById(BizPackageContext.getInstance().getCurStepId());
        this.buildReport(this.checkIsAllPass(!stepConfig.isOnceCheckAll()));
        if (this.checkIsAllPass(stepConfig.isOnceCheckAll())) {
            this.isAllPass = false;
            if (BizPackageSceneUtils.isFruEvalScene()) {
                this.setCurrentStatus(title, "bizpack.wizard.doitem.not_pass", "failed.gif");
                this.chgWizState4FruEval(true);
            } else {
                this.chgWizState(false);
            }
            this.layout.getBtnReDetect().setEnabled(true);
            this.layout.getHandleItemNoPassBtn().setEnabled(true);
            this.notifyObserver(AutoProcessStatus.FAILURE);
        } else {
            this.isAllPass = true;
            if (BizPackageSceneUtils.isFruEvalScene()) {
                this.setCurrentStatus(title, "bizpack.wizard.doitem.pass", "success.gif");
                this.chgWizState4FruEval(true);
            }
            this.notifyObserver(AutoProcessStatus.SUCCESS);
        }
    }

    private boolean checkIsAllPass(boolean notOnceCheckAll) {
        return notOnceCheckAll && this.layout.getErrMsg() != null && !this.layout.getErrMsg().isEmpty();
    }

    private void setCurrentStatus(String title, String resourceStr, String imageStr) {
        this.layout.setCurrentStatusTxt(title + ResourceUtil.getStringWithParams(resourceStr, " "));
        this.layout.setCurrentStatusIcon(this.resource.getImage(imageStr));
    }

    private void setStatus(boolean isSucc, boolean backEnable) {
        final FlowWizardState curState = this.getUIState(isSucc, backEnable);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DoItemStep.this.changeUIState(curState);
            }
        });
    }

    @Override
    public void setCurrentDescTxt(String txt) {
        this.layout.setCurrentDesc(txt, this.showLeftTime);
    }

    private void setCurrentProgress(int progress, boolean isshow) {
        String progressPer = progress + "%";
        this.layout.getCurrentProgress().setVisible(isshow);
        this.layout.setCurrentProgress(progressPer);
    }

    private void setCurrentRemainTime(int remainTime, boolean isshow) {
        int seconds = remainTime % 60;
        int minutes = remainTime / 60;
        String remainTimeFinal = this.getTime(minutes, seconds);
        this.layout.getCurrentLeftTimeDes().setVisible(isshow);
        this.layout.getCurrentLeftTime().setVisible(isshow);
        if (StringUtils.isNULLStr(this.layout.getBizCfg().getRemainText())) {
            this.layout.setCurrentLeftTimeDes(ResourceUtil.getString("wizard.doitem.desc.timeleft"));
        } else {
            this.layout.setCurrentLeftTimeDes(ResourceUtil.getString(this.layout.getBizCfg().getRemainText()));
        }
        this.layout.setCurrentLeftTime(remainTimeFinal);
    }

    private void finishRemainTime() {
        if (this.showLeftTime) {
            super.getSsEnv().getDict().put("remainTime", 0);
        }
    }

    private void finishPro() {
        if (this.showPro) {
            super.getSsEnv().getDict().put("curProgressPer", 100);
        }
    }

    @Override
    public void onStepDialogDisplayed() {
        for (ConfirmBord confirmBord : this.cfg.getConfirmBoardList()) {
            confirmBord.getConfirmButton().doClick();
        }
    }

    @Override
    public void onStepFinished(AutoProcessStatus status) {
        this.outputResult(status);
        if (status.equals((Object)AutoProcessStatus.SUCCESS)) {
            this.clickButton(Navigation.NEXT);
        } else if (status.equals((Object)AutoProcessStatus.FAILURE)) {
            this.clickButton(Navigation.CANCEL);
        }
    }

    private void clickButton(Navigation button) {
        FlowWizardDialog wizardDialog;
        if (BizPackageContext.getInstance().getWizard() instanceof FlowWizardDialog) {
            wizardDialog = (FlowWizardDialog)BizPackageContext.getInstance().getWizard();
            wizardDialog.clickNaviButton(button);
        }
        if (BizPackageContext.getInstance().getWizard() instanceof GuideFlowWizardDialog) {
            wizardDialog = (GuideFlowWizardDialog)BizPackageContext.getInstance().getWizard();
            wizardDialog.clickNaviButton(button);
        }
    }

    private void outputResult(AutoProcessStatus status) {
        StringBuffer stringBuffer = new StringBuffer();
        String processName = AutoProcessConfig.getInstance().getCurrentProcess();
        String stepId = BizPackageContext.getInstance().getCurStepId();
        String stepString = String.format(Locale.ROOT, "%s--------step: %s, result: %s", System.lineSeparator(), stepId, status.toString());
        stringBuffer.append(stepString);
        for (Item item : this.items) {
            PackagesResource resUtil = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
            String itemName = item.getTitleRes(resUtil);
            String itemString = String.format(Locale.ROOT, "%s------------check item: %s, result: %s", System.lineSeparator(), itemName, item.getResult().toString());
            stringBuffer.append(itemString);
            AutoProcessItem result = new AutoProcessItem();
            result.setId(item.getId());
            if (item.getResult() == ItemResult.FAILED || item.getResult() == ItemResult.NOT_PASS) {
                String errMsg = String.format(Locale.ROOT, "%s----------------\u9519\u8bef\u4fe1\u606f: %s", System.lineSeparator(), item.getReason());
                stringBuffer.append(errMsg);
                String suggestion = String.format(Locale.ROOT, "%s----------------\u4fee\u590d\u5efa\u8bae: %s", System.lineSeparator(), item.getSuggest());
                stringBuffer.append(suggestion);
                result.setResult(AutoProcessStatus.FAILURE.toString());
                result.setErrorMessage(item.getReason());
                result.setSuggestion(item.getSuggest());
            }
            String resultKey = processName + "#" + stepId + "#" + item.getId();
            AutoProcessResult.getInstance().getResults().put(resultKey, result);
        }
        AutoProcessResult.getInstance().append(stringBuffer.toString());
    }

    private class InitStepTask
    extends ServiceTask {
        private InitStepTask() {
        }

        protected TaskResult doTask() {
            return DoItemStep.this.initStep();
        }
    }

    private class QueryRemainTimeTask
    extends Thread {
        private QueryRemainTimeTask() {
        }

        @Override
        public void run() {
            String id = "timeTask_" + new Date().getTime();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("queryRemainTimeTask id[" + id + "] start");
            }
            while (true) {
                if (DoItemStep.this.getSsEnv().getDict().get("remainTime") == null && DoItemStep.this.isFinished()) {
                    LOGGER.info("no remain time and task finish.");
                    break;
                }
                if (DoItemStep.this.getSsEnv().getDict().get("remainTime") == null) {
                    DoItemStep.this.setCurrentRemainTime(0, false);
                    continue;
                }
                int remainTime = (Integer)DoItemStep.this.getSsEnv().getDict().get("remainTime");
                DoItemStep.this.setCurrentRemainTime(remainTime, true);
                if (DoItemStep.this.finish) {
                    if (BizPackageSceneUtils.isFruEvalScene()) {
                        DoItemStep.this.setCurrentRemainTime(0, false);
                    }
                    if (!LOGGER.isInfoEnabled()) break;
                    LOGGER.info("queryRemainTimeTask id[" + id + "] end");
                    break;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    LOGGER.error("setCurrentProgress sleep err", (Throwable)e);
                }
            }
        }
    }

    private class QueryProgressTask
    extends Thread {
        private QueryProgressTask() {
        }

        @Override
        public void run() {
            String id = "progressTask_" + new Date().getTime();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("queryProgressTask id[" + id + "] start");
            }
            while (true) {
                if (DoItemStep.this.getSsEnv().getDict().get("curProgressPer") == null && DoItemStep.this.isFinished()) {
                    LOGGER.info("no progress and task finish.");
                    break;
                }
                if (DoItemStep.this.getSsEnv().getDict().get("curProgressPer") == null) {
                    DoItemStep.this.setCurrentProgress(0, false);
                    continue;
                }
                int progress = (Integer)DoItemStep.this.getSsEnv().getDict().get("curProgressPer");
                DoItemStep.this.setCurrentProgress(progress, true);
                if (DoItemStep.this.finish) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("queryProgressTask id[" + id + "] end");
                    }
                    if (BizPackageSceneUtils.isFruEvalScene() || progress == 0) {
                        DoItemStep.this.setCurrentProgress(0, false);
                        break;
                    }
                    if (progress <= 0 || progress >= 100) break;
                    DoItemStep.this.setCurrentProgress(100, true);
                    break;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    LOGGER.error("setCurrentProgress sleep err", (Throwable)e);
                }
            }
        }
    }

    private class ConfirmBordListener
    implements ActionListener {
        private ConfirmBord bord = null;

        public ConfirmBordListener(ConfirmBord bord) {
            this.bord = bord;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (this.bord.isReclick()) {
                    DoItemStep.this.reDetectPerform();
                    this.bord.getConfirmButton().setEnabled(false);
                } else if (DoItemStep.this.confirmData(this.bord)) {
                    BizPackageContext.getInstance().getJythonContext().getDict().put("clickReplacedButtonTime", String.valueOf(DateUtil.toBeiJingTimeMillis(new Date())));
                    BizPackageContext.getInstance().getJythonContext().getDict().put("bord", this.bord);
                    BizPackageContext.getInstance().getJythonContext().getDict().put("ConfirmBordUtil", ConfirmBordUtil.getInstance());
                    this.bord.getConfirmButton().setEnabled(false);
                    DoItemStep.this.initAllItem();
                    DoItemStep.this.autoExecItem();
                }
                if (BizPackageSceneUtils.isNeededRecord()) {
                    BizPackageSceneUtils.closeDataRecord(new Date(), DoItemStep.SCENE_CHM_RECORD_CLOSE_DATA);
                }
            }
            catch (Exception ex) {
                LOGGER.error("error happend!!!", (Throwable)ex);
            }
        }
    }

    private class IgnoreActionLisnener
    implements ActionListener {
        private Item item;

        public IgnoreActionLisnener(Item item) {
            this.item = item;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WarningDialog dialog;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Click the Ignore button...");
            }
            if (0 != (dialog = DialogUtils.showYesNoDialog((Window)DoItemStep.this.getParentWindow(), (String)ResourceUtil.getString("expansion.wizard.doitem.ignore.tips"))).getValue()) {
                return;
            }
            DoItemStep.this.ignorePerform(this.item);
        }
    }

    private class ReDetectActionLisnener
    implements ActionListener {
        private ReDetectActionLisnener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DoItemStep.this.reDetectPerform();
        }
    }

    private final class UpdateUITask
    implements Runnable {
        private static final String EMPTY = "";
        private static final String REMIND_INFO = "remindInfo";
        private static final String LOADING_IMG = "loading.gif";
        private static final String REMIND_INFO_SIZE = "remindInfoSize";

        private UpdateUITask() {
        }

        @Override
        public void run() {
            while (DoItemStep.this.cfg.isShowRemindInfo()) {
                this.handleRemindText();
                ConnUtils.sleep((int)100);
            }
        }

        private void handleRemindText() {
            Object object = DoItemStep.this.getSsEnv().getDict().get(REMIND_INFO);
            if (object != null && !StringUtils.isNULLStr(object.toString())) {
                Object sizeObject = DoItemStep.this.getSsEnv().getDict().get(REMIND_INFO_SIZE);
                if (sizeObject != null) {
                    try {
                        String sizeInfo = sizeObject.toString();
                        String[] sizes = sizeInfo.split(",");
                        DoItemStep.this.layout.getRemindText().setPreferredSize(new Dimension(Integer.parseInt(sizes[0]), Integer.parseInt(sizes[1])));
                        DoItemStep.this.getSsEnv().getDict().remove(REMIND_INFO_SIZE);
                    }
                    catch (NumberFormatException e) {
                        LOGGER.error("remind size invalid" + sizeObject, (Throwable)e);
                    }
                }
                DoItemStep.this.layout.getRemindText().setVisible(true);
                DoItemStep.this.layout.getRemindText().setIcon(ResourceUtil.getImage(LOADING_IMG));
                String text = DoItemStep.this.getSsEnv().getDict().get(REMIND_INFO).toString();
                DoItemStep.this.layout.getRemindText().setText(text);
            } else {
                DoItemStep.this.layout.getRemindText().setText(EMPTY);
                DoItemStep.this.layout.getRemindText().setVisible(false);
                DoItemStep.this.layout.getRemindText().setIcon(null);
            }
        }
    }
}

