/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.step.doitem;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.flow.ui.IFlowUIState;
import com.huawei.ism.tool.base.ui.task.ServiceTask;
import com.huawei.ism.tool.base.ui.task.ServiceTaskExecutor;
import com.huawei.ism.tool.base.ui.task.TaskResult;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardCardLayout;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardState;
import com.huawei.ism.tool.base.utils.DateUtil;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.entity.BizStepConfig;
import com.huawei.ism.tool.bizpack.wizardparse.entity.ProcessStepType;
import com.huawei.ism.tool.bizpack.wizardparse.entity.item.Item;
import com.huawei.ism.tool.bizpack.wizardparse.entity.item.ItemResult;
import com.huawei.ism.tool.bizpack.wizardparse.intf.IDevgGraphInit;
import com.huawei.ism.tool.bizpack.wizardparse.task.DoOneCmdSettingTask;
import com.huawei.ism.tool.bizpack.wizardparse.task.ExecPyScriptTask;
import com.huawei.ism.tool.bizpack.wizardparse.task.ExecPyUtils;
import com.huawei.ism.tool.bizpack.wizardparse.task.TaskManager;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.waitdialog.CompileAndExecOnePyFuncWaitDialog;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.waitdialog.WaitDialogResult;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.AbstractBizStep;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.DoOneCmdStepUiObserver;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.doitem.DoItemStepCfg;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.doitem.DoItemType;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.doitem.DoOneCmdExecStepLayout;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.doitem.comp.ConfirmBord;
import com.huawei.ism.tool.bizpack.wizardparse.util.BizPackageSceneUtils;
import com.huawei.ism.tool.bizpack.wizardparse.util.PackagesResource;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.tool.obase.connection.support.ConnUtils;
import com.huawei.ism.tool.pyengine.utils.PyJavaUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ImageObserver;
import java.io.FileNotFoundException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoOneCmdExecStep
extends AbstractBizStep
implements DoOneCmdStepUiObserver,
IDevgGraphInit {
    public static final String SCENE_CHM_RECORD_CLOSE_DATA = "5";
    private static final Logger LOGGER = LoggerFactory.getLogger(DoOneCmdExecStep.class);
    private DoOneCmdExecStepLayout layout;
    private String scriptPath = "";
    private DoItemStepCfg cfg;
    private DoOneCmdSettingTask itemTask;
    private List<Item> items;
    private int executingItemRowIndex = 1;
    private boolean showPro;
    private boolean isDisplayingDetailedProcess = false;
    private boolean showLeftTime;
    private DoItemType type;
    private boolean finish = true;
    private String pyName = "";
    private String preScriptPath = "";
    private boolean isFlowRollback = false;
    private ExecPyScriptTask confirmTask;
    private PackagesResource resource = BizPackageContext.getInstance().getCurBizPackage().getResUtil();

    private void reDetectPerform() {
        this.finish = false;
        this.isDisplayingDetailedProcess = false;
        this.layout.getBtnReDetect().setEnabled(false);
        this.layout.clearResultInfo();
        this.layout.setStatusPanelEnable(this.cfg.isShowPro(), this.cfg.isShowLeftTime());
        this.layout.updateUI();
        if (this.cfg.isFailedCheckAll()) {
            this.initAllItemWait();
        }
        this.doOneCmdSetItem();
    }

    public DoOneCmdExecStepLayout getUILayout() {
        return this.layout;
    }

    protected FlowWizardCardLayout getLayout() {
        return this.layout;
    }

    @Override
    protected IFlowUIState getInitUIState() {
        FlowWizardState tmpState = this.getUIState(false, false);
        if (this.type.equals((Object)DoItemType.CONFIRM_CHECK)) {
            tmpState = this.getUIState(false, super.isBackwardAbs());
        }
        return tmpState;
    }

    private TaskResult initStep() {
        TaskResult taskResult;
        this.initByConfig(BizPackageContext.getInstance().getCurBizWizardCfg().getStepsById(this.getId()));
        this.setAllStageNum();
        super.setIndex(this.getStageIndex());
        this.executingItemRowIndex = 0;
        this.layout.setStatusPanelEnable(this.cfg.isShowPro(), this.cfg.isShowLeftTime());
        List<ConfirmBord> confirmBordList = this.cfg.getConfirmBoardList();
        for (ConfirmBord bord : confirmBordList) {
            this.confirmBordInitData(bord);
            bord.getConfirmButton().setEnabled(true);
        }
        this.finish = true;
        this.layout.clearUI();
        this.layout.setCurrentLeftTime("");
        this.layout.setCurrentLeftTimeDes("");
        this.layout.setCurrentProgress("");
        if (this.type.equals((Object)DoItemType.CONFIRM_CHECK)) {
            return new TaskResult(TaskResult.Result.SUCCESS);
        }
        if (BizPackageContext.getInstance().getCurBizWizardCfg().getStepsById(this.getId()).isNeedDeviceGraph() && TaskResult.Result.FAILED == (taskResult = this.initDevGraph()).getResult()) {
            return taskResult;
        }
        this.clearTable();
        this.doOneCmdSetItem();
        return new TaskResult(TaskResult.Result.SUCCESS);
    }

    private void clearTable() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("the step title:" + this.cfg.getTitle());
        }
        while (this.layout.getExpansionDetailTable().getRowCount() != 0) {
            this.layout.getExpansionDetailTableModel().removeAll();
        }
    }

    private void doOneCmdSetItem() {
        this.finish = false;
        this.setRunningUiStatus();
        this.layout.setCurrentLeftTime("");
        this.layout.setCurrentLeftTimeDes("");
        this.layout.setCurrentProgress("");
        super.getSsEnv().getDict().put("remainTime", null);
        super.getSsEnv().getDict().put("curProgressPer", null);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("failedCheckAll:" + this.cfg.isFailedCheckAll());
        }
        this.itemTask = new DoOneCmdSettingTask(this.cfg, this, this.scriptPath);
        TaskManager.submitTask(this.itemTask);
        if (this.showPro) {
            new QueryProgressTask().start();
        }
        if (this.showLeftTime) {
            new QueryRemainTimeTask().start();
        }
        AsyncExcutor.submit((Runnable)new UpdateUITask());
    }

    private void initAllItemWait() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Item item : DoOneCmdExecStep.this.items) {
                    item.setResult(ItemResult.WAITING);
                    item.setDate("--");
                }
            }
        });
    }

    public boolean ending() {
        return true;
    }

    public boolean flowExiting() {
        if (!this.finish) {
            DialogUtils.showInfoDialog((Window)this.getParentWindow(), (String)ResourceUtil.getString("bizpackage.error.doitem.scriptrunning"));
            return false;
        }
        return this.cancel();
    }

    @Override
    public void initByConfig(BizStepConfig stepConfig) {
        this.scriptPath = this.getScriptPath();
        super.getSsEnv().getDict().put("importRootDir", this.scriptPath);
        if (stepConfig instanceof DoItemStepCfg) {
            this.cfg = (DoItemStepCfg)stepConfig;
            this.initLayout(this.cfg);
            this.items = this.cfg.getCheckItem();
            super.setParamAbs(this.cfg.getParam());
            super.setBackwardAbs(this.cfg.isBackward());
            if (this.cfg.getType().equals((Object)ProcessStepType.CHECK)) {
                this.type = DoItemType.CHECK;
            } else if (this.cfg.getType().equals((Object)ProcessStepType.EXEC_SETTING) || this.cfg.getType().equals((Object)ProcessStepType.ONE_CMD_SETTING)) {
                this.type = DoItemType.EXEC;
                this.layout.getBtnReDetect().setText(ResourceUtil.getString("expansion.btn.reexec"));
                UCD.formatMnemonicDisplay((AbstractButton)this.layout.getBtnReDetect());
            } else if (this.cfg.getType().equals((Object)ProcessStepType.CONFIRM_REPLACED)) {
                this.type = DoItemType.CONFIRM_CHECK;
            }
            super.setCancelScriptAbs(this.cfg.getCancelScript());
            this.showLeftTime = this.cfg.isShowLeftTime();
            this.showPro = this.cfg.isShowPro();
            this.layout.setStatusPanel(this.showPro, this.showLeftTime);
            List<ConfirmBord> bords = this.cfg.getConfirmBoardList();
            this.pyName = this.cfg.getScriptFile();
            this.preScriptPath = this.getScriptPath();
            if (!bords.isEmpty()) {
                for (ConfirmBord bord : bords) {
                    this.initConfirmBordListener(bord);
                    if (!LOGGER.isInfoEnabled()) continue;
                    LOGGER.info("int bord listener" + bord);
                }
                this.layout.buildConfirmBord(bords, this.cfg);
            }
            this.setDocLinkParentWindow(this.cfg);
        }
    }

    @Override
    public TaskResult initDevGraph() {
        if (!ExecPyUtils.execInitScript(BizPackageContext.getInstance().getCurBizWizardCfg().getStepsById(this.getId()).getScriptFile(), this.getParamAbs(), "initDevGraph")) {
            TaskResult result = new TaskResult(TaskResult.Result.FAILED);
            String errorMsg = ResourceUtil.getString("bizpackage.error.preset.execscriptfailed");
            result.setErrorLocaleDescription(errorMsg);
            return result;
        }
        return this.getDevGraphExecResult();
    }

    private void initLayout(DoItemStepCfg initCfg) {
        this.layout = new DoOneCmdExecStepLayout(initCfg);
        this.operators.clear();
        this.operators.add(this.layout.getBtnReDetect());
        this.layout.getBtnReDetect().setEnabled(false);
        this.layout.getBtnReDetect().addActionListener(new ReDetectActionLisnener());
    }

    private void initConfirmBordListener(ConfirmBord bord) {
        this.removeAllConfirmBtnListener(bord);
        bord.getConfirmButton().addActionListener(new ConfirmBordListener(bord));
    }

    private void removeAllConfirmBtnListener(ConfirmBord bord) {
        ActionListener[] lsts;
        for (ActionListener actionListener : lsts = bord.getConfirmButton().getActionListeners()) {
            bord.getConfirmButton().removeActionListener(actionListener);
        }
    }

    private boolean confirmData(ConfirmBord bord) {
        this.confirmTask.execFunc("confirm", super.getParamAbs());
        Object confirm = super.getSsEnv().getDict().get("confirmMsg");
        if (null == confirm || "".equals(((String)confirm).trim())) {
            DialogUtils.showInfoDialog((Window)this.getParentWindow(), (String)ResourceUtil.getString("bizpackage.error.doitem.scriptexecerr"));
            return false;
        }
        Window parentWindows = this.getParentWindow();
        if (parentWindows instanceof JDialog) {
            WarningDialog wdialog = DialogUtils.createWarningDialog((JDialog)((JDialog)parentWindows), (String)((String)confirm));
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("getParentWindow = " + this.getParentWindow().getClass());
            }
            if (0 == wdialog.getValue()) {
                this.refreshConfirmBord(bord);
                return true;
            }
        }
        return false;
    }

    private void refreshConfirmBord(ConfirmBord bord) {
        this.confirmTask.execFunc("refresh", super.getParamAbs());
        Object retData = super.getSsEnv().getDict().get("retData");
        if (null == retData) {
            return;
        }
        String json = (String)retData;
        bord.getInfoBord().setTextData(json, this.cfg.isNeedDeviceGraph());
    }

    private void confirmBordInitData(final ConfirmBord bord) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BizPackageContext.getInstance().getJythonContext().clearMsgData();
                Window parent = DoOneCmdExecStep.this.getParentWindow();
                List fs = AsyncExcutor.execute((Window)parent, (Callable[])new Callable[]{new CompileAndExecOnePyFuncWaitDialog(DoOneCmdExecStep.this.preScriptPath, DoOneCmdExecStep.this.pyName, "initData", DoOneCmdExecStep.this.getParamAbs())});
                WaitDialogResult result = (WaitDialogResult)fs.get(0);
                if (!WaitDialogResult.handleResult(DoOneCmdExecStep.this.getParentWindow(), result)) {
                    return;
                }
                DoOneCmdExecStep.this.confirmTask = result.getTask();
                if (null == DoOneCmdExecStep.this.confirmTask) {
                    DialogUtils.showErrorDialog((Window)DoOneCmdExecStep.this.getParentWindow(), (String)ResourceUtil.getString("bizpackage.error.preset.scriptinitfailed"));
                    return;
                }
                if (!((Boolean)DoOneCmdExecStep.this.getSsEnv().getDict().get("succ")).booleanValue()) {
                    String errText = (String)DoOneCmdExecStep.this.getSsEnv().getDict().get("errMsg");
                    DialogUtils.showErrorDialog((Window)DoOneCmdExecStep.this.getParentWindow(), (String)errText);
                    return;
                }
                Object retData = DoOneCmdExecStep.this.getSsEnv().getDict().get("retData");
                if (null == retData) {
                    return;
                }
                String json = (String)retData;
                DoOneCmdExecStep.this.getSsEnv().getDict().put("curData", retData);
                bord.getInfoBord().setTextData(json, DoOneCmdExecStep.this.cfg.isNeedDeviceGraph());
            }
        });
    }

    public IsmTableCell.IconCell createStateCell(Item item, ImageObserver imageObserver) {
        ImageIcon icon = null;
        String textState = item.getResult().toString() + item.getRemainTime();
        if (ItemResult.EXECUTING == item.getResult()) {
            icon = ResourceUtil.getImage("loading.gif");
            icon.setImageObserver(imageObserver);
        } else if (ItemResult.SUCCEED == item.getResult()) {
            icon = ResourceUtil.getImage("success.png");
        } else if (ItemResult.FAILED == item.getResult()) {
            icon = ResourceUtil.getImage("failed.png");
        } else if (ItemResult.PAUSED == item.getResult()) {
            icon = ResourceUtil.getImage("pause.png");
        } else if (ItemResult.ROLLBACKING == item.getResult() || ItemResult.ROLLBACK_FAILED == item.getResult()) {
            icon = ResourceUtil.getImage("pause.png");
            textState = ItemResult.PAUSED.toString();
            this.isFlowRollback = true;
        }
        IsmTableCell.IconCell iconCell = new IsmTableCell.IconCell((Icon)icon, textState);
        return iconCell;
    }

    public void updateExpansionItems(Map<String, Object> dataDict, List<Item> exeItems) {
        DefaultTableModel expansionDetailTableModel = this.layout.getExpansionDetailTableModel();
        IsmTable expansionDetailTable = this.layout.getExpansionDetailTable();
        expansionDetailTableModel.removeAll();
        this.layout.setTableHeaderSize();
        int stepIdx = 0;
        boolean hasStepExecuting = false;
        for (Item item : exeItems) {
            int colIndex = 0;
            DefaultTableRow row = new DefaultTableRow(4, (Object)item);
            row.setValueAt(colIndex++, (Object)item.getDate());
            row.setValueAt(colIndex++, (Object)item.getTitle());
            row.setValueAt(colIndex++, (Object)this.createStateCell(item, (ImageObserver)expansionDetailTable));
            if (ItemResult.EXECUTING == item.getResult()) {
                this.executingItemRowIndex = stepIdx;
                hasStepExecuting = true;
                Boolean showPwrOnStep = (Boolean)dataDict.get("showPowerOnInfo");
                this.showExecutingDetailInfo(dataDict, showPwrOnStep);
            }
            row.setValueAt(colIndex++, (Object)item.getProgress());
            expansionDetailTableModel.addRow(new TableRow[]{row});
            if (hasStepExecuting) {
                int rowNum = expansionDetailTableModel.getRowIndex((TableRow)row);
                Rectangle rect = expansionDetailTable.getCellRect(rowNum, 0, true);
                expansionDetailTable.scrollRectToVisible(rect);
            }
            ++stepIdx;
        }
        this.layout.getExpansionDetailTableModel().fireTableRowsUpdated(0, expansionDetailTableModel.getRowCount());
        this.layout.getExpansionDetailTable().updateUI();
        if (hasStepExecuting && !this.isFlowRollback && !this.isDisplayingDetailedProcess) {
            this.layout.clearResultInfo();
        }
    }

    private void showExecutingDetailInfo(Map<String, Object> dataDict, Boolean showPwrOnStep) {
        if (null != showPwrOnStep && showPwrOnStep.booleanValue()) {
            String errMsg = (String)dataDict.get("errMsg");
            String suggest = (String)dataDict.get("suggestion");
            if (StringUtils.isNULLStr(errMsg) || StringUtils.isNULLStr(suggest)) {
                return;
            }
            ArrayList<String> msgs = new ArrayList<String>();
            msgs.add("loading");
            msgs.add(errMsg);
            msgs.add(suggest);
            if (!this.isDisplayingDetailedProcess) {
                LOGGER.info("First time to display the executing process detailed message.");
                this.layout.showResultInfo(msgs);
                this.isDisplayingDetailedProcess = true;
            } else {
                this.layout.updateResultInfo(msgs);
            }
        }
    }

    @Override
    public void postMsg(final Map<String, Object> dataDict) {
        SwingUtil.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Object pyList = dataDict.get("itemList");
                List exeItems = PyJavaUtils.convertPyList2Jlist(pyList);
                try {
                    DoOneCmdExecStep.this.updateExpansionItems(dataDict, exeItems);
                }
                catch (Exception e) {
                    LOGGER.error("refresh item1 error....", (Throwable)e);
                }
            }
        });
    }

    @Override
    public void fireException(Exception e) {
        String reason = null;
        String suggest = null;
        if (e instanceof FileNotFoundException) {
            reason = ResourceUtil.getString("bizpackage.error.doitem.scriptfilenotfound");
            suggest = ResourceUtil.getString("bizpackage.error.doitem.scriptfilenotfound.suggestion");
        } else if (e instanceof SignException) {
            reason = ResourceUtil.getString("bizpackage.error.doitem.scriptfile.notsigned");
            suggest = ResourceUtil.getString("bizpackage.error.doitem.scriptfile.notsigned.suggestion");
        } else {
            reason = ResourceUtil.getString("bizpackage.error.doitem.scriptexecerr");
            suggest = ResourceUtil.getString("bizpackage.error.doitem.scriptexecerr.suggestion");
        }
        ArrayList<String> msgs = new ArrayList<String>();
        msgs.add("failed");
        msgs.add(reason);
        msgs.add(suggest);
        this.layout.showResultInfo(msgs);
        this.layout.getBtnReDetect().setEnabled(true);
        this.chgWizState(false);
        this.finish = true;
    }

    @Override
    public void fireFinish(Item item, int curIndex) {
        Map<String, Object> dataDict = super.getSsEnv().getDict();
        boolean isSucc = (Boolean)dataDict.get("succ");
        FlowWizardState state = this.getUIState(isSucc, this.isBackwardAbs());
        Boolean isRollbaking = (Boolean)super.getSsEnv().getDict().get("isRollbacking");
        ArrayList<String> msgs = new ArrayList<String>();
        if (!isSucc) {
            String errMsg = (String)dataDict.getOrDefault("errMsg", "");
            String suggest = (String)dataDict.getOrDefault("suggestion", "");
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("errMsg is:" + errMsg + ", and suggest is\uff1a" + suggest);
            }
            msgs.add("failed");
            msgs.add(errMsg);
            msgs.add(suggest);
        }
        SwingUtilities.invokeLater(() -> {
            if (isSucc) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("succ......" + curIndex);
                }
                this.layout.getResultPanel().setVisible(false);
                this.layout.getBtnReDetect().setEnabled(false);
                this.changeUIState(state);
            } else {
                this.layout.showResultInfo(msgs);
                LOGGER.info("one item setting wizard not success......");
                this.layout.getBtnReDetect().setEnabled(null == isRollbaking || isRollbaking == false);
                this.changeUIState(state);
            }
        });
        this.finish = true;
    }

    public void setBackwardBtnStatus(boolean isSucc) {
        switch (this.cfg.getBackaftersuc()) {
            case ENABLE: {
                this.setStatus(isSucc, true);
                break;
            }
            case DISABLE: {
                this.setStatus(isSucc, false);
                break;
            }
            case NOT_SET: {
                this.chgWizState(isSucc);
                break;
            }
        }
    }

    private String getTime(int minutes, int seconds) {
        SimpleDateFormat fo = new SimpleDateFormat("HH:mm:ss");
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, minutes);
        cal.set(13, seconds);
        return fo.format(cal.getTime());
    }

    @Override
    public void setCurrentStatusTxt(String txt) {
        this.layout.setCurrentStatusTxt(txt);
    }

    private void setResultType(boolean succ, Item item) {
        if (succ) {
            if (this.type.equals((Object)DoItemType.CHECK)) {
                item.setResult(ItemResult.PASS);
            } else if (this.type.equals((Object)DoItemType.EXEC)) {
                item.setResult(ItemResult.SUCCEED);
            } else if (this.type.equals((Object)DoItemType.CONFIRM_CHECK)) {
                item.setResult(ItemResult.PASS);
            }
        } else if (this.type.equals((Object)DoItemType.CHECK)) {
            item.setResult(ItemResult.NOT_PASS);
        } else if (this.type.equals((Object)DoItemType.EXEC)) {
            item.setResult(ItemResult.FAILED);
        } else if (this.type.equals((Object)DoItemType.CONFIRM_CHECK)) {
            item.setResult(ItemResult.NOT_PASS);
        }
    }

    private void setStatus(boolean isSucc, boolean backEnable) {
        final FlowWizardState curState = this.getUIState(isSucc, backEnable);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DoOneCmdExecStep.this.changeUIState(curState);
            }
        });
    }

    @Override
    public void setCurrentDescTxt(String txt) {
        this.layout.setCurrentDesc(txt, this.showLeftTime);
    }

    private void setCurrentProgress(int progress, boolean isshow) {
        String progressPer = progress + "%";
        this.layout.getCurrentProgress().setVisible(isshow);
        this.layout.setCurrentProgress(progressPer);
    }

    private void setCurrentRemainTime(int remainTime, boolean isshow) {
        int seconds = remainTime % 60;
        int minutes = remainTime / 60;
        String remainTimeFinal = this.getTime(minutes, seconds);
        this.layout.getCurrentLeftTimeDes().setVisible(isshow);
        this.layout.getCurrentLeftTime().setVisible(isshow);
        if (StringUtils.isNULLStr(this.layout.getBizCfg().getRemainText())) {
            this.layout.setCurrentLeftTimeDes(ResourceUtil.getString("wizard.doitem.desc.timeleft"));
        } else {
            this.layout.setCurrentLeftTimeDes(ResourceUtil.getString(this.layout.getBizCfg().getRemainText()));
        }
        this.layout.setCurrentLeftTime(remainTimeFinal);
    }

    protected boolean init() {
        this.setCurStepID();
        ProgressDialog progressDialog = new ProgressDialog(this.getParentWindow());
        ServiceTaskExecutor taskExecutor = new ServiceTaskExecutor(progressDialog);
        TaskResult taskResult = taskExecutor.execute((ServiceTask)new InitStepTask());
        if (taskResult != null && taskResult.getResult() == TaskResult.Result.FAILED) {
            DialogUtils.showErrorDialog((Window)this.getParentWindow(), (String)taskResult.getErrorLocaleDescription());
            if (!this.type.equals((Object)DoItemType.CONFIRM_CHECK)) {
                this.doOneCmdSetItem();
            }
        }
        return true;
    }

    public int getExecutingItemRowIndex() {
        return this.executingItemRowIndex;
    }

    public void setExecutingItemRowIndex(int executingItemRowIndex) {
        this.executingItemRowIndex = executingItemRowIndex;
    }

    private class InitStepTask
    extends ServiceTask {
        private InitStepTask() {
        }

        protected TaskResult doTask() {
            return DoOneCmdExecStep.this.initStep();
        }
    }

    private class QueryRemainTimeTask
    extends Thread {
        private QueryRemainTimeTask() {
        }

        @Override
        public void run() {
            String id = "timeTask_" + new Date().getTime();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("queryRemainTimeTask id[" + id + "] start");
            }
            while (DoOneCmdExecStep.this.getSsEnv().getDict().get("remainTime") != null || !DoOneCmdExecStep.this.finish) {
                if (DoOneCmdExecStep.this.getSsEnv().getDict().get("remainTime") == null) {
                    DoOneCmdExecStep.this.setCurrentRemainTime(0, false);
                    continue;
                }
                int remainTime = (Integer)DoOneCmdExecStep.this.getSsEnv().getDict().get("remainTime");
                DoOneCmdExecStep.this.setCurrentRemainTime(remainTime, true);
                if (DoOneCmdExecStep.this.finish) {
                    if (!LOGGER.isInfoEnabled()) break;
                    LOGGER.info("queryRemainTimeTask id[" + id + "] end");
                    break;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    LOGGER.error("setCurrentProgress sleep err", (Throwable)e);
                }
            }
        }
    }

    private class QueryProgressTask
    extends Thread {
        private QueryProgressTask() {
        }

        @Override
        public void run() {
            String id = "progressTask_" + new Date().getTime();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("queryProgressTask id[" + id + "] start");
            }
            while (DoOneCmdExecStep.this.getSsEnv().getDict().get("curProgressPer") != null || !DoOneCmdExecStep.this.finish) {
                if (DoOneCmdExecStep.this.getSsEnv().getDict().get("curProgressPer") == null) {
                    DoOneCmdExecStep.this.setCurrentProgress(0, false);
                    continue;
                }
                int progress = (Integer)DoOneCmdExecStep.this.getSsEnv().getDict().get("curProgressPer");
                DoOneCmdExecStep.this.setCurrentProgress(progress, true);
                if (DoOneCmdExecStep.this.finish) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("queryProgressTask id[" + id + "] end");
                    }
                    if (progress == 0) {
                        DoOneCmdExecStep.this.setCurrentProgress(0, false);
                        break;
                    }
                    if (progress <= 0 || progress >= 100) break;
                    DoOneCmdExecStep.this.setCurrentProgress(100, true);
                    break;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    LOGGER.error("setCurrentProgress sleep err", (Throwable)e);
                }
            }
        }
    }

    private class ConfirmBordListener
    implements ActionListener {
        private ConfirmBord bord = null;

        public ConfirmBordListener(ConfirmBord bord) {
            this.bord = bord;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (DoOneCmdExecStep.this.confirmData(this.bord)) {
                    BizPackageContext.getInstance().getJythonContext().getDict().put("clickReplacedButtonTime", String.valueOf(DateUtil.toBeiJingTimeMillis(new Date())));
                    this.bord.getConfirmButton().setEnabled(false);
                    DoOneCmdExecStep.this.doOneCmdSetItem();
                }
                if (BizPackageSceneUtils.isNeededRecord()) {
                    BizPackageSceneUtils.closeDataRecord(new Date(), DoOneCmdExecStep.SCENE_CHM_RECORD_CLOSE_DATA);
                }
            }
            catch (Exception ex) {
                LOGGER.error("error happend!!!", (Throwable)ex);
            }
        }
    }

    private class ReDetectActionLisnener
    implements ActionListener {
        private ReDetectActionLisnener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DoOneCmdExecStep.this.reDetectPerform();
        }
    }

    private final class UpdateUITask
    implements Runnable {
        private static final String EMPTY = "";
        private static final String REMIND_INFO = "remindInfo";
        private static final String LOADING_IMG = "loading.gif";
        private static final String REMIND_INFO_SIZE = "remindInfoSize";

        private UpdateUITask() {
        }

        @Override
        public void run() {
            while (DoOneCmdExecStep.this.cfg.isShowRemindInfo()) {
                this.handleRemindText();
                ConnUtils.sleep((int)100);
            }
        }

        private void handleRemindText() {
            Object object = DoOneCmdExecStep.this.getSsEnv().getDict().get(REMIND_INFO);
            if (object != null && !StringUtils.isNULLStr(object.toString())) {
                Object sizeObject = DoOneCmdExecStep.this.getSsEnv().getDict().get(REMIND_INFO_SIZE);
                if (sizeObject != null) {
                    try {
                        String sizeInfo = sizeObject.toString();
                        String[] sizes = sizeInfo.split(",");
                        DoOneCmdExecStep.this.layout.getRemindText().setPreferredSize(new Dimension(Integer.parseInt(sizes[0]), Integer.parseInt(sizes[1])));
                        DoOneCmdExecStep.this.getSsEnv().getDict().remove(REMIND_INFO_SIZE);
                    }
                    catch (NumberFormatException e) {
                        LOGGER.error("remind size invalid" + sizeObject, (Throwable)e);
                    }
                }
                DoOneCmdExecStep.this.layout.getRemindText().setVisible(true);
                DoOneCmdExecStep.this.layout.getRemindText().setIcon(ResourceUtil.getImage(LOADING_IMG));
                String text = DoOneCmdExecStep.this.getSsEnv().getDict().get(REMIND_INFO).toString();
                DoOneCmdExecStep.this.layout.getRemindText().setText(text);
            } else {
                DoOneCmdExecStep.this.layout.getRemindText().setText(EMPTY);
                DoOneCmdExecStep.this.layout.getRemindText().setVisible(false);
                DoOneCmdExecStep.this.layout.getRemindText().setIcon(null);
            }
        }
    }
}

