/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.step.select;

import com.google.common.base.Objects;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.obase.ui.dialogs.PublicDialog;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.InputConfirmPanel;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NotNull;

public class ReplaceTipConfirmDialog
extends PublicDialog {
    private static final long serialVersionUID = -6288716217430293719L;
    private static final int DIALOG_WIDTH = 530;
    private static final int DIALOG_HEIGHT = 360;
    private static final String FRU_MODULE_BACKENDINTF = "backEndIntf";
    private ImageIcon tipImg = ResourceUtil.getImage("danger.png");
    private boolean isOKClick = false;
    private String[] tipParms;
    private String fruType;

    public ReplaceTipConfirmDialog(String fruType, String[] params) {
        this.fruType = fruType;
        this.tipParms = (String[])params.clone();
        this.initTipUI();
    }

    public boolean isOKClick() {
        return this.isOKClick;
    }

    public void initTipUI() {
        this.setModal(true);
        this.setTitle(ResourceUtil.getString("bizpack.select.comfirm.dlg.title"));
        this.getOkBtn().setEnabled(false);
        this.setAppButtonVisible(false);
        this.setHelpButtonVisiable(false);
        this.getContentPanel().setLayout(new BorderLayout());
        this.getContentPanel().add(this.createUI(), "Center");
        InputConfirmPanel inputConfirmPanel = new InputConfirmPanel(ResourceUtil.getString("bizpack.select.comfirm.dlg.checkbox"), "Yes", Collections.singletonList(this.getOkBtn()));
        this.getContentPanel().add((Component)UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(0), inputConfirmPanel}), "South");
        UiMethod.setComponentSize((Dimension)this.getDimensionByFruType(this.fruType), (Component[])new Component[]{this});
        this.pack();
        this.setResizable(false);
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)((Object)this));
        SwingUtil.putScreenCenter((Window)((Object)this));
        this.initListener();
    }

    @NotNull
    private Dimension getDimensionByFruType(String fruType) {
        if (Objects.equal((Object)fruType, (Object)FRU_MODULE_BACKENDINTF) && LanguageManager.isEnglish()) {
            return new Dimension(530, 420);
        }
        return new Dimension(530, 360);
    }

    private Component createUI() {
        JTextArea tipsText;
        String enOriginalString = ResourceUtil.getStringWithParams("bizpack.select.comfirm.original.for.riskPower", new Object[0]);
        String enTargetString = ResourceUtil.getStringWithParams("bizpack.select.comfirm.target.for.riskPower", new Object[0]);
        if (enOriginalString.equals(this.tipParms[0])) {
            this.tipParms[0] = enTargetString;
            tipsText = UiMethod.createJTextArea((String)ResourceUtil.getStringWithParams("bizpack.select.comfirm.dlg.tips.for.riskPower", this.tipParms));
        } else {
            tipsText = UiMethod.createJTextArea((String)ResourceUtil.getStringWithParams("bizpack.select.comfirm.dlg.tips", this.tipParms));
        }
        return UCD.buildVerticalBox(null, (Component[])new Component[]{Box.createVerticalStrut(0), UCD.buildHBoxRight((Component[])new Component[]{Box.createHorizontalStrut(0), new JLabel(this.tipImg), UCD.buildVerticalBox(null, (Component[])new Component[]{Box.createVerticalStrut(10), tipsText}), Box.createHorizontalStrut(0)}), Box.createVerticalStrut(0)});
    }

    private void initListener() {
        this.getOkBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReplaceTipConfirmDialog.this.isOKClick = true;
                ReplaceTipConfirmDialog.this.dispose();
            }
        });
    }
}

