/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.step.select;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.FileChooser;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.info.InfoBoard;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.info.InfoItem;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.table.TableColumn;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.table.TableItem;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.AbstractBizStepLayout;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.select.SelectForReplaceStepCfg;
import com.huawei.ism.tool.bizpack.wizardparse.util.AutomateUtils;
import com.huawei.ism.tool.bizpack.wizardparse.util.BizPackageSceneUtils;
import com.huawei.ism.tool.bizpack.wizardparse.util.PackagesResource;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumnModel;

public class SelectForReplaceStepLayout
extends AbstractBizStepLayout {
    private static final long serialVersionUID = 2824885784636195901L;
    private static final int EXTEND_HEIGHT = 255;
    private static final int REFRESH_HEIGHT = 30;
    private static final int EXTEND_WEIGHT = 44;
    private static final Dimension TEXT_LABEL_SIZE = new Dimension(150, 30);
    private JPanel inputPanel = new JPanel();
    private JPanel docLinkPanel = new JPanel();
    private JCheckBox check = new JCheckBox();
    private JCheckBox defaultVisible = new JCheckBox();
    private List<JPanel> fileChooserPanelLists = new ArrayList<JPanel>();
    private int reFreshNum = 0;
    private Map<String, InfoItem> id2Component = new HashMap<String, InfoItem>();
    private boolean showItem = true;

    public SelectForReplaceStepLayout(SelectForReplaceStepCfg cfg) {
        BizPackageContext.getInstance().getId2LayoutMap().put(cfg.getId(), this);
        this.initUi(cfg);
        this.setCompName();
    }

    private void setCompName() {
        AutomateUtils.setNameAttribute(this.inputPanel, "inputPanel_selectForReplaceStep");
        AutomateUtils.setNameAttribute(this.docLinkPanel, "docLinkPanel_selectForReplaceStep");
        AutomateUtils.setNameAttribute(this.check, "check_selectForReplaceStep");
        AutomateUtils.setNameAttribute(this.defaultVisible, "defaultVisible");
    }

    private void initUi(SelectForReplaceStepCfg cfg) {
        this.setBizCfg(cfg);
        this.showItem = cfg.isShowitem();
        String processId = cfg.getProcessId();
        if (!"riskPower".equals(processId)) {
            this.defaultVisible.setText(ResourceUtil.getString("wizard.select.desc.defaultvisible"));
            String lang = BizPackageContext.getInstance().getJythonContext().getLan();
            if (lang.equalsIgnoreCase("en")) {
                this.defaultVisible.setToolTipText(ResourceUtil.getString("wizard.select.desc.defaultvisible"));
            }
        } else {
            this.defaultVisible.setVisible(false);
        }
        JComponent view = null;
        if (cfg.isShowall()) {
            if (cfg.getGuideLinkGroup().getLinks().size() > 0) {
                cfg.getGuideLinkGroup().init();
                this.docLinkPanel = cfg.getGuideLinkGroup().getLinkPanel();
                view = UCD.buildVerticalBox(null, (Component[])new Component[]{this.docLinkPanel, UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{this.inputPanel}), Box.createVerticalGlue(), UiMethod.buildCompsLeft((Component[])new Component[]{this.check})});
            } else {
                view = UCD.buildVerticalBox(null, (Component[])new Component[]{UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{this.inputPanel}), Box.createVerticalGlue(), UiMethod.buildCompsLeft((Component[])new Component[]{this.check})});
            }
        } else if (cfg.getGuideLinkGroup().getLinks().size() > 0) {
            cfg.getGuideLinkGroup().init();
            this.docLinkPanel = cfg.getGuideLinkGroup().getLinkPanel();
            view = UCD.buildVerticalBox(null, (Component[])new Component[]{this.docLinkPanel, UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{this.defaultVisible}), UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{this.inputPanel}), Box.createVerticalGlue(), UiMethod.buildCompsLeft((Component[])new Component[]{this.check})});
        } else {
            view = UCD.buildVerticalBox(null, (Component[])new Component[]{UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{this.defaultVisible}), UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{this.inputPanel}), Box.createVerticalGlue(), UiMethod.buildCompsLeft((Component[])new Component[]{this.check})});
        }
        this.setViewInLayout(cfg, view, true);
    }

    public boolean init(SelectForReplaceStepCfg preCfg) {
        this.inputPanel.removeAll();
        List<TableItem> selectTables = preCfg.getSelectTableList();
        this.inputPanel.setLayout(new BoxLayout(this.inputPanel, 1));
        if (null != preCfg.getLoadItem()) {
            this.inputPanel.add(preCfg.getLoadItem().getLayout());
        }
        PackagesResource util = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
        List<Object> infos = preCfg.getInfoList();
        int count = 0;
        for (Object object : infos) {
            if (!(object instanceof InfoBoard)) continue;
            ++count;
        }
        this.reFreshNum = count;
        int size = selectTables.size();
        JPanel tablePanel = null;
        if (size == 1) {
            tablePanel = this.createOneSelectTable(selectTables.get(0));
        } else if (size == 2) {
            tablePanel = this.createDoubleSelectTable(selectTables);
        } else {
            return false;
        }
        this.inputPanel.add(tablePanel);
        this.inputPanel.add(Box.createVerticalStrut(20));
        this.checkFreshPanel(preCfg, util, infos);
        return true;
    }

    void checkFreshPanel(SelectForReplaceStepCfg preCfg, PackagesResource util, List<Object> infos) {
        for (Object object : infos) {
            if (object instanceof InfoBoard) {
                InfoBoard refreshBoard = (InfoBoard)object;
                JPanel freshPanel = this.createFreshBoardPanel(refreshBoard);
                this.inputPanel.add(freshPanel);
            } else if (object instanceof FileChooser) {
                if (!this.fileChooserPanelLists.isEmpty()) continue;
                FileChooser fileChooser = (FileChooser)object;
                JPanel fileChooserPanel = this.createFileChooserPanel(fileChooser);
                this.inputPanel.add(fileChooserPanel);
                this.fileChooserPanelLists.add(fileChooserPanel);
            }
            this.inputPanel.add(Box.createVerticalStrut(12));
        }
        if (!this.fileChooserPanelLists.isEmpty()) {
            for (JPanel fileChooser : this.fileChooserPanelLists) {
                this.inputPanel.add(fileChooser);
            }
        }
        if (preCfg.getPromise().trim().equals("")) {
            this.check.setVisible(false);
        } else {
            this.check.setText(util.getString(preCfg.getPromise()));
            this.check.setToolTipText(util.getString(preCfg.getPromise()));
        }
    }

    private JPanel createOneSelectTable(TableItem selectTableItem) {
        IsmTable ismtable = selectTableItem.getComponent();
        this.setTableLenth(selectTableItem, ismtable);
        TableScrollPane tableScrollPane = new TableScrollPane(this.showItem, true, selectTableItem.isNeedMultiCheck(), ismtable);
        tableScrollPane.setPreferredSize(this.getTabelPreferredSize(false));
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)tableScrollPane);
        return panel;
    }

    private JPanel createDoubleSelectTable(List<TableItem> selectTables) {
        PackagesResource util = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        int i = 0;
        for (TableItem selectTableItem : selectTables) {
            IsmTable ismtable = selectTableItem.getComponent();
            this.setTableLenth(selectTableItem, ismtable);
            TableScrollPane tableScrollPane = new TableScrollPane(this.showItem, true, false, ismtable);
            JComponent view = UiMethod.buildFrameSpace((JComponent)tableScrollPane, (int)8);
            panel.add(view);
            TitledBorder title = BorderFactory.createTitledBorder(util.getString(selectTableItem.getName()));
            view.setBorder(title);
            if (++i >= selectTables.size()) continue;
            panel.add(Box.createHorizontalStrut(20));
        }
        return panel;
    }

    private void setTableLenth(TableItem selectTableItem, IsmTable ismtable) {
        List<TableColumn> colList = selectTableItem.getColumnIdList();
        TableColumnModel colModule = ismtable.getColumnModel();
        for (int index = 0; index < this.getColVisibleSize(colList); ++index) {
            TableColumn col = colList.get(index);
            int len = col.getLength();
            if (len <= 0) continue;
            colModule.getColumn(index).setPreferredWidth(len);
        }
    }

    private int getColVisibleSize(List<TableColumn> colList) {
        int size = 0;
        for (TableColumn tableColumn : colList) {
            if (!tableColumn.isVisible()) continue;
            ++size;
        }
        return size;
    }

    private JPanel createFreshBoardPanel(InfoBoard refreshBoard) {
        PackagesResource util = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        TitledBorder title = BorderFactory.createTitledBorder(util.getString(refreshBoard.getName()));
        panel.setBorder(title);
        panel.add(Box.createHorizontalStrut(6));
        List<InfoItem> items = refreshBoard.getRefreshItems();
        for (InfoItem refreshItem : items) {
            JLabel label = refreshItem.getLabel();
            JLabel text = refreshItem.getText();
            text.setPreferredSize(TEXT_LABEL_SIZE);
            text.setText("");
            panel.add(label);
            panel.add(Box.createHorizontalStrut(12));
            panel.add(text);
            panel.add(Box.createHorizontalGlue());
            this.id2Component.put(refreshItem.getId(), refreshItem);
        }
        return panel;
    }

    private JPanel createFileChooserPanel(FileChooser fileChooser) {
        JPanel panel = fileChooser.getFileChooserBord();
        if (BizPackageSceneUtils.isScene()) {
            String userPath = FilePathUtils.filterPath(BizPackageSceneUtils.sceneResultPath());
            fileChooser.fillTextFieldPath(userPath);
            fileChooser.setFileChooserDisable();
        }
        return panel;
    }

    private Dimension getTabelPreferredSize(boolean isDouble) {
        Dimension wizardSize = BizPackageContext.getInstance().getCurBizWizardCfg().getWizardSize();
        Dimension tableSize = null;
        if (!isDouble) {
            int hei = wizardSize.height - 255 - 30 * this.reFreshNum;
            int wid = wizardSize.width - 44;
            tableSize = new Dimension(wid, hei);
        }
        return tableSize;
    }

    public Map<String, InfoItem> getId2Component() {
        return this.id2Component;
    }

    public void setId2Component(Map<String, InfoItem> id2Component) {
        this.id2Component = id2Component;
    }

    public JCheckBox getCheck() {
        return this.check;
    }

    public void setCheck(JCheckBox check) {
        this.check = check;
    }

    public JCheckBox getDefaultVisible() {
        return this.defaultVisible;
    }

    public void setDefaultVisible(JCheckBox defaultVisible) {
        this.defaultVisible = defaultVisible;
    }
}

