/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.util;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.entity.A800Node;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.entity.DmeNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceOptionUtil {
    private static final Logger log = LoggerFactory.getLogger(DeviceOptionUtil.class);

    public static List<DevNode> getSelectNodes() {
        return DefaultNodeProviderImpl.getInstance().getNodeList().stream().map(DeviceOptionUtil::mapToShowNode).collect(Collectors.toList());
    }

    private static DevNode mapToShowNode(com.huawei.ism.tool.obase.entity.DevNode node) {
        if (node instanceof AiDevNode) {
            return ((AiDevNode)node).getA800Nodes().stream().filter(DmeNode::isSelect).findFirst().map(EntityUtils::toNewDev).orElseGet(() -> EntityUtils.toNewDev((com.huawei.ism.tool.obase.entity.DevNode)node));
        }
        return EntityUtils.toNewDev((com.huawei.ism.tool.obase.entity.DevNode)node);
    }

    public static DevNode transToRequestNode(DevNode devNode) {
        if (!ItDeviceType.A800_NODE.equals((Object)devNode.getItDeviceType())) {
            return devNode;
        }
        return DefaultNodeProviderImpl.getInstance().getNodeList().stream().filter(AiDevNode.class::isInstance).map(AiDevNode.class::cast).map(AiDevNode::getA800Nodes).flatMap(Collection::stream).filter(a800Node -> a800Node.getDeviceSerialNumber().equals(devNode.getDeviceSerialNumber())).map(DeviceOptionUtil::getRequestZone).map(EntityUtils::toNewDev).findFirst().orElse(devNode);
    }

    private static DmeNode getRequestZone(A800Node a800Node) {
        return a800Node.getZones().stream().filter(node -> DeviceOptionUtil.hasDeviceBeenAuthenticated(node)).min(Comparator.comparing(com.huawei.ism.tool.obase.entity.DevNode::getUuid)).orElse((DmeNode)a800Node.getZones().get(0));
    }

    public static List<String> getAllZoneIds(DevNode devNode, boolean filterAuth) {
        return DeviceOptionUtil.filterZones(devNode, filterAuth).map(com.huawei.ism.tool.obase.entity.DevNode::getUuid).collect(Collectors.toList());
    }

    public static List<DmeNode> getAllZoneNodes(DevNode devNode, boolean filterAuth) {
        return DeviceOptionUtil.filterZones(devNode, filterAuth).collect(Collectors.toList());
    }

    @NotNull
    private static Stream<DmeNode> filterZones(DevNode devNode, boolean filterAuth) {
        return DefaultNodeProviderImpl.getInstance().getNodeList().stream().filter(AiDevNode.class::isInstance).map(AiDevNode.class::cast).map(AiDevNode::getA800Nodes).flatMap(Collection::stream).filter(a800Node -> a800Node.getDeviceSerialNumber().equals(devNode.getDeviceSerialNumber())).map(A800Node::getZones).flatMap(Collection::stream).filter(node -> !filterAuth || DeviceOptionUtil.hasDeviceBeenAuthenticated(node));
    }

    public static boolean isNeedSetZoneInfos(DevNode devNode) {
        return ItDeviceType.A800_NODE.equals((Object)devNode.getItDeviceType());
    }

    public static Optional<AiDevNode> findDmeNode(DevNode devNode) {
        return DefaultNodeProviderImpl.getInstance().getNodeList().stream().filter(AiDevNode.class::isInstance).map(AiDevNode.class::cast).filter(node -> node.getA800Nodes().stream().anyMatch(a800Node -> a800Node.getDeviceSerialNumber().equals(devNode.getDeviceSerialNumber()))).findFirst();
    }

    public static Optional<A800Node> findA800Node(DevNode selectZone) {
        return DefaultNodeProviderImpl.getInstance().getNodeList().stream().filter(AiDevNode.class::isInstance).map(AiDevNode.class::cast).map(AiDevNode::getA800Nodes).flatMap(Collection::stream).filter(node -> node.getZones().stream().anyMatch(zone -> zone.getDeviceSerialNumber().equals(selectZone.getDeviceSerialNumber()))).findFirst();
    }

    public static boolean hasDeviceBeenAuthenticated(DmeNode node) {
        return node.getLoginUser() != null && !StringUtils.isNULLStr(node.getLoginUser().getUserName());
    }

    private DeviceOptionUtil() {
    }
}

