/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.util;

import com.huawei.ism.tool.bizpack.PackProduct;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;

public class ListSortUtil {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ListSortUtil.class);
    public static final String SORTTYPE_ASC = "ASC";
    public static final String SORTTYPE_DESC = "DESC";

    public static void sortProductName(List<PackProduct> list, final String sort) {
        if (list.isEmpty()) {
            LOGGER.error("the params is illegal");
            return;
        }
        Comparator<PackProduct> comparator = new Comparator<PackProduct>(){

            @Override
            public int compare(PackProduct productA, PackProduct productB) {
                int ret = 0;
                String stra = productA.getProductName();
                String strb = productB.getProductName();
                ret = ListSortUtil.sortStr(stra, strb, sort);
                return ret;
            }
        };
        Collections.sort(list, comparator);
    }

    public static void sortVersion(List<String> list, final String sort) {
        if (list.isEmpty()) {
            LOGGER.error("the params is illegal");
            return;
        }
        Comparator<String> comparator = new Comparator<String>(){

            @Override
            public int compare(String aValue, String bValue) {
                int ret = 0;
                ret = ListSortUtil.sortStr(aValue, bValue, sort);
                return ret;
            }
        };
        Collections.sort(list, comparator);
    }

    private static int sortStr(String aValue, String bValue, String sort) {
        String validSort;
        int ret = 0;
        String validA = aValue == null ? "" : aValue;
        String validB = bValue == null ? "" : bValue;
        String string = validSort = sort == null || !SORTTYPE_ASC.equals(sort) || !SORTTYPE_DESC.equals(sort) ? SORTTYPE_ASC : sort;
        if (SORTTYPE_ASC.equals(validSort)) {
            ret = validA.compareTo(validB);
        }
        if (SORTTYPE_DESC.equals(validSort)) {
            ret = validB.compareTo(validA);
        }
        return ret;
    }
}

