/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cms.verify.bc;

import java.math.BigInteger;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.security.auth.x500.X500Principal;

class CrlCompareUtil {
    CrlCompareUtil() {
    }

    static boolean unrevokeIssuerByRootCRL(List<X509CRL> rootCRLs, BigInteger serialNumber) {
        if (rootCRLs.isEmpty()) {
            return false;
        }
        Iterator<X509CRL> iter = rootCRLs.iterator();
        while (iter.hasNext()) {
            if (iter.next().getRevokedCertificate(serialNumber) == null) continue;
            return false;
        }
        return true;
    }

    static boolean isCaCert(X509Certificate cert) {
        if (cert.getBasicConstraints() == -1) {
            return false;
        }
        return !cert.getSubjectX500Principal().equals(cert.getIssuerX500Principal());
    }

    static void updateCert(List<byte[]> updateCrlList, List<X509CRL> rootCRLs, X509Certificate cert) throws CertificateEncodingException {
        boolean isNeedSave;
        boolean bl = isNeedSave = CrlCompareUtil.isCaCert(cert) && CrlCompareUtil.unrevokeIssuerByRootCRL(rootCRLs, cert.getSerialNumber());
        if (isNeedSave) {
            updateCrlList.add(cert.getEncoded());
        }
    }

    private static Optional<X509Certificate> getIssuerCert(List<X509Certificate> certList, Map<X500Principal, X509Certificate> certMap, X509CRL crl) {
        X509Certificate issuerCert = certMap.get(crl.getIssuerX500Principal());
        if (issuerCert != null) {
            return Optional.of(issuerCert);
        }
        for (X509Certificate cert : certList) {
            if (!cert.getSubjectX500Principal().equals(crl.getIssuerX500Principal())) continue;
            return Optional.of(cert);
        }
        return Optional.empty();
    }

    static boolean isUnrevoked(boolean isNeedCare, List<X509Certificate> certList, Map<X500Principal, X509Certificate> certMap, List<X509CRL> rootCrls, X509CRL crl) {
        if (!isNeedCare) {
            return true;
        }
        X509Certificate issuerCert = CrlCompareUtil.getIssuerCert(certList, certMap, crl).get();
        if (issuerCert != null) {
            return CrlCompareUtil.unrevokeIssuerByRootCRL(rootCrls, issuerCert.getSerialNumber());
        }
        return false;
    }

    static int getCompareRes(Date oriDate, Date updateTime, int oriStatus) {
        int res = 0;
        int status = oriStatus;
        if (oriDate != null) {
            if (updateTime.before(oriDate)) {
                res = 2;
            } else if (updateTime.after(oriDate)) {
                res = 1;
            } else {
                return oriStatus;
            }
            if (oriStatus != res) {
                status = oriStatus == 0 ? res : 3;
            }
        }
        return status;
    }
}

