/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.model;

import com.huawei.json.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryCondition
implements Cloneable {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryCondition.class);
    public static final String SORT_KEY = "sortby";
    public static final String FILTER_KEY = "filter";
    public static final String RANGE_KEY = "range";
    private Map<String, String> parameterMap;
    private List<JSONObject> filterJson = new ArrayList<JSONObject>();
    private String sortField = null;
    private boolean asc = false;
    private int start = -1;
    private int end = -1;

    public QueryCondition() {
    }

    public QueryCondition(Map<String, String> paramMap) {
        this.parameterMap = paramMap;
        String filter = this.parameterMap.get(FILTER_KEY);
        if (null != filter && !this.setFiter(filter)) {
            throw new IllegalArgumentException("The query param of url error:");
        }
        String sortor = this.parameterMap.get(SORT_KEY);
        if (null != sortor && !this.setSort(sortor)) {
            throw new IllegalArgumentException("The query conditon of url error:");
        }
        String range = this.parameterMap.get(RANGE_KEY);
        if (null != range && !this.setRange(range)) {
            throw new IllegalArgumentException("The query conditon of url error:");
        }
    }

    public List<JSONObject> getFilterJson() {
        return this.filterJson;
    }

    private boolean setFiter(String filterExpression) {
        String[] exps;
        for (String express : exps = filterExpression.split(" or ")) {
            JSONObject jonExp = new JSONObject();
            if (express.contains(" and ")) {
                String[] subExps;
                for (String subExp : subExps = express.split(" and ")) {
                    if (this.addConditon(jonExp, subExp)) continue;
                    return false;
                }
            } else if (!this.addConditon(jonExp, express)) {
                return false;
            }
            this.filterJson.add(jonExp);
        }
        return true;
    }

    private boolean addConditon(JSONObject json, String exp) {
        try {
            if (exp.contains("::")) {
                String[] strExps = exp.split("::");
                if (2 != strExps.length) {
                    return false;
                }
                json.put(strExps[0], (Object)strExps[1]);
                return true;
            }
            String[] strs = exp.split(":");
            if (2 != strs.length) {
                return false;
            }
            if (strs[1].contains("(") || strs[1].contains("[")) {
                json.put(strs[0], (Object)strs[1]);
            } else {
                json.put(strs[0], (Object)("Like " + strs[1]));
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private boolean setSort(String sort) {
        String[] strs = sort.split(",");
        if (2 != strs.length) {
            return false;
        }
        this.sortField = strs[0].trim();
        String aOrD = strs[1].trim();
        if ("a".equalsIgnoreCase(aOrD)) {
            this.asc = true;
        } else if ("d".equalsIgnoreCase(aOrD)) {
            this.asc = false;
        } else {
            return false;
        }
        return true;
    }

    public boolean hasSort() {
        return null != this.sortField;
    }

    public boolean hasFilter() {
        return null != this.filterJson && this.filterJson.size() > 0;
    }

    public String getSortField() {
        return this.sortField;
    }

    public boolean isAsc() {
        return this.asc;
    }

    public QueryCondition clone() throws CloneNotSupportedException {
        return (QueryCondition)super.clone();
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public boolean hasRange() {
        return this.start != -1 && this.end != -1;
    }

    public boolean setRange(String range) {
        String[] strs = range.split("-");
        if (strs.length != 2) {
            return false;
        }
        String startStr = strs[0];
        if ('[' == startStr.charAt(0)) {
            startStr = startStr.substring(1);
        }
        this.start = startStr.trim().length() == 0 ? Integer.MIN_VALUE : Integer.valueOf(startStr);
        String endStr = strs[1];
        if (']' == endStr.charAt(endStr.length() - 1)) {
            endStr = endStr.substring(0, endStr.length() - 1);
        }
        this.end = endStr.trim().length() == 0 ? Integer.MAX_VALUE : Integer.valueOf(endStr);
        return true;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public String getSort() {
        return this.getParam(SORT_KEY);
    }

    public String getFilter() {
        return this.getParam(FILTER_KEY);
    }

    public Map<String, String> getParamMap() {
        return new HashMap<String, String>(this.parameterMap);
    }

    public String getParam(String paramKey) {
        return this.parameterMap.get(paramKey);
    }
}

