/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.thread;

import com.huawei.ism.common.Framework;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.thread.TaskListener;
import com.huawei.ism.ui.swing.dialog.ErrorDialog;
import com.huawei.ism.ui.swing.dialog.InformationDialog;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTaskListener
implements TaskListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTaskListener.class);
    private ProgressDialog progressDialog = null;
    private Container parentDialog = null;

    public DefaultTaskListener() {
    }

    public DefaultTaskListener(Container dialog) {
        this.parentDialog = dialog;
    }

    @Override
    public void taskCompleted(Object result) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultTaskListener.this.closeProgressDialog();
                InformationDialog dialog = DefaultTaskListener.this.getInformationDialog(DefaultTaskListener.this.parentDialog);
                if (dialog == null) {
                    LOGGER.error("get information Dialog failed. ");
                    return;
                }
                dialog.setVisible(true);
            }
        });
    }

    @Override
    public void taskFailed(Object result, final Throwable exception) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultTaskListener.this.closeProgressDialog();
                String message = DefaultTaskListener.this.getErrorMessage(exception);
                ErrorDialog errorDialog = DefaultTaskListener.this.getErrorDialog(DefaultTaskListener.this.parentDialog, message);
                if (errorDialog != null) {
                    errorDialog.setVisible(true);
                }
            }
        });
        LOGGER.error(exception.getMessage(), exception);
    }

    @Override
    public void taskRunning(int progress) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (null == DefaultTaskListener.this.progressDialog) {
                    if (null == DefaultTaskListener.this.parentDialog) {
                        DefaultTaskListener.this.parentDialog = Framework.getInstance().getMainFrame();
                    }
                    DefaultTaskListener.this.progressDialog = DefaultTaskListener.this.getProgressDialog(DefaultTaskListener.this.parentDialog);
                    if (null != DefaultTaskListener.this.progressDialog) {
                        DefaultTaskListener.this.progressDialog.setVisible(true);
                        DefaultTaskListener.this.progressDialog.toFront();
                    }
                }
            }
        });
    }

    private ProgressDialog getProgressDialog(Container container) {
        if (container instanceof Frame) {
            return new ProgressDialog((Window)((Frame)container));
        }
        if (container instanceof JDialog) {
            return new ProgressDialog((Window)((JDialog)container));
        }
        return null;
    }

    private ErrorDialog getErrorDialog(Container container, String errorMessage) {
        if (container instanceof Frame) {
            return new ErrorDialog((Frame)container, errorMessage);
        }
        if (container instanceof JDialog) {
            return new ErrorDialog((JDialog)container, errorMessage);
        }
        return null;
    }

    private InformationDialog getInformationDialog(Container container) {
        if (container instanceof Frame) {
            return new InformationDialog((Frame)container);
        }
        if (container instanceof JDialog) {
            return new InformationDialog((JDialog)container);
        }
        return null;
    }

    protected void closeProgressDialog() {
        if (null != this.progressDialog) {
            this.progressDialog.dispose();
        }
    }

    protected String getErrorMessage(Throwable exception) {
        String message;
        if (exception instanceof IsmException) {
            IsmException baseExc = (IsmException)exception;
            message = baseExc.getErrorMessage();
        } else {
            message = exception.getMessage();
        }
        return message;
    }

    @Override
    public void taskInterrupted(String message) {
        this.closeProgressDialog();
        LOGGER.error("Task Interrupted:" + message);
    }

    public void setProgressDialog(ProgressDialog progressDialog) {
        this.progressDialog = progressDialog;
    }

    public ProgressDialog getProgressDialog() {
        return this.progressDialog;
    }

    public void setParentDialog(Container parentDialog) {
        this.parentDialog = parentDialog;
    }

    public Container getParentDialog() {
        return this.parentDialog;
    }
}

