/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tlv.lang;

import com.huawei.ism.tlv.lang.IsmSignedInteger;

public class SignedInt32
extends IsmSignedInteger {
    private static final long serialVersionUID = -4505752174646939468L;
    private final int value;

    public SignedInt32(byte[] bytes) {
        this.value = this.fromByteArray(bytes, bytes.length);
    }

    public SignedInt32(byte[] bytes, int offset) {
        if (null == bytes) {
            throw new IllegalArgumentException("Data cannot be null");
        }
        if (offset < 0 || bytes.length - offset < 4) {
            throw new IllegalArgumentException("Data size mismatch");
        }
        byte[] tmp = new byte[4];
        System.arraycopy(bytes, offset, tmp, 0, 4);
        this.value = this.fromByteArray(tmp, tmp.length);
    }

    public SignedInt32(int value) {
        this.value = value;
    }

    private int fromByteArray(byte[] abyte0, int bytesToRead) {
        if (abyte0.length < bytesToRead || bytesToRead <= 0) {
            throw new IllegalArgumentException("Data size mismatch");
        }
        int arrayLength = abyte0.length;
        int count = bytesToRead >= 4 ? 4 : bytesToRead;
        int intValue = abyte0[arrayLength - 1] & 0xFF;
        for (int i = 2; i <= count; ++i) {
            intValue <<= 8;
            intValue |= abyte0[arrayLength - i] & 0xFF;
        }
        return intValue;
    }

    @Override
    public byte[] toByteArray() {
        byte[] bytes = new byte[]{(byte)(this.value >>> 0), (byte)(this.value >>> 8), (byte)(this.value >>> 16), (byte)(this.value >>> 24)};
        return bytes;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SignedInt32 other = (SignedInt32)obj;
        return this.value == other.value;
    }
}

