/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.forms.mainframe;

import com.huawei.ism.ui.forms.mainframe.MainPane;
import com.huawei.ism.ui.forms.mainframe.MainPaneTree;
import com.huawei.ism.ui.swing.PropertyPane;
import com.huawei.ism.ui.swing.tree.IsmTreeNode;
import com.huawei.ism.ui.widgets.action.ActionManager;
import com.huawei.ism.util.SwingUtil;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MainPaneTreeSelectionHandler
implements TreeSelectionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MainPaneTreeSelectionHandler.class);
    private MainPane mainPane = null;
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private TreeSelectionEvent lastEvent = null;

    public MainPaneTreeSelectionHandler(MainPane mainPane) {
        this.mainPane = mainPane;
        TreeSelectEventTask task = new TreeSelectEventTask();
        Thread thread = new Thread(task);
        thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread1, Throwable throwable) {
                LOGGER.error("Uncaught exception on thread" + thread1.getName(), throwable);
            }
        });
        thread.setName("Tree Event Processor Thread");
        thread.start();
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        try {
            this.lock.writeLock().lock();
            this.lastEvent = e;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private TreeSelectionEvent getLastestTreeSelectionEvent() {
        TreeSelectionEvent event = null;
        try {
            this.lock.writeLock().lock();
            event = this.lastEvent;
            this.lastEvent = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return event;
    }

    private void processTreeSelectionEvent() {
        TreeSelectionEvent lastEventTemp = this.getLastestTreeSelectionEvent();
        if (lastEventTemp == null) {
            return;
        }
        MainPaneTree tree = (MainPaneTree)lastEventTemp.getSource();
        TreePath selectionPath = tree.getSelectionPath();
        if (selectionPath == null) {
            return;
        }
        Object obj = selectionPath.getLastPathComponent();
        if (obj instanceof IsmTreeNode) {
            IsmTreeNode selectionNode = (IsmTreeNode)obj;
            ActionManager.getInstance().updateActions(selectionNode.getDeviceID());
            this.updatePropertyPane(selectionNode);
        }
    }

    private void updatePropertyPane(IsmTreeNode selectionNode) {
        PropertyPane pane = selectionNode.getPropertyPane();
        if (null == pane) {
            return;
        }
        SwingUtil.runInEventDispatchThread(new ClkUpdTask(pane));
        this.mainPane.setPropertyPane(pane);
    }

    private final class TreeSelectEventTask
    implements Runnable {
        private TreeSelectEventTask() {
        }

        @Override
        public void run() {
            while (true) {
                this.processEvent();
            }
        }

        private void processEvent() {
            try {
                MainPaneTreeSelectionHandler.this.processTreeSelectionEvent();
                Thread.sleep(150L);
            }
            catch (Throwable e) {
                LOGGER.error("processTreeSelectionEvent error", e);
            }
        }
    }

    private static final class ClkUpdTask
    implements Runnable {
        private final PropertyPane pane;

        private ClkUpdTask(PropertyPane pane) {
            this.pane = pane;
        }

        @Override
        public void run() {
            this.pane.clickToUpdate();
        }
    }
}

