/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.module.task;

import com.huawei.ism.ui.module.task.BackgroundTask;
import com.huawei.ism.ui.module.task.ITaskParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTaskParser<T>
implements ITaskParser<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTaskParser.class);
    protected static final int PROGRESS_MAX_VALUE = 100;
    protected static final int PROGRESS_MIN_VALUE = 0;

    @Override
    public BackgroundTask createTask(T obj) {
        if (null == obj) {
            return null;
        }
        BackgroundTask task = null;
        try {
            String taskName = this.getTaskName(obj);
            if (null == taskName) {
                return null;
            }
            task = new BackgroundTask(this.getTaskSN(obj));
            task.setName(taskName);
            task.setState(this.getTaskState(obj));
            task.setDeviceName(this.getDeviceName(obj));
            task.setTaskObject(this.getTaskObjectName(obj));
            task.setProgress(this.getProgress(obj));
            task.setResult(this.getTaskDescription(obj));
            task.setDeviceID(this.getDeviceID(obj));
            task.setRemoveOnCompleted(this.removedOnCompleted(obj));
        }
        catch (Throwable t) {
            LOGGER.error("convert error.");
        }
        return task;
    }

    public boolean removeTaskOnComplete() {
        return true;
    }

    protected String getTaskObjectName(T obj) {
        if (null == obj) {
            return null;
        }
        return obj.toString();
    }

    public String getTaskDescription(T obj) {
        return null;
    }

    @Override
    public BackgroundTask.State getTaskState(T obj) {
        return BackgroundTask.State.RUNNING_NORMAL;
    }

    protected abstract String getTaskName(T var1);

    protected abstract int getProgress(T var1);

    protected abstract String getDeviceName(T var1);

    protected abstract String getDeviceID(T var1);

    @Override
    public boolean removedOnCompleted(T obj) {
        BackgroundTask.State taskState = this.getTaskState(obj);
        return taskState == BackgroundTask.State.COMPLETED_NORMAL;
    }
}

