/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing;

import com.huawei.ism.ui.forms.help.HelpKeyGetter;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui2.module.featuremanager.FeatureItem;
import com.huawei.ism.util.UCD;
import java.awt.Color;
import javax.swing.JPanel;
import javax.swing.UIManager;

public abstract class PropertyPane
extends JPanel
implements HelpKeyGetter {
    public static final int CLICK_TO_UPDATE = 0;
    public static final int AUTO_UPDATE = 1;
    private static final long serialVersionUID = -1923342032629426680L;
    private boolean drawBorder = true;
    private FeatureItem featureItem;

    public PropertyPane() {
        this.setOpaque(true);
        this.updateCustomProperty();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.updateCustomProperty();
    }

    protected void updateCustomProperty() {
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.blue || IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.unify) {
            this.setBackground(Color.WHITE);
        } else {
            this.setBackground(UIManager.getColor("IsmArmorStyle.BaseColor"));
            this.setBorder(UCD.createEmptyBorder(3));
            if (!this.drawBorder) {
                this.setBorder(UCD.createEmptyBorder(0));
            }
        }
    }

    public abstract void updateProperty(int var1);

    public void clickToUpdate() {
        this.updateProperty(0);
    }

    public void autoUpdate() {
        this.updateProperty(1);
    }

    public void stopDisplay() {
    }

    public abstract String getDeviceID();

    public final void setDrawBorderMark(boolean dropBorderMark) {
        this.drawBorder = dropBorderMark;
        this.updateCustomProperty();
    }

    public final FeatureItem getFeatureItem() {
        return this.featureItem;
    }

    public final void setFeatureItem(FeatureItem featureItem) {
        this.featureItem = featureItem;
    }

    public boolean allowLeaveOff() {
        return true;
    }

    @Override
    public String getHelpKey() {
        return "default";
    }
}

