/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf.armor;

import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui.swing.plaf.armor.ArmorTitleBarPane;
import com.huawei.ism.util.CommonUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRootPaneUI;

public class ArmorRootPaneUI
extends BasicRootPaneUI {
    private static final int CORNER_DRAG_WIDTH = 16;
    private static final int BORDER_DRAG_THICKNESS = 5;
    private static final String[] BORDER_KEYS = new String[]{null, "RootPane.frameBorder", "RootPane.plainDialogBorder", "RootPane.informationDialogBorder", "RootPane.errorDialogBorder", "RootPane.colorChooserDialogBorder", "RootPane.fileChooserDialogBorder", "RootPane.questionDialogBorder", "RootPane.warningDialogBorder"};
    private static final int[] CURSOR_SHAPE = new int[]{6, 6, 8, 7, 7, 6, 0, 0, 0, 7, 10, 0, 0, 0, 11, 4, 0, 0, 0, 5, 4, 4, 9, 5, 5};
    private Window window;
    private JRootPane root;
    private Cursor lastCursor = Cursor.getPredefinedCursor(0);
    private MouseInputListener mouseInputListener;
    private JComponent titlePane;
    private LayoutManager layoutManager;
    private LayoutManager oldLayout;

    public static ComponentUI createUI(JComponent c) {
        return new ArmorRootPaneUI();
    }

    @Override
    public void installUI(JComponent comp) {
        super.installUI(comp);
        this.root = CommonUtil.convertObject(comp, JRootPane.class);
        int style = this.root.getWindowDecorationStyle();
        if (style != 0) {
            this.installClientDecorations(this.root);
        }
    }

    @Override
    public void uninstallUI(JComponent comp) {
        super.uninstallUI(comp);
        this.uninstallClientDecorations(this.root);
        this.layoutManager = null;
        this.mouseInputListener = null;
        this.root = null;
    }

    private void installWindowListeners(JRootPane rootPane, Component parent) {
        this.window = parent instanceof Window ? (Window)parent : SwingUtilities.getWindowAncestor(parent);
        if (this.window != null) {
            if (this.mouseInputListener == null) {
                this.mouseInputListener = this.createWindowMouseInputListener();
            }
            this.window.addMouseListener(this.mouseInputListener);
            this.window.addMouseMotionListener(this.mouseInputListener);
        }
    }

    private void installClientDecorations(JRootPane rootPane) {
        this.installBorder(rootPane);
        JComponent titlePaneComp = this.createTitlePane(rootPane);
        this.setTitlePane(rootPane, titlePaneComp);
        this.installWindowListeners(rootPane, rootPane.getParent());
        this.installLayout(rootPane);
        if (this.window != null) {
            rootPane.revalidate();
            rootPane.repaint();
        }
    }

    void installBorder(JRootPane rootPane) {
        int windowDecorationStyle = rootPane.getWindowDecorationStyle();
        if (windowDecorationStyle == 0) {
            LookAndFeel.uninstallBorder(rootPane);
        } else {
            LookAndFeel.installBorder(rootPane, BORDER_KEYS[windowDecorationStyle]);
        }
    }

    private void installLayout(JRootPane rootPane) {
        if (this.layoutManager == null) {
            this.layoutManager = this.createLayoutManager();
        }
        this.oldLayout = rootPane.getLayout();
        rootPane.setLayout(this.layoutManager);
    }

    private LayoutManager createLayoutManager() {
        return new MetalRootLayout();
    }

    private void uninstallBorder(JRootPane rootPane) {
        LookAndFeel.uninstallBorder(rootPane);
    }

    private void uninstallWindowListeners() {
        if (this.window != null) {
            this.window.removeMouseListener(this.mouseInputListener);
            this.window.removeMouseMotionListener(this.mouseInputListener);
        }
    }

    private void uninstallLayout(JRootPane rootPane) {
        if (this.oldLayout != null) {
            rootPane.setLayout(this.oldLayout);
            this.oldLayout = null;
        }
    }

    private void uninstallClientDecorations(JRootPane rootPane) {
        this.uninstallBorder(rootPane);
        this.uninstallWindowListeners();
        this.setTitlePane(rootPane, null);
        this.uninstallLayout(rootPane);
        int windowStyle = rootPane.getWindowDecorationStyle();
        if (windowStyle == 0) {
            rootPane.repaint();
            rootPane.revalidate();
        }
        if (this.window != null) {
            this.window.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.window = null;
    }

    protected JComponent createTitlePane(JRootPane rootPane) {
        ArmorTitleBarPane barPane = new ArmorTitleBarPane(rootPane, this);
        MouseInputListener listener = this.createWindowMouseInputListener();
        barPane.addMouseListener(listener);
        barPane.addMouseMotionListener(listener);
        return barPane;
    }

    private MouseInputListener createWindowMouseInputListener() {
        return new MouseInputHandler();
    }

    private void setTitlePane(JRootPane rootPane, JComponent comp) {
        JLayeredPane layeredPane = rootPane.getLayeredPane();
        JComponent oldTitlePane = this.getTitlePane();
        if (oldTitlePane != null) {
            oldTitlePane.setVisible(false);
            layeredPane.remove(oldTitlePane);
        }
        if (comp != null) {
            layeredPane.add((Component)comp, JLayeredPane.FRAME_CONTENT_LAYER);
            comp.setVisible(true);
        }
        this.titlePane = comp;
    }

    private JComponent getTitlePane() {
        return this.titlePane;
    }

    private JRootPane getRootPane() {
        return this.root;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        String propertyName = propertyChangeEvent.getPropertyName();
        if (propertyName == null) {
            return;
        }
        if (propertyName.equals("windowDecorationStyle")) {
            JRootPane rootPane = (JRootPane)propertyChangeEvent.getSource();
            int windoStyle = rootPane.getWindowDecorationStyle();
            this.uninstallClientDecorations(rootPane);
            if (windoStyle != 0) {
                this.installClientDecorations(rootPane);
            }
        } else if (propertyName.equals("ancestor")) {
            this.uninstallWindowListeners();
            if (((JRootPane)propertyChangeEvent.getSource()).getWindowDecorationStyle() != 0) {
                this.installWindowListeners(this.root, this.root.getParent());
            }
        }
    }

    private class MouseInputHandler
    implements MouseInputListener {
        private boolean isMovingWindow;
        private int dragCursor;
        private int dragOffsetX;
        private int dragOffsetY;
        private int dragWidth;
        private int dragHeight;

        private MouseInputHandler() {
        }

        @Override
        public void mousePressed(MouseEvent ev) {
            JRootPane rootPane = ArmorRootPaneUI.this.getRootPane();
            if (rootPane.getWindowDecorationStyle() == 0) {
                return;
            }
            Point dragPoint = ev.getPoint();
            Container container = (Container)ev.getSource();
            if (container != null && container instanceof Window) {
                ((Window)container).toFront();
            }
            Point point = SwingUtilities.convertPoint(container, dragPoint, ArmorRootPaneUI.this.getTitlePane());
            Frame frame = null;
            Dialog dialog = null;
            if (container instanceof Frame) {
                frame = (Frame)container;
            } else if (container instanceof Dialog) {
                dialog = (Dialog)container;
            }
            int frameState = frame != null ? frame.getExtendedState() : 0;
            this.pressMouse(dragPoint, container, point, frame, dialog, frameState);
        }

        private void pressMouse(Point dragPoint, Container container, Point point, Frame frame, Dialog dialog, int frameState) {
            if (ArmorRootPaneUI.this.getTitlePane() != null && ArmorRootPaneUI.this.getTitlePane().contains(point)) {
                boolean meetMovingWindow = this.meetMovingWindow(dragPoint, container, frame, dialog, frameState);
                boolean isTitleBar = container instanceof ArmorTitleBarPane;
                if (meetMovingWindow || isTitleBar) {
                    this.isMovingWindow = true;
                    this.dragOffsetX = (int)dragPoint.getX();
                    this.dragOffsetY = (int)dragPoint.getY();
                }
            } else {
                boolean temp;
                boolean bl = temp = dialog != null && dialog.isResizable();
                if (frame != null && frame.isResizable() && (frameState & 6) == 0 || temp) {
                    this.dragOffsetX = (int)dragPoint.getX();
                    this.dragOffsetY = (int)dragPoint.getY();
                    this.dragWidth = container.getWidth();
                    this.dragHeight = container.getHeight();
                    this.dragCursor = this.getCursor(this.calCorner(container, (int)dragPoint.getX(), (int)dragPoint.getY()));
                }
            }
        }

        private boolean meetMovingWindow(Point dragPoint, Container container, Frame frame, Dialog dialog, int frameState) {
            boolean result = frame != null && (frameState & 6) == 0 || dialog != null;
            return result && (int)dragPoint.getY() >= 5 && (int)dragPoint.getX() >= 5 && (int)dragPoint.getX() < container.getWidth() - 5;
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if (this.dragCursor != 0 && ArmorRootPaneUI.this.window != null && !ArmorRootPaneUI.this.window.isValid()) {
                ArmorRootPaneUI.this.window.validate();
                ArmorRootPaneUI.this.getRootPane().repaint();
            }
            this.isMovingWindow = false;
            this.dragCursor = 0;
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            JRootPane rootPane = ArmorRootPaneUI.this.getRootPane();
            if (rootPane.getWindowDecorationStyle() == 0) {
                return;
            }
            Container container = this.getWindow(event);
            Frame frame = null;
            Dialog dialog = null;
            if (container instanceof Frame) {
                frame = (Frame)container;
            } else if (container instanceof Dialog) {
                dialog = (Dialog)container;
            }
            int cursor = this.getCursor(this.calCorner(container, event.getX(), event.getY()));
            boolean bool = frame != null && frame.isResizable() && (frame.getExtendedState() & 6) == 0;
            boolean bl = bool = bool || dialog != null && dialog.isResizable();
            if (cursor != 0 && bool) {
                container.setCursor(Cursor.getPredefinedCursor(cursor));
            } else {
                container.setCursor(ArmorRootPaneUI.this.lastCursor);
            }
        }

        private void adjust(Rectangle bounds, Dimension dimension, int deltaX, int deltaY, int deltaWidth, int deltaHeight) {
            int boundsX = (int)bounds.getX();
            int boundsY = (int)bounds.getY();
            boundsX += deltaX;
            boundsY += deltaY;
            bounds.width += deltaWidth;
            bounds.height += deltaHeight;
            if (dimension != null) {
                int correction;
                if (bounds.width < dimension.width) {
                    correction = dimension.width - bounds.width;
                    if (deltaX != 0) {
                        boundsX -= correction;
                    }
                    bounds.width = dimension.width;
                }
                if (bounds.height < dimension.height) {
                    correction = dimension.height - bounds.height;
                    if (deltaY != 0) {
                        boundsY -= correction;
                    }
                    bounds.height = dimension.height;
                }
            }
            bounds.setLocation(boundsX, boundsY);
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            Container container = this.getWindow(event);
            Point point = event.getPoint();
            if (this.isMovingWindow) {
                Point eventLocationOnScreen = event.getLocationOnScreen();
                ArmorRootPaneUI.this.window.setLocation(eventLocationOnScreen.x - this.dragOffsetX, eventLocationOnScreen.y - this.dragOffsetY);
            } else if (this.dragCursor != 0) {
                Rectangle bounds = container.getBounds();
                Rectangle startBounds = new Rectangle(bounds);
                Dimension minDimension = container.getMinimumSize();
                this.dragCusor(point, bounds, minDimension);
                if (!bounds.equals(startBounds)) {
                    container.setBounds(bounds);
                    if (Toolkit.getDefaultToolkit().isDynamicLayoutActive()) {
                        container.validate();
                        ArmorRootPaneUI.this.getRootPane().repaint();
                    }
                }
            }
        }

        private void dragCusor(Point point, Rectangle rectangle, Dimension dimension) {
            switch (this.dragCursor) {
                case 11: {
                    this.adjust(rectangle, dimension, 0, 0, (int)point.getX() + (this.dragWidth - this.dragOffsetX) - rectangle.width, 0);
                    break;
                }
                case 9: {
                    this.adjust(rectangle, dimension, 0, 0, 0, (int)point.getY() + (this.dragHeight - this.dragOffsetY) - rectangle.height);
                    break;
                }
                case 8: {
                    this.adjust(rectangle, dimension, 0, (int)point.getY() - this.dragOffsetY, 0, -((int)point.getY() - this.dragOffsetY));
                    break;
                }
                case 10: {
                    this.adjust(rectangle, dimension, (int)point.getX() - this.dragOffsetX, 0, -((int)point.getX() - this.dragOffsetX), 0);
                    break;
                }
                case 7: {
                    this.adjust(rectangle, dimension, 0, (int)point.getY() - this.dragOffsetY, (int)point.getX() + (this.dragWidth - this.dragOffsetX) - rectangle.width, -((int)point.getY() - this.dragOffsetY));
                    break;
                }
                case 5: {
                    this.adjust(rectangle, dimension, 0, 0, (int)point.getX() + (this.dragWidth - this.dragOffsetX) - rectangle.width, (int)point.getY() + (this.dragHeight - this.dragOffsetY) - rectangle.height);
                    break;
                }
                case 6: {
                    this.adjust(rectangle, dimension, (int)point.getX() - this.dragOffsetX, (int)point.getY() - this.dragOffsetY, -((int)point.getX() - this.dragOffsetX), -((int)point.getY() - this.dragOffsetY));
                    break;
                }
                case 4: {
                    this.adjust(rectangle, dimension, (int)point.getX() - this.dragOffsetX, 0, -((int)point.getX() - this.dragOffsetX), (int)point.getY() + (this.dragHeight - this.dragOffsetY) - rectangle.height);
                    break;
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent event) {
            Container container = (Container)event.getSource();
            ArmorRootPaneUI.this.lastCursor = container.getCursor();
            this.mouseMoved(event);
        }

        @Override
        public void mouseExited(MouseEvent event) {
            Container container = (Container)event.getSource();
            container.setCursor(Cursor.getDefaultCursor());
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            Container container = this.getWindow(event);
            if (!(container instanceof Frame)) {
                return;
            }
            Frame frame = (Frame)container;
            Point convertPoint = SwingUtilities.convertPoint(container, event.getPoint(), ArmorRootPaneUI.this.getTitlePane());
            int state = frame.getExtendedState();
            JComponent comp = ArmorRootPaneUI.this.getTitlePane();
            if (null == comp || !comp.contains(convertPoint)) {
                return;
            }
            if (event.getClickCount() % 2 == 0 && (event.getModifiers() & 0x10) != 0) {
                if (!frame.isResizable()) {
                    return;
                }
                IsmPlafUtils.setFrameMaxBounds(frame);
                if ((state & 6) != 0) {
                    frame.setExtendedState(state & 0xFFFFFFF9);
                } else {
                    frame.setExtendedState(state | 6);
                }
            }
        }

        private Container getWindow(MouseEvent event) {
            Container container = (Container)event.getSource();
            if (!(container instanceof Window)) {
                container = SwingUtilities.getWindowAncestor(container);
            }
            return container;
        }

        private int calCorner(Container container, int x, int y) {
            Insets insets = container.getInsets();
            int xPosition = this.calPosition(x - insets.left, container.getWidth() - insets.left - insets.right);
            int yPosition = this.calPosition(y - insets.top, container.getHeight() - insets.top - insets.bottom);
            if (xPosition == -1 || yPosition == -1) {
                return -1;
            }
            return yPosition * 5 + xPosition;
        }

        private int getCursor(int corner) {
            if (corner == -1) {
                return 0;
            }
            return CURSOR_SHAPE[corner];
        }

        private int calPosition(int spot, int width) {
            if (spot < 5) {
                return 0;
            }
            if (spot < 16) {
                return 1;
            }
            if (spot >= width - 5) {
                return 4;
            }
            if (spot >= width - 16) {
                return 3;
            }
            return 2;
        }
    }

    private static class MetalRootLayout
    implements LayoutManager2 {
        private MetalRootLayout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension titlePaneDimension;
            JComponent titlePane;
            Dimension menuBarDimension;
            int cpWidth = 0;
            int cpHeight = 0;
            int mbWidth = 0;
            int mbHeight = 0;
            int tpWidth = 0;
            int tpHeight = 0;
            Insets insets = parent.getInsets();
            JRootPane root = CommonUtil.convertObject(parent, JRootPane.class);
            Dimension contentPaneDimension = root.getContentPane() != null ? root.getContentPane().getPreferredSize() : root.getSize();
            if (contentPaneDimension != null) {
                cpWidth = contentPaneDimension.width;
                cpHeight = contentPaneDimension.height;
            }
            if (root.getJMenuBar() != null && (menuBarDimension = root.getJMenuBar().getPreferredSize()) != null) {
                mbWidth = menuBarDimension.width;
                mbHeight = menuBarDimension.height;
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof ArmorRootPaneUI && (titlePane = ((ArmorRootPaneUI)root.getUI()).getTitlePane()) != null && (titlePaneDimension = titlePane.getPreferredSize()) != null) {
                tpWidth = titlePaneDimension.width;
                tpHeight = titlePaneDimension.height;
            }
            return new Dimension(Math.max(Math.max(cpWidth, mbWidth), tpWidth) + insets.left + insets.right, cpHeight + mbHeight + tpHeight + insets.top + insets.bottom);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Dimension titlePaneDimension;
            JComponent titlePane;
            Dimension menuBarDimension;
            int cpWidth = 0;
            int cpHeight = 0;
            int mbWidth = 0;
            int mbHeight = 0;
            int tpWidth = 0;
            int tpHeight = 0;
            Insets insets = parent.getInsets();
            JRootPane root = CommonUtil.convertObject(parent, JRootPane.class);
            Dimension contentPaneDimension = root.getContentPane() != null ? root.getContentPane().getMinimumSize() : root.getSize();
            if (contentPaneDimension != null) {
                cpWidth = contentPaneDimension.width;
                cpHeight = contentPaneDimension.height;
            }
            if (root.getJMenuBar() != null && (menuBarDimension = root.getJMenuBar().getMinimumSize()) != null) {
                mbWidth = menuBarDimension.width;
                mbHeight = menuBarDimension.height;
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof ArmorRootPaneUI && (titlePane = ((ArmorRootPaneUI)root.getUI()).getTitlePane()) != null && (titlePaneDimension = titlePane.getMinimumSize()) != null) {
                tpWidth = titlePaneDimension.width;
                tpHeight = titlePaneDimension.height;
            }
            return new Dimension(Math.max(Math.max(cpWidth, mbWidth), tpWidth) + insets.left + insets.right, cpHeight + mbHeight + tpHeight + insets.top + insets.bottom);
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            int maxWidth;
            int maxHeight;
            Dimension titlePaneDimension;
            JComponent titlePane;
            Dimension menuBarDimension;
            Dimension contentPaneDimension;
            int cpWidth = Integer.MAX_VALUE;
            int cpHeight = Integer.MAX_VALUE;
            int mbWidth = Integer.MAX_VALUE;
            int mbHeight = Integer.MAX_VALUE;
            int tpWidth = Integer.MAX_VALUE;
            int tpHeight = Integer.MAX_VALUE;
            Insets insets = target.getInsets();
            JRootPane root = CommonUtil.convertObject(target, JRootPane.class);
            if (root.getContentPane() != null && (contentPaneDimension = root.getContentPane().getMaximumSize()) != null) {
                cpWidth = contentPaneDimension.width;
                cpHeight = contentPaneDimension.height;
            }
            if (root.getJMenuBar() != null && (menuBarDimension = root.getJMenuBar().getMaximumSize()) != null) {
                mbWidth = menuBarDimension.width;
                mbHeight = menuBarDimension.height;
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof ArmorRootPaneUI && (titlePane = ((ArmorRootPaneUI)root.getUI()).getTitlePane()) != null && (titlePaneDimension = titlePane.getMaximumSize()) != null) {
                tpWidth = titlePaneDimension.width;
                tpHeight = titlePaneDimension.height;
            }
            if ((maxHeight = Math.max(Math.max(cpHeight, mbHeight), tpHeight)) != Integer.MAX_VALUE) {
                maxHeight = cpHeight + mbHeight + tpHeight + insets.top + insets.bottom;
            }
            if ((maxWidth = Math.max(Math.max(cpWidth, mbWidth), tpWidth)) != Integer.MAX_VALUE) {
                maxWidth += insets.left + insets.right;
            }
            return new Dimension(maxWidth, maxHeight);
        }

        @Override
        public void layoutContainer(Container parent) {
            Dimension tpd;
            JComponent titlePane;
            JRootPane root = CommonUtil.convertObject(parent, JRootPane.class);
            Rectangle bounds = root.getBounds();
            Insets insets = root.getInsets();
            int nextY = 0;
            int innerWidth = bounds.width - insets.right - insets.left;
            int innerHeight = bounds.height - insets.top - insets.bottom;
            if (root.getLayeredPane() != null) {
                root.getLayeredPane().setBounds(insets.left, insets.top, innerWidth, innerHeight);
            }
            if (root.getGlassPane() != null) {
                root.getGlassPane().setBounds(insets.left, insets.top, innerWidth, innerHeight);
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof ArmorRootPaneUI && (titlePane = ((ArmorRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getPreferredSize()) != null) {
                int tpHeight = tpd.height;
                titlePane.setBounds(0, 0, innerWidth, tpHeight);
                nextY += tpHeight;
            }
            if (root.getJMenuBar() != null) {
                Dimension mbd = root.getJMenuBar().getPreferredSize();
                root.getJMenuBar().setBounds(0, nextY, innerWidth, mbd.height);
                nextY += mbd.height;
            }
            if (root.getContentPane() != null) {
                root.getContentPane().setBounds(0, nextY, innerWidth, innerHeight < nextY ? 0 : innerHeight - nextY);
            }
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        @Override
        public void invalidateLayout(Container target) {
        }
    }
}

