/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf.armor;

import com.huawei.ism.tool.framework.pubservice.exception.EncapsulatedRuntimeException;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui.swing.plaf.armor.ArmorRootPaneUI;
import com.huawei.ism.util.SwingUIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;

public class ArmorTitleBarPane
extends JComponent {
    private static final long serialVersionUID = -5556262082689561118L;
    private static final Border HANDYEMPTYBORDER = new EmptyBorder(0, 0, 0, 0);
    private static final int IMAGE_HEIGHT = 16;
    private static final int IMAGE_WIDTH = 16;
    private transient Icon maximizeIcon;
    private transient Icon restoreIcon;
    private transient Image systemIcon;
    private transient Action maximizeAction;
    private transient JButton restoreButton;
    private transient JButton minimizeButton;
    private transient JButton closeButton;
    private transient WindowListener windowListener;
    private Window currentWindow;
    private JRootPane rootPane;
    private int state;
    private transient PropertyChangeListener propertyChangeListener;
    private transient JMenuBar menuBar;
    private transient Action closeAction;
    private transient Action iconifyAction;
    private transient Action restoreAction;
    private transient ArmorRootPaneUI rootPaneUI;

    public ArmorTitleBarPane(JRootPane root, ArmorRootPaneUI ui) {
        this.rootPane = root;
        this.rootPaneUI = ui;
        this.state = -1;
        this.installSubcomponents();
        this.installDefaults();
        this.setLayout(this.createLayout());
    }

    private void installDefaults() {
        this.setFont(UIManager.getFont("InternalFrame.titleFont", this.getLocale()));
    }

    private void installListeners() {
        if (this.currentWindow != null) {
            this.windowListener = this.createWindowListener();
            this.currentWindow.addWindowListener(this.windowListener);
            this.propertyChangeListener = this.createWindowPropertyChangeListener();
            this.currentWindow.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    private WindowListener createWindowListener() {
        return new WindowHandler();
    }

    private PropertyChangeListener createWindowPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    public void uninstall() {
        this.uninstallWindowListeners();
        this.currentWindow = null;
        this.removeAll();
    }

    private void uninstallWindowListeners() {
        if (this.currentWindow != null) {
            this.currentWindow.removeWindowListener(this.windowListener);
            this.currentWindow.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    @Override
    public JRootPane getRootPane() {
        return this.rootPane;
    }

    private int getWindowDecorationStyle() {
        return this.getRootPane().getWindowDecorationStyle();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.uninstallWindowListeners();
        this.currentWindow = null;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.uninstallWindowListeners();
        this.currentWindow = SwingUtilities.getWindowAncestor(this);
        if (this.currentWindow != null) {
            if (this.currentWindow instanceof Frame) {
                this.setState(((Frame)this.currentWindow).getExtendedState());
            } else {
                this.setState(0);
            }
            this.setActive(this.currentWindow.isActive());
            this.installListeners();
            this.updateSystemIcon();
        }
    }

    protected JMenuBar createMenuBar() {
        this.menuBar = new SystemMenuBar();
        this.menuBar.setFocusable(false);
        this.menuBar.setBorderPainted(true);
        return this.menuBar;
    }

    private void installSubcomponents() {
        int decorationStyle = this.getWindowDecorationStyle();
        if (decorationStyle == 1) {
            this.createActions();
            this.menuBar = this.createMenuBar();
            this.add(this.menuBar);
            this.createButtons();
            this.add(this.minimizeButton);
            this.add(this.restoreButton);
            this.add(this.closeButton);
        } else {
            boolean bool;
            boolean bl = bool = decorationStyle == 2 || decorationStyle == 3 || decorationStyle == 4 || decorationStyle == 5 || decorationStyle == 6;
            if (bool || decorationStyle == 7 || decorationStyle == 8) {
                this.createActions();
                this.createButtons();
                this.add(this.closeButton);
            }
        }
    }

    private void createActions() {
        this.closeAction = new CloseAction();
        if (this.getWindowDecorationStyle() == 1) {
            this.iconifyAction = new MinimizeAction();
            this.restoreAction = new RestoreAction();
            this.maximizeAction = new MaximizeAction();
        }
    }

    private void close() {
        Window systemWindow = this.getCurrentWindow();
        if (systemWindow != null) {
            systemWindow.dispatchEvent(new WindowEvent(systemWindow, 201));
        }
    }

    private void minimize() {
        Frame frame = this.getFrame();
        if (frame != null) {
            frame.setExtendedState(this.state | 1);
        }
    }

    private void maximize() {
        Frame frame = this.getFrame();
        if (frame != null) {
            IsmPlafUtils.setFrameMaxBounds(frame);
            frame.setExtendedState(this.state | 6);
        }
    }

    private void restore() {
        Frame windowsFrame = this.getFrame();
        if (windowsFrame == null) {
            return;
        }
        if ((this.state & 1) != 0) {
            windowsFrame.setExtendedState(this.state & 0xFFFFFFFE);
        } else {
            windowsFrame.setExtendedState(this.state & 0xFFFFFFF9);
        }
    }

    protected JMenu createMenu() {
        JMenu menu = new JMenu("");
        if (this.getWindowDecorationStyle() == 1) {
            this.addMenuItems(menu);
        }
        return menu;
    }

    private void addMenuItems(JMenu menu) {
        JMenuItem mi = menu.add(this.restoreAction);
        int mnemonic = IsmPlafUtils.getInt("MetalTitlePane.restoreMnemonic", -1);
        if (mnemonic != -1) {
            mi.setMnemonic(mnemonic);
        }
        mi = menu.add(this.iconifyAction);
        mnemonic = IsmPlafUtils.getInt("MetalTitlePane.iconifyMnemonic", -1);
        if (mnemonic != -1) {
            mi.setMnemonic(mnemonic);
        }
        if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
            mi = menu.add(this.maximizeAction);
            mnemonic = IsmPlafUtils.getInt("MetalTitlePane.maximizeMnemonic", -1);
            if (mnemonic != -1) {
                mi.setMnemonic(mnemonic);
            }
        }
        menu.add(new JSeparator());
        mi = menu.add(this.closeAction);
        mnemonic = IsmPlafUtils.getInt("MetalTitlePane.closeMnemonic", -1);
        if (mnemonic != -1) {
            mi.setMnemonic(mnemonic);
        }
    }

    private JButton createTitleButton(Action action, String name) {
        JButton button = new JButton();
        button.setFocusPainted(false);
        button.setFocusable(false);
        button.setOpaque(true);
        button.setText(null);
        button.setBorder(HANDYEMPTYBORDER);
        button.putClientProperty("paintActive", Boolean.TRUE);
        button.putClientProperty("AccessibleName", name);
        button.setAction(action);
        button.setBackground(UIManager.getColor("IsmArmorStyle.BaseColor"));
        button.setBorderPainted(false);
        button.setContentAreaFilled(false);
        button.setIconTextGap(0);
        return button;
    }

    private void setButtonIcon(JButton button, String normalIconKey, String rolloverIconKey, String selectedIconKey) {
        if (null != button) {
            String prefix = "TitleBar.";
            Icon normalIcon = UIManager.getIcon(prefix + normalIconKey);
            button.setIcon(normalIcon);
            button.setDisabledIcon(normalIcon);
            Icon rolloverIcon = UIManager.getIcon(prefix + rolloverIconKey);
            button.setRolloverIcon(rolloverIcon);
            button.setRolloverSelectedIcon(rolloverIcon);
            Icon selectedIcon = UIManager.getIcon(prefix + selectedIconKey);
            button.setSelectedIcon(selectedIcon);
            button.setPressedIcon(selectedIcon);
        }
    }

    private void createButtons() {
        if (this.getWindowDecorationStyle() == 1) {
            this.closeButton = this.createTitleButton(this.closeAction, "Close");
            this.setButtonIcon(this.closeButton, "close_normal", "close_rollover", "close_selected");
            this.maximizeIcon = UIManager.getIcon("TitleBar.maximize_normal");
            this.restoreIcon = UIManager.getIcon("TitleBar.restore_normal");
            this.minimizeButton = this.createTitleButton(this.iconifyAction, "Iconify");
            this.setButtonIcon(this.minimizeButton, "minimize_normal", "minimize_rollover", "minimize_selected");
            this.restoreButton = this.createTitleButton(this.restoreAction, "Maximize");
            this.restoreButton.setIcon(this.restoreIcon);
        } else {
            this.closeButton = this.createTitleButton(this.closeAction, "Close");
            this.setButtonIcon(this.closeButton, "dialog_close_normal", "dialog_close_rollover", "dialog_close_selected");
        }
    }

    private LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    private void setActive(boolean isActive) {
        Boolean activeB = isActive;
        this.closeButton.putClientProperty("paintActive", activeB);
        if (this.getWindowDecorationStyle() == 1) {
            this.minimizeButton.putClientProperty("paintActive", activeB);
            this.restoreButton.putClientProperty("paintActive", activeB);
        }
        this.getRootPane().repaint();
    }

    private void setState(int barState, boolean updateRegardless) {
        Window window = this.getCurrentWindow();
        if (window != null && this.getWindowDecorationStyle() == 1) {
            if (this.state == barState && !updateRegardless) {
                return;
            }
            Frame frame = this.getFrame();
            if (frame != null) {
                this.setFrameState(barState, frame);
            } else {
                this.maximizeAction.setEnabled(false);
                this.restoreAction.setEnabled(false);
                this.iconifyAction.setEnabled(false);
                this.remove(this.restoreButton);
                this.remove(this.minimizeButton);
                this.revalidate();
                this.repaint();
            }
            this.closeAction.setEnabled(true);
            this.state = barState;
        }
    }

    private void setState(int state) {
        this.setState(state, false);
    }

    private void setFrameState(int barState, Frame frame) {
        JRootPane systemRootPane = this.getRootPane();
        if ((barState & 6) != 0 && (systemRootPane.getBorder() == null || systemRootPane.getBorder() instanceof UIResource) && frame.isShowing()) {
            systemRootPane.setBorder(null);
        } else if ((barState & 6) == 0) {
            this.rootPaneUI.installBorder(systemRootPane);
        }
        if (frame.isResizable()) {
            this.updateButtons(barState);
        } else {
            this.maximizeAction.setEnabled(false);
            this.restoreAction.setEnabled(false);
            if (this.restoreButton.getParent() != null) {
                this.remove(this.restoreButton);
                this.revalidate();
                this.repaint();
            }
        }
    }

    private void updateButtons(int barState) {
        if ((barState & 6) != 0) {
            this.updateToggleButton(this.restoreAction, this.restoreIcon);
            this.maximizeAction.setEnabled(false);
            this.restoreAction.setEnabled(true);
        } else {
            this.updateToggleButton(this.maximizeAction, this.maximizeIcon);
            this.maximizeAction.setEnabled(true);
            this.restoreAction.setEnabled(false);
        }
        if (this.restoreButton.getParent() == null || this.minimizeButton.getParent() == null) {
            this.add(this.restoreButton);
            this.add(this.minimizeButton);
            this.revalidate();
            this.repaint();
        }
        this.restoreButton.setText(null);
    }

    private void updateToggleButton(Action action, Icon icon) {
        this.restoreButton.setAction(action);
        this.restoreButton.setIcon(icon);
        this.restoreButton.setText(null);
        if (icon == this.restoreIcon) {
            this.setButtonIcon(this.restoreButton, "restore_normal", "restore_rollover", "restore_selected");
        } else if (icon == this.maximizeIcon) {
            this.setButtonIcon(this.restoreButton, "maximize_normal", "maximize_selected", "maximize_rollover");
        }
    }

    private Frame getFrame() {
        Window ststemWindow = this.getCurrentWindow();
        if (ststemWindow instanceof Frame) {
            return (Frame)ststemWindow;
        }
        return null;
    }

    private Window getCurrentWindow() {
        return this.currentWindow;
    }

    private String getTitle() {
        Window window = this.getCurrentWindow();
        if (window instanceof Frame) {
            return ((Frame)window).getTitle();
        }
        if (window instanceof Dialog) {
            return ((Dialog)window).getTitle();
        }
        return null;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Frame frame = this.getFrame();
        if (frame != null) {
            this.setState(frame.getExtendedState());
        }
        JRootPane systemRootPane = this.getRootPane();
        Window systemWindow = this.getCurrentWindow();
        boolean leftToRight = systemWindow == null ? systemRootPane.getComponentOrientation().isLeftToRight() : systemWindow.getComponentOrientation().isLeftToRight();
        int width = this.getWidth();
        int height = this.getHeight();
        int xOffset = 0;
        if (this.getWindowDecorationStyle() == 1) {
            ImageIcon leftBackgroundIcon = (ImageIcon)UIManager.getIcon("TitleBar.leftBackground");
            graphics.drawImage(leftBackgroundIcon.getImage(), 0, 0, width, leftBackgroundIcon.getIconHeight(), this);
            ImageIcon rightBackgroundIcon = (ImageIcon)UIManager.getIcon("TitleBar.rightBackground");
            graphics.drawImage(rightBackgroundIcon.getImage(), width - rightBackgroundIcon.getIconWidth(), 0, rightBackgroundIcon.getIconWidth(), rightBackgroundIcon.getIconHeight(), this);
            xOffset += leftToRight ? 26 : -26;
        } else {
            ImageIcon backgroundIcon = (ImageIcon)UIManager.getIcon("TitleBar.dialog_background");
            graphics.drawImage(backgroundIcon.getImage(), 0, 0, width, backgroundIcon.getIconHeight(), this);
            xOffset += leftToRight ? 11 : -width - 11;
        }
        this.paintTextField(graphics, systemRootPane, systemWindow, leftToRight, height, xOffset);
    }

    private void paintTextField(Graphics graphics, JRootPane systemRootPane, Window systemWindow, boolean leftToRight, int height, int xOffset) {
        String theTitle = this.getTitle();
        if (theTitle != null) {
            FontMetrics fm = SwingUIUtil.getFontMetrics(systemRootPane, graphics);
            graphics.setColor(Color.WHITE);
            int yOffset = (height - fm.getHeight()) / 2 + fm.getAscent();
            Rectangle rect = new Rectangle(0, 0, 0, 0);
            if (this.minimizeButton != null && this.minimizeButton.getParent() != null) {
                rect = this.minimizeButton.getBounds();
            }
            int actualXOffset = xOffset;
            if (leftToRight) {
                if ((int)rect.getX() == 0) {
                    if (null == systemWindow) {
                        throw new EncapsulatedRuntimeException("systemWindow is null.");
                    }
                    rect.setLocation(systemWindow.getWidth() - systemWindow.getInsets().right - 2, (int)rect.getY());
                }
                int titleW = (int)rect.getX() - actualXOffset - 60;
                theTitle = SwingUIUtil.clipStringIfNecessary(systemRootPane, fm, theTitle, titleW);
            } else {
                int titleW = actualXOffset - (int)rect.getX() - rect.width - 4;
                theTitle = SwingUIUtil.clipStringIfNecessary(systemRootPane, fm, theTitle, titleW);
                actualXOffset -= SwingUIUtil.stringWidth(systemRootPane, fm, theTitle);
            }
            String title = this.getTitle();
            SwingUIUtil.drawString(systemRootPane, graphics, theTitle, actualXOffset, yOffset);
            if (!theTitle.equalsIgnoreCase(title)) {
                this.setToolTipText(title);
            }
        }
    }

    private void updateSystemIcon() {
        Window systemWindow = this.getCurrentWindow();
        if (systemWindow == null) {
            this.systemIcon = null;
            return;
        }
        List<Image> icons = systemWindow.getIconImages();
        this.systemIcon = icons.isEmpty() ? null : (icons.size() == 1 ? icons.get(0) : SwingUIUtil.getScaledIconImage(icons, 16, 16));
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        @Override
        public void windowActivated(WindowEvent ev) {
            ArmorTitleBarPane.this.setActive(true);
        }

        @Override
        public void windowDeactivated(WindowEvent ev) {
            ArmorTitleBarPane.this.setActive(false);
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            String propertyName = pce.getPropertyName();
            if ("resizable".equals(propertyName) || "state".equals(propertyName)) {
                Frame currentFrame = ArmorTitleBarPane.this.getFrame();
                if (null != currentFrame) {
                    ArmorTitleBarPane.this.setState(currentFrame.getExtendedState(), true);
                }
                if ("resizable".equals(propertyName)) {
                    ArmorTitleBarPane.this.getRootPane().repaint();
                }
            } else if ("title".equals(propertyName)) {
                ArmorTitleBarPane.this.repaint();
            } else if ("componentOrientation".equals(propertyName)) {
                this.revalidateAndRepaint();
            } else if ("iconImage".equals(propertyName)) {
                ArmorTitleBarPane.this.updateSystemIcon();
                this.revalidateAndRepaint();
            }
        }

        private void revalidateAndRepaint() {
            ArmorTitleBarPane.this.revalidate();
            ArmorTitleBarPane.this.repaint();
        }
    }

    private class TitlePaneLayout
    implements LayoutManager {
        private TitlePaneLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            int height = this.computeHeight();
            return new Dimension(height, height);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        private int computeHeight() {
            FontMetrics fm = ArmorTitleBarPane.this.rootPane.getFontMetrics(ArmorTitleBarPane.this.getFont());
            int fontHeight = fm.getHeight();
            fontHeight += 7;
            int titleBarHeight = UIManager.getInt("IsmDialog.TitleBarHeight");
            if (ArmorTitleBarPane.this.getWindowDecorationStyle() == 1) {
                titleBarHeight = UIManager.getInt("IsmFrame.TitleBarHeight");
            }
            int finalHeight = Math.max(fontHeight, titleBarHeight);
            return finalHeight;
        }

        @Override
        public void layoutContainer(Container container) {
            int xx;
            int buttonWidth;
            int buttonHeight;
            boolean leftToRight = ArmorTitleBarPane.this.currentWindow == null ? ArmorTitleBarPane.this.getRootPane().getComponentOrientation().isLeftToRight() : ArmorTitleBarPane.this.currentWindow.getComponentOrientation().isLeftToRight();
            int width = ArmorTitleBarPane.this.getWidth();
            int height = ArmorTitleBarPane.this.getHeight();
            int yy = 3;
            if (ArmorTitleBarPane.this.closeButton != null && ArmorTitleBarPane.this.closeButton.getIcon() != null) {
                buttonHeight = ArmorTitleBarPane.this.closeButton.getIcon().getIconHeight();
                buttonWidth = ArmorTitleBarPane.this.closeButton.getIcon().getIconWidth();
            } else {
                buttonHeight = 16;
                buttonWidth = 16;
            }
            int spacing = 5;
            yy = height - buttonHeight - 2;
            if (ArmorTitleBarPane.this.getWindowDecorationStyle() != 1) {
                spacing = 11;
                yy = (height - buttonHeight) / 2;
            }
            int n = xx = leftToRight ? spacing : width - buttonWidth - spacing;
            if (ArmorTitleBarPane.this.menuBar != null) {
                ArmorTitleBarPane.this.menuBar.setBounds(xx, yy, 16, 16);
            }
            xx = leftToRight ? width : 0;
            xx += leftToRight ? -spacing - buttonWidth : spacing;
            if (ArmorTitleBarPane.this.closeButton != null) {
                ArmorTitleBarPane.this.closeButton.setBounds(xx, yy, buttonWidth, buttonHeight);
            }
            if (!leftToRight) {
                xx += buttonWidth;
            }
            if (ArmorTitleBarPane.this.getWindowDecorationStyle() != 1) {
                return;
            }
            xx = this.locationRestoreButton(leftToRight, xx, yy, buttonHeight, buttonWidth);
            this.locationMinButton(leftToRight, xx, yy, buttonHeight, buttonWidth);
        }

        private int locationMinButton(boolean leftToRight, int xx, int yy, int buttonHeight, int buttonWidth) {
            int actualXx = xx;
            if (ArmorTitleBarPane.this.minimizeButton != null && ArmorTitleBarPane.this.minimizeButton.getParent() != null) {
                int spacing = 4;
                ArmorTitleBarPane.this.minimizeButton.setBounds(actualXx += leftToRight ? -spacing - buttonWidth : spacing, yy, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    actualXx += buttonWidth;
                }
            }
            return actualXx;
        }

        private int locationRestoreButton(boolean leftToRight, int xx, int yy, int buttonHeight, int buttonWidth) {
            boolean isSupportedMax = Toolkit.getDefaultToolkit().isFrameStateSupported(6);
            int actualXx = xx;
            if (isSupportedMax && ArmorTitleBarPane.this.restoreButton.getParent() != null) {
                int spacing = 4;
                ArmorTitleBarPane.this.restoreButton.setBounds(actualXx += leftToRight ? -spacing - buttonWidth : spacing, yy, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    actualXx += buttonWidth;
                }
            }
            return actualXx;
        }
    }

    private class SystemMenuBar
    extends JMenuBar {
        private static final long serialVersionUID = 1076828848336991896L;

        private SystemMenuBar() {
        }

        @Override
        public void paint(Graphics graphics) {
            if (ArmorTitleBarPane.this.systemIcon != null) {
                graphics.drawImage(ArmorTitleBarPane.this.systemIcon, 0, 0, 16, 16, null);
            } else {
                Icon icon = UIManager.getIcon("InternalFrame.icon");
                if (icon != null) {
                    icon.paintIcon(this, graphics, 0, 0);
                }
            }
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            return new Dimension(Math.max(16, size.width), Math.max(size.height, 16));
        }
    }

    private class RestoreAction
    extends AbstractAction {
        private static final long serialVersionUID = 6770026585472953566L;

        public RestoreAction() {
            super(null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ArmorTitleBarPane.this.restore();
        }
    }

    private class MaximizeAction
    extends AbstractAction {
        private static final long serialVersionUID = -1425567658668955012L;

        public MaximizeAction() {
            super(null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ArmorTitleBarPane.this.maximize();
        }
    }

    private class MinimizeAction
    extends AbstractAction {
        private static final long serialVersionUID = -3847224432555497479L;

        public MinimizeAction() {
            super(null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ArmorTitleBarPane.this.minimize();
        }
    }

    private class CloseAction
    extends AbstractAction {
        private static final long serialVersionUID = -2838961894571122928L;

        public CloseAction() {
            super(null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ArmorTitleBarPane.this.close();
        }
    }
}

