/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf.armor;

import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui.swing.tree.IsmTreeNode;
import com.huawei.ism.util.UCD;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.TreeCellRenderer;

public class ArmorTreeCellRender
extends JPanel
implements TreeCellRenderer {
    private static final long serialVersionUID = 2149473006310725215L;
    private boolean isTreeCellRollover = false;
    private boolean isTreeCellSelected = false;
    private int mouseOverRow = -1;
    private JLabel textLable;
    private JLabel orientIconLable;

    public ArmorTreeCellRender() {
        this.doLayoutUI();
    }

    protected void doLayoutUI() {
        this.textLable = new JLabel();
        this.orientIconLable = new JLabel();
        Box allBox = UCD.buildHBoxLeft(5, this.textLable, this.orientIconLable);
        this.add(allBox);
        this.setOpaque(false);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.setSelected(selected);
        this.setRollover(row == this.mouseOverRow);
        IsmTreeNode treeNode = null;
        if (value instanceof IsmTreeNode) {
            treeNode = (IsmTreeNode)value;
            String text = treeNode.getText();
            this.textLable.setText(text);
            String toolTip = treeNode.getTooltipText();
            if (toolTip != null) {
                this.textLable.setToolTipText(toolTip);
            }
            this.loadTreeNodeIcon(tree, expanded, leaf, treeNode.getIcon());
        } else {
            String text = tree.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
            this.textLable.setText(text);
            this.loadTreeNodeIcon(tree, expanded, leaf, null);
        }
        this.textLable.setEnabled(tree.isEnabled());
        this.orientIconLable.setEnabled(tree.isEnabled());
        this.loadRolloverIcon(tree);
        this.setComponentOrientation(tree.getComponentOrientation());
        return this;
    }

    protected void loadTreeNodeIcon(JTree tree, boolean expanded, boolean leaf, Icon customeIcon) {
        Icon icon = null;
        if (customeIcon instanceof ImageIcon) {
            icon = customeIcon;
            ImageIcon imageIcon = (ImageIcon)icon;
            imageIcon.setImageObserver(tree);
        }
        this.textLable.setIcon(icon);
        if (!tree.isEnabled()) {
            Icon disabledIcon = UIManager.getLookAndFeel().getDisabledIcon(tree, icon);
            if (disabledIcon != null) {
                icon = disabledIcon;
            }
            this.textLable.setDisabledIcon(icon);
        }
    }

    private void loadRolloverIcon(JTree tree) {
        if (this.isTreeCellRollover || this.isTreeCellSelected) {
            Icon orientIcon = UIManager.getIcon("IsmTreeUI.arrowIcon");
            if (!tree.isEnabled()) {
                this.orientIconLable.setIcon(null);
            } else {
                this.orientIconLable.setIcon(orientIcon);
                this.orientIconLable.setBorder(new EmptyBorder(0, 5, 0, 5));
            }
        } else {
            this.orientIconLable.setIcon(null);
            this.setBorder(null);
        }
    }

    public void setSelected(boolean isSelected) {
        this.isTreeCellSelected = isSelected;
    }

    public void setRollover(boolean isRollover) {
        this.isTreeCellRollover = isRollover;
    }

    public void setRolloverRow(int row) {
        this.mouseOverRow = row;
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.isEnabled() && (this.isTreeCellRollover || this.isTreeCellSelected)) {
            int xx = 0;
            int yy = 0;
            int ww = this.getPreferredSize().width - 5;
            int height = this.getPreferredSize().height;
            Color oldColor = graphics.getColor();
            graphics.setColor(new Color(15725559));
            graphics.fillRect(0, 0, ww, height);
            Color borderColor = UIManager.getColor("Popup.borderColor");
            IsmPlafUtils.drawBorderStyle(graphics, borderColor, borderColor, new Rectangle(xx, yy, ww, height), true);
            graphics.setColor(oldColor);
        }
        super.revalidate();
        super.paint(graphics);
    }
}

