/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf.unify;

import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui.swing.text.IsmPasswordField;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPasswordFieldUI;
import javax.swing.text.JTextComponent;

public class UnifyPasswordTextFieldUI
extends BasicPasswordFieldUI {
    private Handler handler;

    public static ComponentUI createUI(JComponent c) {
        return new UnifyPasswordTextFieldUI();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.handler = new Handler();
        this.getComponent().addMouseListener(this.handler);
        this.getComponent().addFocusListener(this.handler);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.getComponent().removeMouseListener(this.handler);
        this.getComponent().removeFocusListener(this.handler);
    }

    @Override
    protected void paintBackground(Graphics graphics) {
        IsmPasswordField textField;
        JTextComponent textComponent = this.getComponent();
        if (textComponent instanceof IsmPasswordField && (textField = (IsmPasswordField)textComponent).isShowErrorToolTip() && textField.isEnabled()) {
            graphics.setColor(UIManager.getColor("TextComponent.errBackground"));
            graphics.fillRect(0, 0, textComponent.getWidth(), textComponent.getHeight());
            return;
        }
        graphics.setColor(textComponent.getBackground());
        graphics.fillRect(0, 0, textComponent.getWidth(), textComponent.getHeight());
        graphics.setColor(UIManager.getColor("TextField.backgroundTopHighlighter"));
        graphics.drawLine(1, 1, textComponent.getWidth() - 2, 1);
        int gradientHeight = UIManager.getInt("TextField.backgroundGradientHeight");
        String gradientKey = "TextField.backgroundNormalGradient";
        if (!textComponent.isEnabled() || !textComponent.isEditable()) {
            gradientKey = "TextField.backgroundDisabledGradient";
        }
        IsmPlafUtils.drawGradient((Component)textComponent, graphics, gradientKey, new Rectangle(1, 2, textComponent.getWidth() - 2, gradientHeight), true);
    }

    private class Handler
    extends MouseAdapter
    implements FocusListener {
        private Handler() {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.refresh();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.refresh();
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.refresh();
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.refresh();
        }

        protected void refresh() {
            if (UnifyPasswordTextFieldUI.this.getComponent().getParent() != null) {
                UnifyPasswordTextFieldUI.this.getComponent().getParent().repaint();
            }
        }
    }
}

