/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.table;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui.swing.plaf.unify.UnifyBorders;
import com.huawei.ism.ui.swing.table.EndChangeListener;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.KeywordRowFilter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class KeywordFilterField
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int FILTER_FIELD_WIDTH = 180;
    private static final int FILTER_FIELD_HIGH = 21;
    private final String invalidText = ResourceManager.getString("COMMON.TXT.INPUT_KEYWORD");
    private transient RowFilter<TableModel, Integer> extFilter;
    private boolean isAfterFilter = false;
    private FilterTextField inputField;
    private JLabel filterButton;
    private IsmTable table;
    private boolean clearSelection = true;

    public KeywordFilterField(IsmTable table) {
        this.table = table;
        this.setLayout(new BoxLayout(this, 0));
        this.setPreferredSize(new Dimension(180, 21));
        this.setMaximumSize(new Dimension(180, 21));
        URL url = KeywordFilterField.class.getResource("images/filter.png");
        this.filterButton = new JLabel(new ImageIcon(url));
        this.filterButton.setBorder(BorderFactory.createEmptyBorder());
        this.add(this.filterButton);
        this.add(Box.createHorizontalStrut(8));
        this.inputField = new FilterTextField();
        this.add(this.inputField);
        this.setBorder(new CompoundBorder(new FilterFieldBorder(), new EmptyBorder(0, 1, 0, 0)));
        if (IsmPlafUtils.isUnifyStyle()) {
            this.setBorder(new CompoundBorder(UnifyBorders.getTextComponentBorder(), new EmptyBorder(0, 1, 0, 0)));
            this.setOpaque(false);
            this.inputField.setOpaque(false);
        }
        this.setEnabled(true);
    }

    public KeywordFilterField(IsmTable table, ListSelectionListener listSelectionListener) {
        this(table);
        this.inputField.setListSelectionListener(listSelectionListener);
        this.inputField.setSource(table);
    }

    public String getKeyword() {
        return this.inputField.getText();
    }

    public void setKeyword(String keyword) {
        this.inputField.setText(null == keyword ? "" : keyword);
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    public void addEndChangeListener(EndChangeListener listener) {
        this.listenerList.add(EndChangeListener.class, listener);
    }

    protected void fireFilterChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(new ChangeEvent(this));
        }
    }

    protected void fireEndFilterChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            Object listener;
            if (listeners[i] != EndChangeListener.class || !((listener = listeners[i + 1]) instanceof EndChangeListener)) continue;
            ((EndChangeListener)listener).endStateChanged(new ChangeEvent(this));
        }
    }

    @Override
    public void setEnabled(boolean enable) {
        if (enable) {
            this.setBackground(Color.WHITE);
            this.filterButton.setBackground(Color.WHITE);
            this.inputField.setBackground(Color.WHITE);
        } else {
            Color invalidColor = UIManager.getColor("TextField.disabledBackground");
            this.setBackground(invalidColor);
            this.filterButton.setBackground(invalidColor);
            this.inputField.setBackground(invalidColor);
        }
        for (Component comp : this.getComponents()) {
            comp.setEnabled(enable);
        }
    }

    public void setExtFilter(RowFilter<TableModel, Integer> ... filters) {
        this.extFilter = null;
        if (null != filters && filters.length > 0) {
            this.extFilter = RowFilter.andFilter(Arrays.asList(filters));
        }
    }

    @Override
    public boolean isFocusOwner() {
        return this.inputField.isFocusOwner();
    }

    public void setClearSelection(boolean clearSelection) {
        this.clearSelection = clearSelection;
    }

    public void updateFilter() {
        if (this.clearSelection) {
            this.table.clearSelection();
        }
        TableRowSorter sorter = (TableRowSorter)this.table.getRowSorter();
        String text = this.inputField.getText();
        if (text.length() == 0) {
            sorter.setRowFilter(this.extFilter);
        } else if (null == this.extFilter) {
            sorter.setRowFilter(new KeywordRowFilter(text, new int[0]));
        } else {
            ArrayList<RowFilter<TableModel, Integer>> list = new ArrayList<RowFilter<TableModel, Integer>>(0);
            this.addFilter(text, list);
            RowFilter<TableModel, Integer> filter = RowFilter.andFilter(list);
            sorter.setRowFilter(filter);
        }
    }

    private void addFilter(String text, List<RowFilter<TableModel, Integer>> list) {
        if (this.isAfterFilter) {
            list.add(new KeywordRowFilter(text, new int[0]));
            list.add(this.extFilter);
        } else {
            list.add(this.extFilter);
            list.add(new KeywordRowFilter(text, new int[0]));
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (!IsmPlafUtils.isUnifyStyle()) {
            super.paintComponent(graphics);
            return;
        }
        graphics.setColor(Color.WHITE);
        graphics.fillRect(1, 1, this.getWidth() - 2, this.getHeight());
        graphics.setColor(UIManager.getColor("TextField.backgroundTopHighlighter"));
        graphics.drawLine(1, 1, this.getWidth() - 2, 0);
        int gradientHeight = UIManager.getInt("TextField.backgroundGradientHeight");
        String gradientKey = "TextField.backgroundNormalGradient";
        if (!this.isEnabled() || !this.inputField.isEditable()) {
            gradientKey = "TextField.backgroundDisabledGradient";
        }
        IsmPlafUtils.drawGradient((Component)this, graphics, gradientKey, new Rectangle(1, 1, this.getWidth() - 2, gradientHeight), true);
        super.paintComponent(graphics);
    }

    public JTextField getInputTextField() {
        return this.inputField;
    }

    public void setAfterFilter(boolean isAfterFilter) {
        this.isAfterFilter = isAfterFilter;
    }

    private final class FilterFieldBorder
    extends BevelBorder {
        private static final long serialVersionUID = 1L;

        public FilterFieldBorder() {
            super(1);
        }

        @Override
        public Color getHighlightOuterColor(Component c) {
            if (KeywordFilterField.this.inputField.isEnabled()) {
                if (KeywordFilterField.this.inputField.isEditable() && KeywordFilterField.this.inputField.isFocusOwner()) {
                    return UIManager.getColor("TextField.rdFocusOuterColor");
                }
                return UIManager.getColor("TextField.rdNormalOuterColor");
            }
            return UIManager.getColor("TextField.disabledBorderColor");
        }

        @Override
        public Color getHighlightInnerColor(Component component) {
            return component.getBackground();
        }

        @Override
        public Color getShadowInnerColor(Component component) {
            if (component.isEnabled()) {
                if (KeywordFilterField.this.inputField.isEditable() && KeywordFilterField.this.inputField.isFocusOwner()) {
                    return UIManager.getColor("TextField.luFocusOuterColor");
                }
                return UIManager.getColor("TextField.luNormalOuterColor");
            }
            return UIManager.getColor("TextField.disabledBorderColor");
        }

        @Override
        public Color getShadowOuterColor(Component component) {
            if (component.isEnabled()) {
                if (KeywordFilterField.this.inputField.isEditable() && KeywordFilterField.this.inputField.isFocusOwner()) {
                    return UIManager.getColor("TextField.luInnerColor");
                }
                return UIManager.getColor("TextField.luInnerColor");
            }
            return component.getBackground();
        }
    }

    private class FilterTextField
    extends JTextField {
        private static final long serialVersionUID = 1L;
        private final Color invalidTextColor = Color.GRAY;
        private ListSelectionListener listSelectionListener;
        private IsmTable source;

        public FilterTextField() {
            this.setBorder(BorderFactory.createEmptyBorder());
            this.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    FilterTextField.this.doFilter();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    FilterTextField.this.doFilter();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    FilterTextField.this.doFilter();
                }
            });
        }

        private void doFilter() {
            if (Objects.nonNull(this.listSelectionListener) && Objects.nonNull(this.source)) {
                this.source.getSelectionModel().removeListSelectionListener(this.listSelectionListener);
            }
            KeywordFilterField.this.fireFilterChanged();
            KeywordFilterField.this.updateFilter();
            KeywordFilterField.this.fireEndFilterChanged();
            if (Objects.nonNull(this.listSelectionListener) && Objects.nonNull(this.source)) {
                ListSelectionModel selectionModel = this.source.getSelectionModel();
                ListSelectionEvent listSelectionEvent = new ListSelectionEvent(selectionModel, selectionModel.getMinSelectionIndex(), selectionModel.getMaxSelectionIndex(), false);
                this.listSelectionListener.valueChanged(listSelectionEvent);
                this.source.getSelectionModel().addListSelectionListener(this.listSelectionListener);
            }
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            String text = this.getText();
            if (!(this.hasFocus() || null != text && text.length() != 0)) {
                graphics.setColor(this.invalidTextColor);
                graphics.drawString(KeywordFilterField.this.invalidText, this.getX() - 28, this.getY() + this.getHeight() / 2 + 2);
            }
        }

        public void setListSelectionListener(ListSelectionListener listSelectionListener) {
            this.listSelectionListener = listSelectionListener;
        }

        public void setSource(IsmTable source) {
            this.source = source;
        }
    }
}

