/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.table;

import com.huawei.ism.ui.swing.plaf.IsmBorders;
import com.huawei.ism.ui.swing.plaf.IsmButtonStyle;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui.swing.plaf.armor.ArmorBorders;
import com.huawei.ism.ui.swing.plaf.unify.UnifyBorders;
import com.huawei.ism.ui.swing.plaf.unify.UnifyTableHeaderUI;
import com.huawei.ism.util.UCD;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.Border;

class TernaryCheckBoxRender
extends JLabel {
    private static final long serialVersionUID = 4105195263511036415L;
    private boolean isRecovered = false;
    private State state;

    public TernaryCheckBoxRender() {
        UCD.setJComponentSize(this, 13, 13);
        this.setState(State.UNSELECTED);
    }

    public void setStateEnabled(State newState) {
        State finalNewState = newState;
        if (!this.isEnabled()) {
            switch (finalNewState) {
                case SELECTED: {
                    finalNewState = State.DISABLED_SELECTED;
                    break;
                }
                case UNSELECTED: {
                    finalNewState = State.DISABLED_UNSELECTED;
                    break;
                }
                default: {
                    finalNewState = State.DISABLED_PARTIAL_SELECTED;
                }
            }
        }
        this.setState(finalNewState);
    }

    private void setState(State newState) {
        Icon curIcon = null;
        switch (newState) {
            case SELECTED: {
                curIcon = UIManager.getIcon("CheckBox.selectedEnabledIcon");
                break;
            }
            case UNSELECTED: {
                curIcon = UIManager.getIcon("CheckBox.unselectedEnabledIcon");
                break;
            }
            case PARTIAL_SELECTED: {
                curIcon = UIManager.getIcon("CheckBox.partialEnabledIcon");
                break;
            }
            case DISABLED_SELECTED: {
                curIcon = UIManager.getIcon("CheckBox.selectedDisabledIcon");
                break;
            }
            case DISABLED_UNSELECTED: {
                curIcon = UIManager.getIcon("CheckBox.unselectedDisabledIcon");
                break;
            }
            default: {
                curIcon = UIManager.getIcon("CheckBox.partialDisabledIcon");
            }
        }
        this.setIcon(curIcon);
        this.state = newState;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled == this.isEnabled()) {
            return;
        }
        this.setState(this.stateToUnState(this.state, enabled));
        super.setEnabled(enabled);
    }

    private State stateToUnState(State stateTemp, boolean enabeld) {
        if (!enabeld) {
            switch (stateTemp) {
                case SELECTED: {
                    return State.DISABLED_SELECTED;
                }
                case UNSELECTED: {
                    return State.DISABLED_UNSELECTED;
                }
            }
            return State.DISABLED_PARTIAL_SELECTED;
        }
        switch (stateTemp) {
            case DISABLED_SELECTED: {
                return State.SELECTED;
            }
            case DISABLED_UNSELECTED: {
                return State.UNSELECTED;
            }
        }
        return State.PARTIAL_SELECTED;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setOpaque(true);
        Border border = null;
        if (IsmPlafUtils.LAFStyle.armor == IsmPlafUtils.getLAFStyle()) {
            this.setBackground(UIManager.getColor("TableHeader.background"));
            border = ArmorBorders.getTableHeaderBorder(new Insets(0, 4, 0, 0));
        } else {
            border = IsmPlafUtils.LAFStyle.unify == IsmPlafUtils.getLAFStyle() ? UnifyBorders.getTableHeaderBorder(new Insets(0, 4, 0, 0)) : IsmBorders.getTableHeaderBorder();
        }
        this.setBorder(border);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.armor) {
            super.paintComponent(graphics);
            return;
        }
        Dimension size = this.getSize();
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.unify) {
            UnifyTableHeaderUI.paintBackGroud(this, graphics, this.isRecovered);
            this.paintIcon(graphics, size);
            return;
        }
        IsmButtonStyle style = (IsmButtonStyle)UIManager.get("TableHeader.style");
        IsmButtonStyle.ButtonState stateTemp = IsmButtonStyle.ButtonState.NORMAL;
        IsmPlafUtils.drawDualGradient((Component)this, graphics, style.getGradientUL(stateTemp), style.getGradientDR(stateTemp), new Rectangle(0, 0, this.getWidth(), this.getHeight()), true);
        Color innerBorderColorLU = style.getInnerBorderColorLU(stateTemp);
        Color innerBorderColorRD = style.getInnerBorderColorRD(stateTemp);
        int width = size.width;
        int height = size.height;
        graphics.setColor(innerBorderColorLU);
        graphics.fillRect(0, 1, width, 1);
        graphics.fillRect(0, 1, 1, height - 2);
        graphics.setColor(innerBorderColorRD);
        graphics.fillRect(1, height - 3 + 1, width - 2, 1);
        graphics.fillRect(width - 3 + 1, 1, 1, height - 2);
        this.paintIcon(graphics, size);
    }

    private void paintIcon(Graphics graphics, Dimension size) {
        Icon icon = this.getIcon();
        if (null != icon) {
            icon.paintIcon(this, graphics, (size.width - icon.getIconWidth()) / 2, (size.height - icon.getIconHeight()) / 2);
        }
    }

    public void setRecovered(boolean recovered) {
        if (recovered) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.isRecovered = recovered;
    }

    public static enum State {
        SELECTED,
        UNSELECTED,
        PARTIAL_SELECTED,
        DISABLED_SELECTED,
        DISABLED_UNSELECTED,
        DISABLED_PARTIAL_SELECTED;

    }
}

