/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.text.validator;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.text.validator.InputValidator;
import java.text.MessageFormat;
import java.text.Normalizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexInputValidator
implements InputValidator {
    private static final long serialVersionUID = 2702676821014932431L;
    public static final String EMAIL_REGEX = "\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*";
    private static final String PHONE_REGEX = "[\\+]?\\d+";
    private String regex = null;
    private String validateTipPattern = null;
    private String tooltipPattern = null;

    public RegexInputValidator(String regex, String tipPattern) {
        this(regex, tipPattern, tipPattern);
    }

    public RegexInputValidator(String regex, String toolTipPattern, String validateTipPattern) {
        this.setTooltipPattern(toolTipPattern);
        this.setValidateTipPattern(validateTipPattern);
        this.regex = regex;
    }

    public static RegexInputValidator getEmailValidate() {
        return new RegexInputValidator(EMAIL_REGEX, ResourceManager.getString("textfield.email.tooltip"), ResourceManager.getString("textfield.email.validatetip"));
    }

    public static RegexInputValidator getPhoneValidate() {
        return new RegexInputValidator(PHONE_REGEX, ResourceManager.getString("textfield.phone.tooltip"), ResourceManager.getString("textfield.phone.validatetipe"));
    }

    @Override
    public String validateInput(String input, String inputValueName) {
        Pattern pattern = Pattern.compile(this.regex);
        Matcher matcher = pattern.matcher(Normalizer.normalize(input, Normalizer.Form.NFKC));
        if (!matcher.matches()) {
            return this.buildValidateTip(inputValueName);
        }
        return null;
    }

    @Override
    public String getToolTip() {
        return this.buildToolTip("");
    }

    public String getValidateTipPattern() {
        return this.validateTipPattern;
    }

    public void setValidateTipPattern(String tipPattern) {
        this.validateTipPattern = tipPattern;
    }

    public String getTooltipPattern() {
        return this.tooltipPattern;
    }

    public void setTooltipPattern(String tooltipPattern) {
        this.tooltipPattern = tooltipPattern;
    }

    protected String buildToolTip(Object ... objects) {
        if (null != this.tooltipPattern) {
            return MessageFormat.format(this.tooltipPattern, objects);
        }
        return null;
    }

    protected String buildValidateTip(Object ... objects) {
        if (null != this.validateTipPattern) {
            return MessageFormat.format(this.validateTipPattern, objects);
        }
        return null;
    }
}

